/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.rule.IssueTypeUrls;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestIssueResourceCreateMeta.xml")
public class TestIssueResourceCreateMetaIssueType
extends BaseJiraFuncTest {
    private static final String TEST_PROJECT_ID = "10000";
    private static final String PLANET_EXPRESS_PROJECT_ID = "10001";
    @Rule
    public final IssueTypeUrls issueTypeUrls = new IssueTypeUrls();
    @Inject
    private FuncTestUrlHelper urlHelper;
    private IssueClient issueClient;

    @Test
    public void testWithProjectKeys() {
        PageBean firstProjectIssueTypes = this.issueClient.getCreateIssueMetaProjectIssueTypes("PEXPRESS", Long.valueOf(0L), Integer.valueOf(50));
        this.testPlanetExpressProjectIssueTypes(firstProjectIssueTypes.getValues());
        PageBean secondProjectIssueTypes = this.issueClient.getCreateIssueMetaProjectIssueTypes("TST", Long.valueOf(0L), Integer.valueOf(50));
        this.testTestProjectIssueTypes(secondProjectIssueTypes.getValues());
    }

    @Test
    public void testWithProjectIds() {
        PageBean firstProjectIssueTypes = this.issueClient.getCreateIssueMetaProjectIssueTypes(PLANET_EXPRESS_PROJECT_ID, Long.valueOf(0L), Integer.valueOf(50));
        this.testPlanetExpressProjectIssueTypes(firstProjectIssueTypes.getValues());
        PageBean secondProjectIssueTypes = this.issueClient.getCreateIssueMetaProjectIssueTypes(TEST_PROJECT_ID, Long.valueOf(0L), Integer.valueOf(50));
        this.testTestProjectIssueTypes(secondProjectIssueTypes.getValues());
    }

    @Test
    public void testWithNotExistingProjectId() {
        Response response = (Response)this.issueClient.getCreateIssueMetaProjectIssueTypesResource("-1", Long.valueOf(0L), Integer.valueOf(50)).request().get(Response.class);
        response.close();
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testMetadataForSpecificIssueTypeWithNotExistingProjectId() {
        Response response = (Response)this.issueClient.getCreateIssueMetaProjectIssueTypeResource("-1", "1", Long.valueOf(0L), Integer.valueOf(50)).request().get(Response.class);
        response.close();
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testWithRestrictedProject() {
        long schemeId = this.backdoor.project().getSchemes((Long)Long.valueOf((long)10000L)).permissionScheme.id;
        this.backdoor.permissionSchemes().removePermission(schemeId, ProjectPermissions.BROWSE_PROJECTS, JiraPermissionHolderType.PROJECT_ROLE);
        Response response = (Response)((IssueClient)this.issueClient.loginAs("fry")).getCreateIssueMetaProjectIssueTypesResource(TEST_PROJECT_ID, Long.valueOf(0L), Integer.valueOf(50)).request().get(Response.class);
        response.close();
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testMetadataForSpecificIssueTypeWithRestrictedProject() {
        long schemeId = this.backdoor.project().getSchemes((Long)Long.valueOf((long)10000L)).permissionScheme.id;
        this.backdoor.permissionSchemes().removePermission(schemeId, ProjectPermissions.BROWSE_PROJECTS, JiraPermissionHolderType.PROJECT_ROLE);
        Response response = (Response)((IssueClient)this.issueClient.loginAs("fry")).getCreateIssueMetaProjectIssueTypeResource(TEST_PROJECT_ID, "14", Long.valueOf(0L), Integer.valueOf(50)).request().get(Response.class);
        response.close();
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testWithPaging() {
        List<IssueType> firstProjectIssueTypes = this.getIssueTypesWithPaging("PEXPRESS");
        this.testPlanetExpressProjectIssueTypes(firstProjectIssueTypes);
        List<IssueType> secondProjectIssueTypes = this.getIssueTypesWithPaging("TST");
        this.testTestProjectIssueTypes(secondProjectIssueTypes);
    }

    private List<IssueType> getIssueTypesWithPaging(String projectIdOrKey) {
        LinkedList<IssueType> firstProjectIssueTypes = new LinkedList<IssueType>();
        long startAt = 0L;
        boolean maxResults = true;
        while (true) {
            PageBean firstProjectIssueTypesPaged = this.issueClient.getCreateIssueMetaProjectIssueTypes(projectIdOrKey, Long.valueOf(startAt), Integer.valueOf(1));
            firstProjectIssueTypes.addAll(firstProjectIssueTypesPaged.getValues());
            if (firstProjectIssueTypesPaged.getIsLast().booleanValue()) break;
            ++startAt;
        }
        return firstProjectIssueTypes;
    }

    private void testTestProjectIssueTypes(List<IssueType> secondProjectIssueTypes) {
        Assert.assertEquals((long)3L, (long)secondProjectIssueTypes.size());
        IssueType bug = secondProjectIssueTypes.get(0);
        IssueType newFeature = secondProjectIssueTypes.get(1);
        IssueType improvement = secondProjectIssueTypes.get(2);
        this.assertBug(bug);
        this.assertNewFeature(newFeature);
        this.assertImprovement(improvement);
    }

    private void testPlanetExpressProjectIssueTypes(List<IssueType> firstProjectIssueTypes) {
        Assert.assertEquals((long)5L, (long)firstProjectIssueTypes.size());
        IssueType bug = firstProjectIssueTypes.get(0);
        IssueType newFeature = firstProjectIssueTypes.get(1);
        IssueType task = firstProjectIssueTypes.get(2);
        IssueType improvement = firstProjectIssueTypes.get(3);
        IssueType subTask = firstProjectIssueTypes.get(4);
        this.assertBug(bug);
        this.assertNewFeature(newFeature);
        this.assertTask(task);
        this.assertImprovement(improvement);
        this.assertSubTask(subTask);
    }

    private void assertBug(IssueType issueType) {
        Assert.assertEquals((Object)"1", (Object)issueType.id);
        Assert.assertEquals((Object)"Bug", (Object)issueType.name);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + this.issueTypeUrls.getIssueTypeUrl("bug")), (Object)issueType.iconUrl);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/issuetype/1"), (Object)issueType.self);
    }

    private void assertNewFeature(IssueType issueType) {
        Assert.assertEquals((Object)"2", (Object)issueType.id);
        Assert.assertEquals((Object)"New Feature", (Object)issueType.name);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + this.issueTypeUrls.getIssueTypeUrl("new feature")), (Object)issueType.iconUrl);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/issuetype/2"), (Object)issueType.self);
    }

    private void assertTask(IssueType issueType) {
        Assert.assertEquals((Object)"3", (Object)issueType.id);
        Assert.assertEquals((Object)"Task", (Object)issueType.name);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + this.issueTypeUrls.getIssueTypeUrl("task")), (Object)issueType.iconUrl);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/issuetype/3"), (Object)issueType.self);
    }

    private void assertImprovement(IssueType issueType) {
        Assert.assertEquals((Object)"4", (Object)issueType.id);
        Assert.assertEquals((Object)"Improvement", (Object)issueType.name);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + this.issueTypeUrls.getIssueTypeUrl("improvement")), (Object)issueType.iconUrl);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/issuetype/4"), (Object)issueType.self);
    }

    private void assertSubTask(IssueType issueType) {
        Assert.assertEquals((Object)"5", (Object)issueType.id);
        Assert.assertEquals((Object)"Sub-task", (Object)issueType.name);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + this.issueTypeUrls.getIssueTypeUrl("sub-task")), (Object)issueType.iconUrl);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/issuetype/5"), (Object)issueType.self);
    }

    @Before
    public void setup() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }
}

