/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.util.BidiUtils;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestIssueResourceCustomFields
extends BaseJiraRestTest {
    private static final String SELECT_CF_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:select";
    private static final String MULTI_SELECT_CF_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:multiselect";
    private static final String RADIO_CF_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons";
    private static final String MULTI_CHECKBOXES_CF_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes";
    private static final String CASCADING_SELECT_CF_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect";
    private static final String SAMPLE_SELECT_CF_ID = "customfield_10020";
    private static final String SAMPLE_RADIO_CF_ID = "customfield_10019";
    private static final String SAMPLE_MULTI_CHECKBOXES_CF_ID = "customfield_10016";
    private static final String SAMPLE_MULTI_SELECT_CF_ID = "customfield_10017";
    private static final String SAMPLE_CASCADING_SELECT_CF_ID = "customfield_10000";
    private static final String SAMPLE_ISSUE_KEY = "HSP-1";
    private static final String OPTION_VALUE_KEY = "value";
    @Inject
    FuncTestUrlHelper funcTestUrlHelper;
    @Inject
    TextAssertions textAssertions;
    private IssueClient issueClient;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testTextField() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String textField = (String)issue.fields.get("customfield_10021");
        Assert.assertNotNull((Object)textField);
        Assert.assertEquals((Object)"this is *text*", (Object)textField);
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:textfield", (Object)((JsonTypeBean)issue.schema.get("customfield_10021")).getCustom());
        String renderedField = (String)issue.renderedFields.getCustomField("customfield_10021");
        Assert.assertEquals((Object)"<p>this is <b>text</b></p>", (Object)renderedField);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10021", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        textField = (String)issue.fields.get("customfield_10021");
        Assert.assertNull((Object)textField);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testTextArea() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String textArea = (String)issue.fields.get("customfield_10013");
        Assert.assertNotNull((Object)textArea);
        Assert.assertEquals((Object)"lots of text here, *brother*!", (Object)textArea);
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:textarea", (Object)((JsonTypeBean)issue.schema.get("customfield_10013")).getCustom());
        String renderedField = (String)issue.renderedFields.getCustomField("customfield_10013");
        Assert.assertEquals((Object)"<p>lots of text here, <b>brother</b>!</p>", (Object)renderedField);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10013", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        textArea = (String)issue.fields.get("customfield_10013");
        Assert.assertNull((Object)textArea);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testTextareaBidiAreEscaped() {
        String content = String.format("{code}%1$s{code}{noformat}%1$s{noformat}", BidiUtils.getBidis());
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10013", new FieldOperation[]{new FieldOperation("set", (Object)content)}));
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String renderedContent = (String)issue.renderedFields.getCustomField("customfield_10013");
        Assert.assertEquals((Object)(BidiUtils.getCodePanelWithEscapedBidis() + BidiUtils.getNoFormatPanelWithEscapedBidis()), (Object)renderedContent);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testTextareaBidiAreNotEscaped() {
        this.backdoor.darkFeatures().disableForSite(BidiUtils.BIDI_ESCAPING);
        String content = String.format("{code}%1$s{code}{noformat}%1$s{noformat}", BidiUtils.getBidis());
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10013", new FieldOperation[]{new FieldOperation("set", (Object)content)}));
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String renderedContent = (String)issue.renderedFields.getCustomField("customfield_10013");
        Assert.assertEquals((Object)(BidiUtils.getCodePanelWithUnescapedBidis() + BidiUtils.getNoFormatPanelWithUnescapedBidis()), (Object)renderedContent);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testDatePicker() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String datePickerCF = (String)issue.fields.get("customfield_10012");
        Assert.assertNotNull((Object)datePickerCF);
        Assert.assertEquals((Object)"2010-06-23", (Object)datePickerCF);
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:datepicker", (Object)((JsonTypeBean)issue.schema.get("customfield_10012")).getCustom());
        String renderedField = (String)issue.renderedFields.getCustomField("customfield_10012");
        Assert.assertEquals((Object)"23/Jun/10", (Object)renderedField);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10012", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        datePickerCF = (String)issue.fields.get("customfield_10012");
        Assert.assertNull((Object)datePickerCF);
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().update("customfield_10012", new FieldOperation[]{new FieldOperation("set", (Object)"1981-00-0")});
        ParsedResponse response = this.issueClient.updateResponse(SAMPLE_ISSUE_KEY, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Error parsing date string: 1981-00-0", response.entity.errors.get("customfield_10012"));
        updateRequest = new IssueUpdateRequest().update("customfield_10012", new FieldOperation[]{new FieldOperation("set", (Object)"1981-13-1")});
        response = this.issueClient.updateResponse(SAMPLE_ISSUE_KEY, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Error parsing date string: 1981-13-1", response.entity.errors.get("customfield_10012"));
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testDateTime() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String dateTimeCF = (String)issue.fields.get("customfield_10001");
        Assert.assertNotNull((Object)dateTimeCF);
        this.textAssertions.assertEqualDateStrings("2010-06-16T15:26:00.000+1000", dateTimeCF);
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:datetime", (Object)((JsonTypeBean)issue.schema.get("customfield_10001")).getCustom());
        String renderedField = (String)issue.renderedFields.getCustomField("customfield_10001");
        Assert.assertEquals((Object)"16/Jun/10 3:26 PM", (Object)renderedField);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10001", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        dateTimeCF = (String)issue.fields.get("customfield_10001");
        Assert.assertNull((Object)dateTimeCF);
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().update("customfield_10001", new FieldOperation[]{new FieldOperation("set", (Object)"1981-00-00T15:12:00.000+1000")});
        ParsedResponse response = this.issueClient.updateResponse(SAMPLE_ISSUE_KEY, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Error parsing time: 1981-00-00T15:12:00.000+1000", response.entity.errors.get("customfield_10001"));
        updateRequest = new IssueUpdateRequest().update("customfield_10001", new FieldOperation[]{new FieldOperation("set", (Object)"1981-13-01T15:12:00.000+1000")});
        response = this.issueClient.updateResponse(SAMPLE_ISSUE_KEY, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Error parsing time: 1981-13-01T15:12:00.000+1000", response.entity.errors.get("customfield_10001"));
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testFloat() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        Double floatCF = (Double)issue.fields.get("customfield_10018");
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:float", (Object)((JsonTypeBean)issue.schema.get("customfield_10018")).getCustom());
        Assert.assertEquals((double)42.0, (double)floatCF, (double)0.0);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10018", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        floatCF = (Double)issue.fields.get("customfield_10018");
        Assert.assertNull((Object)floatCF);
    }

    @Test
    @Restore(value="TestIssueLinkCheck.xml")
    public void testImportId() {
        Issue issue = this.issueClient.get("ANOT-1", new Issue.Expand[]{Issue.Expand.schema});
        Double bugzillaId = (Double)issue.fields.get(SAMPLE_CASCADING_SELECT_CF_ID);
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:importid", (Object)((JsonTypeBean)issue.schema.get(SAMPLE_CASCADING_SELECT_CF_ID)).getCustom());
        Assert.assertEquals((double)2.0, (double)bugzillaId, (double)0.0);
        this.issueClient.edit("ANOT-1", new IssueUpdateRequest().update(SAMPLE_CASCADING_SELECT_CF_ID, new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("ANOT-1", new Issue.Expand[]{Issue.Expand.schema});
        bugzillaId = (Double)issue.fields.get(SAMPLE_CASCADING_SELECT_CF_ID);
        Assert.assertEquals((double)2.0, (double)bugzillaId, (double)0.0);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testSelect() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        Assert.assertEquals((Object)SELECT_CF_TYPE, (Object)((JsonTypeBean)issue.schema.get(SAMPLE_SELECT_CF_ID)).getCustom());
        Map option = (Map)issue.fields.get(SAMPLE_SELECT_CF_ID);
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/customFieldOption/10011"), option.get("self"));
        Assert.assertEquals((Object)"Select!", option.get(OPTION_VALUE_KEY));
        this.assertOptionEnabled(option);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update(SAMPLE_SELECT_CF_ID, new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        option = (Map)issue.fields.get(SAMPLE_SELECT_CF_ID);
        Assert.assertNull((Object)option);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testSelectOptionStateFlag() {
        this.checkSimpleCustomOptionStateFlag(SAMPLE_SELECT_CF_ID, SAMPLE_ISSUE_KEY);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testRadioButtons() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        Assert.assertThat((Object)((JsonTypeBean)issue.schema.get(SAMPLE_RADIO_CF_ID)).getCustom(), (Matcher)Matchers.equalTo((Object)RADIO_CF_TYPE));
        Map radioButtons = (Map)issue.fields.get(SAMPLE_RADIO_CF_ID);
        Assert.assertThat(radioButtons.get("self"), (Matcher)Matchers.equalTo((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/customFieldOption/10010")));
        Assert.assertThat(radioButtons.get(OPTION_VALUE_KEY), (Matcher)Matchers.equalTo((Object)"Radio Ga Ga"));
        Assert.assertThat((String)"id must be a string=10010", radioButtons.get("id"), (Matcher)Matchers.equalTo((Object)"10010"));
        this.assertOptionEnabled(radioButtons);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update(SAMPLE_RADIO_CF_ID, new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        radioButtons = (Map)issue.fields.get(SAMPLE_RADIO_CF_ID);
        Assert.assertNull((Object)radioButtons);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testRadioOptionStateFlag() {
        this.checkSimpleCustomOptionStateFlag(SAMPLE_RADIO_CF_ID, SAMPLE_ISSUE_KEY);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testProject() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        Map projectPicker = (Map)issue.fields.get("customfield_10007");
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:project", (Object)((JsonTypeBean)issue.schema.get("customfield_10007")).getCustom());
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/project/10001"), projectPicker.get("self"));
        Assert.assertEquals((Object)"MKY", projectPicker.get("key"));
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10007", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        projectPicker = (Map)issue.fields.get("customfield_10007");
        Assert.assertNull((Object)projectPicker);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testMultiVersion() {
        List multiVersion;
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        List versions = multiVersion = (List)issue.fields.get("customfield_10011");
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion", (Object)((JsonTypeBean)issue.schema.get("customfield_10011")).getCustom());
        Assert.assertEquals((long)2L, (long)versions.size());
        HashSet<Map<String, String>> expected = new HashSet<Map<String, String>>(2);
        expected.add(MapBuilder.newBuilder().add("self", this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/version/10000").add("name", "New Version 1").toMap());
        expected.add(MapBuilder.newBuilder().add("self", this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/version/10002").add("name", "New Version 5").toMap());
        HashSet found = new HashSet(2);
        found.add(MapBuilder.newBuilder().add("self", ((Map)versions.get(0)).get("self")).add("name", ((Map)versions.get(0)).get("name")).toMap());
        found.add(MapBuilder.newBuilder().add("self", ((Map)versions.get(1)).get("self")).add("name", ((Map)versions.get(1)).get("name")).toMap());
        Assert.assertEquals(found, expected);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10011", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        multiVersion = (List)issue.fields.get("customfield_10011");
        Assert.assertNull((Object)multiVersion);
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().customField(Long.valueOf(10011L), Collections.singletonList(EasyMap.build((Object)"id", (Object)"10005"))));
        ParsedResponse response = this.issueClient.updateResponse(SAMPLE_ISSUE_KEY, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Version id '10005' is not valid", response.entity.errors.get("customfield_10011"));
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testVersion() {
        Map version;
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        Map v4 = version = (Map)issue.fields.get("customfield_10009");
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:version", (Object)((JsonTypeBean)issue.schema.get("customfield_10009")).getCustom());
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/version/10001"), v4.get("self"));
        Assert.assertEquals((Object)"New Version 4", v4.get("name"));
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10009", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        version = (Map)issue.fields.get("customfield_10009");
        Assert.assertNull((Object)version);
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().customField(Long.valueOf(10009L), (Object)EasyMap.build((Object)"id", (Object)"10005")));
        ParsedResponse response = this.issueClient.updateResponse(SAMPLE_ISSUE_KEY, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Version id '10005' is not valid", response.entity.errors.get("customfield_10009"));
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testUserPicker() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        Map userPicker = (Map)issue.fields.get("customfield_10022");
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:userpicker", (Object)((JsonTypeBean)issue.schema.get("customfield_10022")).getCustom());
        Map fred = userPicker;
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/user?username=fred"), fred.get("self"));
        Assert.assertEquals((Object)"fred", fred.get("name"));
        Assert.assertEquals((Object)"Fred Normal", fred.get("displayName"));
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10022", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        userPicker = (Map)issue.fields.get("customfield_10022");
        Assert.assertNull((Object)userPicker);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testUrl() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String url = (String)issue.fields.get("customfield_10010");
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:url", (Object)((JsonTypeBean)issue.schema.get("customfield_10010")).getCustom());
        Assert.assertEquals((Object)"http://www.atlassian.com", (Object)url);
        String renderedField = (String)issue.renderedFields.getCustomField("customfield_10010");
        Assert.assertNull((Object)renderedField);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10010", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        url = (String)issue.fields.get("customfield_10010");
        Assert.assertNull((Object)url);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testMultiSelect() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        List multiSelect = (List)issue.fields.get(SAMPLE_MULTI_SELECT_CF_ID);
        Assert.assertEquals((Object)MULTI_SELECT_CF_TYPE, (Object)((JsonTypeBean)issue.schema.get(SAMPLE_MULTI_SELECT_CF_ID)).getCustom());
        Assert.assertEquals((long)2L, (long)multiSelect.size());
        boolean option2Present = false;
        boolean option3Present = false;
        List expectedValues = EasyList.build((Object)"Option 2", (Object)"Option 3");
        for (Map option : multiSelect) {
            Assert.assertTrue((boolean)expectedValues.contains(option.get(OPTION_VALUE_KEY)));
            if (option.get(OPTION_VALUE_KEY).equals("Option 2")) {
                option2Present = true;
                Assert.assertEquals((Object)"10007", option.get("id"));
                Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/customFieldOption/10007"), option.get("self"));
                this.assertOptionEnabled(option);
            }
            if (!option.get(OPTION_VALUE_KEY).equals("Option 3")) continue;
            option3Present = true;
            Assert.assertEquals((Object)"10008", option.get("id"));
            Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/customFieldOption/10008"), option.get("self"));
            this.assertOptionEnabled(option);
        }
        Assert.assertTrue((option2Present && option3Present ? 1 : 0) != 0);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update(SAMPLE_MULTI_SELECT_CF_ID, new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        multiSelect = (List)issue.fields.get(SAMPLE_MULTI_SELECT_CF_ID);
        Assert.assertNull((Object)multiSelect);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testMultiSelectOptionStateFlag() {
        this.checkComplexCustomOptionStateFlag(SAMPLE_MULTI_SELECT_CF_ID, SAMPLE_ISSUE_KEY);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testMultiCheckboxes() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        List multiCheckbox = (List)issue.fields.get(SAMPLE_MULTI_CHECKBOXES_CF_ID);
        Assert.assertEquals((Object)MULTI_CHECKBOXES_CF_TYPE, (Object)((JsonTypeBean)issue.schema.get(SAMPLE_MULTI_CHECKBOXES_CF_ID)).getCustom());
        Assert.assertEquals((long)1L, (long)multiCheckbox.size());
        Map option1 = (Map)multiCheckbox.get(0);
        Assert.assertEquals((Object)"10014", option1.get("id"));
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/customFieldOption/10014"), option1.get("self"));
        Assert.assertEquals((Object)"check out my stats", option1.get(OPTION_VALUE_KEY));
        this.assertOptionEnabled(option1);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update(SAMPLE_MULTI_CHECKBOXES_CF_ID, new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        multiCheckbox = (List)issue.fields.get(SAMPLE_MULTI_CHECKBOXES_CF_ID);
        Assert.assertNull((Object)multiCheckbox);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testMultiCheckboxesOptionStateFlag() {
        this.checkComplexCustomOptionStateFlag(SAMPLE_MULTI_CHECKBOXES_CF_ID, SAMPLE_ISSUE_KEY);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testMultiUserPicker() {
        List multiUser;
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        List users = multiUser = (List)issue.fields.get("customfield_10006");
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", (Object)((JsonTypeBean)issue.schema.get("customfield_10006")).getCustom());
        Assert.assertEquals((long)2L, (long)users.size());
        Map admin = (Map)users.get(0);
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/user?username=admin"), admin.get("self"));
        Assert.assertEquals((Object)"admin", admin.get("name"));
        Assert.assertEquals((Object)"Administrator", admin.get("displayName"));
        Map fred = (Map)users.get(1);
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/user?username=fred"), fred.get("self"));
        Assert.assertEquals((Object)"fred", fred.get("name"));
        Assert.assertEquals((Object)"Fred Normal", fred.get("displayName"));
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10006", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        multiUser = (List)issue.fields.get("customfield_10006");
        Assert.assertNull((Object)multiUser);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testMultiGroupPicker() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        List groups = (List)issue.fields.get("customfield_10005");
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker", (Object)((JsonTypeBean)issue.schema.get("customfield_10005")).getCustom());
        Assert.assertEquals((long)2L, (long)groups.size());
        Map developers = (Map)groups.get(0);
        Assert.assertEquals((Object)"jira-developers", developers.get("name"));
        Map users = (Map)groups.get(1);
        Assert.assertEquals((Object)"jira-users", users.get("name"));
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10005", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        groups = (List)issue.fields.get("customfield_10005");
        Assert.assertNull((Object)groups);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testGroupPicker() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        Map group = (Map)issue.fields.get("customfield_10002");
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:grouppicker", (Object)((JsonTypeBean)issue.schema.get("customfield_10002")).getCustom());
        Assert.assertEquals((Object)"jira-developers", group.get("name"));
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10002", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        group = (Map)issue.fields.get("customfield_10002");
        Assert.assertNull((Object)group);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testCascadingSelect() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        Map option = (Map)issue.fields.get(SAMPLE_CASCADING_SELECT_CF_ID);
        Assert.assertEquals((Object)CASCADING_SELECT_CF_TYPE, (Object)((JsonTypeBean)issue.schema.get(SAMPLE_CASCADING_SELECT_CF_ID)).getCustom());
        if (option.get(OPTION_VALUE_KEY).equals("Option 2")) {
            Assert.assertEquals((Object)"Option 2", option.get(OPTION_VALUE_KEY));
            Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/customFieldOption/10001"), option.get("self"));
            this.assertOptionEnabled(option);
            Assert.assertNull(option.get("children"));
            Map<String, Object> child = this.getChildOption(option);
            Assert.assertEquals((Object)"Sub-option I", (Object)child.get(OPTION_VALUE_KEY));
            Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/customFieldOption/10004"), (Object)child.get("self"));
            this.assertOptionEnabled(child);
            Assert.assertNull((Object)child.get("child"));
            Assert.assertNull((Object)child.get("children"));
        }
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update(SAMPLE_CASCADING_SELECT_CF_ID, new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        option = (Map)issue.fields.get(SAMPLE_CASCADING_SELECT_CF_ID);
        Assert.assertNull((Object)option);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testCascadingSelectOptionStateFlag() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        Map option = (Map)issue.fields.get(SAMPLE_CASCADING_SELECT_CF_ID);
        Map<String, Object> childOption = this.getChildOption(option);
        this.assertOptionEnabled(option);
        this.assertOptionEnabled(childOption);
        this.backdoor.customFields().disableOption(this.getOptionId(option));
        this.backdoor.customFields().disableOption(this.getOptionId(childOption));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        option = (Map)issue.fields.get(SAMPLE_CASCADING_SELECT_CF_ID);
        childOption = this.getChildOption(option);
        this.assertOptionDisabled(option);
        this.assertOptionDisabled(childOption);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testLabels() {
        Issue issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        List labels = (List)issue.fields.get("customfield_10004");
        Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:labels", (Object)((JsonTypeBean)issue.schema.get("customfield_10004")).getCustom());
        Assert.assertEquals(Arrays.asList("wack", "whoa"), (Object)labels);
        this.issueClient.edit(SAMPLE_ISSUE_KEY, new IssueUpdateRequest().update("customfield_10004", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        labels = (List)issue.fields.get("customfield_10004");
        Assert.assertNull((Object)labels);
    }

    @Test
    @Restore(value="TestIssueResourceCustomFields.xml")
    public void testEmptyFieldsReturned() {
        this.backdoor.issues().createIssue("HSP", "some issue", null, "Minor", "Bug");
        Issue issue = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        Issue.Fields fields = issue.fields;
        Assert.assertTrue((boolean)fields.has(SAMPLE_CASCADING_SELECT_CF_ID));
        Assert.assertNull((Object)fields.get(SAMPLE_CASCADING_SELECT_CF_ID));
        Assert.assertTrue((boolean)fields.has("customfield_10012"));
        Assert.assertNull((Object)fields.get("customfield_10012"));
        Assert.assertTrue((boolean)fields.has("customfield_10001"));
        Assert.assertNull((Object)fields.get("customfield_10001"));
        Assert.assertTrue((boolean)fields.has("customfield_10013"));
        Assert.assertNull((Object)fields.get("customfield_10013"));
        Assert.assertTrue((boolean)fields.has("customfield_10002"));
        Assert.assertNull((Object)fields.get("customfield_10002"));
        Assert.assertTrue((boolean)fields.has("customfield_10003"));
        Assert.assertNull((Object)fields.get("customfield_10003"));
        Assert.assertTrue((boolean)fields.has(SAMPLE_MULTI_CHECKBOXES_CF_ID));
        Assert.assertNull((Object)fields.get(SAMPLE_MULTI_CHECKBOXES_CF_ID));
        Assert.assertTrue((boolean)fields.has(SAMPLE_MULTI_SELECT_CF_ID));
        Assert.assertNull((Object)fields.get(SAMPLE_MULTI_SELECT_CF_ID));
        Assert.assertTrue((boolean)fields.has("customfield_10005"));
        Assert.assertNull((Object)fields.get("customfield_10005"));
        Assert.assertTrue((boolean)fields.has("customfield_10006"));
        Assert.assertNull((Object)fields.get("customfield_10006"));
        Assert.assertTrue((boolean)fields.has("customfield_10018"));
        Assert.assertNull((Object)fields.get("customfield_10018"));
        Assert.assertTrue((boolean)fields.has("customfield_10007"));
        Assert.assertNull((Object)fields.get("customfield_10007"));
        Assert.assertTrue((boolean)fields.has(SAMPLE_RADIO_CF_ID));
        Assert.assertNull((Object)fields.get(SAMPLE_RADIO_CF_ID));
        Assert.assertTrue((boolean)fields.has("customfield_10008"));
        Assert.assertNull((Object)fields.get("customfield_10008"));
        Assert.assertTrue((boolean)fields.has(SAMPLE_SELECT_CF_ID));
        Assert.assertNull((Object)fields.get(SAMPLE_SELECT_CF_ID));
        Assert.assertTrue((boolean)fields.has("customfield_10009"));
        Assert.assertNull((Object)fields.get("customfield_10009"));
        Assert.assertTrue((boolean)fields.has("customfield_10021"));
        Assert.assertNull((Object)fields.get("customfield_10021"));
        Assert.assertTrue((boolean)fields.has("customfield_10010"));
        Assert.assertNull((Object)fields.get("customfield_10010"));
        Assert.assertTrue((boolean)fields.has("customfield_10022"));
        Assert.assertNull((Object)fields.get("customfield_10022"));
        Assert.assertTrue((boolean)fields.has("customfield_10011"));
        Assert.assertNull((Object)fields.get("customfield_10011"));
    }

    private void checkSimpleCustomOptionStateFlag(String customFieldId, String issueKey) {
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[]{Issue.Expand.schema});
        Map option = (Map)issue.fields.get(customFieldId);
        this.assertOptionEnabled(option);
        this.backdoor.customFields().disableOption(this.getOptionId(option));
        issue = this.issueClient.get(issueKey, new Issue.Expand[]{Issue.Expand.schema});
        option = (Map)issue.fields.get(customFieldId);
        this.assertOptionDisabled(option);
    }

    private void checkComplexCustomOptionStateFlag(String customFieldId, String issueKey) {
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[]{Issue.Expand.schema});
        Collection customFieldOptions = (Collection)issue.fields.get(customFieldId);
        customFieldOptions.forEach(option -> {
            this.assertOptionEnabled((Map<String, Object>)option);
            this.backdoor.customFields().disableOption(this.getOptionId((Map<String, Object>)option));
        });
        issue = this.issueClient.get(SAMPLE_ISSUE_KEY, new Issue.Expand[]{Issue.Expand.schema});
        customFieldOptions = (Collection)issue.fields.get(customFieldId);
        customFieldOptions.forEach(this::assertOptionDisabled);
    }

    private Long getOptionId(Map<String, Object> option) {
        return Long.valueOf(String.valueOf(option.get("id")));
    }

    private Map<String, Object> getChildOption(Map<String, Object> option) {
        return (Map)option.get("child");
    }

    private void assertOptionEnabled(Map<String, Object> option) {
        Assert.assertThat((Object)option.get("disabled"), (Matcher)Matchers.equalTo((Object)Boolean.FALSE));
    }

    private void assertOptionDisabled(Map<String, Object> option) {
        Assert.assertThat((Object)option.get("disabled"), (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
    }
}

