/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestIssueResourceDelete.xml")
public class TestIssueResourceDelete
extends BaseJiraRestTest {
    private IssueClient issueClient;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testSimpleDelete() throws Exception {
        ParsedResponse resp1 = this.issueClient.delete("HSP-5", null);
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        resp1 = this.issueClient.getResponse("HSP-5");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Issue Does Not Exist"));
        resp1 = this.issueClient.delete("10013", null);
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        resp1 = this.issueClient.getResponse("HSP-6");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Issue Does Not Exist"));
    }

    @Test
    public void testErrors() throws Exception {
        ParsedResponse resp1 = this.issueClient.delete("HSP-567", null);
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Issue Does Not Exist"));
        resp1 = ((IssueClient)this.issueClient.loginAs("fred")).delete("HSP-5", null);
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)403));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("You do not have permission to delete issues in this project."));
    }

    @Test
    public void testSubtasks() throws Exception {
        ParsedResponse resp1 = this.issueClient.delete("HSP-7", null);
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("The issue 'HSP-7' has subtasks.  You must specify the 'deleteSubtasks' parameter to delete this issue and all its subtasks."));
        resp1 = this.issueClient.delete("HSP-7", "false");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("The issue 'HSP-7' has subtasks.  You must specify the 'deleteSubtasks' parameter to delete this issue and all its subtasks."));
        resp1 = this.issueClient.delete("HSP-7", "true");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        resp1 = this.issueClient.getResponse("HSP-7");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Issue Does Not Exist"));
        resp1 = this.issueClient.delete("HSP-1", null);
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("The issue 'HSP-1' has subtasks.  You must specify the 'deleteSubtasks' parameter to delete this issue and all its subtasks."));
        resp1 = this.issueClient.delete("HSP-2", null);
        resp1 = this.issueClient.delete("HSP-3", null);
        resp1 = this.issueClient.delete("HSP-4", null);
        resp1 = this.issueClient.delete("HSP-1", null);
        resp1 = this.issueClient.getResponse("HSP-1");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        resp1 = this.issueClient.getResponse("HSP-2");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        resp1 = this.issueClient.getResponse("HSP-3");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        resp1 = this.issueClient.getResponse("HSP-4");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
    }
}

