/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraIssueMetaTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.UserHistoryControl;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.BeanClient;
import com.atlassian.jira.testkit.client.restclient.FieldMetaData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueBean;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssuePickerBean;
import com.atlassian.jira.testkit.client.restclient.LabelSuggestionBean;
import com.atlassian.jira.testkit.client.restclient.LabelSuggestionsBean;
import com.atlassian.jira.testkit.client.restclient.SectionBean;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserBean;
import com.atlassian.jira.testkit.client.restclient.UserPickerResultBean;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestIssueResourceEditMeta.xml")
public class TestIssueResourceEditMeta
extends BaseJiraIssueMetaTest {
    private static final FeatureFlag PRIORITIES_PER_PROJECT = FeatureFlag.featureFlag((String)"jira.priorities.per.project");
    private IssueClient issueClient;
    private BeanClient beanClient;

    @Before
    public void setup() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.beanClient = new BeanClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testEditmetaViaExpand() throws Exception {
        String restApiBaseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm() + "/rest/api/2/";
        Issue issue = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertNull((Object)issue.editmeta);
        issue = this.issueClient.get("TST-1", new Issue.Expand[]{Issue.Expand.editmeta});
        Assert.assertNotNull((Object)issue.editmeta);
        Assert.assertThat((Object)issue.editmeta.fields, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasKey((Object)"summary"), Matchers.hasKey((Object)"description"), Matchers.hasKey((Object)"timetracking"), Matchers.hasKey((Object)"issuetype"), Matchers.hasKey((Object)"labels"), Matchers.hasKey((Object)"assignee"), Matchers.hasKey((Object)"resolution"), Matchers.hasKey((Object)"attachment"), Matchers.hasKey((Object)"comment"), Matchers.hasKey((Object)"worklog"), Matchers.hasKey((Object)"security"), Matchers.hasKey((Object)"versions"), Matchers.hasKey((Object)"fixVersions"), Matchers.hasKey((Object)"resolution")}));
        FieldMetaData versions = (FieldMetaData)issue.editmeta.fields.get("versions");
        FieldMetaData resolutions = (FieldMetaData)issue.editmeta.fields.get("resolution");
        List versionsAllowedValues = versions.allowedValues;
        Assert.assertThat((Object)versionsAllowedValues, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)versionsAllowedValues, (Matcher)Matchers.everyItem(this.selfUrlMatcher(restApiBaseUrl + "version/{id}")));
        List resolutionsAllowedValues = resolutions.allowedValues;
        Assert.assertThat((Object)resolutionsAllowedValues, (Matcher)Matchers.hasSize((int)5));
        Assert.assertThat((Object)resolutionsAllowedValues, (Matcher)Matchers.everyItem(this.selfUrlMatcher(restApiBaseUrl + "resolution/{id}")));
        issue = this.issueClient.getPartially("TST-1", EnumSet.of(Issue.Expand.editmeta), new StringList[]{StringList.fromList((String[])new String[]{"summary", "description"})});
        Assert.assertNotNull((Object)issue.editmeta);
        Assert.assertThat((Object)issue.editmeta.fields, (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)"summary"), (Matcher)Matchers.hasKey((Object)"description")));
        Assert.assertThat(issue.editmeta.fields.keySet(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testEditMetaAllowedValuesForCustomFieldWithEnabledOptions() {
        List<String> customFields = this.addSampleCustomFieldsWithOptions(true);
        Issue issue = this.issueClient.get("TST-1", new Issue.Expand[]{Issue.Expand.editmeta});
        this.getCustomFieldMetaData(customFields, issue).forEach(this::assertFieldAllowedValuesEnabled);
    }

    @Test
    public void testEditMetaAllowedValuesForCustomFieldWithDisabledOptions() {
        List<String> customFields = this.addSampleCustomFieldsWithOptions(false);
        Issue issue = this.issueClient.get("TST-1", new Issue.Expand[]{Issue.Expand.editmeta});
        this.getCustomFieldMetaData(customFields, issue).forEach(this::assertFieldAllowedValuesDisabled);
    }

    @Test
    public void testEditMetaAutoCompleteUrls() throws Exception {
        this.getUserHistoryClient().addIssue("admin", "TST-2");
        this.getUserHistoryClient().addIssue("admin", "TST-3");
        Issue issue = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertNull((Object)issue.editmeta);
        issue = this.issueClient.get("TST-1", new Issue.Expand[]{Issue.Expand.editmeta});
        Assert.assertNotNull((Object)issue.editmeta);
        FieldMetaData assignee = (FieldMetaData)issue.editmeta.fields.get("assignee");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)assignee.autoCompleteUrl));
        List assigneeSuggestions = this.beanClient.getUsersFromUrl(assignee.autoCompleteUrl + "a");
        Assert.assertEquals((long)1L, (long)assigneeSuggestions.size());
        Assert.assertEquals((Object)"admin", (Object)((User)assigneeSuggestions.get((int)0)).displayName);
        FieldMetaData reporter = (FieldMetaData)issue.editmeta.fields.get("reporter");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)reporter.autoCompleteUrl));
        List reporterSuggestions = this.beanClient.getUsersFromUrl(reporter.autoCompleteUrl + "a");
        Assert.assertEquals((long)1L, (long)reporterSuggestions.size());
        Assert.assertEquals((Object)"admin", (Object)((User)reporterSuggestions.get((int)0)).displayName);
        FieldMetaData issueLinks = (FieldMetaData)issue.editmeta.fields.get("issuelinks");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)issueLinks.autoCompleteUrl));
        IssuePickerBean issuePickerBean = this.beanClient.getIssueSuggestionsFromUrl(issueLinks.autoCompleteUrl + "TS");
        Assert.assertEquals((long)2L, (long)((SectionBean)issuePickerBean.sections.get((int)0)).issues.size());
        SectionBean sectionBean = (SectionBean)issuePickerBean.sections.get(0);
        Assert.assertTrue((boolean)this.containsBeanWithKey(sectionBean.issues, "TST-2"));
        Assert.assertTrue((boolean)this.containsBeanWithKey(sectionBean.issues, "TST-3"));
        FieldMetaData labels = (FieldMetaData)issue.editmeta.fields.get("labels");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)labels.autoCompleteUrl));
        LabelSuggestionsBean labelSuggestionBean = this.beanClient.getLabelSuggestionsFromUrl(labels.autoCompleteUrl + "b");
        Assert.assertEquals((long)2L, (long)labelSuggestionBean.suggestions.size());
        Assert.assertEquals((Object)"bar", (Object)((LabelSuggestionBean)labelSuggestionBean.suggestions.get((int)0)).label);
        Assert.assertEquals((Object)"bob", (Object)((LabelSuggestionBean)labelSuggestionBean.suggestions.get((int)1)).label);
        FieldMetaData userPickerCF = (FieldMetaData)issue.editmeta.fields.get("customfield_10010");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)userPickerCF.autoCompleteUrl));
        UserPickerResultBean userPickerResultBean = this.beanClient.getUserPickResultsFromUrl(userPickerCF.autoCompleteUrl + "a");
        Assert.assertEquals((long)1L, (long)userPickerResultBean.users.size());
        Assert.assertEquals((Object)"admin", (Object)((UserBean)userPickerResultBean.users.get((int)0)).name);
        FieldMetaData multiUserPickerCF = (FieldMetaData)issue.editmeta.fields.get("customfield_10110");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)multiUserPickerCF.autoCompleteUrl));
        UserPickerResultBean multiUserPickerResultBean = this.beanClient.getUserPickResultsFromUrl(multiUserPickerCF.autoCompleteUrl + "a");
        Assert.assertEquals((long)1L, (long)multiUserPickerResultBean.users.size());
        Assert.assertEquals((Object)"admin", (Object)((UserBean)multiUserPickerResultBean.users.get((int)0)).name);
        FieldMetaData labelCF = (FieldMetaData)issue.editmeta.fields.get("customfield_10210");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)labelCF.autoCompleteUrl));
        LabelSuggestionsBean labelSuggestionsBean = this.beanClient.getLabelSuggestionsFromUrl(labelCF.autoCompleteUrl + "b");
        Assert.assertEquals((long)1L, (long)labelSuggestionsBean.suggestions.size());
        Assert.assertEquals((Object)"bob", (Object)((LabelSuggestionBean)labelSuggestionsBean.suggestions.get((int)0)).label);
    }

    private UserHistoryControl getUserHistoryClient() {
        return this.backdoor.getTestkit().userHistory();
    }

    @Test
    public void testFieldsFilteredByPermissions() {
        Issue issue = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertNull((Object)issue.editmeta);
        issue = ((IssueClient)this.issueClient.loginAs("fry")).get("TST-1", new Issue.Expand[]{Issue.Expand.editmeta});
        Assert.assertNotNull((Object)issue.editmeta);
        Assert.assertThat((Object)issue.editmeta.fields, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasKey((Object)"summary"), Matchers.hasKey((Object)"description"), Matchers.hasKey((Object)"timetracking"), Matchers.hasKey((Object)"issuetype"), Matchers.hasKey((Object)"labels"), Matchers.hasKey((Object)"resolution"), Matchers.hasKey((Object)"attachment"), Matchers.hasKey((Object)"security")}));
        Assert.assertThat((Object)issue.editmeta.fields, (Matcher)Matchers.not((Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)"comment"), (Matcher)Matchers.hasKey((Object)"worklog"), (Matcher)Matchers.hasKey((Object)"assignee"))));
    }

    @Test
    public void testNothingWhenNoEditPermissions() {
        Issue issue = ((IssueClient)this.issueClient.loginAs("fry")).get("PH-1", new Issue.Expand[]{Issue.Expand.editmeta});
        Assert.assertNotNull((Object)issue.editmeta);
        Assert.assertTrue((String)"Editmeta is empty", (boolean)issue.editmeta.fields.isEmpty());
    }

    @Test
    public void testResponseIsEmptyWhenJiraIssueEditableIsSetToFalseOnWorkflow() {
        String closeIssueTransition = "2";
        IssueUpdateRequest request = new IssueUpdateRequest();
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.CLOSE_ISSUES, "admin");
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.RESOLVE_ISSUES, "admin");
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.TRANSITION_ISSUES, "admin");
        request.transition(ResourceRef.withId((String)closeIssueTransition));
        this.issueClient.transition("TST-1", request);
        Issue issue = this.issueClient.get("TST-1", new Issue.Expand[]{Issue.Expand.editmeta});
        Assert.assertNotNull((Object)issue.editmeta);
        Assert.assertThat(issue.editmeta.fields.keySet(), (Matcher)Matchers.empty());
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=76001)
    public void testPrioritySchemes() throws Exception {
        this.backdoor.darkFeatures().enableForSite(PRIORITIES_PER_PROJECT);
        long schemeId = this.backdoor.prioritySchemes().createPriorityScheme("test scheme", "", (List<String>)ImmutableList.of((Object)"5", (Object)"3", (Object)"1"));
        this.backdoor.prioritySchemes().assignProject(schemeId, 10000L);
        FieldMetaData fieldMetaData = (FieldMetaData)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[]{Issue.Expand.editmeta}).editmeta.fields.get("priority");
        Assert.assertThat(fieldMetaData.allowedValues.stream().map(o -> (String)((HashMap)o).get("id")).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"5", "3", "1"}));
        this.backdoor.darkFeatures().disableForSite(PRIORITIES_PER_PROJECT);
        fieldMetaData = (FieldMetaData)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[]{Issue.Expand.editmeta}).editmeta.fields.get("priority");
        Assert.assertThat(fieldMetaData.allowedValues.stream().map(o -> (String)((HashMap)o).get("id")).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"1", "2", "3", "4", "5"}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=76001)
    public void testWithDefaultPriorityScheme() throws Exception {
        this.backdoor.darkFeatures().disableForSite(PRIORITIES_PER_PROJECT);
        FieldMetaData fieldMetaData = (FieldMetaData)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[]{Issue.Expand.editmeta}).editmeta.fields.get("priority");
        Assert.assertThat(fieldMetaData.allowedValues.stream().map(o -> (String)((HashMap)o).get("id")).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"1", "2", "3", "4", "5"}));
        this.backdoor.darkFeatures().enableForSite(PRIORITIES_PER_PROJECT);
        fieldMetaData = (FieldMetaData)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[]{Issue.Expand.editmeta}).editmeta.fields.get("priority");
        Assert.assertThat(fieldMetaData.allowedValues.stream().map(o -> (String)((HashMap)o).get("id")).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"1", "2", "3", "4", "5"}));
    }

    private boolean containsBeanWithKey(List<IssueBean> issueBeans, String key) {
        for (IssueBean issueBean : issueBeans) {
            if (!issueBean.key.equals(key)) continue;
            return true;
        }
        return false;
    }

    private Matcher<Map<String, String>> selfUrlMatcher(final String url) {
        return new TypeSafeMatcher<Map<String, String>>(){

            public void describeTo(Description description) {
                description.appendText("item containing self url: ").appendValue((Object)url);
            }

            protected boolean matchesSafely(Map<String, String> item) {
                return url.replaceAll("\\{id\\}", item.get("id")).equals(item.get("self"));
            }
        };
    }

    private List<FieldMetaData> getCustomFieldMetaData(List<String> customFields, Issue issue) {
        return issue.editmeta.fields.values().stream().filter(metaData -> customFields.contains(metaData.name)).collect(Collectors.toList());
    }
}

