/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.DevMode;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.rule.IssueTypeUrls;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.Priority;
import com.atlassian.jira.testkit.client.restclient.Progress;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.Resolution;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.Status;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.Vote;
import com.atlassian.jira.testkit.client.restclient.Watches;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestIssueResourceFields.xml")
public class TestIssueResourceFields
extends BaseJiraFuncTest {
    @Rule
    public final IssueTypeUrls issueTypeUrls = new IssueTypeUrls();
    @Inject
    private FuncTestUrlHelper urlHelper;
    private Long defaultAvatarId;
    private IssueClient issueClient;
    private SearchClient searchClient;

    @Test
    public void testExpandos() throws Exception {
        Issue minimal = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertThat((Object)minimal.expand, (Matcher)Matchers.containsString((String)Issue.Expand.renderedFields.name()));
        Assert.assertThat((Object)minimal.renderedFields, (Matcher)Matchers.equalTo(null));
        Issue expanded = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        Assert.assertNotNull((Object)expanded.renderedFields.environment);
        Assert.assertNotNull((Object)expanded.renderedFields.description);
        Assert.assertEquals((long)1L, (long)expanded.renderedFields.comment.getComments().size());
        Assert.assertNotNull((Object)expanded.renderedFields.timetracking);
        Assert.assertEquals((long)1L, (long)expanded.renderedFields.worklog.worklogs.size());
    }

    @Test
    public void testRenderedTextFields() throws Exception {
        Issue expanded = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        Assert.assertEquals((Object)"Curabitur bibendum molestie eros vel pretium.\n", (Object)expanded.fields.environment);
        Assert.assertEquals((Object)"Curabitur bibendum molestie eros vel pretium.<br/>\n", (Object)expanded.renderedFields.environment);
        Assert.assertEquals((Object)"Suspendisse a mi augue. Donec quis.\n", (Object)expanded.fields.description);
        Assert.assertEquals((Object)"Suspendisse a mi augue. Donec quis.<br/>\n", (Object)expanded.renderedFields.description);
    }

    @Test
    public void testRenderedDateFields() throws Exception {
        Issue expanded = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        Assert.assertEquals((Object)"2010-06-11T12:17:45.383+1000", (Object)expanded.fields.created);
        Assert.assertEquals((Object)"11/Jun/10 12:17 PM", (Object)expanded.renderedFields.created);
        Assert.assertEquals((Object)"2010-06-11T12:25:16.265+1000", (Object)expanded.fields.updated);
        Assert.assertEquals((Object)"11/Jun/10 12:25 PM", (Object)expanded.renderedFields.updated);
        Assert.assertEquals((Object)"2010-06-11T12:19:10.488+1000", (Object)expanded.fields.resolutiondate);
        Assert.assertEquals((Object)"11/Jun/10 12:19 PM", (Object)expanded.renderedFields.resolutiondate);
        Assert.assertEquals((Object)"2010-06-23", (Object)expanded.fields.duedate);
        Assert.assertEquals((Object)"23/Jun/10", (Object)expanded.renderedFields.duedate);
    }

    @Test
    public void testSystemFields() throws Exception {
        Issue json = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields, Issue.Expand.transitions});
        Assert.assertEquals((Object)"10000", (Object)json.id);
        Assert.assertEquals((Object)"HSP-1", (Object)json.key);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/issue/10000"), (Object)json.self);
        Assert.assertNotNull((Object)json.fields);
        Assert.assertNotNull((Object)json.transitions);
        Assert.assertNotNull((Object)json.renderedFields);
        Assert.assertEquals((long)2L, (long)json.transitions.size());
        Issue.Fields fields = json.fields;
        Assert.assertNotNull((Object)fields.summary);
        Assert.assertEquals((Object)"Donec posuere tellus nulla; vitae pellentesque.", (Object)fields.summary);
        Vote votes = fields.votes;
        Assert.assertEquals((long)0L, (long)votes.votes);
        Assert.assertEquals((Object)false, (Object)votes.hasVoted);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/issue/HSP-1/votes"), (Object)votes.self);
        Watches watchers = fields.watches;
        Assert.assertEquals((long)1L, (long)watchers.watchCount);
        Assert.assertEquals((Object)true, (Object)watchers.isWatching);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/issue/HSP-1/watchers"), (Object)watchers.self);
        Assert.assertNotNull((Object)fields.security);
        Assert.assertEquals((Object)"Insecure", (Object)fields.security.name);
        Assert.assertNotNull((Object)fields.resolutiondate);
        this.assertEqualDateStrings("2010-06-11T12:19:10.488+1000", fields.resolutiondate);
        Assert.assertNotNull((Object)fields.environment);
        Assert.assertEquals((Object)"Curabitur bibendum molestie eros vel pretium.<br/>\n", (Object)json.renderedFields.environment);
        Assert.assertNotNull((Object)fields.updated);
        this.assertEqualDateStrings("2010-06-11T12:25:16.265+1000", fields.updated);
        Assert.assertNotNull((Object)fields.created);
        this.assertEqualDateStrings("2010-06-11T12:17:45.383+1000", fields.created);
        Assert.assertNotNull((Object)fields.description);
        Assert.assertEquals((Object)"Suspendisse a mi augue. Donec quis.<br/>\n", (Object)json.renderedFields.description);
        Assert.assertNotNull((Object)fields.duedate);
        Assert.assertEquals((Object)"2010-06-23", (Object)fields.duedate);
        this.checkLabels(fields);
        Assert.assertNotNull((Object)fields.timetracking);
        this.checkIssueType(fields);
        this.checkStatus(fields);
        this.checkAssignee(fields);
        this.checkReporter(fields);
        this.checkResolution(fields);
        this.checkProject(fields);
        this.checkPriority(fields);
        this.checkProgress(fields);
        this.checkComponents(fields);
        this.checkFixVersions(fields);
        this.checkVersions(fields);
    }

    @Test
    public void testFieldsParam() throws Exception {
        HashSet fieldsToInclude = Sets.newHashSet((Object[])new String[]{"summary", "status", "assignee"});
        Issue json = this.issueClient.getPartially("HSP-2", new StringList[]{StringList.fromList((String[])new String[]{"summary"}), StringList.fromList((String[])new String[]{"status", "assignee"})});
        Issue.Fields fields = json.fields;
        Assert.assertNotNull((Object)fields);
        for (String field : fieldsToInclude) {
            Assert.assertNotNull((String)("field was not returned: " + field), (Object)fields.get(field));
        }
        Sets.SetView notReturnedFields = Sets.difference((Set)fields.idSet(), (Set)fieldsToInclude);
        for (String field : notReturnedFields) {
            Assert.assertNull((String)("field was returned: " + field), (Object)fields.get(field));
        }
    }

    @Test
    public void testNoCommentsInSearch() throws Exception {
        SearchRequest search = new SearchRequest().jql("KEY = HSP-2");
        SearchResult result = this.searchClient.getSearch(search);
        Assert.assertEquals((long)1L, (long)result.issues.size());
        Issue json = (Issue)result.issues.get(0);
        Assert.assertNull((Object)json.fields.comment);
    }

    @Test
    public void testAddingCommentsInSearch() throws Exception {
        SearchRequest search = new SearchRequest().jql("KEY = HSP-2").fields(new String[]{"*navigable", "comment"});
        SearchResult result = this.searchClient.getSearch(search);
        Assert.assertEquals((long)1L, (long)result.issues.size());
        Issue json = (Issue)result.issues.get(0);
        Assert.assertNotNull((Object)json.fields.comment);
        Assert.assertEquals((Object)0, (Object)json.fields.comment.getTotal());
    }

    @Test
    public void testFieldsParamWithCustomFields() throws Exception {
        Issue json = this.issueClient.getPartially("HSP-2", new StringList[]{StringList.fromList((String[])new String[]{"summary", "status", "assignee", "customfield_10001"})});
        Issue.Fields fields = json.fields;
        Assert.assertNotNull((Object)fields);
        Assert.assertNotNull((Object)fields.get("summary"));
        Assert.assertNotNull((Object)fields.get("status"));
        Assert.assertNotNull((Object)fields.get("assignee"));
        Assert.assertNotNull((Object)fields.get("customfield_10001"));
        Set idSet = fields.idSet();
        idSet.remove("summary");
        idSet.remove("status");
        idSet.remove("assignee");
        idSet.remove("customfield_10001");
        for (String id : idSet) {
            Assert.assertNull((Object)fields.get(id));
        }
    }

    @Test
    public void testFieldsNotShown() throws Exception {
        Issue json = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        Issue.Fields fields = json.fields;
        Assert.assertNotNull((Object)fields);
        try {
            fields.get("customfield_10100");
            Assert.fail((String)"Customfield 10100 should not be present for this type of issue");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        json = this.issueClient.get("HSP-3", new Issue.Expand[0]);
        fields = json.fields;
        Assert.assertNotNull((Object)fields);
        Assert.assertNotNull((Object)fields.get("customfield_10100"));
        Assert.assertEquals((Object)"Elizabeth", (Object)fields.get("customfield_10100"));
    }

    @Test
    public void testPriorityIssueTypeAndStatusIconUrlShouldBeReturnedCorrectlyIfItIsAnAbsoluteUrl() throws Exception {
        Issue hsp2 = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        Assert.assertThat((Object)hsp2.fields.issuetype.iconUrl, (Matcher)Matchers.equalTo((Object)"http://127.0.0.1:8090/jira/images/icons/task.gif"));
        Assert.assertThat((Object)hsp2.fields.priority.iconUrl(), (Matcher)Matchers.equalTo((Object)"http://127.0.0.1:8090/jira/images/icons/priority_critical.gif"));
        Assert.assertThat((Object)hsp2.fields.status.iconUrl(), (Matcher)Matchers.equalTo((Object)"http://127.0.0.1:8090/jira/images/icons/status_open.gif"));
    }

    @Test
    @DevMode
    public void testArchivingFields() {
        Issue hsp1 = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertNull((Object)hsp1.fields.get("archiveddate"));
        Assert.assertNull((Object)hsp1.fields.get("archivedby"));
        this.backdoor.issues().archiveIssue("HSP-2");
        Issue hsp2 = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        Assert.assertNotNull((Object)hsp2.fields.get("archiveddate"));
        String userName = (String)((Map)hsp2.fields.get("archivedby")).get("name");
        Assert.assertThat((Object)userName, (Matcher)Matchers.equalTo((Object)"admin"));
    }

    @Test
    @DevMode
    public void testProjectArchivingFields() {
        Issue hsp1 = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertNull((Object)hsp1.fields.get("archiveddate"));
        Assert.assertNull((Object)hsp1.fields.get("archivedby"));
        this.backdoor.project().archiveProject("HSP");
        Issue hsp2 = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        Assert.assertNotNull((Object)hsp2.fields.get("archiveddate"));
        String userName = (String)((Map)hsp2.fields.get("archivedby")).get("name");
        Assert.assertThat((Object)userName, (Matcher)Matchers.equalTo((Object)"admin"));
    }

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.searchClient = new SearchClient((JIRAEnvironmentData)this.environmentData);
        this.defaultAvatarId = Long.parseLong(this.backdoor.applicationProperties().getString("jira.avatar.default.id"));
    }

    private void checkFixVersions(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.fixVersions);
        List versions = fields.fixVersions;
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/version/10000"), (Object)((Version)versions.get((int)0)).self);
        Assert.assertEquals((Object)"Test Version Description 1", (Object)((Version)versions.get((int)0)).description);
        Assert.assertEquals((Object)"New Version 1", (Object)((Version)versions.get((int)0)).name);
        Assert.assertFalse((boolean)((Version)versions.get((int)0)).archived);
        Assert.assertFalse((boolean)((Version)versions.get((int)0)).released);
        Assert.assertEquals((Object)this.urlHelper.getRestApiUrl("version/10002"), (Object)((Version)versions.get((int)1)).self);
        Assert.assertEquals((Object)"Test Version Description 5", (Object)((Version)versions.get((int)1)).description);
        Assert.assertEquals((Object)"New Version 5", (Object)((Version)versions.get((int)1)).name);
        Assert.assertFalse((boolean)((Version)versions.get((int)1)).archived);
        Assert.assertFalse((boolean)((Version)versions.get((int)1)).released);
    }

    private void checkVersions(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.versions);
        List versions = fields.versions;
        Assert.assertEquals((Object)this.urlHelper.getRestApiUrl("version/10000"), (Object)((Version)versions.get((int)0)).self);
        Assert.assertEquals((Object)"Test Version Description 1", (Object)((Version)versions.get((int)0)).description);
        Assert.assertEquals((Object)"New Version 1", (Object)((Version)versions.get((int)0)).name);
        Assert.assertFalse((boolean)((Version)versions.get((int)0)).archived);
        Assert.assertFalse((boolean)((Version)versions.get((int)0)).released);
        Assert.assertEquals((Object)this.urlHelper.getRestApiUrl("version/10002"), (Object)((Version)versions.get((int)1)).self);
        Assert.assertEquals((Object)"Test Version Description 5", (Object)((Version)versions.get((int)1)).description);
        Assert.assertEquals((Object)"New Version 5", (Object)((Version)versions.get((int)1)).name);
        Assert.assertFalse((boolean)((Version)versions.get((int)1)).archived);
        Assert.assertFalse((boolean)((Version)versions.get((int)1)).released);
    }

    private void checkComponents(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.components);
        List components = fields.components;
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/component/10001"), (Object)((Component)components.get((int)0)).self);
        Assert.assertEquals((Object)"New Component 2", (Object)((Component)components.get((int)0)).name);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/component/10002"), (Object)((Component)components.get((int)1)).self);
        Assert.assertEquals((Object)"New Component 3", (Object)((Component)components.get((int)1)).name);
    }

    private void checkPriority(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.priority);
        Priority priority = fields.priority;
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/priority/3"), (Object)priority.self());
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/images/icons/priorities/major.svg"), (Object)priority.iconUrl());
        Assert.assertEquals((Object)"Major", (Object)priority.name());
        Assert.assertEquals((Object)"3", (Object)priority.id());
    }

    private void checkProgress(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.progress);
        Progress progress = fields.progress;
        Assert.assertEquals((Object)7200L, (Object)progress.progress());
        Assert.assertEquals((Object)648000L, (Object)progress.total());
        Assert.assertEquals((Object)1L, (Object)progress.percent());
        Assert.assertNotNull((Object)fields.aggregateprogress);
        Progress aggregateprogress = fields.aggregateprogress;
        Assert.assertEquals((Object)7200L, (Object)aggregateprogress.progress());
        Assert.assertEquals((Object)648000L, (Object)aggregateprogress.total());
        Assert.assertEquals((Object)1L, (Object)aggregateprogress.percent());
        Assert.assertNotNull((Object)fields.workratio);
        Assert.assertEquals((Object)1L, (Object)fields.workratio);
    }

    private void checkProject(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.project);
        Project project = fields.project;
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/project/10000"), (Object)project.self);
        Assert.assertEquals((Object)"10000", (Object)project.id);
        Assert.assertEquals((Object)"HSP", (Object)project.key);
        Assert.assertEquals((Object)"software", (Object)project.projectTypeKey);
        Assert.assertThat((Object)project.avatarUrls, (Matcher)Matchers.equalTo(this.createProjectAvatarUrls(10000L, 10011L)));
    }

    private void checkResolution(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.resolution);
        Resolution resolution = fields.resolution;
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/resolution/1"), (Object)resolution.self);
        Assert.assertEquals((Object)"1", (Object)resolution.id);
        Assert.assertEquals((Object)"Fixed", (Object)resolution.name);
    }

    private void checkAssignee(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.assignee);
        User user = fields.assignee;
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)user.self);
        Assert.assertEquals((Object)"admin", (Object)user.name);
        Assert.assertEquals((Object)"Administrator", (Object)user.displayName);
        Assert.assertThat((Object)user.avatarUrls, (Matcher)Matchers.equalTo(this.createUserAvatarUrls(10062L)));
    }

    private void checkReporter(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.reporter);
        User user = fields.reporter;
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)user.self);
        Assert.assertEquals((Object)"admin", (Object)user.name);
        Assert.assertEquals((Object)"Administrator", (Object)user.displayName);
        Assert.assertThat((Object)user.avatarUrls, (Matcher)Matchers.equalTo(this.createUserAvatarUrls(10062L)));
    }

    private void checkStatus(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.status);
        Status status = fields.status;
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/status/5"), (Object)status.self());
        Assert.assertEquals((Object)"Resolved", (Object)status.name());
        Assert.assertEquals((Object)"5", (Object)status.id());
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/images/icons/statuses/resolved.png"), (Object)status.iconUrl());
    }

    private void checkIssueType(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.issuetype);
        IssueType issueType = fields.issuetype;
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + "/rest/api/2/issuetype/1"), (Object)issueType.self);
        Assert.assertEquals((Object)"1", (Object)issueType.id);
        Assert.assertEquals((Object)"Bug", (Object)issueType.name);
        Assert.assertEquals((Object)(this.urlHelper.getBaseUrl() + this.issueTypeUrls.getIssueTypeUrl("bug")), (Object)issueType.iconUrl);
        Assert.assertFalse((boolean)issueType.subtask);
    }

    private void checkLabels(Issue.Fields fields) {
        Assert.assertNotNull((Object)fields.labels);
        List labels = fields.labels;
        Assert.assertEquals((long)3L, (long)labels.size());
        Assert.assertEquals((Object)"bad", labels.get(0));
        Assert.assertEquals((Object)"big", labels.get(1));
        Assert.assertEquals((Object)"wolf", labels.get(2));
    }

    private Map<String, String> createUserAvatarUrls(Long avatarId) {
        return ImmutableMap.builder().put((Object)"24x24", (Object)this.urlHelper.getBaseUrlPlus("secure/useravatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.urlHelper.getBaseUrlPlus("secure/useravatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.urlHelper.getBaseUrlPlus("secure/useravatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.urlHelper.getBaseUrlPlus("secure/useravatar?avatarId=" + avatarId)).build();
    }

    private Map<String, String> createProjectAvatarUrls(Long projectId, Long avatarId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.defaultAvatarId.equals(avatarId)) {
            builder.put((Object)"24x24", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?avatarId=" + avatarId));
        } else {
            builder.put((Object)"24x24", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=small&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=xsmall&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=medium&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?pid=" + projectId + "&avatarId=" + avatarId));
        }
        return builder.build();
    }

    protected void assertEqualDateStrings(String expected, String actual) {
        String[] expected_split = expected.split("(\\+|\\-)\\d{4}$");
        String[] actual_split = actual.split("(\\+|\\-)\\d{4}$");
        Assert.assertEquals((Object)expected_split[0], (Object)actual_split[0]);
    }
}

