/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.rule.IssueTypeUrls;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.LinkedIssuesMatcher;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueLink;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.LinkRequest;
import com.atlassian.jira.testkit.client.restclient.Priority;
import com.atlassian.jira.testkit.client.restclient.Status;
import com.atlassian.jira.testkit.client.restclient.StatusCategory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.ISSUE_LINKS})
@Restore(value="TestIssueResourceIssueLinks.xml")
public class TestIssueResourceIssueLinks
extends BaseJiraFuncTest {
    @Rule
    public IssueTypeUrls urls = new IssueTypeUrls();
    @Inject
    private FuncTestUrlHelper urlHelper;
    private IssueClient issueClient;

    @Test
    public void testIssueLinksDisabled() throws Exception {
        this.disableIssueLinking();
        Issue issue = this.issueClient.get("LNK-4", new Issue.Expand[0]);
        Assert.assertNull((Object)issue.fields.issuelinks);
    }

    @Test
    public void testNoIssueLinks() throws Exception {
        Issue issue = this.issueClient.get("LNK-5", new Issue.Expand[0]);
        Assert.assertEquals((String)"Object should have no issue links", (long)0L, (long)issue.fields.issuelinks.size());
    }

    @Test
    public void testNoOutwardIssueLinks() throws Exception {
        Issue issue = this.issueClient.get("LNK-1", new Issue.Expand[0]);
        List links = issue.fields.issuelinks;
        for (IssueLink link : links) {
            Assert.assertNull((Object)link.outwardIssue());
        }
    }

    @Test
    public void testNoVisibleLinks() throws Exception {
        Issue issue = ((IssueClient)this.issueClient.loginAs("reporter")).get("LNK-2", new Issue.Expand[0]);
        Assert.assertEquals((String)"Object should have no visible issue links", (long)0L, (long)issue.fields.issuelinks.size());
    }

    @Test
    public void testInvisibleIssueNotShown() throws Exception {
        Issue issue = ((IssueClient)this.issueClient.loginAs("reporter")).get("LNK-4", new Issue.Expand[0]);
        List links = issue.fields.issuelinks;
        Assert.assertEquals((long)1L, (long)links.size());
        Assert.assertEquals((Object)"LNK-1", (Object)((IssueLink)links.get(0)).outwardIssue().key());
    }

    @Test
    public void testSeveralIssueLinks() throws Exception {
        Issue issue = this.issueClient.get("LNK-4", new Issue.Expand[0]);
        List links = issue.fields.issuelinks;
        Assert.assertEquals((long)2L, (long)links.size());
        Assert.assertEquals((Object)((IssueLink)links.get(0)).outwardIssue().key(), (Object)"LNK-1");
        Assert.assertEquals((Object)((IssueLink)links.get(1)).outwardIssue().key(), (Object)"LNK-3");
    }

    @Test
    public void testEachIssueLinkShouldContainAllTheInformationNecessaryForClientsToRenderIt() throws Exception {
        Issue issue = ((IssueClient)this.issueClient.loginAs("reporter")).get("LNK-6", new Issue.Expand[0]);
        List links = issue.fields.issuelinks;
        Assert.assertEquals((long)1L, (long)links.size());
        IssueLink linktoLnk1 = (IssueLink)links.get(0);
        Assert.assertThat((Object)linktoLnk1.type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)new IssueLink.Type().id("10000").name("Duplicate").inward("is duplicated by").outward("duplicates").self(this.urlHelper.getBaseUrlPlus("/rest/api/2/issueLinkType/10000")))));
        Assert.assertThat((Object)linktoLnk1.inwardIssue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
        Assert.assertThat((Object)linktoLnk1.outwardIssue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)new IssueLink.IssueLinkRef().id("10000").key("LNK-1").self(this.urlHelper.getRestApiUrl("/issue/10000")).fields(new IssueLink.IssueLinkRef.Fields().summary("1 visible link").issueType(new IssueType().id("1").avatarId(this.urls.getAvatarId("bug")).self(this.urlHelper.getRestApiUrl("/issuetype/1")).name("Bug").subtask(false).description("A problem which impairs or prevents the functions of the product.").iconUrl(this.urlHelper.getBaseUrlPlus(this.urls.getIssueTypeUrl("bug")))).status(new Status().id("1").name("Open").self(this.urlHelper.getRestApiUrl("/status/1")).description("The issue is open and ready for the assignee to start work on it.").iconUrl(this.urlHelper.getBaseUrlPlus("/images/icons/statuses/open.png")).statusCategory(new StatusCategory(this.urlHelper.getRestApiUrl("statuscategory/2"), Long.valueOf(2L), "new", "default", "To Do"))).priority(new Priority().id("3").name("Major").self(this.urlHelper.getRestApiUrl("/priority/3")).iconUrl(this.urlHelper.getBaseUrlPlus("/images/icons/priorities/major.svg")))))));
    }

    @Test
    public void testIssueEditShouldHandleAddLinkOperation() throws Exception {
        String fromIssueKey = "LNK-1";
        String lnk5_key = "LNK-5";
        String lnk6_key = "LNK-6";
        String lnk6_id = "10010";
        String duplicate_name = "Duplicate";
        String duplicate_id = "10000";
        Assert.assertThat((String)"Link already exists, test needs to be updated", (Object)this.issueClient.get("LNK-1", new Issue.Expand[0]), (Matcher)Matchers.not(LinkedIssuesMatcher.hasLinkWithOutwardIssue("LNK-5", "Duplicate")));
        Assert.assertThat((String)"Link already exists, test needs to be updated", (Object)this.issueClient.get("LNK-1", new Issue.Expand[0]), (Matcher)Matchers.not(LinkedIssuesMatcher.hasLinkWithOutwardIssue("LNK-6", "Duplicate")));
        this.issueClient.edit("LNK-1", new IssueUpdateRequest().update("issuelinks", Arrays.asList(new FieldOperation().operation("add").value((Object)new LinkRequest().type(ResourceRef.withName((String)"Duplicate")).outwardIssue(ResourceRef.withKey((String)"LNK-5"))))));
        Assert.assertThat((Object)this.issueClient.get("LNK-1", new Issue.Expand[0]), LinkedIssuesMatcher.hasLinkWithOutwardIssue("LNK-5", "Duplicate"));
        this.issueClient.edit("LNK-1", new IssueUpdateRequest().update("issuelinks", Arrays.asList(new FieldOperation().operation("add").value((Object)new LinkRequest().type(ResourceRef.withId((String)"10000")).outwardIssue(ResourceRef.withId((String)"10010"))))));
        Assert.assertThat((Object)this.issueClient.get("LNK-1", new Issue.Expand[0]), LinkedIssuesMatcher.hasLinkWithOutwardIssue("LNK-6", "Duplicate"));
    }

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    private void disableIssueLinking() throws IOException {
        this.backdoor.issueLinking().disable();
    }
}

