/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.ENTITY_PROPERTIES})
public class TestIssueResourceIssueProperties
extends BaseJiraFuncTest {
    private IssueClient issueClient;
    private EntityPropertyClient propertyClient;

    @Before
    public void setUp() throws Exception {
        this.backdoor.restoreBlankInstance();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.propertyClient = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "issue");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
    }

    @Test
    public void userCanGetOneIssueProperty() {
        this.backdoor.issues().createIssue("HSP", "fred's issue", "admin");
        this.propertyClient.put("HSP-1", "prop", this.value(5));
        Issue issue = this.issueClient.getWithProperties("HSP-1", (List)Lists.newArrayList((Object[])new String[]{"prop"}), new Issue.Expand[0]);
        Assert.assertThat((Object)issue.getProperty("prop"), (Matcher)Matchers.equalTo((Object)this.value(5)));
    }

    @Test
    public void onlyRequestedPropertiesAreReturned() {
        this.backdoor.issues().createIssue("HSP", "fred's issue", "admin");
        this.propertyClient.put("HSP-1", "prop1", this.value(1));
        this.propertyClient.put("HSP-1", "prop2", this.value(2));
        this.propertyClient.put("HSP-1", "prop3", this.value(3));
        Issue issue = this.issueClient.getWithProperties("HSP-1", (List)Lists.newArrayList((Object[])new String[]{"prop2, prop3"}), new Issue.Expand[0]);
        Assert.assertThat(issue.properties.map.keySet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)issue.getProperty("prop2"), (Matcher)Matchers.equalTo((Object)this.value(2)));
        Assert.assertThat((Object)issue.getProperty("prop3"), (Matcher)Matchers.equalTo((Object)this.value(3)));
    }

    @Test
    public void invalidPropertyIsSimplyNotReturned() {
        this.backdoor.issues().createIssue("HSP", "fred's issue", "admin");
        this.propertyClient.put("HSP-1", "prop", this.value(5));
        Issue issue = this.issueClient.getWithProperties("HSP-1", (List)Lists.newArrayList((Object[])new String[]{"prop, invalid"}), new Issue.Expand[0]);
        Assert.assertThat(issue.properties.map.keySet(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)issue.getProperty("prop"), (Matcher)Matchers.equalTo((Object)this.value(5)));
    }

    @Test
    public void nothingIsReturnedWhenPropertiesAreNotRequested() {
        this.backdoor.issues().createIssue("HSP", "fred's issue", "admin");
        this.propertyClient.put("HSP-1", "prop", this.value(5));
        Map issue = (Map)this.issueClient.issueResource("HSP-1", new Issue.Expand[0]).request().get(Map.class);
        Assert.assertThat(issue.get("properties"), (Matcher)Matchers.equalTo(null));
    }

    @Test
    public void emptyMapIsReturnedWhenPropertiesAreRequestedButNoKeyIsValid() {
        this.backdoor.issues().createIssue("HSP", "fred's issue", "admin");
        this.propertyClient.put("HSP-1", "prop", this.value(5));
        Map issue = (Map)this.issueClient.issueResource("HSP-1", new Issue.Expand[0]).queryParam("properties", new Object[]{"inalidKey"}).request().get(Map.class);
        Assert.assertThat(issue.get("properties"), (Matcher)Matchers.not((Matcher)Matchers.equalTo(null)));
    }

    @Test
    public void allPropertiesMayBeRequestedWithAsteriskAll() {
        this.backdoor.issues().createIssue("HSP", "fred's issue", "admin");
        this.propertyClient.put("HSP-1", "prop1", this.value(1));
        this.propertyClient.put("HSP-1", "prop2", this.value(2));
        this.propertyClient.put("HSP-1", "prop3", this.value(3));
        Issue issue = (Issue)this.issueClient.issueResource("HSP-1", new Issue.Expand[0]).queryParam("properties", new Object[]{"*all"}).request().get(Issue.class);
        Assert.assertThat(issue.properties.map.keySet(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void whenRequestingAllPropertiesSomeMayBeExcluded() {
        this.backdoor.issues().createIssue("HSP", "fred's issue", "admin");
        this.propertyClient.put("HSP-1", "prop1", this.value(1));
        this.propertyClient.put("HSP-1", "prop2", this.value(2));
        this.propertyClient.put("HSP-1", "prop3", this.value(3));
        Issue issue = (Issue)this.issueClient.issueResource("HSP-1", new Issue.Expand[0]).queryParam("properties", new Object[]{"*all, -prop2"}).request().get(Issue.class);
        Assert.assertThat(issue.properties.map.keySet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)issue.getProperty("prop1"), (Matcher)Matchers.equalTo((Object)this.value(1)));
        Assert.assertThat((Object)issue.getProperty("prop3"), (Matcher)Matchers.equalTo((Object)this.value(3)));
    }

    @Test
    public void queryParamsAsArrayWorks() {
        this.backdoor.issues().createIssue("HSP", "fred's issue", "admin");
        this.propertyClient.put("HSP-1", "prop1", this.value(1));
        this.propertyClient.put("HSP-1", "prop2", this.value(2));
        this.propertyClient.put("HSP-1", "prop3", this.value(3));
        Issue issue = (Issue)this.issueClient.issueResource("HSP-1", new Issue.Expand[0]).queryParam("properties", new Object[]{"prop1,prop2"}).queryParam("properties", new Object[]{"prop3"}).request().get(Issue.class);
        Assert.assertThat(issue.properties.map.keySet(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)issue.getProperty("prop1"), (Matcher)Matchers.equalTo((Object)this.value(1)));
        Assert.assertThat((Object)issue.getProperty("prop2"), (Matcher)Matchers.equalTo((Object)this.value(2)));
        Assert.assertThat((Object)issue.getProperty("prop3"), (Matcher)Matchers.equalTo((Object)this.value(3)));
    }

    private JSONObject value(int value) {
        return new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"value", (Object)value));
    }
}

