/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestIssueResourceNoPrioritySet
extends BaseJiraFuncTest {
    private IssueClient issueClient;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    @Restore(value="TestIssueResourceNoPrioritySet.xml")
    public void testUnassignedIssueHasNoValue() throws Exception {
        Issue issue = this.issueClient.get("TST-2", new Issue.Expand[0]);
        Assert.assertNull((Object)issue.fields.priority);
        Assert.assertNull((Object)issue.fields.reporter);
        Issue issue2 = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertEquals((Object)"Blocker", (Object)issue2.fields.priority.name());
        Assert.assertEquals((Object)"admin", (Object)issue2.fields.reporter.name);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Priority");
        Assert.assertNull((Object)this.issueClient.get((String)"TST-2", (Issue.Expand[])new Issue.Expand[0]).fields.priority);
        Assert.assertNull((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.priority);
        Assert.assertNull((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.duedate);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Due Date");
        Assert.assertNull((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.duedate);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields("Due Date");
        this.navigation.issue().setDueDate("TST-1", "10/May/11");
        Assert.assertTrue((boolean)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.duedate.startsWith("2011-05-"));
    }
}

