/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.OperationalUpdateRequest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestIssueResourceOperationalUpdate.xml")
public class TestIssueResourceOperationalUpdate
extends BaseJiraFuncTest {
    private IssueClient issueClient;
    @Inject
    GeneralConfiguration generalConfiguration;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testSimpleImplicitUpdateAndOperationalWorks() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        HashMap<String, List<Map>> update = new HashMap<String, List<Map>>();
        update.put("description", Arrays.asList(MapBuilder.newBuilder().add("set", "newd1").toMap()));
        OperationalUpdateRequest updateRequest = new OperationalUpdateRequest(update);
        IssueFields fields = new IssueFields();
        fields.summary("news1");
        updateRequest.setFields(fields);
        ParsedResponse response = this.issueClient.operationalUpdateResponse(original.id, updateRequest);
        Assert.assertEquals((long)204L, (long)response.statusCode);
        Issue updated = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertEquals((Object)"news1", (Object)updated.fields.summary);
        Assert.assertEquals((Object)"newd1", (Object)updated.fields.description);
    }

    @Test
    public void testImplicitUpdateAndOperationaForSameFieldFails() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        HashMap<String, List<Map>> update = new HashMap<String, List<Map>>();
        update.put("summary", Arrays.asList(MapBuilder.newBuilder().add("set", "implicit").toMap()));
        OperationalUpdateRequest updateRequest = new OperationalUpdateRequest(update);
        IssueFields fields = new IssueFields();
        fields.summary("explicit");
        updateRequest.setFields(fields);
        ParsedResponse response = this.issueClient.operationalUpdateResponse(original.id, updateRequest);
        this.assertResponseCodeAndErrorMessage(400, "Field 'summary' cannot appear in both 'fields' and 'update'", response);
        Issue updated = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertEquals((Object)"A critical bug", (Object)updated.fields.summary);
    }

    private void assertResponseCodeAndErrorMessage(int statusCode, String errorMessage, ParsedResponse response) {
        Assert.assertEquals((long)statusCode, (long)response.statusCode);
        String error = (String)response.entity.errorMessages.get(0);
        Assert.assertEquals((Object)errorMessage, (Object)error);
    }

    private void assertResponseCodeAndErrors(int statusCode, String field, String errorMessage, ParsedResponse response) {
        Assert.assertEquals((long)statusCode, (long)response.statusCode);
        Map errors = response.entity.errors;
        Assert.assertEquals((Object)errorMessage, errors.get(field));
    }

    @Test
    public void testInvalidFieldId() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        OperationalUpdateRequest updateRequest = this.createRequest("sumary", "set", "test");
        ParsedResponse response = this.issueClient.operationalUpdateResponse(original.id, updateRequest);
        this.assertResponseCodeAndErrors(400, "sumary", "Field 'sumary' cannot be set. It is not on the appropriate screen, or unknown.", response);
    }

    @Test
    public void testDescriptionField() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        OperationalUpdateRequest updateRequest = this.createRequest("description", "set", "blah");
        this.issueClient.operationalUpdate(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.description, (Matcher)CoreMatchers.equalTo((Object)"blah"));
    }

    OperationalUpdateRequest createRequest(String fieldName, String operation, Object newvalue) {
        RequestBuilder requestBuilder = new RequestBuilder();
        requestBuilder.addOperation(fieldName, operation, newvalue);
        return requestBuilder.build();
    }

    OperationalUpdateRequest createArrayRequest(String fieldName, String operation, Object ... values) {
        RequestBuilder requestBuilder = new RequestBuilder();
        requestBuilder.addOperation(fieldName, operation, values);
        return requestBuilder.build();
    }

    @Test
    public void testSummaryField() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        OperationalUpdateRequest updateRequest = this.createRequest("summary", "set", "A critical bug");
        this.issueClient.operationalUpdate(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.summary, (Matcher)CoreMatchers.equalTo((Object)"A critical bug"));
    }

    @Test
    public void testComponentField() throws Exception {
        Issue original = this.issueClient.get("PH-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        OperationalUpdateRequest updateRequest = this.createRequest("components", "add", MapBuilder.newBuilder().add("id", "10010").toMap());
        this.issueClient.operationalUpdate(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Component)updated.fields.components.get((int)0)).id, (Matcher)CoreMatchers.equalTo((Object)10010L));
        Assert.assertThat((Object)((Component)updated.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"Database"));
        updateRequest = this.createArrayRequest("components", "set", MapBuilder.newBuilder().add("id", "10010").toMap(), MapBuilder.newBuilder().add("id", "10013").toMap());
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((Component)updated.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"3rd Party Integration"));
        Assert.assertThat((Object)((Component)updated.fields.components.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"Database"));
        RequestBuilder requestBuilder = new RequestBuilder();
        requestBuilder.addOperation("components", "remove", MapBuilder.newBuilder().add("id", "10010").toMap());
        requestBuilder.addOperation("components", "remove", MapBuilder.newBuilder().add("id", "10040").toMap());
        updateRequest = requestBuilder.build();
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Component)updated.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"3rd Party Integration"));
        updateRequest = this.createArrayRequest("components", "set", new Object[0]);
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testPriorityField() throws Exception {
        Issue original = this.issueClient.get("PH-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.priority.name(), (Matcher)CoreMatchers.equalTo((Object)"Major"));
        OperationalUpdateRequest updateRequest = this.createRequest("priority", "set", MapBuilder.newBuilder().add("id", "4").toMap());
        this.issueClient.operationalUpdate(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.priority.name(), (Matcher)CoreMatchers.equalTo((Object)"Minor"));
    }

    @Test
    public void testAssigneeField() throws Exception {
        Issue original = this.issueClient.get("PH-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)"admin"));
        OperationalUpdateRequest updateRequest = this.createRequest("assignee", "set", MapBuilder.newBuilder().add("name", "fry").toMap());
        this.issueClient.operationalUpdate(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)"fry"));
        updateRequest = this.createRequest("assignee", "set", null);
        ParsedResponse response = this.issueClient.operationalUpdateResponse(original.id, updateRequest);
        this.assertResponseCodeAndErrors(400, "assignee", "Issues must be assigned.", response);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)"fry"));
        this.generalConfiguration.setAllowUnassignedIssues(true);
        updateRequest = this.createRequest("assignee", "set", null);
        response = this.issueClient.operationalUpdateResponse(original.id, updateRequest);
        Assert.assertEquals((long)204L, (long)response.statusCode);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.assignee, (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void testFixForField() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Version)original.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        OperationalUpdateRequest updateRequest = this.createRequest("fixVersions", "add", MapBuilder.newBuilder().add("id", "10000").toMap());
        this.issueClient.operationalUpdate(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        updateRequest = this.createArrayRequest("fixVersions", "set", new Object[0]);
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        updateRequest = this.createArrayRequest("fixVersions", "set", MapBuilder.newBuilder().add("id", "10000").toMap());
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        updateRequest = this.createRequest("fixVersions", "remove", MapBuilder.newBuilder().add("id", "10000").toMap());
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testAffectedVersionsField() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Version)original.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        OperationalUpdateRequest updateRequest = this.createRequest("versions", "add", MapBuilder.newBuilder().add("id", "10000").toMap());
        this.issueClient.operationalUpdate(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((Version)updated.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)((Version)updated.fields.versions.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        updateRequest = this.createArrayRequest("versions", "set", new Object[0]);
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        updateRequest = this.createArrayRequest("versions", "set", MapBuilder.newBuilder().add("id", "10000").toMap());
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Version)updated.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        updateRequest = this.createRequest("versions", "remove", MapBuilder.newBuilder().add("id", "10000").toMap());
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testLabelsField() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.labels.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat(original.fields.labels.get(0), (Matcher)CoreMatchers.equalTo((Object)"bar"));
        Assert.assertThat(original.fields.labels.get(1), (Matcher)CoreMatchers.equalTo((Object)"foo"));
        OperationalUpdateRequest updateRequest = this.createRequest("labels", "add", "baz");
        this.issueClient.operationalUpdate(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.labels.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat(updated.fields.labels.get(0), (Matcher)CoreMatchers.equalTo((Object)"bar"));
        Assert.assertThat(updated.fields.labels.get(1), (Matcher)CoreMatchers.equalTo((Object)"baz"));
        Assert.assertThat(updated.fields.labels.get(2), (Matcher)CoreMatchers.equalTo((Object)"foo"));
        original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.labels.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        updateRequest = this.createArrayRequest("labels", "set", new String[0]);
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.labels.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.labels.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        updateRequest = this.createArrayRequest("labels", "set", "quux", "bob");
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.labels.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat(updated.fields.labels.get(0), (Matcher)CoreMatchers.equalTo((Object)"bob"));
        Assert.assertThat(updated.fields.labels.get(1), (Matcher)CoreMatchers.equalTo((Object)"quux"));
        original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.labels.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        updateRequest = this.createRequest("labels", "remove", "bob");
        this.issueClient.operationalUpdate(original.id, updateRequest);
        updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.labels.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testMultipleFieldsAndMultipleOperations() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertThat((Object)original.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        RequestBuilder requestBuilder = new RequestBuilder();
        requestBuilder.addOperation("versions", "remove", MapBuilder.newBuilder().add("id", "10000").toMap());
        requestBuilder.addOperation("versions", "add", MapBuilder.newBuilder().add("id", "10000").toMap());
        requestBuilder.addOperation("versions", "add", MapBuilder.newBuilder().add("id", "10001").toMap());
        requestBuilder.addOperation("assignee", "set", MapBuilder.newBuilder().add("name", "admin").toMap());
        OperationalUpdateRequest updateRequest = requestBuilder.build();
        this.issueClient.operationalUpdate(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testErrorForUnconfiguredField() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        HashMap<String, List<Map>> update = new HashMap<String, List<Map>>();
        update.put("customfield_10000", Arrays.asList(MapBuilder.newBuilder().add("set", "2011-11-17").toMap()));
        OperationalUpdateRequest updateRequest = new OperationalUpdateRequest(update);
        IssueFields fields = new IssueFields();
        fields.customField(Long.valueOf(10001L), (Object)"2011-11-17T08:45:00.000+1100");
        updateRequest.setFields(fields);
        ParsedResponse response = this.issueClient.operationalUpdateResponse(original.id, updateRequest);
        Assert.assertEquals((long)204L, (long)response.statusCode);
        Issue updated = this.issueClient.get("TST-1", new Issue.Expand[0]);
        Assert.assertEquals((Object)"2011-11-17", (Object)updated.fields.get("customfield_10000"));
        Assert.assertEquals((Object)"2011-11-17T08:45:00.000+1100", (Object)updated.fields.get("customfield_10001"));
        original = this.issueClient.get("PH-1", new Issue.Expand[0]);
        update = new HashMap();
        update.put("customfield_10000", Arrays.asList(MapBuilder.newBuilder().add("set", "2011-11-17").toMap()));
        updateRequest = new OperationalUpdateRequest(update);
        fields = new IssueFields();
        fields.customField(Long.valueOf(10001L), (Object)"2011-11-17T08:45:00.000+1100");
        updateRequest.setFields(fields);
        response = this.issueClient.operationalUpdateResponse(original.id, updateRequest);
        this.assertResponseCodeAndErrors(400, "customfield_10000", "Field 'customfield_10000' cannot be set. It is not on the appropriate screen, or unknown.", response);
        this.assertResponseCodeAndErrors(400, "customfield_10001", "Field 'customfield_10001' cannot be set. It is not on the appropriate screen, or unknown.", response);
    }

    class RequestBuilder {
        private Map<String, List<Map<String, Object>>> fieldUpdates = new HashMap<String, List<Map<String, Object>>>();

        RequestBuilder() {
        }

        RequestBuilder addOperation(String fieldName, String operation, Object newvalue) {
            List<Map<String, Object>> fieldOper = this.fieldUpdates.get(fieldName);
            if (fieldOper == null) {
                fieldOper = new ArrayList<Map<String, Object>>();
            }
            HashMap<String, Object> operations = new HashMap<String, Object>();
            operations.put(operation, newvalue);
            fieldOper.add(operations);
            this.fieldUpdates.put(fieldName, fieldOper);
            return this;
        }

        OperationalUpdateRequest build() {
            return new OperationalUpdateRequest(this.fieldUpdates);
        }
    }
}

