/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.LinkGroup;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceOpsbar
extends BaseJiraFuncTest {
    private IssueClient issueClient;
    @Inject
    private Administration administration;

    private static void assertAdminMenu(LinkGroup adminGroups) {
        TestIssueResourceOpsbar.assertNoLinks(adminGroups);
        Assert.assertEquals((long)1L, (long)adminGroups.getGroups().size());
        LinkGroup realAdminGroup = (LinkGroup)adminGroups.getGroups().get(0);
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)realAdminGroup.getGroups().get(0), "com.atlassian.jira.jira-project-config-plugin:add-custom-field");
    }

    private static void assertToolsGroup(LinkGroup toolsGroup) {
        Assert.assertEquals((Object)"jira.issue.tools", (Object)toolsGroup.getId());
        TestIssueResourceOpsbar.assertGroupContainsLinkLabels(TestIssueResourceOpsbar.getOnlyGroup(toolsGroup), "XML", "Word", "Printable");
    }

    private static LinkGroup getOnlyGroup(LinkGroup group) {
        Assert.assertEquals((long)1L, (long)group.getGroups().size());
        return (LinkGroup)group.getGroups().get(0);
    }

    private static void assertGroupContainsLinkIds(LinkGroup group, String ... linkIds) {
        List ids = group.getLinks().stream().map(simpleLink -> simpleLink.id).collect(Collectors.toList());
        Assert.assertTrue((boolean)ids.containsAll(Arrays.asList(linkIds)));
    }

    private static void assertGroupContainsLinkLabels(LinkGroup group, String ... linkLabels) {
        List labels = group.getLinks().stream().map(simpleLink -> simpleLink.label).collect(Collectors.toList());
        Assert.assertTrue((boolean)labels.containsAll(Arrays.asList(linkLabels)));
    }

    private static void assertNoLinks(LinkGroup group) {
        Assert.assertTrue((boolean)group.getLinks().isEmpty());
    }

    private static void assertNoGroups(LinkGroup group) {
        Assert.assertTrue((boolean)group.getGroups().isEmpty());
    }

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testLoggedIn() throws Exception {
        this.administration.restoreData("TestOpsBar.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.operations});
        List linkGroups = issue.operations.getLinkGroups();
        Assert.assertEquals((long)2L, (long)linkGroups.size());
        LinkGroup opsbarGroup = (LinkGroup)linkGroups.get(0);
        Assert.assertEquals((Object)"view.issue.opsbar", (Object)opsbarGroup.getId());
        TestIssueResourceOpsbar.assertNoLinks(opsbarGroup);
        List opsBarGroups = opsbarGroup.getGroups();
        Assert.assertEquals((long)6L, (long)opsBarGroups.size());
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsBarGroups.get(0), "edit-issue");
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsBarGroups.get(1), "comment-issue");
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsBarGroups.get(2), "assign-issue");
        LinkGroup transitions = (LinkGroup)opsBarGroups.get(3);
        MatcherAssert.assertThat((Object)transitions.getLinks(), (Matcher)Matchers.empty());
        List workflowGroups = transitions.getGroups();
        Assert.assertEquals((long)1L, (long)workflowGroups.size());
        Assert.assertEquals((Object)"opsbar-transitions_more", (Object)((LinkGroup)workflowGroups.get((int)0)).getHeader().id);
        Assert.assertEquals((long)1L, (long)((LinkGroup)workflowGroups.get(0)).getGroups().size());
        if (this.isReferencePluginEnabled()) {
            TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)((LinkGroup)workflowGroups.get(0)).getGroups().get(0), "reference-transition-item", "action_id_4", "action_id_5", "action_id_2");
        } else {
            TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)((LinkGroup)workflowGroups.get(0)).getGroups().get(0), "action_id_4", "action_id_5", "action_id_2");
        }
        TestIssueResourceOpsbar.assertAdminMenu((LinkGroup)opsBarGroups.get(4));
        TestIssueResourceOpsbar.assertToolsGroup((LinkGroup)linkGroups.get(1));
    }

    @Test
    public void testCanEditWhenNotLoggedIn() {
        this.administration.restoreData("TestOpsBar.xml");
        this.navigation.logout();
        Issue issue = ((IssueClient)this.issueClient.anonymous()).get("ANONED-1", new Issue.Expand[]{Issue.Expand.operations});
        List linkGroups = issue.operations.getLinkGroups();
        Assert.assertEquals((long)2L, (long)linkGroups.size());
        LinkGroup opsbarGroup = (LinkGroup)linkGroups.get(0);
        Assert.assertEquals((Object)"view.issue.opsbar", (Object)opsbarGroup.getId());
        TestIssueResourceOpsbar.assertNoLinks(opsbarGroup);
        Assert.assertEquals((long)5L, (long)opsbarGroup.getGroups().size());
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsbarGroup.getGroups().get(0), "edit-issue");
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsbarGroup.getGroups().get(1), "edit-labels");
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(2));
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(3));
        List workflowGroups = ((LinkGroup)opsbarGroup.getGroups().get(2)).getGroups();
        Assert.assertEquals((long)1L, (long)workflowGroups.size());
        Assert.assertEquals((Object)"opsbar-transitions_more", (Object)((LinkGroup)workflowGroups.get((int)0)).getHeader().id);
        TestIssueResourceOpsbar.assertNoGroups((LinkGroup)workflowGroups.get(0));
        TestIssueResourceOpsbar.assertToolsGroup((LinkGroup)linkGroups.get(1));
    }

    @Test
    public void testCannotEditWhenNotLoggedIn() {
        this.administration.restoreData("TestOpsBar.xml");
        this.navigation.logout();
        Issue issue = ((IssueClient)this.issueClient.anonymous()).get("ANON-1", new Issue.Expand[]{Issue.Expand.operations});
        List linkGroups = issue.operations.getLinkGroups();
        Assert.assertEquals((long)2L, (long)linkGroups.size());
        LinkGroup opsbarGroup = (LinkGroup)linkGroups.get(0);
        Assert.assertEquals((Object)"view.issue.opsbar", (Object)opsbarGroup.getId());
        TestIssueResourceOpsbar.assertNoLinks(opsbarGroup);
        Assert.assertEquals((long)5L, (long)opsbarGroup.getGroups().size());
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsbarGroup.getGroups().get(0), "ops-login-lnk");
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(1));
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(2));
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(3));
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(4));
        List workflowGroups = ((LinkGroup)opsbarGroup.getGroups().get(2)).getGroups();
        Assert.assertEquals((long)1L, (long)workflowGroups.size());
        Assert.assertEquals((Object)"opsbar-transitions_more", (Object)((LinkGroup)workflowGroups.get((int)0)).getHeader().id);
        TestIssueResourceOpsbar.assertNoGroups((LinkGroup)workflowGroups.get(0));
        TestIssueResourceOpsbar.assertToolsGroup((LinkGroup)linkGroups.get(1));
    }

    private boolean isReferencePluginEnabled() {
        return this.administration.plugins().referencePlugin().isInstalled() && this.administration.plugins().referencePlugin().isEnabled();
    }
}

