/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestIssueResourceSchema
extends BaseJiraFuncTest {
    private IssueClient issueClient;
    @Inject
    private Administration administration;

    @Test
    public void testIssueRepresentationShouldContainExpandableSchemaField() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue minimal = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertThat((String)"names should not be expanded by default", (Object)minimal.schema, (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((Object)minimal.expand, (Matcher)Matchers.containsString((String)Issue.Expand.schema.name()));
        Issue hsp1_expanded = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        Set fields = hsp1_expanded.fields.idSet();
        Set schema = hsp1_expanded.schema.keySet();
        Assert.assertTrue((String)("Found in 'schema' but not in 'fields'" + Sets.difference(schema, (Set)fields)), (boolean)Sets.difference(schema, (Set)fields).isEmpty());
    }

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }
}

