/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueLink;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestIssueResourceSubtasks.xml")
public class TestIssueResourceSubtasks
extends BaseJiraRestTest {
    private IssueClient issueClient;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testSubtaskLink() throws Exception {
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List subtasks = issue.fields.subtasks;
        Assert.assertEquals((long)1L, (long)subtasks.size());
        String baseUrl = this.environmentData.getBaseUrl().toExternalForm();
        IssueLink.IssueLinkRef lnkHsp2 = (IssueLink.IssueLinkRef)subtasks.get(0);
        Assert.assertEquals((Object)"HSP-2", (Object)lnkHsp2.key());
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/issue/10001"), (Object)lnkHsp2.self());
    }

    @Test
    public void testParentLink() throws Exception {
        Issue issue = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        String baseUrl = this.environmentData.getBaseUrl().toExternalForm();
        IssueLink.IssueLinkRef parent = issue.fields.parent;
        Assert.assertEquals((Object)"HSP-1", (Object)parent.key());
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/issue/10000"), (Object)parent.self());
    }
}

