/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestIssueResourceTimeTracking.xml")
public class TestIssueResourceTimeTracking
extends BaseJiraFuncTest {
    private IssueClient issueClient;
    @Inject
    private TimeTracking timeTracking;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testTimeTrackingDisabled() throws Exception {
        this.timeTracking.disable();
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        Assert.assertNull((String)"Time tracking shouldn't be in response when time tracking is disabled", (Object)issue.fields.timetracking);
    }

    @Test
    public void testIssueWithNoTimeTracking() throws Exception {
        Issue issue = this.issueClient.get("FUNC-1", new Issue.Expand[0]);
        Assert.assertNull((Object)issue.fields.timetracking.originalEstimate);
        Assert.assertNull((Object)issue.fields.timetracking.remainingEstimate);
        Assert.assertNull((Object)issue.fields.timetracking.timeSpent);
        Assert.assertNotNull((Object)issue.fields.progress);
        Assert.assertEquals((Object)0L, (Object)issue.fields.progress.total());
        Assert.assertEquals((Object)0L, (Object)issue.fields.progress.progress());
        Assert.assertNull((Object)issue.fields.progress.percent());
        Assert.assertNotNull((Object)issue.fields.aggregateprogress);
        Assert.assertEquals((Object)0L, (Object)issue.fields.aggregateprogress.total());
        Assert.assertEquals((Object)0L, (Object)issue.fields.aggregateprogress.progress());
        Assert.assertNull((Object)issue.fields.aggregateprogress.percent());
    }

    @Test
    public void testIssueWithOriginalEstimate() throws Exception {
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        Assert.assertNotNull((Object)issue.fields.timetracking);
        Assert.assertEquals((Object)"3d", (Object)issue.fields.timetracking.originalEstimate);
    }

    @Test
    public void testIssueWithTimeSpent() throws Exception {
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        Assert.assertNotNull((Object)issue.fields.timetracking);
        Assert.assertEquals((Object)"1d", (Object)issue.fields.timetracking.timeSpent);
    }

    @Test
    public void testIssueWithTimeRemaining() throws Exception {
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        Assert.assertNotNull((Object)issue.fields.timetracking);
        Assert.assertEquals((Object)"2d", (Object)issue.fields.timetracking.remainingEstimate);
    }

    @Test
    public void testProgressWithSubtasks() throws Exception {
        Issue issue = this.issueClient.get("FUNC-4", new Issue.Expand[0]);
        Assert.assertNotNull((Object)issue.fields.progress);
        Assert.assertEquals((Object)36000L, (Object)issue.fields.progress.total());
        Assert.assertEquals((Object)7200L, (Object)issue.fields.progress.progress());
        Assert.assertEquals((Object)20L, (Object)issue.fields.progress.percent());
        Assert.assertNotNull((Object)issue.fields.aggregateprogress);
        Assert.assertEquals((Object)43200L, (Object)issue.fields.aggregateprogress.total());
        Assert.assertEquals((Object)14400L, (Object)issue.fields.aggregateprogress.progress());
        Assert.assertEquals((Object)33L, (Object)issue.fields.aggregateprogress.percent());
        issue = this.issueClient.get("FUNC-5", new Issue.Expand[0]);
        Assert.assertNotNull((Object)issue.fields.progress);
        Assert.assertEquals((Object)7200L, (Object)issue.fields.progress.total());
        Assert.assertEquals((Object)7200L, (Object)issue.fields.progress.progress());
        Assert.assertEquals((Object)100L, (Object)issue.fields.progress.percent());
        Assert.assertNotNull((Object)issue.fields.aggregateprogress);
        Assert.assertEquals((Object)7200L, (Object)issue.fields.aggregateprogress.total());
        Assert.assertEquals((Object)7200L, (Object)issue.fields.aggregateprogress.progress());
        Assert.assertEquals((Object)100L, (Object)issue.fields.aggregateprogress.percent());
    }
}

