/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.RestoreDataCenterInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueTransitionsMeta;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.TransitionsClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestIssueResourceTransitions
extends BaseJiraFuncTest {
    private static final String JIRA_SAFEGUARDS_CONFIG_RESTRICTED_GROUPS = "jira.safeguards.config.restricted.groups";
    private static final String COMMENT_COUNT_LIMIT_REACHED_KEY = "jira.safeguards.issue.comments.add.not.allowed";
    private static final String LOCALE = "en_US";
    private static final String CLOSED_STATUS_NAME = "Closed";
    private static final ResourceRef CLOSED_STATUS = ResourceRef.withId((String)"2");
    private static final String ISSUE_KEY = "HSP-1";
    private static final String WONT_FIX_RESOLUTION_NAME = "Won't Fix";
    private static final ResourceRef WONT_FIX_RESOLUTION = new ResourceRef().name("Won't Fix");
    private static final ResourceRef DUPLICATE_RESOLUTION = new ResourceRef().name("Duplicate");
    private IssueClient issueClient;
    private TransitionsClient transitionsClient;

    @Before
    public void setUp() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.transitionsClient = new TransitionsClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.setUnlimitedMaxNumberOfCommentsPerIssue();
    }

    private void setUnlimitedMaxNumberOfCommentsPerIssue() {
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "-1");
    }

    @Test
    @Restore(value="TestWorkflowActions.xml")
    public void testTransitionLink() throws Exception {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[]{Issue.Expand.transitions});
        Assert.assertEquals((long)3L, (long)issue.transitions.size());
    }

    @Test
    @Restore(value="TestIssueResourceTransitions.xml")
    public void testCustomFieldInTransition() throws Exception {
        IssueTransitionsMeta transitions = this.transitionsClient.get(ISSUE_KEY);
        Map fields = ((IssueTransitionsMeta.Transition)transitions.transitions.get((int)2)).fields;
        fields.entrySet().stream().filter(field -> ((String)field.getKey()).equals("customfield_10000")).forEach(field -> Assert.assertEquals((Object)"com.atlassian.jira.plugin.system.customfieldtypes:float", (Object)((IssueTransitionsMeta.TransitionField)field.getValue()).schema.custom));
    }

    @Test
    @Restore(value="TestIssueResourceTransitions.xml")
    public void testNumberCustomFieldLocalized() throws Exception {
        this.navigation.userProfile().changeUserLanguage("fran\u00e7ais (France)");
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        issueUpdateRequest.fields(new IssueFields());
        issueUpdateRequest.transition(CLOSED_STATUS);
        issueUpdateRequest.fields().resolution(DUPLICATE_RESOLUTION);
        issueUpdateRequest.fields().customField(Long.valueOf(10000L), (Object)2.5);
        ParsedResponse response = this.transitionsClient.postResponse(ISSUE_KEY, issueUpdateRequest);
        Assert.assertEquals((long)204L, (long)response.statusCode);
        this.navigation.userProfile().changeUserLanguageToJiraDefault();
    }

    @Test
    @Restore(value="TestIssueResourceTransitions.xml")
    public void testIssueTransitionDestination() throws Exception {
        IssueTransitionsMeta transitions = this.transitionsClient.get(ISSUE_KEY);
        Assert.assertEquals((long)3L, (long)transitions.transitions.size());
        int mask = 0;
        for (IssueTransitionsMeta.Transition transition : transitions.transitions) {
            switch (transition.id) {
                case 2: {
                    Assert.assertEquals((Object)transition.to.id(), (Object)"6");
                    mask = (byte)(mask | 1);
                    break;
                }
                case 4: {
                    Assert.assertEquals((Object)transition.to.id(), (Object)"3");
                    mask = (byte)(mask | 2);
                    break;
                }
                case 5: {
                    Assert.assertEquals((Object)transition.to.id(), (Object)"5");
                    mask = (byte)(mask | 4);
                }
            }
        }
        Assert.assertEquals((long)mask, (long)7L);
    }

    @Test
    @Restore(value="TestWorkflowActions.xml")
    public void testTransitionGET() throws Exception {
        IssueTransitionsMeta transitions = this.transitionsClient.get(ISSUE_KEY);
        Assert.assertEquals((long)3L, (long)transitions.transitions.size());
        int mask = 0;
        for (IssueTransitionsMeta.Transition transition : transitions.transitions) {
            switch (transition.id) {
                case 2: {
                    Assert.assertEquals((Object)"Close Issue", (Object)transition.name);
                    Map closeIssue = transition.fields;
                    Assert.assertEquals((long)3L, (long)closeIssue.size());
                    Assert.assertNotNull(closeIssue.get("resolution"));
                    Assert.assertEquals((Object)"resolution", (Object)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"resolution")).schema.type);
                    Assert.assertTrue((boolean)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"resolution")).required);
                    Assert.assertNotNull(closeIssue.get("fixVersions"));
                    Assert.assertEquals((Object)"array", (Object)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"fixVersions")).schema.type);
                    Assert.assertFalse((boolean)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"fixVersions")).required);
                    Assert.assertNotNull(closeIssue.get("assignee"));
                    Assert.assertEquals((Object)"user", (Object)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"assignee")).schema.type);
                    Assert.assertFalse((boolean)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"assignee")).required);
                    mask = (byte)(mask | 1);
                    break;
                }
                case 4: {
                    Assert.assertEquals((Object)"Start Progress", (Object)transition.name);
                    Map startProgress = transition.fields;
                    Assert.assertEquals((long)0L, (long)startProgress.size());
                    mask = (byte)(mask | 2);
                    break;
                }
                case 5: {
                    Assert.assertEquals((Object)"Resolve Issue", (Object)transition.name);
                    Map resolveIssue = transition.fields;
                    Assert.assertEquals((long)3L, (long)resolveIssue.size());
                    Assert.assertNotNull(resolveIssue.get("resolution"));
                    Assert.assertEquals((Object)"resolution", (Object)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"resolution")).schema.type);
                    Assert.assertTrue((boolean)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"resolution")).required);
                    Assert.assertNotNull(resolveIssue.get("fixVersions"));
                    Assert.assertEquals((Object)"array", (Object)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"fixVersions")).schema.type);
                    Assert.assertEquals((Object)"version", (Object)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"fixVersions")).schema.items);
                    Assert.assertFalse((boolean)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"fixVersions")).required);
                    Assert.assertNotNull(resolveIssue.get("assignee"));
                    Assert.assertEquals((Object)"user", (Object)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"assignee")).schema.type);
                    Assert.assertFalse((boolean)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"assignee")).required);
                    mask = (byte)(mask | 4);
                }
            }
        }
        Assert.assertEquals((long)mask, (long)7L);
    }

    @Test
    @Restore(value="TestWorkflowActions.xml")
    public void testTransitionPUT_noComment() {
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        issueUpdateRequest.fields(new IssueFields());
        issueUpdateRequest.transition(CLOSED_STATUS);
        issueUpdateRequest.fields().resolution(WONT_FIX_RESOLUTION);
        issueUpdateRequest.fields().fixVersions((List)Lists.newArrayList((Object[])new ResourceRef[]{new ResourceRef().name("New Version 4"), new ResourceRef().name("New Version 5")}));
        ParsedResponse response = this.transitionsClient.postResponse(ISSUE_KEY, issueUpdateRequest);
        Assert.assertEquals((long)204L, (long)response.statusCode);
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        Assert.assertEquals((Object)CLOSED_STATUS_NAME, (Object)issue.fields.status.name());
        Assert.assertEquals((Object)WONT_FIX_RESOLUTION_NAME, (Object)issue.fields.resolution.name);
        Assert.assertEquals((Object)"New Version 4", (Object)((Version)issue.fields.fixVersions.get((int)0)).name);
        Assert.assertEquals((Object)"New Version 5", (Object)((Version)issue.fields.fixVersions.get((int)1)).name);
    }

    @Test
    @Restore(value="TestWorkflowActions.xml")
    public void testTransitionPOST_invalidRole() {
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        issueUpdateRequest.fields(new IssueFields());
        issueUpdateRequest.transition(CLOSED_STATUS);
        issueUpdateRequest.fields().resolution(WONT_FIX_RESOLUTION);
        issueUpdateRequest.update(this.newAddCommentOperationWithInvalidCommentVisibility());
        ParsedResponse response = this.transitionsClient.postResponse(ISSUE_KEY, issueUpdateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        String error = (String)response.entity.errors.get("comment");
        Assert.assertTrue((boolean)error.startsWith("Cannot deserialize value of type `com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean$VisibilityType` from String \"ROLE\": not one of the values accepted for Enum class"));
    }

    private Map<String, List<FieldOperation>> newAddCommentOperationWithInvalidCommentVisibility() {
        Visibility invalidVisibility = new Visibility("ROLE", "NON-EXISTING-ROLE");
        Comment comment = TestIssueResourceTransitions.newCommentWithVisibility("My comment", invalidVisibility);
        return TestIssueResourceTransitions.newAddCommentOperation(comment);
    }

    @Test
    @RestoreDataCenterInstance(value="TestWorkflowActions.xml")
    public void testTransitionPOST_commentsPerIssueLimitViolation() {
        this.setZeroMaxNumberOfCommentsPerIssue();
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        issueUpdateRequest.fields(new IssueFields());
        issueUpdateRequest.transition(CLOSED_STATUS);
        issueUpdateRequest.fields().resolution(WONT_FIX_RESOLUTION);
        issueUpdateRequest.update(TestIssueResourceTransitions.newAddCommentOperation());
        ParsedResponse response = this.transitionsClient.postResponse(ISSUE_KEY, issueUpdateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals(response.entity.errors.get("comment"), (Object)this.backdoor.i18n().getText(COMMENT_COUNT_LIMIT_REACHED_KEY, LOCALE));
    }

    private static Map<String, List<FieldOperation>> newAddCommentOperation() {
        Comment comment = TestIssueResourceTransitions.newCommentWithVisibility("Some comment", null);
        return TestIssueResourceTransitions.newAddCommentOperation(comment);
    }

    private void setZeroMaxNumberOfCommentsPerIssue() {
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "0");
        this.backdoor.applicationProperties().setString(JIRA_SAFEGUARDS_CONFIG_RESTRICTED_GROUPS, "jira-administrators");
    }

    @Test
    @Restore(value="TestRESTTransitionsSimple.xml")
    public void testBasicTimeTracking() throws Exception {
        this.transitionsClient.get("MKY-1");
    }

    @Test
    @RestoreBlankInstance
    public void testTransitionWithMetadata() {
        this.backdoor.project().addProject("TRANSITION", "TRANSITION", "admin");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("TRANSITION", "summary");
        this.transitionsClient.postResponse(issue.key(), new IssueUpdateRequest().transition(ResourceRef.withId((String)"4")).historyMetadata(HistoryMetadata.builder((String)"transitionMetadataTest").build()));
        JsonNode metadata = this.backdoor.issueNavControl().getHistoryMetadata(issue.key).get(0);
        Assert.assertThat((Object)metadata.get("type").asText(), (Matcher)CoreMatchers.equalTo((Object)"transitionMetadataTest"));
    }

    private static Map<String, List<FieldOperation>> newAddCommentOperation(Comment comment) {
        FieldOperation fieldOperation = new FieldOperation("add", (Object)comment);
        return ImmutableMap.of((Object)"comment", Collections.singletonList(fieldOperation));
    }

    private static Comment newCommentWithVisibility(String body, Visibility visibility) {
        Comment jsonComment = new Comment();
        jsonComment.visibility = visibility;
        jsonComment.body = body;
        return jsonComment;
    }
}

