/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.ResponseMatchers;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.rest.api.issue.TimeTracking;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.EntityProperty;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyKeys;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.Group;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueTransitionsMeta;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.util.json.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestIssueResourceUpdate
extends BaseJiraFuncTest {
    private static final FeatureFlag PRIORITIES_PER_PROJECT = FeatureFlag.featureFlag((String)"jira.priorities.per.project");
    private IssueClient issueClient;
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testEditAllSystemFields() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit"));
        this.issueClient.update(original.id, updateSummaryRequest);
        MatcherAssert.assertThat((Object)this.issueClient.get((String)original.key, (Issue.Expand[])new Issue.Expand[0]).fields.summary, (Matcher)CoreMatchers.equalTo((Object)updateSummaryRequest.fields().summary()));
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().priority(ResourceRef.withId((String)"2")).reporter(ResourceRef.withName((String)"fry")).assignee(ResourceRef.withName((String)"farnsworth")).labels(Arrays.asList("foo", "bar")).timeTracking(new TimeTracking("20m", "20m")).securityLevel(ResourceRef.withId((String)"10001")).versions(new ResourceRef[]{ResourceRef.withId((String)"10001")}).environment("edited environment").description("edited description").dueDate("2012-03-01").fixVersions(new ResourceRef[]{ResourceRef.withId((String)"10001")}).components(new ResourceRef[]{ResourceRef.withId((String)"10001")}).resolution(ResourceRef.withId((String)"2")));
        this.issueClient.update(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        MatcherAssert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.priority.id())));
        MatcherAssert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().priority().id()));
        MatcherAssert.assertThat((Object)updated.fields.reporter.name, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().reporter().name()));
        MatcherAssert.assertThat((Object)updated.fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().assignee().name()));
        MatcherAssert.assertThat((Object)Sets.newHashSet((Iterable)updated.fields.labels), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)Sets.newHashSet((Iterable)original.fields.labels))));
        MatcherAssert.assertThat((Object)Sets.newHashSet((Iterable)updated.fields.labels), (Matcher)CoreMatchers.equalTo((Object)Sets.newHashSet((Iterable)updateRequest.fields().labels())));
        MatcherAssert.assertThat((Object)updated.fields.timetracking, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.timetracking)));
        MatcherAssert.assertThat((Object)updated.fields.timetracking.originalEstimate, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().timeTracking().originalEstimate));
        MatcherAssert.assertThat((Object)updated.fields.timetracking.remainingEstimate, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().timeTracking().remainingEstimate));
        MatcherAssert.assertThat((Object)updated.fields.security, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.security)));
        MatcherAssert.assertThat((Object)updated.fields.security.name, (Matcher)CoreMatchers.equalTo((Object)"lvl2"));
        MatcherAssert.assertThat((Object)updated.fields.versions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.versions)));
        MatcherAssert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Version)updated.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        MatcherAssert.assertThat((Object)updated.fields.environment, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.environment)));
        MatcherAssert.assertThat((Object)updated.fields.environment, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().environment()));
        MatcherAssert.assertThat((Object)updated.fields.description, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.description)));
        MatcherAssert.assertThat((Object)updated.fields.description, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().description()));
        MatcherAssert.assertThat((Object)updated.fields.duedate, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.duedate)));
        MatcherAssert.assertThat((Object)updated.fields.duedate, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().dueDate()));
        MatcherAssert.assertThat((Object)updated.fields.fixVersions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.fixVersions)));
        MatcherAssert.assertThat((Object)updated.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        MatcherAssert.assertThat((Object)updated.fields.components, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.components)));
        MatcherAssert.assertThat((Object)updated.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Component)updated.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"comp2"));
        MatcherAssert.assertThat((Object)updated.fields.resolution.id, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.resolution.id)));
        MatcherAssert.assertThat((Object)updated.fields.resolution.id, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().resolution().id()));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testEditSystemFieldsByName() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit"));
        this.issueClient.update(original.id, updateSummaryRequest);
        MatcherAssert.assertThat((Object)this.issueClient.get((String)original.key, (Issue.Expand[])new Issue.Expand[0]).fields.summary, (Matcher)CoreMatchers.equalTo((Object)updateSummaryRequest.fields().summary()));
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().securityLevel(ResourceRef.withName((String)"lvl2")).priority(ResourceRef.withName((String)"Critical")).versions(new ResourceRef[]{ResourceRef.withName((String)"v2")}).fixVersions(new ResourceRef[]{ResourceRef.withName((String)"v2")}).components(new ResourceRef[]{ResourceRef.withName((String)"comp2")}).resolution(ResourceRef.withName((String)"Duplicate")));
        this.issueClient.update(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        MatcherAssert.assertThat((Object)updated.fields.security, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.security)));
        MatcherAssert.assertThat((Object)updated.fields.security.name, (Matcher)CoreMatchers.equalTo((Object)"lvl2"));
        MatcherAssert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.priority.id())));
        MatcherAssert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)updated.fields.versions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.versions)));
        MatcherAssert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Version)updated.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        MatcherAssert.assertThat((Object)updated.fields.fixVersions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.fixVersions)));
        MatcherAssert.assertThat((Object)updated.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        MatcherAssert.assertThat((Object)updated.fields.components, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.components)));
        MatcherAssert.assertThat((Object)updated.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Component)updated.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"comp2"));
        MatcherAssert.assertThat((Object)updated.fields.resolution.id, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.resolution.id)));
        MatcherAssert.assertThat((Object)updated.fields.resolution.id, (Matcher)CoreMatchers.equalTo((Object)"3"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testEditSystemFieldsByNameAndId() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit"));
        this.issueClient.update(original.id, updateSummaryRequest);
        MatcherAssert.assertThat((Object)this.issueClient.get((String)original.key, (Issue.Expand[])new Issue.Expand[0]).fields.summary, (Matcher)CoreMatchers.equalTo((Object)updateSummaryRequest.fields().summary()));
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().priority(ResourceRef.withName((String)"Critical")).versions(new ResourceRef[]{ResourceRef.withName((String)"v1"), ResourceRef.withName((String)"v2")}).fixVersions(new ResourceRef[]{ResourceRef.withId((String)"10000"), ResourceRef.withName((String)"v2")}).components(new ResourceRef[]{ResourceRef.withId((String)"10000"), ResourceRef.withName((String)"comp2")}));
        this.issueClient.update(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        MatcherAssert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.priority.id())));
        MatcherAssert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)updated.fields.versions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.versions)));
        MatcherAssert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((Version)updated.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        MatcherAssert.assertThat((Object)((Version)updated.fields.versions.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        MatcherAssert.assertThat((Object)updated.fields.fixVersions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.fixVersions)));
        MatcherAssert.assertThat((Object)updated.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        MatcherAssert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        MatcherAssert.assertThat((Object)updated.fields.components, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.components)));
        MatcherAssert.assertThat((Object)updated.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((Component)updated.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"comp1"));
        MatcherAssert.assertThat((Object)((Component)updated.fields.components.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"comp2"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testEditSystemFieldsInvalidData() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit"));
        this.issueClient.update(original.id, updateSummaryRequest);
        MatcherAssert.assertThat((Object)this.issueClient.get((String)original.key, (Issue.Expand[])new Issue.Expand[0]).fields.summary, (Matcher)CoreMatchers.equalTo((Object)updateSummaryRequest.fields().summary()));
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().priority(ResourceRef.withName((String)"BadPriority")).versions(new ResourceRef[]{ResourceRef.withName((String)"v1Bad")}).fixVersions(new ResourceRef[]{ResourceRef.withName((String)"v2Bad")}).components(new ResourceRef[]{ResourceRef.withName((String)"comp1Bad")}).resolution(ResourceRef.withName((String)"BadResolution")).dueDate("2001-01-XV"));
        ParsedResponse response = this.issueClient.updateResponse(original.id, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Priority name 'BadPriority' is not valid", response.entity.errors.get("priority"));
        Assert.assertEquals((Object)"Resolution name 'BadResolution' is not valid", response.entity.errors.get("resolution"));
        Assert.assertEquals((Object)"Component name 'comp1Bad' is not valid", response.entity.errors.get("components"));
        Assert.assertEquals((Object)"Version name 'v1Bad' is not valid", response.entity.errors.get("versions"));
        Assert.assertEquals((Object)"Version name 'v2Bad' is not valid", response.entity.errors.get("fixVersions"));
        Assert.assertEquals((Object)"Error parsing date string: 2001-01-XV", response.entity.errors.get("duedate"));
        updateRequest = new IssueUpdateRequest().fields(new IssueFields().priority(ResourceRef.withRubbish((String)"BadPriority")));
        response = this.issueClient.updateResponse(original.id, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Could not find valid 'id' or 'name' in priority object.", response.entity.errors.get("priority"));
        updateRequest = new IssueUpdateRequest().fields(new IssueFields().resolution(ResourceRef.withRubbish((String)"badResolution")));
        response = this.issueClient.updateResponse(original.id, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Could not find valid 'id' or 'name' in resolution object.", response.entity.errors.get("resolution"));
        updateRequest = new IssueUpdateRequest().fields(new IssueFields().versions(new ResourceRef[]{ResourceRef.withRubbish((String)"v1Bad")}).fixVersions(new ResourceRef[]{ResourceRef.withRubbish((String)"v2Bad")}).components(new ResourceRef[]{ResourceRef.withRubbish((String)"comp1Bad")}));
        response = this.issueClient.updateResponse(original.id, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Component/s is required.", response.entity.errors.get("components"));
        Assert.assertEquals((Object)"Affects Version/s is required.", response.entity.errors.get("versions"));
        Assert.assertEquals((Object)"Fix Version/s is required.", response.entity.errors.get("fixVersions"));
        updateRequest = new IssueUpdateRequest().fields(new IssueFields().resolution(ResourceRef.withId((String)"")));
        response = this.issueClient.updateResponse(original.id, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Could not find valid 'id' or 'name' in resolution object.", response.entity.errors.get("resolution"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testEditSystemFieldsSetNull() throws Exception {
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit"));
        this.issueClient.update(original.id, updateSummaryRequest);
        MatcherAssert.assertThat((Object)this.issueClient.get((String)original.key, (Issue.Expand[])new Issue.Expand[0]).fields.summary, (Matcher)CoreMatchers.equalTo((Object)updateSummaryRequest.fields().summary()));
        HashMap updateRequest = new HashMap();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("security", null);
        fields.put("duedate", null);
        updateRequest.put("fields", fields);
        ParsedResponse response = this.issueClient.update(original.id, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Security Level is required.", response.entity.errors.get("security"));
        Assert.assertEquals((Object)"Due Date is required.", response.entity.errors.get("duedate"));
        this.administration.fieldConfigurations().defaultFieldConfiguration().optionalField("Security Level");
        this.administration.fieldConfigurations().defaultFieldConfiguration().optionalField("Due Date");
        this.issueClient.update(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        MatcherAssert.assertThat((Object)updated.fields.security, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.security)));
        MatcherAssert.assertThat((Object)updated.fields.security, (Matcher)CoreMatchers.equalTo(null));
        MatcherAssert.assertThat((Object)updated.fields.duedate, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.duedate)));
        MatcherAssert.assertThat((Object)updated.fields.duedate, (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testEditGroupCustomFields() throws Exception {
        String TST_1 = "TST-1";
        Group jira_developers = new Group().name("jira-developers").self(URI.create(this.environmentData.getBaseUrl() + "/rest/api/2/group?groupname=jira-developers"));
        Group jira_users = new Group().name("jira-users").self(URI.create(this.environmentData.getBaseUrl() + "/rest/api/2/group?groupname=jira-users"));
        String picker = this.addPicker("single group", "com.atlassian.jira.plugin.system.customfieldtypes:grouppicker", "Default Screen");
        this.issueClient.edit("TST-1", new IssueUpdateRequest().update(picker, new FieldOperation[]{new FieldOperation("set", (Object)jira_developers)}));
        Group group = (Group)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.get(picker, Group.class);
        MatcherAssert.assertThat((Object)group, (Matcher)CoreMatchers.equalTo((Object)jira_developers));
        String multiPicker = this.addPicker("many groups", "com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker", "Default Screen");
        this.issueClient.edit("TST-1", new IssueUpdateRequest().update(multiPicker, new FieldOperation[]{new FieldOperation("set", Arrays.asList(jira_users, jira_developers))}));
        List groups = (List)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.get(multiPicker, (TypeReference)new TypeReference<List<Group>>(){});
        MatcherAssert.assertThat((Object)groups.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)groups, (Matcher)Matchers.hasItems((Object[])new Group[]{jira_users, jira_developers}));
        this.issueClient.edit("TST-1", new IssueUpdateRequest().update(multiPicker, new FieldOperation[]{new FieldOperation("remove", (Object)jira_users)}));
        groups = (List)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.get(multiPicker, (TypeReference)new TypeReference<List<Group>>(){});
        MatcherAssert.assertThat((Object)groups, (Matcher)CoreMatchers.equalTo(Collections.singletonList(jira_developers)));
        this.issueClient.edit("TST-1", new IssueUpdateRequest().update(multiPicker, new FieldOperation[]{new FieldOperation("add", (Object)jira_users)}));
        groups = (List)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.get(multiPicker, (TypeReference)new TypeReference<List<Group>>(){});
        MatcherAssert.assertThat((Object)groups.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)groups, (Matcher)Matchers.hasItems((Object[])new Group[]{jira_users, jira_developers}));
    }

    @Test
    @RestoreBlankInstance
    public void testEditWithMetadata() throws Exception {
        this.backdoor.project().addProject("UPDATE", "UPDATE", "admin");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("UPDATE", "summary");
        this.issueClient.edit(issue.key(), new IssueUpdateRequest().fields(new IssueFields().summary("newmmary")).historyMetadata(HistoryMetadata.builder((String)"updateMetadataTest").build()));
        JsonNode metadata = this.backdoor.issueNavControl().getHistoryMetadata(issue.key).get(0);
        MatcherAssert.assertThat((Object)metadata.get("type").asText(), (Matcher)CoreMatchers.equalTo((Object)"updateMetadataTest"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testEditAndSetIssueProperties() throws Exception {
        ImmutableMap obj1 = ImmutableMap.of((Object)"value", (Object)"value1");
        ImmutableMap obj2 = ImmutableMap.of((Object)"other", (Object)"value2");
        ImmutableList properties = ImmutableList.of((Object)new IssueUpdateRequest.IssueProperty("ipObj1", new JSONObject((Map<String, Object>)obj1).toString()), (Object)new IssueUpdateRequest.IssueProperty("ipObj2", new JSONObject((Map<String, Object>)obj2).toString()));
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit")).properties((List)properties);
        this.issueClient.update(original.id, updateRequest);
        EntityPropertyClient propertyClient = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "issue");
        EntityPropertyKeys propertyKeys = propertyClient.getKeys(original.key);
        Set keyNames = propertyKeys.keys.stream().map(epk -> epk.key).collect(Collectors.toSet());
        MatcherAssert.assertThat(keyNames, (Matcher)Matchers.is((Object)ImmutableSet.of((Object)"ipObj1", (Object)"ipObj2")));
        EntityProperty ip1 = propertyClient.get(original.key, "ipObj1");
        EntityProperty ip2 = propertyClient.get(original.key, "ipObj2");
        MatcherAssert.assertThat((Object)ip1.key, (Matcher)Matchers.is((Object)"ipObj1"));
        MatcherAssert.assertThat(ip1.value.entrySet(), (Matcher)Matchers.everyItem((Matcher)Matchers.isIn((Collection)obj1.entrySet())));
        MatcherAssert.assertThat((Object)ip2.key, (Matcher)Matchers.is((Object)"ipObj2"));
        MatcherAssert.assertThat(ip2.value.entrySet(), (Matcher)Matchers.everyItem((Matcher)Matchers.isIn((Collection)obj2.entrySet())));
    }

    @Test
    @RestoreBlankInstance
    public void testEditWithoutNotificationDoesNotWorkForRegularUsers() throws Exception {
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.backdoor.project().addProject("Project", "PR", "admin");
        String issueKey = this.backdoor.issues().createIssue((String)"PR", (String)"summary").key;
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().summary("new summary"));
        ParsedResponse response = ((IssueClient)this.issueClient.loginAs("fred")).updateResponse(issueKey, updateRequest, false);
        MatcherAssert.assertThat((Object)response, ResponseMatchers.hasStatusCode(Response.Status.FORBIDDEN));
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.summary, (Matcher)Matchers.is((Object)"summary"));
    }

    @Test
    @RestoreBlankInstance
    public void testEditWithoutNotificationWorksForAdminAndProjectAdmin() throws Exception {
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.ADMINISTER_PROJECTS, "fred");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.backdoor.project().addProject("Project", "PR", "admin");
        String issueKey = this.backdoor.issues().createIssue((String)"PR", (String)"summary").key;
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().summary("new summary"));
        ParsedResponse responseForAdmin = ((IssueClient)this.issueClient.loginAs("admin")).updateResponse(issueKey, updateRequest, false);
        MatcherAssert.assertThat((Object)responseForAdmin, ResponseMatchers.hasStatusCode(Response.Status.NO_CONTENT));
        ParsedResponse responseForProjectAdmin = ((IssueClient)this.issueClient.loginAs("fred")).updateResponse(issueKey, updateRequest, false);
        MatcherAssert.assertThat((Object)responseForProjectAdmin, ResponseMatchers.hasStatusCode(Response.Status.NO_CONTENT));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testUpdateIssueWithPriorityScheme() throws Exception {
        this.backdoor.darkFeatures().enableForSite(PRIORITIES_PER_PROJECT);
        long prioritySchemeId = this.backdoor.prioritySchemes().createPriorityScheme("Test priority scheme", "Description", (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"5"));
        this.backdoor.prioritySchemes().assignProject(prioritySchemeId, 10000L);
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)original.fields.priority.id(), (Matcher)CoreMatchers.equalTo((Object)"3"));
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit").priority(ResourceRef.withId((String)"2")));
        ParsedResponse response = this.issueClient.updateResponse(original.id, updateRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"This priority is not available for this project.", response.entity.errors.get("priority"));
        Issue notUpdated = this.issueClient.get("TST-1", new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)notUpdated.fields.priority.id(), (Matcher)CoreMatchers.equalTo((Object)original.fields.priority.id()));
        updateRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit second time").priority(ResourceRef.withId((String)"5")));
        this.issueClient.update(original.id, updateRequest);
        Issue updated = this.issueClient.get("TST-1", new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.equalTo((Object)"5"));
    }

    @Test
    @RestoreBlankInstance
    public void testUpdateIssueResourceWithIssueTypeCausingIllegalStatus() {
        Long projectId = this.backdoor.project().addProject("Spiders", "SPD", "admin");
        this.createWorkflowSchemeWithDifferentWorkflows();
        String issueKey = this.issueClient.create(new IssueUpdateRequest().fields(new IssueFields().project(ResourceRef.withId((String)projectId.toString())).issueType(ResourceRef.withName((String)"Bug")).summary("k\u00c4\u0099dziorek"))).key();
        Integer transitionid = ((IssueTransitionsMeta.Transition)this.issueClient.get((String)issueKey, (Issue.Expand[])new Issue.Expand[]{Issue.Expand.transitions}).transitions.stream().findFirst().get()).id;
        this.issueClient.transition(issueKey, new IssueUpdateRequest().transition(ResourceRef.withId((String)transitionid.toString())));
        ParsedResponse response = this.issueClient.updateResponse(issueKey, new IssueUpdateRequest().fields(new IssueFields().issueType(ResourceRef.withName((String)"Task"))));
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        Errors errors = response.entity;
        MatcherAssert.assertThat(errors.errors.get("issuetype"), (Matcher)CoreMatchers.equalTo((Object)"Changing issue type will result in a different workflow being used by this issue. However, the current issue's status does not exist in the target workflow ."));
    }

    private void createWorkflowSchemeWithDifferentWorkflows() {
        String WORKFLOW_NAME = "spoods";
        String STATUS_NAME = "Step two";
        this.administration.workflows().goTo().addWorkflow(WORKFLOW_NAME, "");
        this.administration.workflows().goTo();
        this.administration.statuses().addLinkedStatus(STATUS_NAME, "");
        this.administration.workflows().goTo().workflowSteps(WORKFLOW_NAME).add(STATUS_NAME, STATUS_NAME);
        this.administration.workflows().goTo().workflowSteps(WORKFLOW_NAME).addTransition("Open", "TRANSITION", "", STATUS_NAME, null);
        WorkflowSchemeData workflowSchemeData = new WorkflowSchemeData();
        workflowSchemeData.setName(WORKFLOW_NAME);
        HashMap<String, String> issueTypeMappings = new HashMap<String, String>();
        issueTypeMappings.put(null, "classic default workflow");
        issueTypeMappings.put("Bug", WORKFLOW_NAME);
        workflowSchemeData.setMappingWithDefault(issueTypeMappings);
        workflowSchemeData = this.backdoor.workflowSchemes().createScheme(workflowSchemeData);
        this.administration.project().associateWorkflowScheme("Spiders", workflowSchemeData.getName());
    }

    private String addPicker(String pickerName, String pickerType, String associatedScreenName) {
        String picker = this.backdoor.customFields().createCustomField(pickerName, "", pickerType, null);
        this.backdoor.screens().addFieldToScreen(associatedScreenName, this.backdoor.customFields().getCustomField(picker).getName());
        return picker;
    }
}

