/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.Vote;
import com.atlassian.jira.testkit.client.restclient.VotesClient;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestIssueResourceVotes
extends BaseJiraFuncTest {
    private String issueKey;
    private VotesClient votesClient;
    private IssueClient issueClient;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.votesClient = new VotesClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.navigation.login("fred");
        this.navigation.issue().voteIssue(this.issueKey);
        this.navigation.login("admin");
    }

    @Test
    public void testVote_issueDoesNotExist() throws Exception {
        ParsedResponse response = ((VotesClient)this.votesClient.loginAs("fred")).deleteResponse("HSP-204");
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("Issue Does Not Exist"));
    }

    @Test
    public void testVote_votingDisabled() throws Exception {
        this.administration.generalConfiguration().disableVoting();
        this.backdoor.usersAndGroups().addUser("barney");
        ParsedResponse response = ((VotesClient)this.votesClient.loginAs("barney")).deleteResponse(this.issueKey);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("Voting for issues is currently not enabled for this Jira instance."));
    }

    @Test
    public void testVote_reporter() throws Exception {
        ParsedResponse response = this.votesClient.postResponse(this.issueKey);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("You cannot vote for an issue you have reported."));
        Assert.assertEquals((long)1L, (long)this.getVotes());
        Assert.assertFalse((boolean)this.i_voted());
    }

    @Test
    public void testVote_successful() throws Exception {
        this.backdoor.usersAndGroups().addUser("barney");
        ParsedResponse response = ((VotesClient)this.votesClient.loginAs("barney")).postResponse(this.issueKey);
        Assert.assertEquals((long)204L, (long)response.statusCode);
        Assert.assertEquals((long)2L, (long)this.getVotes());
        Assert.assertTrue((boolean)this.i_voted("barney"));
    }

    @Test
    public void testViewVoters_issueDoesNotExist() throws Exception {
        ParsedResponse response = this.votesClient.getResponse("HSP-55");
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("Issue Does Not Exist"));
    }

    @Test
    public void testViewVoters_votingDisabled() throws Exception {
        this.administration.generalConfiguration().disableVoting();
        ParsedResponse response = this.votesClient.getResponse(this.issueKey);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("Voting for issues is currently not enabled for this Jira instance."));
    }

    @Test
    public void testViewVoters_noPermission() throws Exception {
        Vote vote = ((VotesClient)this.votesClient.loginAs("fred")).get(this.issueKey);
        Assert.assertEquals((long)1L, (long)vote.votes);
        Assert.assertEquals((long)0L, (long)vote.voters.size());
    }

    @Test
    public void testViewVoters_successful() throws Exception {
        Vote voters = this.votesClient.get(this.issueKey);
        Assert.assertEquals((long)1L, (long)voters.votes);
        User user = (User)voters.voters.get(0);
        Assert.assertNotNull((Object)user.self);
        Assert.assertEquals((Object)"fred", (Object)user.name);
        Assert.assertEquals((Object)"Fred Normal", (Object)user.displayName);
    }

    @Test
    public void testUnvote_issueDoesNotExist() throws Exception {
        ParsedResponse response = ((VotesClient)this.votesClient.loginAs("fred")).deleteResponse("HSP-204");
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("Issue Does Not Exist"));
    }

    @Test
    public void testUnvote_votingDisabled() throws Exception {
        this.administration.generalConfiguration().disableVoting();
        ParsedResponse response = ((VotesClient)this.votesClient.loginAs("fred")).deleteResponse(this.issueKey);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("Voting for issues is currently not enabled for this Jira instance."));
    }

    @Test
    public void testUnvote_reporter() throws Exception {
        ParsedResponse response = this.votesClient.deleteResponse(this.issueKey);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("You cannot vote for an issue you have reported."));
        Assert.assertEquals((long)1L, (long)this.getVotes());
    }

    @Test
    public void testUnvote_successful() throws Exception {
        ParsedResponse response = ((VotesClient)this.votesClient.loginAs("fred")).deleteResponse(this.issueKey);
        Assert.assertEquals((long)204L, (long)response.statusCode);
        Assert.assertEquals((long)0L, (long)this.getVotes());
        Assert.assertFalse((boolean)this.i_voted("fred"));
    }

    private int getVotes() {
        return this.issueClient.get((String)this.issueKey, (Issue.Expand[])new Issue.Expand[0]).fields.votes.votes;
    }

    private boolean i_voted() {
        return this.i_voted(null);
    }

    private boolean i_voted(String user) {
        Issue issue = user != null ? ((IssueClient)this.issueClient.loginAs(user)).get(this.issueKey, new Issue.Expand[0]) : this.issueClient.get(this.issueKey, new Issue.Expand[0]);
        return issue.fields.votes.hasVoted;
    }
}

