/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.WatchersClient;
import com.atlassian.jira.testkit.client.restclient.Watches;
import com.atlassian.jira.testkit.client.restclient.matcher.HasErrorMessage;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestIssueResourceWatchers.xml")
public class TestIssueResourceWatchers
extends BaseJiraFuncTest {
    private static final String loginUser = "fred";
    private static final String slashName = "kelpie/trevor";
    private final String anotherUser = "luser";
    private IssueClient issueClient;
    private WatchersClient watchersClient;
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.watchersClient = new WatchersClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    @Test
    public void testWatchingDisabled() throws Exception {
        this.disableWatching();
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertNull((Object)issue.fields.watches);
    }

    @Test
    public void testViewWatchersRequestExpanded() throws Exception {
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertEquals((Object)"HSP-1", (Object)issue.key);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/issue/HSP-1/watchers"), (Object)issue.fields.watches.self);
    }

    @Test
    public void testViewWatchersNoPermissionToViewButCanStillSeeCount() throws Exception {
        Issue issue = ((IssueClient)this.issueClient.loginAs("luser")).get("HSP-1", new Issue.Expand[0]);
        Assert.assertEquals((Object)"HSP-1", (Object)issue.key);
        Assert.assertEquals((long)2L, (long)issue.fields.watches.watchCount);
    }

    @Test
    public void testViewWatchersNoPermissionToViewButCanStillSeeMyselfAndCount() throws Exception {
        Issue issue = ((IssueClient)this.issueClient.loginAs("luser")).get("HSP-2", new Issue.Expand[0]);
        Assert.assertEquals((Object)"HSP-2", (Object)issue.key);
        Watches watchers = issue.fields.watches;
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/issue/HSP-2/watchers"), (Object)watchers.self);
        Assert.assertEquals((long)2L, (long)watchers.watchCount);
    }

    @Test
    public void testViewWatchersIsWatching() throws Exception {
        Issue issue = ((IssueClient)this.issueClient.loginAs("luser")).get("HSP-2", new Issue.Expand[0]);
        Assert.assertEquals((Object)"HSP-2", (Object)issue.key);
        Watches watchers = issue.fields.watches;
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/issue/HSP-2/watchers"), (Object)watchers.self);
        Assert.assertTrue((boolean)watchers.isWatching);
    }

    @Test
    public void testViewWatchersIsNotWatching() throws Exception {
        Issue issue = ((IssueClient)this.issueClient.loginAs("luser")).get("HSP-1", new Issue.Expand[0]);
        Assert.assertEquals((Object)"HSP-1", (Object)issue.key);
        Watches watchers = issue.fields.watches;
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/issue/HSP-1/watchers"), (Object)watchers.self);
        Assert.assertFalse((boolean)watchers.isWatching);
    }

    @Test
    public void testWatchers_Anonymous() throws Exception {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        Watches watchers = ((WatchersClient)this.watchersClient.anonymous()).get("HSP-1");
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/issue/HSP-1/watchers"), (Object)watchers.self);
        Assert.assertEquals((long)2L, (long)watchers.watchCount);
        Assert.assertFalse((boolean)watchers.isWatching);
        Assert.assertEquals((long)0L, (long)watchers.watchers.size());
    }

    @Test
    public void testViewWatchersSubresourceExpanded() throws Exception {
        Watches watchers = this.watchersClient.get("HSP-1");
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/issue/HSP-1/watchers"), (Object)watchers.self);
        List watcherList = watchers.watchers;
        Assert.assertEquals((long)2L, (long)watcherList.size());
        List names = watcherList.stream().map(watcher -> watcher.name).collect(Collectors.toList());
        Assert.assertTrue((boolean)names.contains(loginUser));
        Assert.assertTrue((boolean)names.contains("admin"));
    }

    @Test
    public void testViewWatchersSubresourceExpandedIssueDoesNotExist() throws Exception {
        ParsedResponse response = this.watchersClient.getResponse("HSP-999");
        Assert.assertEquals((long)404L, (long)response.statusCode);
    }

    @Test
    public void testAddWatchWhenWatchingIsDisabled() throws Exception {
        this.disableWatching();
        ParsedResponse resp = ((WatchersClient)this.watchersClient.loginAs(loginUser)).postResponse("HSP-2", loginUser);
        Assert.assertEquals((long)404L, (long)resp.statusCode);
    }

    @Test
    public void testAddWatchToIssueThatDoesNotExist() throws Exception {
        ParsedResponse resp = ((WatchersClient)this.watchersClient.loginAs(loginUser)).postResponse("HSP-999", loginUser);
        Assert.assertEquals((long)404L, (long)resp.statusCode);
    }

    @Test
    public void testAddWatchToIssueThatIAmAlreadyWatching() throws Exception {
        ParsedResponse resp = ((WatchersClient)this.watchersClient.loginAs(loginUser)).postResponse("HSP-1", loginUser);
        Assert.assertEquals((long)204L, (long)resp.statusCode);
    }

    @Test
    public void testAddWatchToIssue() throws Exception {
        ParsedResponse resp = ((WatchersClient)this.watchersClient.loginAs(loginUser)).postResponse("HSP-2", loginUser);
        Assert.assertEquals((long)204L, (long)resp.statusCode);
        Assert.assertTrue((boolean)this.isWatching("HSP-2", loginUser));
    }

    @Test
    public void testAddWatchToIssue_emptyPOST() throws Exception {
        ParsedResponse resp = ((WatchersClient)this.watchersClient.loginAs(loginUser)).postResponse("HSP-2", null);
        Assert.assertEquals((long)204L, (long)resp.statusCode);
        Assert.assertTrue((boolean)this.isWatching("HSP-2", loginUser));
    }

    @Test
    public void testAddWatchForAnotherUser() throws Exception {
        ParsedResponse resp = ((WatchersClient)this.watchersClient.loginAs("luser")).postResponse("HSP-2", loginUser);
        Assert.assertEquals((long)401L, (long)resp.statusCode);
    }

    @Test
    public void testAddWatchForAnotherUserCannotView() throws Exception {
        ParsedResponse resp = this.watchersClient.postResponse("MKY-1", "jack");
        Assert.assertEquals((long)401L, (long)resp.statusCode);
        Assert.assertEquals((Object)"The user \"jack\" does not have permission to view this issue. This user will not be added to the watch list.", resp.entity.errorMessages.get(0));
    }

    @Test
    public void testRemoveWatchForAnotherUserCannotView() throws Exception {
        ParsedResponse resp = this.watchersClient.deleteResponse("MKY-2", "jack");
        Assert.assertEquals((long)204L, (long)resp.statusCode);
        resp = this.watchersClient.postResponse("MKY-2", "jack");
        Assert.assertEquals((long)401L, (long)resp.statusCode);
        Assert.assertEquals((Object)"The user \"jack\" does not have permission to view this issue. This user will not be added to the watch list.", resp.entity.errorMessages.get(0));
    }

    @Test
    public void testRemoveWatchWhenWatchingIsDisabled() throws Exception {
        this.disableWatching();
        ParsedResponse resp = ((WatchersClient)this.watchersClient.loginAs(loginUser)).deleteResponse("HSP-2", loginUser);
        Assert.assertEquals((long)404L, (long)resp.statusCode);
    }

    @Test
    public void testRemoveWatchToIssueThatDoesNotExist() throws Exception {
        ParsedResponse resp = ((WatchersClient)this.watchersClient.loginAs(loginUser)).deleteResponse("HSP-999", loginUser);
        Assert.assertEquals((long)404L, (long)resp.statusCode);
    }

    @Test
    public void testRemoveWatchFromIssueThatIAmNotWatching() throws Exception {
        Assert.assertFalse((boolean)this.isWatching("HSP-2", loginUser));
        ParsedResponse resp = ((WatchersClient)this.watchersClient.loginAs(loginUser)).deleteResponse("HSP-2", loginUser);
        Assert.assertEquals((long)204L, (long)resp.statusCode);
        Assert.assertFalse((boolean)this.isWatching("HSP-2", loginUser));
    }

    @Test
    public void testRemoveWatchForAnotherUser_Denied() throws Exception {
        ParsedResponse resp = ((WatchersClient)this.watchersClient.loginAs("luser")).deleteResponse("HSP-2", loginUser);
        Assert.assertEquals((long)401L, (long)resp.statusCode);
        Assert.assertThat((Object)resp, (Matcher)HasErrorMessage.hasErrorMessage((String)"User 'luser' is not allowed to remove watchers from issue 'HSP-2'"));
    }

    @Test
    public void testRemoveWatchForAnotherUser_Allowed() throws Exception {
        ParsedResponse resp = this.watchersClient.deleteResponse("HSP-2", loginUser);
        Assert.assertEquals((long)204L, (long)resp.statusCode);
        Assert.assertFalse((boolean)this.isWatching("HSP-2", loginUser));
    }

    @Test
    public void testRemoveWatch() throws Exception {
        Assert.assertTrue((boolean)this.isWatching("HSP-1", loginUser));
        ParsedResponse resp = this.watchersClient.deleteResponse("HSP-1", loginUser);
        Assert.assertEquals((long)204L, (long)resp.statusCode);
        Assert.assertFalse((boolean)this.isWatching("HSP-1", loginUser));
    }

    @Test
    public void testSlashNamesWatchIssue() throws Exception {
        ParsedResponse resp = this.watchersClient.postResponse("HSP-2", slashName);
        Assert.assertEquals((long)204L, (long)resp.statusCode);
        Assert.assertTrue((boolean)this.isWatching("HSP-2", slashName));
        resp = this.watchersClient.deleteResponse("HSP-2", slashName);
        Assert.assertEquals((long)204L, (long)resp.statusCode);
        Assert.assertFalse((boolean)this.isWatching("HSP-2", slashName));
    }

    @Test
    public void testAddingOrRemovingWatcherFromIssuesThatIAmNotAllowedToSeeReturns401() throws Exception {
        ParsedResponse addResponse = ((WatchersClient)this.watchersClient.anonymous()).postResponse("HSP-1", loginUser);
        Assert.assertThat((Object)addResponse.statusCode, (Matcher)IsEqual.equalTo((Object)401));
        Assert.assertThat((Object)addResponse, (Matcher)HasErrorMessage.hasErrorMessage((String)"You do not have the permission to see the specified issue."));
        ParsedResponse delResponse = ((WatchersClient)this.watchersClient.anonymous()).deleteResponse("HSP-1", loginUser);
        Assert.assertThat((Object)delResponse.statusCode, (Matcher)IsEqual.equalTo((Object)401));
        Assert.assertThat((Object)addResponse, (Matcher)HasErrorMessage.hasErrorMessage((String)"You do not have the permission to see the specified issue."));
        addResponse = ((WatchersClient)this.watchersClient.loginAs("jack")).postResponse("HSP-1", loginUser);
        Assert.assertThat((Object)addResponse.statusCode, (Matcher)IsEqual.equalTo((Object)401));
        Assert.assertThat((Object)addResponse, (Matcher)HasErrorMessage.hasErrorMessage((String)"User 'jack' is not allowed to add watchers to issue 'HSP-1'"));
        delResponse = ((WatchersClient)this.watchersClient.loginAs("jack")).deleteResponse("HSP-1", loginUser);
        Assert.assertThat((Object)delResponse.statusCode, (Matcher)IsEqual.equalTo((Object)401));
        Assert.assertThat((Object)delResponse, (Matcher)HasErrorMessage.hasErrorMessage((String)"User 'jack' is not allowed to remove watchers from issue 'HSP-1'"));
    }

    private boolean isWatching(String issueKey, String username) {
        Watches watchers = this.watchersClient.get(issueKey);
        for (User watcher : watchers.watchers) {
            if (!username.equals(watcher.name)) continue;
            return true;
        }
        return false;
    }

    private void disableWatching() {
        this.administration.generalConfiguration().disableWatching();
    }
}

