/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.rule.IssueTypeUrls;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.client.WebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueShape
extends BaseJiraFuncTest {
    @Rule
    public IssueTypeUrls issueTypeUrls = new IssueTypeUrls();
    private IssueClient issueClient;
    private static final Pattern DATE_PATTERN = Pattern.compile("^\\d\\d\\d\\d-\\d\\d-\\d\\d$");
    private static final Pattern DATETIME_PATTERN = Pattern.compile("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d[+-]\\d\\d\\d\\d$");

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    @Test
    @Restore(value="TestIssueShape.xml")
    public void testGeneralShape() {
        WebTarget resource = this.issueClient.issueResource("TST-1", new Issue.Expand[0]);
        Object json = resource.request().get(Object.class);
        Map<String, ?> fields = this.asObject(this.getAt(json, "fields"));
        Assert.assertEquals((Object)"A critical bug", (Object)this.asString(this.getAt(fields, "summary")));
        Assert.assertEquals((Object)"blah", (Object)this.asString(this.getAt(fields, "description")));
        Assert.assertEquals((Object)"1", (Object)this.asString(this.getAt(fields, "issuetype", "id")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "issuetype", "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/issuetype/1"));
        Assert.assertEquals((Object)"A problem which impairs or prevents the functions of the product.", (Object)this.asString(this.getAt(fields, "issuetype", "description")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "issuetype", "iconUrl")), (Matcher)Matchers.endsWith((String)this.issueTypeUrls.getIssueTypeUrl("bug")));
        Assert.assertEquals((Object)"Bug", (Object)this.asString(this.getAt(fields, "issuetype", "name")));
        Assert.assertEquals((Object)false, (Object)this.asBoolean(this.getAt(fields, "issuetype", "subtask")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "votes", "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/issue/TST-1/votes"));
        Assert.assertEquals((Object)0, (Object)this.asNumber(this.getAt(fields, "votes", "votes")));
        Assert.assertEquals((Object)false, (Object)this.asBoolean(this.getAt(fields, "votes", "hasVoted")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "security", "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/securitylevel/10001"));
        Assert.assertEquals((Object)"10001", (Object)this.asString(this.getAt(fields, "security", "id")));
        Assert.assertEquals((Object)"", (Object)this.asString(this.getAt(fields, "security", "description")));
        Assert.assertEquals((Object)"lvl2", (Object)this.asString(this.getAt(fields, "security", "name")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "fixVersions", 0, "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/version/10001"));
        Assert.assertEquals((Object)"10001", (Object)this.asString(this.getAt(fields, "fixVersions", 0, "id")));
        Assert.assertEquals((Object)"", (Object)this.asString(this.getAt(fields, "fixVersions", 0, "description")));
        Assert.assertEquals((Object)"v2", (Object)this.asString(this.getAt(fields, "fixVersions", 0, "name")));
        Assert.assertEquals((Object)"2011-09-23", (Object)this.asDateString(this.getAt(fields, "fixVersions", 0, "releaseDate")));
        Assert.assertEquals((Object)false, (Object)this.asBoolean(this.getAt(fields, "fixVersions", 0, "archived")));
        Assert.assertEquals((Object)false, (Object)this.asBoolean(this.getAt(fields, "fixVersions", 0, "released")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "resolution", "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/resolution/1"));
        Assert.assertEquals((Object)"1", (Object)this.asString(this.getAt(fields, "resolution", "id")));
        Assert.assertEquals((Object)"A fix for this issue is checked into the tree and tested.", (Object)this.asString(this.getAt(fields, "resolution", "description")));
        Assert.assertEquals((Object)"Fixed", (Object)this.asString(this.getAt(fields, "resolution", "name")));
        Assert.assertEquals((Object)this.asDateTime("2011-07-27T12:56:01.847+1000"), (Object)this.asDateTime(this.getAt(fields, "resolutiondate")));
        Assert.assertEquals((Object)this.asDateTime("2011-06-29T16:40:56.287+1000"), (Object)this.asDateTime(this.getAt(fields, "created")));
        Assert.assertEquals((Object)this.asDateTime("2011-09-23T10:33:34.794+1000"), (Object)this.asDateTime(this.getAt(fields, "updated")));
        Assert.assertEquals((Object)"2012-02-29", (Object)this.asDateString(this.getAt(fields, "duedate")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "reporter", "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/user?username=fry"));
        Assert.assertEquals((Object)"fry", (Object)this.asString(this.getAt(fields, "reporter", "name")));
        Assert.assertEquals((Object)"fry@example.com", (Object)this.asString(this.getAt(fields, "reporter", "emailAddress")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "reporter", "avatarUrls", "16x16")), (Matcher)Matchers.endsWith((String)"/secure/useravatar?size=xsmall&avatarId=10062"));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "reporter", "avatarUrls", "48x48")), (Matcher)Matchers.endsWith((String)"/secure/useravatar?avatarId=10062"));
        Assert.assertEquals((Object)"Phillip J. Fry", (Object)this.asString(this.getAt(fields, "reporter", "displayName")));
        Assert.assertEquals((Object)true, (Object)this.asBoolean(this.getAt(fields, "reporter", "active")));
        Assert.assertEquals((Object)"bar", (Object)this.asString(this.getAt(fields, "labels", 0)));
        Assert.assertEquals((Object)"foo", (Object)this.asString(this.getAt(fields, "labels", 1)));
        Assert.assertEquals((Object)0, (Object)this.asNumber(this.getAt(fields, "comment", "startAt")));
        Assert.assertEquals((Object)1, (Object)this.asNumber(this.getAt(fields, "comment", "maxResults")));
        Assert.assertEquals((Object)1, (Object)this.asNumber(this.getAt(fields, "comment", "total")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "comment", "comments", 0, "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/issue/10000/comment/10000"));
        Assert.assertEquals((Object)"10000", (Object)this.asString(this.getAt(fields, "comment", "comments", 0, "id")));
        Assert.assertEquals((Object)"foo", (Object)this.asString(this.getAt(fields, "comment", "comments", 0, "body")));
        Assert.assertEquals((Object)this.asDateTime("2011-09-23T10:33:16.309+1000"), (Object)this.asDateTime(this.getAt(fields, "comment", "comments", 0, "created")));
        Assert.assertEquals((Object)this.asDateTime("2011-09-23T10:33:16.309+1000"), (Object)this.asDateTime(this.getAt(fields, "comment", "comments", 0, "updated")));
        Assert.assertEquals((Object)"admin", (Object)this.asString(this.getAt(fields, "comment", "comments", 0, "author", "name")));
        Assert.assertEquals((Object)"admin", (Object)this.asString(this.getAt(fields, "comment", "comments", 0, "updateAuthor", "name")));
    }

    private Object getAt(Object o, Object ... path) {
        for (Object key : path) {
            if (key instanceof String) {
                String s = (String)key;
                Map<String, ?> obj = this.asObject(o);
                Assert.assertTrue((String)(s + " in " + obj), (boolean)obj.containsKey(s));
                o = obj.get(s);
                continue;
            }
            if (key instanceof Integer) {
                int i = (Integer)key;
                List<?> array = this.asArray(o);
                Assert.assertTrue((String)(i + " indexed into " + array), (0 <= i && i < array.size() ? 1 : 0) != 0);
                o = array.get(i);
                continue;
            }
            Assert.fail((String)("unknown key type " + key));
        }
        return o;
    }

    private Map<String, ?> asObject(Object o) {
        Assert.assertTrue((boolean)(o instanceof Map));
        return (Map)o;
    }

    private List<?> asArray(Object o) {
        Assert.assertTrue((boolean)(o instanceof List));
        return (List)o;
    }

    private String asString(Object o) {
        Assert.assertTrue((boolean)(o instanceof String));
        return (String)o;
    }

    private String asDateString(Object o) {
        String s = this.asString(o);
        Assert.assertTrue((String)s, (boolean)DATE_PATTERN.matcher(s).matches());
        return s;
    }

    private Date asDateTime(Object o) {
        String s = this.asString(o);
        Assert.assertTrue((String)s, (boolean)DATETIME_PATTERN.matcher(s).matches());
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(s);
        }
        catch (ParseException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    private boolean asBoolean(Object o) {
        Assert.assertTrue((boolean)(o instanceof Boolean));
        return (Boolean)o;
    }

    private Number asNumber(Object o) {
        Assert.assertTrue((boolean)(o instanceof Number));
        return (Number)o;
    }
}

