/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.EntityProperty;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REST})
@LoginAs(user="admin")
public class TestIssueTypePropertyResource
extends BaseJiraFuncTest {
    public static final String PROPERTY_KEY = "issuetype.cool";
    public static final String PROJECT_KEY = "HSP";
    private EntityPropertyClient client;

    @Before
    public void setUpTest() {
        this.client = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "issuetype");
        this.backdoor.restoreBlankInstance();
    }

    @Test
    public void testCreatingNewIssueTypeProperty() {
        IssueTypeControl.IssueType issueType = this.backdoor.issueType().createIssueType("my-type");
        this.assertHasNoProperties(issueType);
        JSONObject expected = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(issueType.getId(), PROPERTY_KEY, expected);
        EntityProperty result = this.client.get(issueType.getId(), PROPERTY_KEY);
        MatcherAssert.assertThat((Object)result.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        MatcherAssert.assertThat((Object)new JSONObject(result.value), (Matcher)Matchers.is((Object)expected));
        List keys = this.client.getKeys((String)issueType.getId()).keys;
        Matcher matcher = Matchers.hasItem(PropertyAssertions.propertyKey(PROPERTY_KEY));
        MatcherAssert.assertThat((Object)keys, (Matcher)matcher);
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.client.anonymous()).getKeys(issueType.getId());
            return null;
        }, Response.Status.NOT_FOUND);
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.client.anonymous()).get(issueType.getId(), PROPERTY_KEY);
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testDeleteProperty() {
        IssueTypeControl.IssueType issueType = this.backdoor.issueType().createIssueType("my-type");
        this.assertHasNoProperties(issueType);
        JSONObject expected = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(issueType.getId(), PROPERTY_KEY, expected);
        EntityProperty result = this.client.get(issueType.getId(), PROPERTY_KEY);
        MatcherAssert.assertThat((Object)result.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        MatcherAssert.assertThat((Object)new JSONObject(result.value), (Matcher)Matchers.is((Object)expected));
        this.client.delete(issueType.getId(), PROPERTY_KEY);
        this.assertHasNoProperties(issueType);
        PropertyAssertions.assertWebApplicationException(() -> {
            this.client.get(issueType.getId(), PROPERTY_KEY);
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testPropertyRemovedWhenIssueTypeRemoved() {
        IssueTypeControl.IssueType issueType = this.backdoor.issueType().createIssueType("my-type");
        this.assertHasNoProperties(issueType);
        JSONObject expected = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(issueType.getId(), PROPERTY_KEY, expected);
        EntityProperty result = this.client.get(issueType.getId(), PROPERTY_KEY);
        MatcherAssert.assertThat((Object)result.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        MatcherAssert.assertThat((Object)new JSONObject(result.value), (Matcher)Matchers.is((Object)expected));
        this.backdoor.issueType().deleteIssueType(Long.parseLong(issueType.getId()));
        PropertyAssertions.assertWebApplicationException(() -> {
            this.client.get(issueType.getId(), PROPERTY_KEY);
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testSetResultsInForbiddenForNotAdminWithPermissionsToViewIssueType() {
        IssueTypeControl.IssueType issueType = this.backdoor.issueType().createIssueType("my-type");
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(issueType.getId(), PROPERTY_KEY, jsonObject);
        ((EntityPropertyClient)this.client.loginAs("fred")).get(issueType.getId(), PROPERTY_KEY);
        MatcherAssert.assertThat((Object)((EntityPropertyClient)this.client.loginAs((String)"fred")).put((String)issueType.getId(), (String)PROPERTY_KEY, (JSONObject)jsonObject).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testDeleteResultsInForbiddenForNotAdminWithPermissionsToViewIssueType() {
        IssueTypeControl.IssueType issueType = this.backdoor.issueType().createIssueType("my-type");
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(issueType.getId(), PROPERTY_KEY, jsonObject);
        ((EntityPropertyClient)this.client.loginAs("fred")).get(issueType.getId(), PROPERTY_KEY);
        MatcherAssert.assertThat((Object)((EntityPropertyClient)this.client.loginAs((String)"fred")).delete((String)issueType.getId(), (String)PROPERTY_KEY).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testSetResultsInNotFoundForNotAdminWithoutPermissionsToViewIssueType() {
        IssueTypeControl.IssueType issueType = this.backdoor.issueType().createIssueType("my-type");
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(issueType.getId(), PROPERTY_KEY, jsonObject);
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.client.anonymous()).get(issueType.getId(), PROPERTY_KEY);
            return null;
        }, Response.Status.NOT_FOUND);
        MatcherAssert.assertThat((Object)((EntityPropertyClient)this.client.anonymous()).put((String)issueType.getId(), (String)PROPERTY_KEY, (JSONObject)jsonObject).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void testDeleteResultsInNotFoundForNotAdminWithoutPermissionsToViewIssueType() {
        IssueTypeControl.IssueType issueType = this.backdoor.issueType().createIssueType("my-type");
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(issueType.getId(), PROPERTY_KEY, jsonObject);
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.client.anonymous()).get(issueType.getId(), PROPERTY_KEY);
            return null;
        }, Response.Status.NOT_FOUND);
        MatcherAssert.assertThat((Object)((EntityPropertyClient)this.client.anonymous()).delete((String)issueType.getId(), (String)PROPERTY_KEY).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    private void assertHasNoProperties(IssueTypeControl.IssueType issueType) {
        MatcherAssert.assertThat((Object)this.client.getKeys((String)issueType.getId()).keys, (Matcher)Matchers.empty());
    }
}

