/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.IssueTypeClient;
import com.atlassian.jira.testkit.client.restclient.IssueTypeCreateBean;
import com.atlassian.jira.testkit.client.restclient.IssueTypeUpdateBean;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.google.inject.Inject;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestIssueTypeResource
extends BaseJiraRestTest {
    public static final String DESCRIPTION = "description";
    public static final String NAME = "name";
    public static final String NEW_BUG = "New Bug";
    public static final String SUPER_FEATURE = "Super Feature";
    public static final String SUBTASK = "subtask";
    public static final String EMPTY_STRING = "";
    private IssueTypeClient issueTypeClient;
    private IssueClient issueClient;
    @Inject
    FuncTestUrlHelper funcTestUrlHelper;

    @Before
    public void setUpTest() {
        this.backdoor.applicationProperties().setOption("jira.option.allowsubtasks", true);
        this.issueTypeClient = new IssueTypeClient((JIRAEnvironmentData)this.environmentData);
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    @Restore(value="TestIssueTypeResource.xml")
    public void testIssueTypeVisible() {
        IssueTypeControl.IssueType expectedIssueType = this.backdoor.issueType().getIssueTypes().stream().filter(it -> "Task".equals(it.getName())).findFirst().orElseThrow(() -> new AssertionError((Object)"Issue type was not present"));
        IssueType issueType = this.issueTypeClient.get("3");
        Assertions.assertThat((String)issueType.id).isEqualTo(expectedIssueType.getId());
        Assertions.assertThat((String)issueType.name).isEqualTo(expectedIssueType.getName());
        Assertions.assertThat((String)issueType.self).isEqualTo(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/issuetype/" + expectedIssueType.getId());
        Assertions.assertThat((String)issueType.description).isEqualTo("A task that needs to be done.");
        Assertions.assertThat((String)issueType.iconUrl).isEqualTo(this.funcTestUrlHelper.getBaseUrl() + expectedIssueType.getIconUrl());
        Assertions.assertThat((boolean)issueType.subtask).isFalse();
    }

    @Test
    @Restore(value="TestIssueTypeResource.xml")
    public void testIssueTypeNotVisible() {
        ParsedResponse response = ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).getResponse("3");
        Assertions.assertThat((int)response.statusCode).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void testIssueTypeDoesNotExist() {
        ParsedResponse responseZzz = ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).getResponse("zzz");
        Assertions.assertThat((int)responseZzz.statusCode).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    @Restore(value="TestIssueTypeResource.xml")
    public void testIssueTypeResourceSupportsAbsoluteUrlInIconUrl() {
        IssueType response = ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).get("1");
        Assertions.assertThat((String)response.iconUrl).isEqualTo("https://jira.atlassian.com/images/icons/bug.gif");
    }

    @Test
    public void testGetAllIssueTypes() {
        List issueTypes = this.issueTypeClient.get();
        Assertions.assertThat((List)issueTypes).hasSize(4);
        this.assertIssueTypesContain(issueTypes, "1", "2", "3", "4");
    }

    @Test
    @Restore(value="TestIssueTypeResource.xml")
    public void testGetIssueTypesForUserWithRestrictedPermissionsToProjects() {
        List issueTypes = ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).get();
        Assertions.assertThat((List)issueTypes).hasSize(2);
        this.assertIssueTypesContain(issueTypes, "1", "2");
    }

    @Test
    public void testCreateIssueTypeSuccessful() {
        IssueTypeCreateBean issueTypeCreateBean = this.getIssueTypeCreateBean();
        IssueType issueType = this.issueTypeClient.post(issueTypeCreateBean);
        this.assertIssueTypeMatchesJsonBean(issueType, issueTypeCreateBean, false);
        this.assertIssueTypeWithPropertiesExists(issueTypeCreateBean.getName(), issueTypeCreateBean.getDescription(), false);
    }

    @Test
    public void testCreateIssueTypeWithAnonymousUser() {
        PropertyAssertions.assertWebApplicationException(() -> {
            IssueTypeCreateBean issueTypeCreateBean = this.getIssueTypeCreateBean();
            ((IssueTypeClient)this.issueTypeClient.anonymous()).post(issueTypeCreateBean);
            return null;
        }, Response.Status.UNAUTHORIZED);
    }

    @Test
    public void testCreateIssueTypeWithUserWithoutAdminPermissions() {
        PropertyAssertions.assertWebApplicationException(() -> {
            IssueTypeCreateBean issueTypeCreateBean = this.getIssueTypeCreateBean();
            ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).post(issueTypeCreateBean);
            return null;
        }, Response.Status.FORBIDDEN);
    }

    @Test
    public void testCreateIssueTypeWithExistingUserName() {
        Option typeOption = Iterables.first((Iterable)this.issueTypeClient.get());
        Assertions.assertThat((boolean)typeOption.isDefined()).isTrue();
        IssueType issueType = (IssueType)typeOption.get();
        PropertyAssertions.assertWebApplicationException(() -> {
            this.issueTypeClient.post(new IssueTypeCreateBean(issueType.name, DESCRIPTION, IssueTypeCreateBean.Type.standard));
            return null;
        }, Response.Status.CONFLICT);
    }

    @Test
    public void testCreateSubTaskSuccessful() {
        IssueTypeCreateBean subTask = new IssueTypeCreateBean(NAME, DESCRIPTION, IssueTypeCreateBean.Type.subtask);
        IssueType issueType = this.issueTypeClient.post(subTask);
        this.assertIssueTypeMatchesJsonBean(issueType, subTask, true);
        this.assertIssueTypeWithPropertiesExists(subTask.getName(), subTask.getDescription(), true);
    }

    @Test
    public void testCreateSubTaskWhenSubTasksDisabled() {
        this.backdoor.applicationProperties().setOption("jira.option.allowsubtasks", false);
        PropertyAssertions.assertWebApplicationException(() -> {
            this.issueTypeClient.post(new IssueTypeCreateBean(NAME, DESCRIPTION, IssueTypeCreateBean.Type.subtask));
            return null;
        }, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testCreateIssueTypeWithTooLongName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            stringBuilder.append("n");
        }
        PropertyAssertions.assertWebApplicationException(() -> {
            this.issueTypeClient.post(new IssueTypeCreateBean(stringBuilder.toString(), DESCRIPTION, IssueTypeCreateBean.Type.standard));
            return null;
        }, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testCreateIssueTypeWithoutDescription() {
        IssueTypeCreateBean issueTypeCreateBean = new IssueTypeCreateBean(NAME, null, IssueTypeCreateBean.Type.standard);
        IssueType issueType = this.issueTypeClient.post(issueTypeCreateBean);
        ((ObjectAssert)Assertions.assertThat((Object)issueType).overridingErrorMessage("Issue type does not match", new Object[0])).usingRecursiveComparison().comparingOnlyFields(new String[]{NAME}).isEqualTo((Object)issueTypeCreateBean);
        Assertions.assertThat((boolean)issueType.subtask).isFalse();
        this.assertIssueTypeWithPropertiesExists(issueTypeCreateBean.getName(), EMPTY_STRING, false);
    }

    @Test
    public void testIssueTypeIsStandardByDefault() {
        IssueTypeCreateBean issueTypeCreateBean = new IssueTypeCreateBean(NAME, DESCRIPTION, null);
        IssueType issueType = this.issueTypeClient.post(issueTypeCreateBean);
        Assertions.assertThat((boolean)issueType.subtask).isFalse();
    }

    @Test
    public void testIssueTypeHasDefaultAvatarAfterCreation() {
        IssueType issueType = this.issueTypeClient.post(this.getIssueTypeCreateBean());
        String defaultIssueTypeAvatarId = this.backdoor.applicationProperties().getString("jira.avatar.issuetype.default.id");
        Assertions.assertThat((String)issueType.iconUrl).contains(new CharSequence[]{defaultIssueTypeAvatarId});
    }

    @Test
    public void testSubTaskHasDefaultAvatarAfterCreation() {
        IssueType issueType = this.issueTypeClient.post(new IssueTypeCreateBean(NAME, DESCRIPTION, IssueTypeCreateBean.Type.subtask));
        String subTaskAvatarId = this.backdoor.applicationProperties().getString("jira.avatar.issuetype.subtask.default.id");
        Assertions.assertThat((String)issueType.iconUrl).contains(new CharSequence[]{subTaskAvatarId});
    }

    @Test
    public void testDeleteIssueTypeWithoutProvidingAlternative() {
        IssueType issueType = this.issueTypeClient.get("1");
        Assertions.assertThat((String)issueType.name).isEqualTo("Bug");
        SearchResult searchResult = this.backdoor.search().getSearch(new SearchRequest().jql("issuetype = Bug"));
        ((ListAssert)Assertions.assertThat((List)searchResult.issues).overridingErrorMessage("There are issues with issuetype = Bug which requires passing alternative id", new Object[0])).isEmpty();
        this.issueTypeClient.delete("1", Option.none(String.class));
        Assertions.assertThat((List)this.issueTypeClient.get()).extracting(NAME).doesNotContain(new Object[]{"Bug"});
    }

    @Test
    public void testDeleteIssueTypeWithAlternative() {
        IssueType issueType = this.issueTypeClient.get("1");
        Assertions.assertThat((String)issueType.name).isEqualTo("Bug");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", NEW_BUG);
        Assertions.assertThat((String)this.issueClient.get((String)issue.key, (Issue.Expand[])new Issue.Expand[0]).fields.issuetype.name).isEqualTo("Bug");
        List alternatives = this.issueTypeClient.getAlternatives("1");
        Assertions.assertThat((List)alternatives).isNotEmpty();
        IssueType alternative = (IssueType)Iterables.first((Iterable)alternatives).get();
        this.issueTypeClient.delete("1", Option.some((Object)alternative.id));
        Assertions.assertThat((String)this.issueClient.get((String)issue.key, (Issue.Expand[])new Issue.Expand[0]).fields.issuetype.name).isEqualTo(alternative.name);
        Assertions.assertThat((List)this.issueTypeClient.get()).extracting(NAME).doesNotContain(new Object[]{"Bug"});
    }

    @Test
    public void testDeleteIssueWithInvalidAlternative() {
        IssueType issueType = this.issueTypeClient.get("1");
        Assertions.assertThat((String)issueType.name).isEqualTo("Bug");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", NEW_BUG);
        Assertions.assertThat((String)this.issueClient.get((String)issue.key, (Issue.Expand[])new Issue.Expand[0]).fields.issuetype.name).isEqualTo("Bug");
        IssueType subtask = this.issueTypeClient.post(new IssueTypeCreateBean(SUBTASK, DESCRIPTION, IssueTypeCreateBean.Type.subtask));
        Assertions.assertThat((int)this.issueTypeClient.delete((String)issueType.id, (Option)Option.some((Object)subtask.id)).statusCode).isEqualTo(Response.Status.CONFLICT.getStatusCode());
    }

    @Test
    public void testDeleteIssueWithSelfAsAlternative() {
        IssueType issueType = this.issueTypeClient.get("1");
        Assertions.assertThat((String)issueType.name).isEqualTo("Bug");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", NEW_BUG);
        Assertions.assertThat((String)this.issueClient.get((String)issue.key, (Issue.Expand[])new Issue.Expand[0]).fields.issuetype.name).isEqualTo("Bug");
        Assertions.assertThat((int)this.issueTypeClient.delete((String)issueType.id, (Option)Option.some((Object)issueType.id)).statusCode).isEqualTo(Response.Status.CONFLICT.getStatusCode());
    }

    @Test
    public void testDeleteIssueTypeWithInvalidUser() {
        Assertions.assertThat((int)((IssueTypeClient)this.issueTypeClient.loginAs((String)"fred")).delete((String)"1", (Option)Option.none(String.class)).statusCode).isEqualTo(Response.Status.FORBIDDEN.getStatusCode());
    }

    @Test
    public void testDeleteIssueTypeWithAnonymousUser() {
        Assertions.assertThat((int)((IssueTypeClient)this.issueTypeClient.anonymous()).delete((String)"1", (Option)Option.none(String.class)).statusCode).isEqualTo(Response.Status.UNAUTHORIZED.getStatusCode());
    }

    @Test
    public void testDeleteIssueTypeWithAssociatedIssuesWithoutAlternative() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "some bug");
        Assertions.assertThat((String)this.issueClient.get((String)issue.key, (Issue.Expand[])new Issue.Expand[0]).fields.issuetype.name).isEqualTo("Bug");
        List alternatives = this.issueTypeClient.getAlternatives("1");
        for (IssueType alternative : alternatives) {
            this.issueTypeClient.delete(alternative.id, Option.none());
        }
        ParsedResponse response = this.issueTypeClient.delete("1", Option.none());
        Assertions.assertThat((int)response.statusCode).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void testDeleteNotExistingIssueType() {
        Assertions.assertThat((int)this.issueTypeClient.delete((String)"150", (Option)Option.none()).statusCode).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void testUpdatingIssueTypeName() {
        IssueTypeUpdateBean newBug = new IssueTypeUpdateBean(NEW_BUG, "new bug description", null);
        IssueType updatedIssueType = this.issueTypeClient.update("1", newBug);
        this.assertIssueTypeMatchesJsonBean(updatedIssueType, newBug);
        this.assertIssueTypeWithPropertiesExists(newBug.getName(), newBug.getDescription(), false);
    }

    @Test
    public void testUpdateIssueTypeDescriptionWithKeepingOldName() {
        IssueTypeUpdateBean bug = new IssueTypeUpdateBean("Bug", "new bug description", null);
        IssueType issueType = this.issueTypeClient.update("1", bug);
        this.assertIssueTypeMatchesJsonBean(issueType, bug);
        this.assertIssueTypeWithPropertiesExists(bug.getName(), bug.getDescription(), false);
    }

    @Test
    public void testUpdateAvatarId() {
        IssueType newIssueType = this.issueTypeClient.post(new IssueTypeCreateBean("new issue type", DESCRIPTION, IssueTypeCreateBean.Type.standard));
        IssueType update = this.issueTypeClient.update("1", new IssueTypeUpdateBean(null, null, newIssueType.avatarId));
        Assertions.assertThat((Long)update.avatarId).isEqualTo((Object)newIssueType.avatarId);
        Assertions.assertThat((String)update.name).isEqualTo("Bug");
    }

    @Test
    public void testCantChangeNameToTheExistingOne() {
        PropertyAssertions.assertWebApplicationException(() -> {
            this.issueTypeClient.update("2", new IssueTypeUpdateBean("Bug", "bug", null));
            return null;
        }, Response.Status.CONFLICT);
    }

    @Test
    public void testCantUpdateWithAnonymousUser() {
        PropertyAssertions.assertWebApplicationException(() -> {
            ((IssueTypeClient)this.issueTypeClient.anonymous()).update("1", new IssueTypeUpdateBean(NAME, NAME, null));
            return null;
        }, Response.Status.UNAUTHORIZED);
    }

    @Test
    public void testCantUpdateWithUserWithoutAdminRight() {
        PropertyAssertions.assertWebApplicationException(() -> {
            ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).update("1", new IssueTypeUpdateBean(NAME, NAME, null));
            return null;
        }, Response.Status.FORBIDDEN);
    }

    @Test
    public void testCantSetAvatarToNonExistingOne() {
        PropertyAssertions.assertWebApplicationException(() -> {
            this.issueTypeClient.update("1", new IssueTypeUpdateBean(null, null, Long.valueOf(100L)));
            return null;
        }, Response.Status.BAD_REQUEST);
    }

    @Test
    @Restore(value="TestIssueTypeResource.xml")
    public void testGetFilteredIssueTypes() {
        this.backdoor.issueType().createIssueType(SUPER_FEATURE);
        String query = "Feat";
        int maxResults = 5;
        long startAt = 0L;
        PageBean page = this.issueTypeClient.getPage(Long.valueOf(0L), Integer.valueOf(5), "Feat", Collections.emptySet());
        Assertions.assertThat((int)page.getMaxResults()).isEqualTo(5);
        Assertions.assertThat((long)page.getTotal()).isEqualTo(2L);
        Assertions.assertThat((Boolean)page.getIsLast()).isTrue();
        ((ListAssert)Assertions.assertThat((List)page.getValues()).hasSize(2)).extracting(NAME).containsExactly(new Object[]{"New Feature", SUPER_FEATURE});
    }

    @Test
    @Restore(value="TestIssueTypeResource.xml")
    public void testGetFilteredIssueTypesWheProjectIdsNotEmpty() {
        this.backdoor.issueType().createIssueType(SUPER_FEATURE);
        Long projectId = this.backdoor.project().getProjectId("MKY");
        String query = "Feat";
        int maxResults = 5;
        long startAt = 0L;
        PageBean page = this.issueTypeClient.getPage(Long.valueOf(0L), Integer.valueOf(5), "Feat", Collections.singleton(String.valueOf(projectId)));
        Assertions.assertThat((int)page.getMaxResults()).isEqualTo(5);
        Assertions.assertThat((long)page.getTotal()).isEqualTo(2L);
        Assertions.assertThat((Boolean)page.getIsLast()).isTrue();
        ((ListAssert)Assertions.assertThat((List)page.getValues()).hasSize(2)).extracting(NAME).containsExactly(new Object[]{"New Feature", SUPER_FEATURE});
    }

    @Test
    public void testGetIssueTypesWithEmptyQuery() {
        int maxResults = 5;
        long startAt = 0L;
        PageBean page = this.issueTypeClient.getPage(Long.valueOf(0L), Integer.valueOf(5), EMPTY_STRING, Collections.emptySet());
        Assertions.assertThat((int)page.getMaxResults()).isEqualTo(5);
        Assertions.assertThat((long)page.getTotal()).isEqualTo(4L);
        Assertions.assertThat((Boolean)page.getIsLast()).isTrue();
        ((ListAssert)Assertions.assertThat((List)page.getValues()).hasSize(4)).extracting(NAME).containsExactly(new Object[]{"Bug", "Improvement", "New Feature", "Task"});
    }

    @Test
    public void testGetSecondPage() {
        int maxResults = 2;
        long startAt = 1L;
        PageBean page = this.issueTypeClient.getPage(Long.valueOf(1L), Integer.valueOf(2), EMPTY_STRING, Collections.emptySet());
        Assertions.assertThat((int)page.getMaxResults()).isEqualTo(2);
        Assertions.assertThat((long)page.getTotal()).isEqualTo(4L);
        Assertions.assertThat((Boolean)page.getIsLast()).isFalse();
        ((ListAssert)Assertions.assertThat((List)page.getValues()).hasSize(2)).extracting(NAME).containsExactly(new Object[]{"Improvement", "New Feature"});
    }

    private IssueTypeCreateBean getIssueTypeCreateBean() {
        return new IssueTypeCreateBean(NAME, DESCRIPTION, IssueTypeCreateBean.Type.standard);
    }

    private void assertIssueTypeMatchesJsonBean(IssueType issueType, Object jsonBean) {
        ((ObjectAssert)Assertions.assertThat((Object)issueType).overridingErrorMessage("Issue type does not match", new Object[0])).usingRecursiveComparison().comparingOnlyFields(new String[]{NAME, DESCRIPTION}).isEqualTo(jsonBean);
    }

    private void assertIssueTypeMatchesJsonBean(IssueType issueType, Object jsonBean, boolean isSubtask) {
        this.assertIssueTypeMatchesJsonBean(issueType, jsonBean);
        Assertions.assertThat((boolean)issueType.subtask).isEqualTo(isSubtask);
    }

    private void assertIssueTypeWithPropertiesExists(String name, String description, boolean isSubtask) {
        Assertions.assertThat((List)this.issueTypeClient.get()).extracting(new String[]{NAME, DESCRIPTION, SUBTASK}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{name, description, isSubtask})});
    }

    private void assertIssueTypesContain(List<IssueType> issueTypes, String ... ids) {
        Assertions.assertThat(issueTypes).extracting("id").contains((Object[])ids);
    }
}

