/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeSchemeCreateUpdateBean;
import com.atlassian.jira.rest.v2.issue.IssueTypeSchemeBean;
import com.atlassian.jira.rest.v2.issue.IssueTypeSchemeListBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueTypeSchemeClient;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestIssueTypeSchemesRest.xml")
public class TestIssueTypeSchemeResource
extends BaseJiraRestTest {
    private IssueTypeSchemeClient issueTypeSchemeClient;
    static final long ALL_SCRUM_TYPES_SCHEME = 10204L;
    static final long ALL_TYPES_BUT_NO_DEFAULT_SCHEME = 10205L;
    static final long DEFAULT_SCHEME_ID = 10000L;
    static final long NO_BUGS_SCHEME = 10300L;
    static final long TASKS_AND_BUGS_SCHEME = 10202L;
    static final long TASKS_BUGS_AND_SUBTASKS_SCHEME = 10203L;
    static final long TASKS_ONLY_SCHEME = 10201L;
    static final long BUG = 10102L;
    static final long EPIC = 10000L;
    static final long FEATURE = 10104L;
    static final long IMPROVEMENT = 10103L;
    static final long STORY = 10001L;
    static final long TASK = 10100L;
    static final long TSKS_PROJECT_ID = 10000L;
    static final long TSKSBUGS_PROJECT_ID = 10001L;

    @Before
    public void setUpTest() {
        this.issueTypeSchemeClient = new IssueTypeSchemeClient(this.environmentData);
    }

    @Test
    public void testThatAnonymousUsersAreDisallowed() {
        List<Supplier> anonymousAttempts = Arrays.asList(() -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.anonymous()).createIssueTypeScheme(new IssueTypeSchemeCreateUpdateBean()), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.anonymous()).getAllIssueTypeSchemes(), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.anonymous()).getIssueTypeScheme(10204L), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.anonymous()).updateIssueTypeScheme(10201L, new IssueTypeSchemeCreateUpdateBean()), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.anonymous()).deleteIssueTypeScheme(10201L), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.anonymous()).addProjectAssociatonsToScheme(10204L, Long.toString(10001L)), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.anonymous()).getProjectsAssociatedWithIssueTypeScheme(10201L), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.anonymous()).setProjectAssociatonsForScheme(10202L, "TSKS", "TASKS2"), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.anonymous()).unassignProjectFromScheme(10201L, Long.toString(10000L)), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.anonymous()).getProjectsAssociatedWithIssueTypeScheme(10201L));
        anonymousAttempts.forEach(aa -> Assert.assertEquals((long)401L, (long)((ParsedResponse)aa.get()).statusCode));
    }

    public void testThatNonAdminUsersAreDisallowed() {
        this.backdoor.usersAndGroups().addUser("non-admin-user");
        List<Supplier> nonAdminAttempts = Arrays.asList(() -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.loginAs("non-admin-user")).createIssueTypeScheme(new IssueTypeSchemeCreateUpdateBean()), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.loginAs("non-admin-user")).getAllIssueTypeSchemes(), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.loginAs("non-admin-user")).getIssueTypeScheme(10204L), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.loginAs("non-admin-user")).updateIssueTypeScheme(10201L, new IssueTypeSchemeCreateUpdateBean()), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.loginAs("non-admin-user")).deleteIssueTypeScheme(10201L), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.loginAs("non-admin-user")).addProjectAssociatonsToScheme(10204L, Long.toString(10001L)), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.loginAs("non-admin-user")).getProjectsAssociatedWithIssueTypeScheme(10201L), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.loginAs("non-admin-user")).setProjectAssociatonsForScheme(10202L, "TSKS", "TASKS2"), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.loginAs("non-admin-user")).unassignProjectFromScheme(10201L, Long.toString(10000L)), () -> ((IssueTypeSchemeClient)this.issueTypeSchemeClient.loginAs("non-admin-user")).getProjectsAssociatedWithIssueTypeScheme(10201L));
        nonAdminAttempts.forEach(att -> Assert.assertEquals((long)403L, (long)((ParsedResponse)att.get()).statusCode));
    }

    @Test
    public void testGetAllIssueTypeSchemes() {
        List schemes = ((IssueTypeSchemeListBean)this.issueTypeSchemeClient.getAllIssueTypeSchemes().body).getSchemes();
        Assert.assertEquals((long)7L, (long)schemes.size());
        HashSet expected = Sets.newHashSet((Object[])new String[]{"Default Issue Type Scheme", "Tasks Only Scheme", "Only Tasks And Bugs Scheme", "Tasks Bugs And Subtasks Scheme", "All Scrum Types Scheme", "All Types But No Default Scheme", "No Bugs Scheme"});
        Assert.assertEquals((Object)expected, Sets.newHashSet((Iterable)schemes).stream().map(its -> its.getName()).collect(Collectors.toSet()));
    }

    @Test
    public void testGetIssueTypeScheme() {
        IssueTypeSchemeBean scheme = (IssueTypeSchemeBean)this.issueTypeSchemeClient.getIssueTypeScheme((long)10204L).body;
        Assert.assertEquals((Object)"All Scrum Types Scheme", (Object)scheme.getName());
        IssueTypeJsonBean defType = scheme.getDefaultIssueType();
        Assert.assertEquals((Object)"Story", (Object)defType.getName());
        Assert.assertEquals((Object)"10001", (Object)defType.getId());
        Assert.assertEquals((Object)"the lot of them", (Object)scheme.getDescription());
        List types = scheme.getIssueTypes();
        ArrayList expected = Lists.newArrayList((Object[])new String[]{"Task", "Sub-task", "Story", "Bug", "Epic"});
        Assert.assertEquals((Object)expected, types.stream().map(t -> t.getName()).collect(Collectors.toList()));
        Assert.assertEquals((Object)defType, types.get(2));
    }

    @Test
    public void testGetIssueTypeSchemeWithoutDefault() {
        IssueTypeSchemeBean scheme = (IssueTypeSchemeBean)this.issueTypeSchemeClient.getIssueTypeScheme((long)10205L).body;
        Assert.assertEquals((Object)"All Types But No Default Scheme", (Object)scheme.getName());
        Assert.assertNull((Object)scheme.getDefaultIssueType());
        Assert.assertEquals((Object)"Default Issue Type Isn't Specified/ None", (Object)scheme.getDescription());
        ArrayList expected = Lists.newArrayList((Object[])new String[]{"Task", "Sub-task", "Story", "Bug", "Epic", "Improvement", "New Feature"});
        Assert.assertEquals((Object)expected, scheme.getIssueTypes().stream().map(t -> t.getName()).collect(Collectors.toList()));
    }

    @Test
    public void testGetIssueTypeScheme_UnhappyPaths() {
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.getIssueTypeScheme((long)99L).statusCode);
    }

    @Test
    public void testGetAssociatedProjects() {
        List projects = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10201L).body;
        HashSet expected = Sets.newHashSet((Object[])new String[]{"TasksProject", "TasksProject2"});
        Assert.assertEquals((Object)expected, (Object)Sets.newHashSet((Iterable)projects.stream().map(p -> p.name).collect(Collectors.toSet())));
        List oneProj = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10202L).body;
        Assert.assertEquals((Object)"TasksBugs", (Object)((Project)Iterables.getOnlyElement((Iterable)oneProj)).name);
        List noProjects = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10203L).body;
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)noProjects));
    }

    @Test
    public void testGetAssociatedProjects_UnhappyPaths() {
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)999L).statusCode);
    }

    @Test
    public void testCreateIssueTypeScheme() {
        Assert.assertEquals((long)7L, (long)Iterables.size((Iterable)((IssueTypeSchemeListBean)this.issueTypeSchemeClient.getAllIssueTypeSchemes().body).getSchemes()));
        IssueTypeSchemeCreateUpdateBean createBean = new IssueTypeSchemeCreateUpdateBean();
        createBean.setName("foo name");
        createBean.setDescription("some description");
        createBean.setIssueTypeIDs(Arrays.asList(Long.toString(10100L), Long.toString(10001L), Long.toString(10102L)));
        createBean.setDefaultIssueTypeId("10102");
        IssueTypeSchemeBean newITS = (IssueTypeSchemeBean)this.issueTypeSchemeClient.createIssueTypeScheme((IssueTypeSchemeCreateUpdateBean)createBean).body;
        Assert.assertEquals((Object)"foo name", (Object)newITS.getName());
        Assert.assertEquals((Object)"some description", (Object)newITS.getDescription());
        Assert.assertEquals((Object)Long.toString(10102L), (Object)newITS.getDefaultIssueType().getId());
        Assert.assertEquals((Object)"Bug", (Object)newITS.getDefaultIssueType().getName());
        Assert.assertEquals(Arrays.asList(Long.toString(10100L), Long.toString(10001L), Long.toString(10102L)), newITS.getIssueTypes().stream().map(it -> it.getId()).collect(Collectors.toList()));
        Assert.assertEquals((long)8L, (long)Iterables.size((Iterable)((IssueTypeSchemeListBean)this.issueTypeSchemeClient.getAllIssueTypeSchemes().body).getSchemes()));
        IssueTypeSchemeBean latestAddition = (IssueTypeSchemeBean)this.issueTypeSchemeClient.getIssueTypeScheme((long)Long.parseLong((String)newITS.getId())).body;
        Assert.assertEquals((Object)newITS, (Object)latestAddition);
    }

    @Test
    public void testCreateIssueTypeSchemeWithNoDefaultType() {
        Assert.assertEquals((long)7L, (long)Iterables.size((Iterable)((IssueTypeSchemeListBean)this.issueTypeSchemeClient.getAllIssueTypeSchemes().body).getSchemes()));
        IssueTypeSchemeCreateUpdateBean createBean = new IssueTypeSchemeCreateUpdateBean();
        createBean.setName("foo name");
        createBean.setDescription("some description");
        createBean.setIssueTypeIDs(Arrays.asList(Long.toString(10100L), Long.toString(10001L), Long.toString(10102L)));
        IssueTypeSchemeBean newITS = (IssueTypeSchemeBean)this.issueTypeSchemeClient.createIssueTypeScheme((IssueTypeSchemeCreateUpdateBean)createBean).body;
        Assert.assertEquals((Object)"foo name", (Object)newITS.getName());
        Assert.assertEquals((Object)"some description", (Object)newITS.getDescription());
        Assert.assertEquals(null, (Object)newITS.getDefaultIssueType());
        Assert.assertEquals(Arrays.asList(Long.toString(10100L), Long.toString(10001L), Long.toString(10102L)), newITS.getIssueTypes().stream().map(it -> it.getId()).collect(Collectors.toList()));
        Assert.assertEquals((long)8L, (long)Iterables.size((Iterable)((IssueTypeSchemeListBean)this.issueTypeSchemeClient.getAllIssueTypeSchemes().body).getSchemes()));
        IssueTypeSchemeBean latestAddition = (IssueTypeSchemeBean)this.issueTypeSchemeClient.getIssueTypeScheme((long)Long.parseLong((String)newITS.getId())).body;
        Assert.assertEquals((Object)newITS, (Object)latestAddition);
    }

    @Test
    public void testCreateIssueTypeScheme_UnhappyPaths() {
        IssueTypeSchemeCreateUpdateBean badIsssues = new IssueTypeSchemeCreateUpdateBean();
        badIsssues.setName("foo name");
        badIsssues.setDescription("some description");
        badIsssues.setIssueTypeIDs(Arrays.asList("23456", Long.toString(10100L)));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.createIssueTypeScheme((IssueTypeSchemeCreateUpdateBean)badIsssues).statusCode);
        IssueTypeSchemeCreateUpdateBean missingIssues = new IssueTypeSchemeCreateUpdateBean();
        missingIssues.setName("foo name");
        missingIssues.setDescription("some description");
        missingIssues.setIssueTypeIDs(Collections.emptyList());
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.createIssueTypeScheme((IssueTypeSchemeCreateUpdateBean)missingIssues).statusCode);
        IssueTypeSchemeCreateUpdateBean invalidDefault = new IssueTypeSchemeCreateUpdateBean();
        invalidDefault.setName("foo name");
        invalidDefault.setDescription("some description");
        invalidDefault.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10100L)));
        invalidDefault.setDefaultIssueTypeId(Long.toString(10102L));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.createIssueTypeScheme((IssueTypeSchemeCreateUpdateBean)invalidDefault).statusCode);
        IssueTypeSchemeCreateUpdateBean nullName = new IssueTypeSchemeCreateUpdateBean();
        nullName.setName(null);
        nullName.setDescription("some description");
        nullName.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10100L)));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.createIssueTypeScheme((IssueTypeSchemeCreateUpdateBean)nullName).statusCode);
        IssueTypeSchemeCreateUpdateBean emptyName = new IssueTypeSchemeCreateUpdateBean();
        emptyName.setName("");
        emptyName.setDescription("some description");
        emptyName.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10100L)));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.createIssueTypeScheme((IssueTypeSchemeCreateUpdateBean)emptyName).statusCode);
        IssueTypeSchemeCreateUpdateBean existingName = new IssueTypeSchemeCreateUpdateBean();
        existingName.setName("No Bugs Scheme");
        existingName.setDescription("some description");
        existingName.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10100L)));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.createIssueTypeScheme((IssueTypeSchemeCreateUpdateBean)existingName).statusCode);
    }

    @Test
    public void testDeleteIssueTypeScheme() {
        Assert.assertEquals((long)7L, (long)((IssueTypeSchemeListBean)this.issueTypeSchemeClient.getAllIssueTypeSchemes().body).getSchemes().size());
        Assert.assertEquals((long)204L, (long)this.issueTypeSchemeClient.deleteIssueTypeScheme((long)10201L).statusCode);
        List remaining = ((IssueTypeSchemeListBean)this.issueTypeSchemeClient.getAllIssueTypeSchemes().body).getSchemes();
        Assert.assertEquals((long)6L, (long)remaining.size());
        Assert.assertEquals((long)0L, (long)remaining.stream().filter(its -> its.getName().equals("Tasks Only Scheme")).count());
    }

    @Test
    public void testDeleteIssueTypeScheme_UnhappyPaths() {
        Assert.assertEquals((long)403L, (long)this.issueTypeSchemeClient.deleteIssueTypeScheme((long)10000L).statusCode);
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.deleteIssueTypeScheme((long)999L).statusCode);
    }

    @Test
    public void testUpdateIssueTypeSchemeWithNoProjects() {
        IssueTypeSchemeCreateUpdateBean updateBean = new IssueTypeSchemeCreateUpdateBean();
        updateBean.setName("New Name");
        updateBean.setDescription("New Description");
        updateBean.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10000L)));
        IssueTypeSchemeBean updated = (IssueTypeSchemeBean)this.issueTypeSchemeClient.updateIssueTypeScheme((long)10300L, (IssueTypeSchemeCreateUpdateBean)updateBean).body;
        Assert.assertEquals((Object)Long.toString(10300L), (Object)updated.getId());
        Assert.assertEquals((Object)"New Name", (Object)updated.getName());
        Assert.assertEquals((Object)"New Description", (Object)updated.getDescription());
        Assert.assertNull((Object)updated.getDefaultIssueType());
        Assert.assertEquals(Arrays.asList(Long.toString(10001L), Long.toString(10000L)), updated.getIssueTypes().stream().map(it -> it.getId()).collect(Collectors.toList()));
        Assert.assertEquals((Object)updated, (Object)this.issueTypeSchemeClient.getIssueTypeScheme((long)10300L).body);
    }

    @Test
    public void testUpdateIssueTypeSchemeAndKeepNameTheSame() {
        IssueTypeSchemeCreateUpdateBean updateBean = new IssueTypeSchemeCreateUpdateBean();
        updateBean.setName("No Bugs Scheme");
        updateBean.setDescription("New Description");
        updateBean.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10000L)));
        IssueTypeSchemeBean updated = (IssueTypeSchemeBean)this.issueTypeSchemeClient.updateIssueTypeScheme((long)10300L, (IssueTypeSchemeCreateUpdateBean)updateBean).body;
        Assert.assertEquals((Object)Long.toString(10300L), (Object)updated.getId());
        Assert.assertEquals((Object)"No Bugs Scheme", (Object)updated.getName());
        Assert.assertEquals((Object)"New Description", (Object)updated.getDescription());
        Assert.assertNull((Object)updated.getDefaultIssueType());
        Assert.assertEquals(Arrays.asList(Long.toString(10001L), Long.toString(10000L)), updated.getIssueTypes().stream().map(it -> it.getId()).collect(Collectors.toList()));
        Assert.assertEquals((Object)updated, (Object)this.issueTypeSchemeClient.getIssueTypeScheme((long)10300L).body);
    }

    @Test
    public void testUpdateIssueTypeSchemeNoMigration() {
        Assert.assertEquals((long)1L, (long)((List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10205L).body).size());
        IssueTypeSchemeCreateUpdateBean updateBean = new IssueTypeSchemeCreateUpdateBean();
        updateBean.setName("New Name");
        updateBean.setDescription("New Description");
        updateBean.setIssueTypeIDs(Arrays.asList(Long.toString(10100L), Long.toString(10001L), Long.toString(10000L), Long.toString(10103L), Long.toString(10104L)));
        IssueTypeSchemeBean updated = (IssueTypeSchemeBean)this.issueTypeSchemeClient.updateIssueTypeScheme((long)10205L, (IssueTypeSchemeCreateUpdateBean)updateBean).body;
        Assert.assertEquals((Object)Long.toString(10205L), (Object)updated.getId());
        Assert.assertEquals((Object)"New Name", (Object)updated.getName());
        Assert.assertEquals((Object)"New Description", (Object)updated.getDescription());
        Assert.assertNull((Object)updated.getDefaultIssueType());
        Assert.assertEquals(Arrays.asList(10100L, 10001L, 10000L, 10103L, 10104L), updated.getIssueTypes().stream().map(it -> Long.parseLong(it.getId())).collect(Collectors.toList()));
        Assert.assertEquals((Object)updated, (Object)this.issueTypeSchemeClient.getIssueTypeScheme((long)10205L).body);
    }

    @Test
    public void testUpdateIssueTypeScheme_UnhappyPaths() {
        IssueTypeSchemeCreateUpdateBean updateBean = new IssueTypeSchemeCreateUpdateBean();
        updateBean.setName("New Name");
        updateBean.setDescription("New Description");
        updateBean.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10000L)));
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.updateIssueTypeScheme((long)777L, (IssueTypeSchemeCreateUpdateBean)updateBean).statusCode);
        IssueTypeSchemeCreateUpdateBean noTypes = new IssueTypeSchemeCreateUpdateBean();
        noTypes.setName("New Name");
        noTypes.setDescription("New Description");
        noTypes.setIssueTypeIDs(Collections.emptyList());
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.updateIssueTypeScheme((long)10201L, (IssueTypeSchemeCreateUpdateBean)noTypes).statusCode);
        IssueTypeSchemeCreateUpdateBean badTypes = new IssueTypeSchemeCreateUpdateBean();
        badTypes.setName("New Name");
        badTypes.setDescription("New Description");
        badTypes.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), "999"));
        badTypes.setDefaultIssueTypeId(Long.toString(10001L));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.updateIssueTypeScheme((long)10201L, (IssueTypeSchemeCreateUpdateBean)badTypes).statusCode);
        IssueTypeSchemeCreateUpdateBean invalidDefault = new IssueTypeSchemeCreateUpdateBean();
        invalidDefault.setName("New Name");
        invalidDefault.setDescription("New Description");
        invalidDefault.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10000L)));
        invalidDefault.setDefaultIssueTypeId(Long.toString(10100L));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.updateIssueTypeScheme((long)10201L, (IssueTypeSchemeCreateUpdateBean)invalidDefault).statusCode);
        IssueTypeSchemeCreateUpdateBean nullName = new IssueTypeSchemeCreateUpdateBean();
        nullName.setName(null);
        nullName.setDescription("New Description");
        nullName.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10000L)));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.updateIssueTypeScheme((long)10201L, (IssueTypeSchemeCreateUpdateBean)nullName).statusCode);
        IssueTypeSchemeCreateUpdateBean emptyName = new IssueTypeSchemeCreateUpdateBean();
        emptyName.setName("");
        emptyName.setDescription("New Description");
        emptyName.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10000L)));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.updateIssueTypeScheme((long)10201L, (IssueTypeSchemeCreateUpdateBean)emptyName).statusCode);
        IssueTypeSchemeCreateUpdateBean nameInUse = new IssueTypeSchemeCreateUpdateBean();
        nameInUse.setName("No Bugs Scheme");
        nameInUse.setDescription("New Description");
        nameInUse.setIssueTypeIDs(Arrays.asList(Long.toString(10001L), Long.toString(10000L)));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.updateIssueTypeScheme((long)10201L, (IssueTypeSchemeCreateUpdateBean)nameInUse).statusCode);
        IssueTypeSchemeCreateUpdateBean migrationReqd = new IssueTypeSchemeCreateUpdateBean();
        migrationReqd.setName("some namme");
        migrationReqd.setDescription("some description");
        migrationReqd.setDefaultIssueTypeId(Long.toString(10100L));
        migrationReqd.setIssueTypeIDs(Arrays.asList(Long.toString(10100L)));
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.updateIssueTypeScheme((long)10202L, (IssueTypeSchemeCreateUpdateBean)migrationReqd).statusCode);
    }

    @Test
    public void testAddProjectAssociationsToScheme() {
        List initialProjects = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10204L).body;
        Project onlyProj = (Project)Iterables.getOnlyElement((Iterable)initialProjects);
        Assert.assertEquals((Object)"AllScrumTypesProject", (Object)onlyProj.name);
        Assert.assertEquals((Object)"ALLSCRUMTP", (Object)onlyProj.key);
        int statusCode = this.issueTypeSchemeClient.addProjectAssociatonsToScheme((long)10204L, (String[])new String[]{"TSKS", "TASKS2"}).statusCode;
        System.out.println("####statusCode:" + statusCode);
        List updatedProjects = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10204L).body;
        Assert.assertEquals((String)"Couldn't find the newly associated projects", (long)3L, (long)Iterables.size((Iterable)updatedProjects));
        Assert.assertEquals((String)"Couldn't find the newly associated projects", (long)2L, (long)Lists.newArrayList((Iterable)updatedProjects).stream().filter(p -> "TasksProject".equals(p.name) || "TasksProject2".equals(p.name)).count());
        this.issueTypeSchemeClient.addProjectAssociatonsToScheme(10204L, Long.toString(10001L));
        List newlyUpdatedProjects = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10204L).body;
        Assert.assertEquals((String)"Couldn't find the newly associated project", (long)4L, (long)Iterables.size((Iterable)newlyUpdatedProjects));
        Assert.assertEquals((String)"Couldn't find the newly associated project", (long)1L, (long)Lists.newArrayList((Iterable)newlyUpdatedProjects).stream().filter(p -> "TasksBugs".equals(p.name)).count());
    }

    @Test
    public void testAddProjectAssociationsToScheme_UnhappyPaths() {
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.addProjectAssociatonsToScheme((long)789L, (String[])new String[]{Long.toString((long)10001L)}).statusCode);
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.addProjectAssociatonsToScheme((long)10300L, (String[])new String[]{"TSKS", "GOJIRA"}).statusCode);
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.addProjectAssociatonsToScheme((long)10300L, (String[])new String[]{Long.toString((long)10000L), "989"}).statusCode);
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.addProjectAssociatonsToScheme((long)10202L, (String[])new String[]{"ALLSCRUMTP", "TSKS", "TASKS2"}).statusCode);
    }

    @Test
    public void testSetProjectAssociationsForScheme() {
        List initialProjects = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10202L).body;
        Project onlyProj = (Project)Iterables.getOnlyElement((Iterable)initialProjects);
        Assert.assertEquals((Object)"TasksBugs", (Object)onlyProj.name);
        this.issueTypeSchemeClient.setProjectAssociatonsForScheme(10202L, new String[0]);
        List emptyProjects = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10202L).body;
        Assert.assertEquals((String)"shouldn't have any projects associated at this point", (long)0L, (long)emptyProjects.size());
        this.issueTypeSchemeClient.setProjectAssociatonsForScheme(10202L, "TSKS", "TASKS2");
        List newlyUpdatedProjects = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10202L).body;
        Assert.assertEquals((String)"Couldn't find the newly associated projects", (long)2L, (long)Iterables.size((Iterable)newlyUpdatedProjects));
        Assert.assertEquals((String)"Couldn't find the newly associated projects by name", (long)2L, (long)Lists.newArrayList((Iterable)newlyUpdatedProjects).stream().filter(p -> "TasksProject".equals(p.name) || "TasksProject2".equals(p.name)).count());
        this.issueTypeSchemeClient.setProjectAssociatonsForScheme(10202L, Long.toString(10001L));
        List oneProjAgain = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10202L).body;
        Assert.assertEquals((String)"expected just one project", (long)1L, (long)Iterables.size((Iterable)oneProjAgain));
        Assert.assertEquals((String)"expected just the one project, 'TASKSBUGS'", (long)1L, (long)Lists.newArrayList((Iterable)oneProjAgain).stream().filter(p -> "TasksBugs".equals(p.name)).count());
    }

    @Test
    public void testSetProjectAssociationsToScheme_UnhappyPaths() {
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.setProjectAssociatonsForScheme((long)789L, (String[])new String[]{"TSKS", "TASKS2"}).statusCode);
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.setProjectAssociatonsForScheme((long)10300L, (String[])new String[]{"TSKS", "GOJIRA"}).statusCode);
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.setProjectAssociatonsForScheme((long)10300L, (String[])new String[]{Long.toString((long)10000L), "989"}).statusCode);
        Assert.assertEquals((long)400L, (long)this.issueTypeSchemeClient.setProjectAssociatonsForScheme((long)10202L, (String[])new String[]{"ALLSCRUMTP", "TSKS", "TASKS2"}).statusCode);
    }

    @Test
    public void testUnAssignProjectFromScheme() {
        Assert.assertEquals((long)2L, (long)((List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10201L).body).size());
        this.issueTypeSchemeClient.unassignProjectFromScheme(10201L, "TASKS2");
        List projects = (List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10201L).body;
        Assert.assertEquals((long)1L, (long)projects.size());
        Assert.assertEquals((Object)"TSKS", (Object)((Project)Iterables.getOnlyElement((Iterable)projects)).key);
        this.issueTypeSchemeClient.unassignProjectFromScheme(10201L, Long.toString(10000L));
        Assert.assertEquals((long)0L, (long)((List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10201L).body).size());
    }

    @Test
    public void testUnAssignProjectFromSchemeUnHappyPaths() {
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.unassignProjectFromScheme((long)798L, (String)"TASKS2").statusCode);
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.unassignProjectFromScheme((long)10201L, (String)Long.toString((long)10001L)).statusCode);
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.unassignProjectFromScheme((long)10201L, (String)"GOJIRA").statusCode);
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.unassignProjectFromScheme((long)10201L, (String)"789").statusCode);
        Assert.assertEquals((long)403L, (long)this.issueTypeSchemeClient.unassignProjectFromScheme((long)10000L, (String)"TASKS2").statusCode);
    }

    @Test
    public void testUnAssignAllProjectsFromScheme() {
        Assert.assertEquals((long)2L, (long)((List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10201L).body).size());
        this.issueTypeSchemeClient.unassignAllProjectsFromScheme(10201L);
        Assert.assertEquals((long)0L, (long)((List)this.issueTypeSchemeClient.getProjectsAssociatedWithIssueTypeScheme((long)10201L).body).size());
    }

    @Test
    public void testUnAssignAllProjectsFromSchemeUnHappyPaths() {
        Assert.assertEquals((long)404L, (long)this.issueTypeSchemeClient.unassignAllProjectsFromScheme((long)798L).statusCode);
        Assert.assertEquals((long)403L, (long)this.issueTypeSchemeClient.unassignAllProjectsFromScheme((long)10000L).statusCode);
    }
}

