/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.UserJson;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import com.atlassian.jira.testkit.client.restclient.WorklogWithPaginationBean;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.WORKLOGS})
public class TestIssueWorklogResource
extends BaseJiraRestTest {
    public static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String ISSUE_KEY = "HSP-1";
    private WorklogClient worklogClient;
    private IssueClient issueClient;

    @Test
    public void testViewWorklog() throws Exception {
        Worklog worklog = this.getDefaultWorklogFromJira();
        MatcherAssert.assertThat((Object)worklog, (Matcher)Matchers.equalTo((Object)this.getDefaultWorklog()));
    }

    @Test
    public void testViewWorklogNotFound() throws Exception {
        ParsedResponse response123 = this.worklogClient.getResponse(ISSUE_KEY, "123");
        Assert.assertEquals((long)404L, (long)response123.statusCode);
        Assert.assertEquals((long)1L, (long)response123.entity.errorMessages.size());
        Assert.assertEquals((Object)"Cannot find worklog with id: '123'.", response123.entity.errorMessages.get(0));
        ParsedResponse responseAbc = this.worklogClient.getResponse(ISSUE_KEY, "abc");
        Assert.assertEquals((long)404L, (long)responseAbc.statusCode);
        Assert.assertEquals((long)1L, (long)responseAbc.entity.errorMessages.size());
        Assert.assertEquals((Object)"Cannot find worklog with id: 'abc'.", responseAbc.entity.errorMessages.get(0));
    }

    @Test
    public void testViewAllWorklogs() throws Exception {
        WorklogWithPaginationBean response = this.worklogClient.getAll(ISSUE_KEY);
        Assert.assertEquals((Object)new Integer(0), (Object)response.startAt);
        Assert.assertEquals((Object)new Integer(1), (Object)response.maxResults);
        Assert.assertEquals((Object)new Integer(1), (Object)response.total);
        Assert.assertEquals((long)1L, (long)response.worklogs.size());
        Worklog worklog = (Worklog)response.worklogs.get(0);
        MatcherAssert.assertThat((Object)worklog, (Matcher)Matchers.equalTo((Object)this.getDefaultWorklog()));
    }

    @Test
    public void testAddWorklog() throws Exception {
        Date now = new Date();
        Worklog toAdd = new Worklog();
        toAdd.timeSpent = "1h";
        toAdd.started = TestIssueWorklogResource.asTimeString(now);
        toAdd.comment = "This is my comment";
        this.addWorkLog(toAdd, now);
    }

    @Test
    public void testAddWorklogUsingSeconds() throws Exception {
        Date now = new Date();
        Worklog toAdd = new Worklog();
        toAdd.timeSpentSeconds = 3600L;
        toAdd.started = TestIssueWorklogResource.asTimeString(now);
        toAdd.comment = "This is my comment";
        this.addWorkLog(toAdd, now);
    }

    private void addWorkLog(Worklog toAdd, Date now) {
        ParsedResponse response = this.worklogClient.post(ISSUE_KEY, toAdd);
        Assert.assertEquals((long)201L, (long)response.statusCode);
        Assert.assertNotNull((Object)response.body);
        Worklog worklog = (Worklog)response.body;
        String id = worklog.id;
        Assert.assertEquals((Object)this.getBaseUrlPlus("rest/api/2/issue/10000/worklog/" + id), (Object)worklog.self);
        Assert.assertEquals((Object)this.getBaseUrlPlus("rest/api/2/user?username=admin"), (Object)worklog.author.self);
        Assert.assertEquals((Object)"admin", (Object)worklog.author.name);
        Assert.assertEquals((Object)"Administrator", (Object)worklog.author.displayName);
        Assert.assertEquals((Object)this.getBaseUrlPlus("rest/api/2/user?username=admin"), (Object)worklog.updateAuthor.self);
        Assert.assertEquals((Object)"admin", (Object)worklog.updateAuthor.name);
        Assert.assertEquals((Object)"Administrator", (Object)worklog.updateAuthor.displayName);
        Assert.assertNotNull((Object)worklog.created);
        Assert.assertNotNull((Object)worklog.updated);
        this.assertEqualDateStrings(TestIssueWorklogResource.asTimeString(now), worklog.started);
        Assert.assertEquals((Object)"1h", (Object)worklog.timeSpent);
        Worklog response2 = this.worklogClient.get(ISSUE_KEY, worklog.id);
        Assert.assertTrue((boolean)worklog.equals((Object)response2));
        toAdd = new Worklog();
        toAdd.started = TestIssueWorklogResource.asTimeString(now);
        response = this.worklogClient.post(ISSUE_KEY, toAdd);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errors.size());
    }

    @Test
    public void testAddWorklogWhenRoleDoesntExist() {
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        worklog.visibility = new Visibility();
        worklog.visibility.type = "role";
        worklog.visibility.value = "not-existing-role";
        ParsedResponse post = this.worklogClient.post(ISSUE_KEY, worklog);
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
    }

    @Test
    public void testAddWorklogWhenGroupDoesntExist() {
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        worklog.visibility = new Visibility();
        worklog.visibility.type = "group";
        worklog.visibility.value = "not-existing-group";
        ParsedResponse post = this.worklogClient.post(ISSUE_KEY, worklog);
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
    }

    @Test
    public void testEditWorklog() throws Exception {
        DateTime date = new DateTime();
        date.plusDays(10);
        Worklog worklog = this.getDefaultWorklogFromJira();
        worklog.timeSpent = "10h";
        worklog.timeSpentSeconds = null;
        worklog.started = TestIssueWorklogResource.asTimeString(date.toDate());
        worklog.comment = "This is the new comment";
        ParsedResponse post = this.worklogClient.put(ISSUE_KEY, worklog);
        Assert.assertEquals((long)200L, (long)post.statusCode);
        Assert.assertTrue((boolean)worklog.equals(post.body));
        Worklog freshWorklog = new Worklog();
        freshWorklog.id = worklog.id;
        post = this.worklogClient.put(ISSUE_KEY, freshWorklog);
        Assert.assertTrue((boolean)worklog.equals(post.body));
    }

    @Test
    public void testEditWorklogToRoleWhichDoesntExist() {
        Worklog worklog = this.getDefaultWorklogFromJira();
        worklog.visibility = new Visibility();
        worklog.visibility.type = "role";
        worklog.visibility.value = "not-existing-role";
        ParsedResponse post = this.worklogClient.post(ISSUE_KEY, worklog);
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
    }

    @Test
    public void testEditWorklogToGroupWhichDoesntExist() {
        Worklog worklog = this.getDefaultWorklogFromJira();
        worklog.timeSpent = "1h";
        worklog.visibility = new Visibility();
        worklog.visibility.type = "group";
        worklog.visibility.value = "not-existing-group";
        ParsedResponse post = this.worklogClient.post(ISSUE_KEY, worklog);
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
    }

    @Test
    public void worklogEditCanNotChangeUpdateDateAndIssueId() throws Exception {
        String newUpdateDate;
        Worklog worklog = this.getDefaultWorklogFromJira();
        String originalIssueId = worklog.issueId;
        worklog.issueId = "10";
        worklog.updated = newUpdateDate = TestIssueWorklogResource.asTimeString(new DateTime(System.currentTimeMillis()).minusYears(1).toDate());
        worklog.timeSpent = "1h";
        worklog.timeSpentSeconds = null;
        ParsedResponse post = this.worklogClient.put(ISSUE_KEY, worklog);
        Assert.assertEquals((long)200L, (long)post.statusCode);
        Worklog editedWorklog = (Worklog)post.body;
        MatcherAssert.assertThat((Object)editedWorklog.issueId, (Matcher)Matchers.equalTo((Object)originalIssueId));
        MatcherAssert.assertThat((Object)editedWorklog.updated, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)newUpdateDate)));
    }

    @Test
    public void testAddWorklogIssueFields() throws Exception {
        Worklog toAdd = new Worklog();
        toAdd.timeSpent = "1h";
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        long timeEstimate = DateUtils.getDuration((String)issue.fields.timetracking.remainingEstimate);
        long totalTime = DateUtils.getDuration((String)issue.fields.timetracking.timeSpent);
        this.worklogClient.post(ISSUE_KEY, toAdd);
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate -= 60L, totalTime += 60L);
        this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "auto").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate -= 60L, totalTime += 60L);
        this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "leave").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime += 60L);
        timeEstimate = TimeUnit.HOURS.toMinutes(6L);
        this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "new").add("newEstimate", "6h").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime += 60L);
        timeEstimate = TimeUnit.HOURS.toMinutes(5L) + 10L;
        this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "new").add("newEstimate", "5h%2010m").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime += 60L);
        ParsedResponse response = this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "new").toMap());
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errors.size());
        Assert.assertEquals((Object)"Value is required when adjustEstimate is new", response.entity.errors.get("newEstimate"));
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
        this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "manual").add("reduceBy", "2h").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate -= 120L, totalTime += 60L);
        response = this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "manual").toMap());
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errors.size());
        Assert.assertEquals((Object)"A value is required for manual estimate adjustment", response.entity.errors.get("reduceBy"));
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
    }

    @Test
    public void testEditWorklogIssueFields() throws Exception {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        long timeEstimate = DateUtils.getDuration((String)issue.fields.timetracking.remainingEstimate);
        long totalTime = DateUtils.getDuration((String)issue.fields.timetracking.timeSpent);
        Worklog worklog = this.getDefaultWorklogFromJira();
        worklog.timeSpent = "1h";
        this.worklogClient.put(ISSUE_KEY, worklog);
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate += 60L, totalTime -= 60L);
        worklog.timeSpent = "3h";
        this.worklogClient.put(ISSUE_KEY, worklog);
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate -= 120L, totalTime += 120L);
        worklog.timeSpentSeconds = 3600L;
        this.worklogClient.put(ISSUE_KEY, worklog, MapBuilder.newBuilder().add("adjustEstimate", "auto").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate += 120L, totalTime -= 120L);
        worklog.timeSpentSeconds = 7200L;
        this.worklogClient.put(ISSUE_KEY, worklog, MapBuilder.newBuilder().add("adjustEstimate", "leave").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime += 60L);
        worklog.timeSpent = "1h";
        timeEstimate = TimeUnit.HOURS.toMinutes(8L);
        this.worklogClient.put(ISSUE_KEY, worklog, MapBuilder.newBuilder().add("adjustEstimate", "new").add("newEstimate", "8h").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime -= 60L);
        ParsedResponse response = this.worklogClient.put(ISSUE_KEY, worklog, MapBuilder.newBuilder().add("adjustEstimate", "manual").add("reduceBy", "2h").toMap());
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errors.size());
        Assert.assertEquals((Object)"Manual adjustment of remaining estimate not allowed when editing a worklog", response.entity.errors.get("adjustEstimate"));
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
    }

    @Test
    public void testDeleteWorklog() throws Exception {
        Date now = new Date();
        Worklog toAdd = new Worklog();
        toAdd.timeSpent = "1h";
        toAdd.started = TestIssueWorklogResource.asTimeString(now);
        ParsedResponse addReponse = this.worklogClient.post(ISSUE_KEY, toAdd);
        ParsedResponse deleteResponse = this.worklogClient.delete(ISSUE_KEY, (Worklog)addReponse.body);
        Assert.assertEquals((long)204L, (long)deleteResponse.statusCode);
        ParsedResponse response = this.worklogClient.getResponse(ISSUE_KEY, ((Worklog)addReponse.body).id);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)response.entity.errorMessages.get(0)).startsWith("Cannot find worklog with id"));
        deleteResponse = this.worklogClient.delete(ISSUE_KEY, (Worklog)addReponse.body);
        Assert.assertEquals((long)404L, (long)deleteResponse.statusCode);
        Assert.assertEquals((long)1L, (long)deleteResponse.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)deleteResponse.entity.errorMessages.get(0)).startsWith("Cannot find worklog with id"));
    }

    @Test
    public void testDeleteWorklogAdjustEstimate() throws Exception {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        long timeEstimate = DateUtils.getDuration((String)issue.fields.timetracking.remainingEstimate);
        long totalTime = DateUtils.getDuration((String)issue.fields.timetracking.timeSpent);
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        ParsedResponse response = this.worklogClient.post(ISSUE_KEY, worklog);
        this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body);
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
        response = this.worklogClient.post(ISSUE_KEY, worklog);
        this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "auto").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
        response = this.worklogClient.post(ISSUE_KEY, worklog);
        this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "leave").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate -= 60L, totalTime);
        response = this.worklogClient.post(ISSUE_KEY, worklog);
        ParsedResponse deleteResponse = this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "new").toMap());
        Assert.assertEquals((long)400L, (long)deleteResponse.statusCode);
        Assert.assertEquals((long)1L, (long)deleteResponse.entity.errors.size());
        Assert.assertEquals((Object)"Value is required when adjustEstimate is new", deleteResponse.entity.errors.get("newEstimate"));
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate - 60L, totalTime + 60L);
        timeEstimate = TimeUnit.HOURS.toMinutes(8L);
        this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "new").add("newEstimate", "8h").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
        timeEstimate -= 60L;
        response = this.worklogClient.post(ISSUE_KEY, worklog);
        deleteResponse = this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "manual").toMap());
        Assert.assertEquals((long)400L, (long)deleteResponse.statusCode);
        Assert.assertEquals((long)1L, (long)deleteResponse.entity.errors.size());
        Assert.assertEquals((Object)"A value is required for manual estimate adjustment", deleteResponse.entity.errors.get("increaseBy"));
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime + 60L);
        this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "manual").add("increaseBy", "2h").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate += 120L, totalTime);
    }

    @Test
    public void testWorklogVisibility() throws Exception {
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        worklog.visibility = new Visibility();
        worklog.visibility.type = "group";
        worklog.visibility.value = "jira-administrators";
        ParsedResponse response = this.worklogClient.post(ISSUE_KEY, worklog);
        Assert.assertEquals((Object)worklog.visibility.type, (Object)((Worklog)response.body).visibility.type);
        Assert.assertEquals((Object)worklog.visibility.value, (Object)((Worklog)response.body).visibility.value);
        worklog = (Worklog)response.body;
        Worklog doubleCheck = this.worklogClient.get(ISSUE_KEY, worklog.id);
        doubleCheck.timeSpentSeconds = null;
        Assert.assertTrue((boolean)worklog.equals((Object)doubleCheck));
        worklog.visibility.value = "jira-users";
        worklog.timeSpentSeconds = null;
        response = this.worklogClient.put(ISSUE_KEY, worklog);
        doubleCheck.timeSpentSeconds = null;
        Assert.assertTrue((boolean)worklog.equals(response.body));
        doubleCheck = this.worklogClient.get(ISSUE_KEY, worklog.id);
        doubleCheck.timeSpentSeconds = null;
        Assert.assertTrue((boolean)worklog.equals((Object)doubleCheck));
        Worklog other = worklog;
        other.visibility = null;
        other.timeSpent = "2h";
        this.worklogClient.put(ISSUE_KEY, other);
        doubleCheck = this.worklogClient.get(ISSUE_KEY, worklog.id);
        doubleCheck.timeSpentSeconds = 3600L;
        Assert.assertTrue((boolean)worklog.equals((Object)doubleCheck));
        Worklog freshWorklog = new Worklog();
        freshWorklog.id = worklog.id;
        response = this.worklogClient.put(ISSUE_KEY, freshWorklog);
        Assert.assertNull((Object)((Worklog)response.body).visibility);
        doubleCheck = this.worklogClient.get(ISSUE_KEY, worklog.id);
        doubleCheck.timeSpentSeconds = null;
        Assert.assertNull((Object)doubleCheck.visibility);
    }

    private void verifyTimeTracking(String issueKey, long expectedEstimateHours, long totalTimeHours) throws InvalidDurationException {
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        long timeEstimate = DateUtils.getDuration((String)issue.fields.timetracking.remainingEstimate);
        long timeSpent = DateUtils.getDuration((String)issue.fields.timetracking.timeSpent);
    }

    @Before
    public void setUpTest() {
        this.worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.backdoor.restoreDataFromResource("TestWorklogAndTimeTracking.xml");
    }

    private static String asTimeString(@Nullable Date date) {
        return date != null ? new SimpleDateFormat(TIME_FORMAT).format(date) : null;
    }

    private Worklog getDefaultWorklog() {
        Worklog ew = new Worklog();
        ew.started = "2010-05-24T09:52:00.000+1000";
        ew.created = "2010-05-24T09:52:41.092+1000";
        ew.updated = "2010-05-24T09:52:41.092+1000";
        ew.timeSpent = "2h";
        ew.id = "10000";
        ew.comment = "I'm finished finally!";
        ew.self = this.getBaseUrlPlus("rest/api/2/issue/10000/worklog/10000");
        ew.issueId = "10000";
        UserJson user = new UserJson();
        user.self = this.getBaseUrlPlus("rest/api/2/user?username=admin");
        user.name = "admin";
        user.displayName = "Administrator";
        ew.author = user;
        ew.updateAuthor = user;
        return ew;
    }

    private Worklog getDefaultWorklogFromJira() {
        Worklog worklog = this.worklogClient.get(ISSUE_KEY, "10000");
        Assert.assertNotNull((Object)worklog);
        return worklog;
    }

    private void assertEqualDateStrings(String expected, String actual) {
        String[] expected_split = expected.split("(\\+|\\-)\\d{4}$");
        String[] actual_split = actual.split("(\\+|\\-)\\d{4}$");
        Assert.assertEquals((Object)expected_split[0], (Object)actual_split[0]);
    }

    public String getBaseUrlPlus(String ... paths) {
        return this.getBaseUrlPlus(Arrays.asList(paths));
    }

    public String getBaseUrlPlus(Iterable<String> paths) {
        Iterable pathsNoLeadingSlashes = Iterables.transform(paths, (Function)new Function<String, String>(){

            public String apply(String path) {
                return path.startsWith("/") ? path.substring(1) : path;
            }
        });
        String path = pathsNoLeadingSlashes != null ? StringUtils.join((Iterable)Lists.newArrayList((Iterable)pathsNoLeadingSlashes), (char)'/') : "";
        return String.format("%s/%s", this.environmentData.getBaseUrl(), path);
    }
}

