/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestJmxMonitoringController
extends BaseJiraFuncTest {
    private JmxMonitoringClient client;

    @Before
    public void setUp() {
        this.client = new JmxMonitoringClient(this.getEnvironmentData());
    }

    @Test
    public void testJmxMonitoringStartWithWebsudoEnabled() {
        this.backdoor.websudo().enable();
        ParsedResponse response = this.client.startJmxMonitoring();
        Assert.assertEquals((long)401L, (long)response.statusCode);
        this.backdoor.websudo().disable();
    }

    @Test
    public void testJmxMonitoringStartWithWebsudoDisabled() {
        ParsedResponse response = this.client.startJmxMonitoring();
        Assert.assertEquals((long)200L, (long)response.statusCode);
    }

    @Test
    public void testJmxMonitoringStopWithWebsudoEnabled() {
        this.backdoor.websudo().enable();
        ParsedResponse response = this.client.stopJmxMonitoring();
        Assert.assertEquals((long)401L, (long)response.statusCode);
        this.backdoor.websudo().disable();
    }

    @Test
    public void testJmxMonitoringStopWithWebsudoDisabled() {
        ParsedResponse response = this.client.stopJmxMonitoring();
        Assert.assertEquals((long)200L, (long)response.statusCode);
    }

    private static class JmxMonitoringClient
    extends RestApiClient<JmxMonitoringClient> {
        public JmxMonitoringClient(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        public ParsedResponse startJmxMonitoring() {
            return this.toResponse(() -> (Response)this.createResource().path("monitoring").path("jmx").path("startExposing").request().post(null, Response.class));
        }

        public ParsedResponse stopJmxMonitoring() {
            return this.toResponse(() -> (Response)this.createResource().path("monitoring").path("jmx").path("stopExposing").request().post(null, Response.class));
        }
    }
}

