/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.LinkedIssuesMatcher;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueLink;
import com.atlassian.jira.testkit.client.restclient.LinkIssueClient;
import com.atlassian.jira.testkit.client.restclient.LinkRequest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestLinkIssueResource.xml")
public class TestLinkIssueResource
extends BaseJiraRestTest {
    static final LinkRequest DUP_HSP1_MKY1 = new LinkRequest().type(ResourceRef.withName((String)"Duplicate")).inwardIssue(ResourceRef.withKey((String)"HSP-1")).outwardIssue(ResourceRef.withKey((String)"MKY-1"));
    private LinkIssueClient linkIssueClient;
    private IssueClient issueClient;
    @Inject
    private FuncTestUrlHelper funcTestUrlHelper;

    @Before
    public void setUpTest() {
        this.linkIssueClient = new LinkIssueClient((JIRAEnvironmentData)this.environmentData);
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testLinkIssuesWithComment() throws Exception {
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        LinkRequest linkRequest = DUP_HSP1_MKY1.comment(comment);
        ParsedResponse response = this.linkIssueClient.linkIssues(linkRequest);
        Assert.assertEquals((long)201L, (long)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List comments = issue.fields.comment.getComments();
        Assert.assertEquals((Object)comment.body, (Object)((Comment)comments.get((int)0)).body);
        List issueLinks = issue.fields.issuelinks;
        IssueLink issueLink = (IssueLink)issueLinks.get(0);
        Assert.assertEquals((Object)"MKY-1", (Object)issueLink.outwardIssue().key());
        IssueLink.Type type = issueLink.type();
        Assert.assertEquals((Object)"Duplicate", (Object)type.name());
        issue = this.issueClient.get("MKY-1", new Issue.Expand[0]);
        comments = issue.fields.comment.getComments();
        Assert.assertEquals((long)0L, (long)comments.size());
        issueLinks = issue.fields.issuelinks;
        issueLink = (IssueLink)issueLinks.get(0);
        Assert.assertEquals((Object)"HSP-1", (Object)issueLink.inwardIssue().key());
        type = issueLink.type();
        Assert.assertEquals((Object)"Duplicate", (Object)type.name());
    }

    @Test
    public void testLinkIssues() throws Exception {
        ParsedResponse linkToMky1Resp = this.linkIssueClient.linkIssues(DUP_HSP1_MKY1);
        Assert.assertEquals((long)201L, (long)linkToMky1Resp.statusCode);
        Assert.assertThat((Object)this.issueClient.get("HSP-1", new Issue.Expand[0]), LinkedIssuesMatcher.hasLinkWithOutwardIssue("MKY-1", "Duplicate"));
        ResourceRef duplicates_id = ResourceRef.withId((String)"10000");
        ResourceRef hsp1_key = ResourceRef.withKey((String)"HSP-1");
        ResourceRef hsp2_id = ResourceRef.withId((String)"10101");
        ParsedResponse linkToHsp2Resp = this.linkIssueClient.linkIssues(DUP_HSP1_MKY1.type(duplicates_id).inwardIssue(hsp1_key).outwardIssue(hsp2_id));
        Assert.assertEquals((long)201L, (long)linkToHsp2Resp.statusCode);
        Assert.assertThat((Object)this.issueClient.get("HSP-2", new Issue.Expand[0]), LinkedIssuesMatcher.hasLinkWithInwardIssue("HSP-1", "Duplicate"));
    }

    @Test
    public void testLinkIssuesToSelf() throws Exception {
        LinkRequest linkRequest = new LinkRequest().type(ResourceRef.withName((String)"Duplicate")).inwardIssue(ResourceRef.withKey((String)"HSP-1")).outwardIssue(ResourceRef.withKey((String)"HSP-1"));
        ParsedResponse response = this.linkIssueClient.linkIssues(linkRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"You cannot link an issue to itself.", response.entity.errorMessages.get(0));
    }

    @Test
    public void testLinkIssuesWithInvalidRoleLevelSpecified() throws Exception {
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        comment.visibility = new Visibility("role", "Developers");
        LinkRequest linkRequest = DUP_HSP1_MKY1.comment(comment);
        ParsedResponse response = this.linkIssueClient.linkIssues(linkRequest);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"You are currently not a member of the project role: Developers.", response.entity.errors.values().iterator().next());
    }

    @Test
    public void testLinkIssuesWithGroupLevelSpecified() throws Exception {
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        comment.visibility = new Visibility("group", "jira-administrators");
        LinkRequest linkRequest = DUP_HSP1_MKY1.comment(comment);
        ParsedResponse response = this.linkIssueClient.linkIssues(linkRequest);
        Assert.assertEquals((long)201L, (long)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List comments = issue.fields.comment.getComments();
        Assert.assertEquals((Object)comment.body, (Object)((Comment)comments.get((int)0)).body);
    }

    @Test
    public void testLinkIssuesWithRoleLevelSpecified() throws Exception {
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        comment.visibility = new Visibility("role", "Administrators");
        LinkRequest linkRequest = DUP_HSP1_MKY1.comment(comment);
        ParsedResponse response = this.linkIssueClient.linkIssues(linkRequest);
        Assert.assertEquals((long)201L, (long)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List comments = issue.fields.comment.getComments();
        Assert.assertEquals((Object)comment.body, (Object)((Comment)comments.get((int)0)).body);
    }

    @Test
    public void testLinkIssuesFailedBecauseIssueLinkingDisabled() throws Exception {
        this.backdoor.issueLinking().disable();
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        LinkRequest linkRequest = DUP_HSP1_MKY1.comment(comment);
        ParsedResponse response = this.linkIssueClient.linkIssues(linkRequest);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((Object)"Issue linking is currently disabled.", response.entity.errorMessages.get(0));
    }

    @Test
    public void testLinkIssuesFailedIssueANotVisible() throws Exception {
        ParsedResponse response = ((LinkIssueClient)this.linkIssueClient.loginAs("fred")).linkIssues(DUP_HSP1_MKY1);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((Object)"You do not have the permission to see the specified issue.", response.entity.errorMessages.get(0));
    }

    @Test
    public void testLinkIssuesFailedIssueBNotVisible() throws Exception {
        ParsedResponse response = ((LinkIssueClient)this.linkIssueClient.loginAs("bob")).linkIssues(DUP_HSP1_MKY1);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((Object)"You do not have the permission to see the specified issue.", response.entity.errorMessages.get(0));
    }

    @Test
    public void testLinkIssuesFailedNoLInkIssuePermissionIssueA() throws Exception {
        LinkRequest linkRequest = DUP_HSP1_MKY1.outwardIssue(ResourceRef.withKey((String)"HSP-2"));
        ParsedResponse response = ((LinkIssueClient)this.linkIssueClient.loginAs("bob")).linkIssues(linkRequest);
        Assert.assertEquals((long)401L, (long)response.statusCode);
        Assert.assertEquals((Object)"No Link Issue Permission for issue 'HSP-1'", response.entity.errorMessages.get(0));
    }

    @Test
    public void testLinkIssuesFailedNoLInkIssuePermissionIssueB() throws Exception {
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        LinkRequest linkRequest = DUP_HSP1_MKY1.inwardIssue(ResourceRef.withKey((String)"MKY-1")).outwardIssue(ResourceRef.withKey((String)"MKY-2")).comment(comment);
        ParsedResponse response = ((LinkIssueClient)this.linkIssueClient.loginAs("fred")).linkIssues(linkRequest);
        Assert.assertEquals((long)401L, (long)response.statusCode);
        Assert.assertEquals((Object)"No Link Issue Permission for issue 'MKY-1'", response.entity.errorMessages.get(0));
    }

    @Test
    public void testLinkIssuesFailedBecauseLinkTypeDoesNotExist() throws Exception {
        LinkRequest linkRequest = DUP_HSP1_MKY1.type(ResourceRef.withName((String)"calculated"));
        ParsedResponse response = this.linkIssueClient.linkIssues(linkRequest);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((Object)"No issue link type with name 'calculated' found.", response.entity.errorMessages.get(0));
    }

    @Test
    public void testLinkIssuesLinkIssuePermissionForIssueAButNotB() throws Exception {
        ParsedResponse response = ((LinkIssueClient)this.linkIssueClient.loginAs("linker")).linkIssues(DUP_HSP1_MKY1);
        Assert.assertEquals((long)201L, (long)response.statusCode);
    }

    @Test
    public void testLinkIssuesNoLinkIssuePermissionForIssueBButB() throws Exception {
        LinkRequest linkRequest = DUP_HSP1_MKY1.inwardIssue(ResourceRef.withKey((String)"MKY-1")).outwardIssue(ResourceRef.withKey((String)"HSP-1"));
        ParsedResponse response = ((LinkIssueClient)this.linkIssueClient.loginAs("linker")).linkIssues(linkRequest);
        Assert.assertEquals((long)401L, (long)response.statusCode);
        Assert.assertEquals((Object)"No Link Issue Permission for issue 'MKY-1'", response.entity.errorMessages.get(0));
    }

    @Test
    public void testLinkIssuesUsingIssueTypeIdInsteadOfName() throws Exception {
        ParsedResponse notFoundResponse = this.linkIssueClient.linkIssues(DUP_HSP1_MKY1.type(ResourceRef.withId((String)"1")));
        Assert.assertEquals((long)404L, (long)notFoundResponse.statusCode);
        Assert.assertThat((Object)notFoundResponse.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"No issue link type with id '1' found."));
        ParsedResponse resp = this.linkIssueClient.linkIssues(DUP_HSP1_MKY1.type(ResourceRef.withId((String)"10100")));
        Assert.assertEquals((long)201L, (long)resp.statusCode);
        Assert.assertThat((Object)((IssueLink)this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.issuelinks.get(0)).type().name(), (Matcher)Matchers.equalTo((Object)"Blocks"));
    }

    @Test
    public void testGetIssueLink() throws Exception {
        IssueLink issueLink = this.linkIssueClient.getIssueLink("10100");
        Assert.assertEquals((Object)"10100", (Object)issueLink.id());
        Assert.assertEquals((Object)this.funcTestUrlHelper.getRestApiUri("issueLink/10100"), (Object)issueLink.self());
        Assert.assertEquals((Object)issueLink.inwardIssue().id(), (Object)"10200");
        Assert.assertEquals((Object)issueLink.outwardIssue().id(), (Object)"10201");
    }

    @Test
    public void testGetIssueLinkInvalidId() throws Exception {
        ParsedResponse linkIssueClientIssueLinkResponse = this.linkIssueClient.getIssueLinkResponse("32423");
        Assert.assertEquals((long)404L, (long)linkIssueClientIssueLinkResponse.statusCode);
        Assert.assertEquals((Object)"No issue link with id '32423' exists.", linkIssueClientIssueLinkResponse.entity.errorMessages.get(0));
    }

    @Test
    public void testGetIssueLinkWithoutPermission() throws Exception {
        ParsedResponse response = ((LinkIssueClient)this.linkIssueClient.loginAs("linker")).getIssueLinkResponse("10100");
        Assert.assertEquals((long)404L, (long)response.statusCode);
    }

    @Test
    public void testDeleteIssueLink() throws Exception {
        ParsedResponse response = this.linkIssueClient.deleteIssueLink("10100");
        Assert.assertEquals((long)204L, (long)response.statusCode);
        ParsedResponse linkIssueClientIssueLinkResponse = this.linkIssueClient.getIssueLinkResponse("10100");
        Assert.assertEquals((long)404L, (long)linkIssueClientIssueLinkResponse.statusCode);
        Assert.assertEquals((Object)"No issue link with id '10100' exists.", linkIssueClientIssueLinkResponse.entity.errorMessages.get(0));
    }

    @Test
    public void testDeleteIssueLinkInvalidId() throws Exception {
        ParsedResponse linkIssueClientIssueLinkResponse = this.linkIssueClient.deleteIssueLink("32423");
        Assert.assertEquals((long)404L, (long)linkIssueClientIssueLinkResponse.statusCode);
        Assert.assertEquals((Object)"No issue link with id '32423' exists.", linkIssueClientIssueLinkResponse.entity.errorMessages.get(0));
    }

    @Test
    public void testDeleteIssueLinkWithoutPermission() throws Exception {
        ParsedResponse response = ((LinkIssueClient)this.linkIssueClient.loginAs("linker")).deleteIssueLink("10100");
        Assert.assertEquals((long)404L, (long)response.statusCode);
    }
}

