/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.HeaderValue;
import com.atlassian.jira.issue.SelfUrlOriginType;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.inject.Inject;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.URLEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestLogin
extends BaseJiraFuncTest {
    public static final int CAPTCHA_MAX_TRIES = 10;
    public static final String X_AUTHENTICATION_DENIED_REASON = "X-Authentication-Denied-Reason";
    public static final String REST_AUTH_RESOURCE = "/rest/auth/latest/session";
    public static final String SESSION_PARAM = "JSESSIONID";
    private JSONObject fredBadCredentials;
    private JSONObject fredGoodCredentials;
    @Inject
    FuncTestRestClient funcTestRestClient;
    @Inject
    FuncTestUrlHelper funcTestUrlHelper;

    @Before
    public void setUpTest() {
        try {
            this.fredBadCredentials = new JSONObject();
            this.fredBadCredentials.put("username", "fred");
            this.fredBadCredentials.put("password", "fredzzz");
            this.fredGoodCredentials = new JSONObject();
            this.fredGoodCredentials.put("username", "fred");
            this.fredGoodCredentials.put("password", "fred");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testCurrentUser() throws Exception {
        JSONObject json = this.funcTestRestClient.getJSON(REST_AUTH_RESOURCE, new String[0]);
        Assert.assertEquals((Object)"admin", (Object)json.getString("name"));
        Assert.assertTrue((boolean)json.has("loginInfo"));
    }

    @Test
    public void testCurrentUserUglyName() throws Exception {
        this.backdoor.usersAndGroups().addUser("jo smith");
        this.navigation.login("jo smith");
        JSONObject json = this.funcTestRestClient.getJSON(REST_AUTH_RESOURCE, new String[0]);
        Assert.assertEquals((Object)"jo smith", (Object)json.getString("name"));
        Assert.assertTrue((boolean)json.has("loginInfo"));
    }

    @Test
    public void testCurrentUserAnon() throws Exception {
        this.navigation.logout();
        WebResponse response = this.funcTestRestClient.GET(REST_AUTH_RESOURCE);
        Assert.assertEquals((long)401L, (long)response.getResponseCode());
    }

    @Test
    public void testLogin() throws Exception {
        this.navigation.logout();
        this.backdoor.usersAndGroups().resetLoginCount("admin");
        long currentLoginCount = this.backdoor.usersAndGroups().getLoginInfo("admin").getLoginCount();
        JSONObject json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "BAD-PASSWORD");
        WebResponse response = this.loginAs(json);
        Assert.assertEquals((long)401L, (long)response.getResponseCode());
        Assert.assertEquals((Object)"JIRA REST POST", (Object)response.getHeaderField("WWW-Authenticate"));
        JSONObject userThatDoesntExist = new JSONObject().put("username", "wtf").put("password", "kljasdfjkl;dfs");
        Assert.assertEquals((String)"should return 401 if user doesn't exist", (long)401L, (long)this.loginAs(userThatDoesntExist).getResponseCode());
        json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "admin");
        response = this.loginAs(json);
        Assert.assertEquals((long)200L, (long)response.getResponseCode());
        JSONObject responseJson = new JSONObject(response.getText());
        JSONObject session = responseJson.getJSONObject("session");
        Assert.assertEquals((Object)SESSION_PARAM, (Object)session.getString("name"));
        Assert.assertEquals((Object)this.tester.getDialog().getWebClient().getCookieValue(SESSION_PARAM), (Object)session.getString("value"));
        JSONObject loginInfo = responseJson.getJSONObject("loginInfo");
        Assert.assertTrue((boolean)loginInfo.has("previousLoginTime"));
        Assert.assertTrue((boolean)loginInfo.has("lastFailedLoginTime"));
        Assert.assertEquals((long)(currentLoginCount + 1L), (long)loginInfo.getLong("loginCount"));
        Assert.assertEquals((long)1L, (long)loginInfo.getLong("failedLoginCount"));
    }

    @Test
    public void testWhenTheLoginResourceGivesYouACookieYouShouldBeAbleToActuallyDoSomethingWithIt() throws Exception {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "this is a summary");
        this.navigation.logout();
        JSONObject json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "admin");
        String jsessionId = TestLogin.getSessionId(this.loginAs(json));
        this.tester.getDialog().getWebClient().clearCookies();
        WebResponse response = this.funcTestRestClient.GET("/rest/api/latest/issue/" + key, MapBuilder.newBuilder().add("Cookie", "JSESSIONID=" + jsessionId).toImmutableMap());
        Assert.assertThat((Object)response.getResponseCode(), (Matcher)IsEqual.equalTo((Object)200));
        JSONObject issue = new JSONObject(response.getText());
        Assert.assertTrue((boolean)issue.has("key"));
    }

    @Test
    public void testCanLoginAfterSessionTimeout() throws Exception {
        this.navigation.logout();
        JSONObject json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "admin");
        WebResponse response = this.loginAs(json);
        Assert.assertEquals((long)200L, (long)response.getResponseCode());
        response = this.funcTestRestClient.GET(REST_AUTH_RESOURCE);
        Assert.assertEquals((long)200L, (long)response.getResponseCode());
        response = this.funcTestRestClient.GET("/rest/api/latest/project/HSP");
        Assert.assertEquals((long)200L, (long)response.getResponseCode());
        WebClient client = this.tester.getDialog().getWebClient();
        client.clearCookies();
        client.addCookie(SESSION_PARAM, "BAD1");
        response = this.funcTestRestClient.GET(REST_AUTH_RESOURCE);
        Assert.assertEquals((long)401L, (long)response.getResponseCode());
        client.clearCookies();
        client.addCookie(SESSION_PARAM, "BAD2");
        response = this.funcTestRestClient.GET("/rest/api/latest/project/HSP");
        Assert.assertEquals((long)401L, (long)response.getResponseCode());
        client.clearCookies();
        client.addCookie(SESSION_PARAM, "BAD3");
        response = this.loginAs(json);
        Assert.assertEquals((long)200L, (long)response.getResponseCode());
    }

    private static String getSessionId(WebResponse response) throws JSONException, IOException {
        JSONObject responseJson = new JSONObject(response.getText());
        JSONObject session = responseJson.getJSONObject("session");
        return session.getString("value");
    }

    @Test
    public void testLoginsThatAreDeniedDueToCaptchaProtectionShouldReturn403() throws Exception {
        this.navigation.logout();
        WebResponse response = this.provokeCaptchaFailure(this.fredBadCredentials);
        Assert.assertThat((Object)response.getResponseCode(), (Matcher)IsEqual.equalTo((Object)403));
        Assert.assertThat((Object)response, HeaderValue.header(X_AUTHENTICATION_DENIED_REASON, (Matcher<? super String>)IsEqual.equalTo((Object)String.format("CAPTCHA_CHALLENGE; login-url=%s", this.funcTestUrlHelper.getBaseUrlPlus("login.jsp")))));
    }

    @Test
    public void testCaptchaFailureWithWrongPasswordIsIdenticalToCaptchaFailureWithRightPassword() throws Exception {
        this.navigation.logout();
        WebResponse wrongPassResponse = this.provokeCaptchaFailure(this.fredBadCredentials);
        WebResponse rightPassResponse = this.loginAs(this.fredGoodCredentials);
        Assert.assertThat((Object)rightPassResponse.getHeaderField(X_AUTHENTICATION_DENIED_REASON), (Matcher)IsEqual.equalTo((Object)wrongPassResponse.getHeaderField(X_AUTHENTICATION_DENIED_REASON)));
    }

    @Test
    public void testLoginReturnEncodedUsername_IncludingUtf8Chars_InResponseHeader() throws Exception {
        String utf8Username = "\u00c5\u0082Test\u00c5\u0082";
        String urlEncodedUsername = URLEncoder.encode("\u00c5\u0082Test\u00c5\u0082", "UTF-8");
        this.navigation.logout();
        this.backdoor.usersAndGroups().addUser("\u00c5\u0082Test\u00c5\u0082");
        this.navigation.login("\u00c5\u0082Test\u00c5\u0082");
        WebResponse response = this.funcTestRestClient.GET(REST_AUTH_RESOURCE);
        Assert.assertEquals((long)200L, (long)response.getResponseCode());
        Assert.assertEquals((Object)urlEncodedUsername, (Object)response.getHeaderField("X-AUSERNAME"));
    }

    @Test
    public void testLoginWithSelfFieldSetToBaseUrl() throws Exception {
        String baseUrl = "http://localhost:1111/jira";
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", SelfUrlOriginType.BASEURL.name());
        this.backdoor.applicationProperties().setString("jira.baseurl", baseUrl);
        JSONObject json = this.funcTestRestClient.getJSON(REST_AUTH_RESOURCE, new String[0]);
        Assert.assertEquals((Object)(baseUrl + "/rest/api/latest/user?username=admin"), (Object)json.getString("self"));
    }

    protected WebResponse loginAs(JSONObject json) throws IOException, SAXException {
        return this.funcTestRestClient.POST(REST_AUTH_RESOURCE, json);
    }

    protected WebResponse provokeCaptchaFailure(JSONObject badCredentials) throws IOException, SAXException {
        WebResponse response;
        int tries = 10;
        do {
            response = this.loginAs(badCredentials);
            this.navigation.logout();
        } while (response.getResponseCode() == 401 && --tries > 0);
        if (tries == 0) {
            Assert.fail((String)String.format("Captcha did not kick in after %d failed logins", 10));
        }
        return response;
    }

    @Test
    public void testLogout() throws Exception {
        this.navigation.login("admin");
        WebResponse response = this.funcTestRestClient.DELETE(REST_AUTH_RESOURCE);
        Assert.assertEquals((long)204L, (long)response.getResponseCode());
        response = this.funcTestRestClient.DELETE(REST_AUTH_RESOURCE);
        Assert.assertEquals((long)401L, (long)response.getResponseCode());
    }
}

