/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.issue.users.IssueInvolvementBean;
import com.atlassian.jira.rest.v2.issue.users.UserIssueRelevanceBean;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebResponse;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestMentionResource
extends BaseJiraFuncTest {
    @Inject
    private FuncTestRestClient restClient;
    private String issueKey;

    @Before
    public void setUp() throws Exception {
        this.backdoor.restoreBlankInstance();
        this.createUsers();
        this.issueKey = this.backdoor.issues().createIssue("HSP", "A test issue for the mention rest test").key();
    }

    @Test
    public void shouldReturnUserWithMultipleRoles() throws Exception {
        List<UserIssueRelevanceBean> results = this.getResultsForIssue(this.issueKey, 1, "");
        Assert.assertThat(results, (Matcher)Matchers.hasSize((int)1));
        List involvements = (List)results.get(0).getIssueInvolvements().stream().map(IssueInvolvementBean::getId).map(String::toLowerCase).collect(CollectorsUtil.toImmutableList());
        Assert.assertThat((Object)involvements, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"assignee", "reporter", "watcher"}));
    }

    @Test
    public void shouldReturnUserWithMultipleRolesIfSearchedByUserName() throws Exception {
        List<UserIssueRelevanceBean> results = this.getResultsForIssue(this.issueKey, 1, "admin");
        Assert.assertThat(results, (Matcher)Matchers.hasSize((int)1));
        List involvements = (List)results.get(0).getIssueInvolvements().stream().map(IssueInvolvementBean::getId).map(String::toLowerCase).collect(CollectorsUtil.toImmutableList());
        Assert.assertThat((Object)involvements, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"assignee", "reporter", "watcher"}));
    }

    @Test
    public void shouldReturnUserWithMultipleRolesIfSearchedByRole() throws Exception {
        List<UserIssueRelevanceBean> results = this.getResultsForIssue(this.issueKey, 1, "assignee");
        Assert.assertThat(results, (Matcher)Matchers.hasSize((int)1));
        List involvements = (List)results.get(0).getIssueInvolvements().stream().map(IssueInvolvementBean::getId).map(String::toLowerCase).collect(CollectorsUtil.toImmutableList());
        Assert.assertThat((Object)involvements, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"assignee", "reporter", "watcher"}));
    }

    @Test
    public void shouldFindUserByUsername() throws Exception {
        List<UserIssueRelevanceBean> results = this.getResultsForIssue(this.issueKey, 1, "admin");
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldFindUserByFullname() throws Exception {
        List<UserIssueRelevanceBean> results = this.getResultsForIssue(this.issueKey, 1, "Administrator");
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldFilterUsers() throws Exception {
        List<UserIssueRelevanceBean> results = this.getResultsForIssue(this.issueKey, 10, "someStringThatHopefullyNoUserWillEverHave");
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSearchByPreffixMatching() throws Exception {
        List<UserIssueRelevanceBean> results = this.getResultsForIssue(this.issueKey, 10, "dmin");
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnSeveralUsersForSomeFilters() throws Exception {
        List<UserIssueRelevanceBean> results = this.getResultsForIssue(this.issueKey, 10, "p");
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldReturnOtherUsersIfInsufficientWithRoles() throws Exception {
        List<UserIssueRelevanceBean> results = this.getResultsForIssue(this.issueKey, 5, "");
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)results.get(1).getIssueInvolvements(), (Matcher)Is.is((Matcher)IsEmptyCollection.empty()));
    }

    @Test
    public void shouldReturnInvolvedUsersBeforeOthers() throws Exception {
        List<UserIssueRelevanceBean> results = this.getResultsForIssue(this.issueKey, 5, "");
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)results.get(0).getIssueInvolvements(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)IsEmptyCollection.empty())));
        for (int i = 1; i < 5; ++i) {
            Assert.assertThat((Object)results.get(i).getIssueInvolvements(), (Matcher)Is.is((Matcher)IsEmptyCollection.empty()));
        }
    }

    @Test
    public void shouldOnlyReturnMaxResults() throws Exception {
        List<UserIssueRelevanceBean> resultsMax2 = this.getResultsForIssue(this.issueKey, 2, "");
        Assert.assertThat((Object)resultsMax2.size(), (Matcher)Is.is((Object)2));
        List<UserIssueRelevanceBean> resultsMax1 = this.getResultsForIssue(this.issueKey, 1, "");
        Assert.assertThat((Object)resultsMax1.size(), (Matcher)Is.is((Object)1));
    }

    private List<UserIssueRelevanceBean> getResultsForIssue(String key, int maxResults, String search) throws Exception {
        ImmutableList.Builder list = ImmutableList.builder();
        WebResponse response = this.restClient.GET("/rest/internal/2/user/mention/search?issueKey=" + key + "&maxResults=" + maxResults + "&query=" + search);
        JSONArray jsonArray = new JSONArray(response.getText());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject currentUser = jsonArray.getJSONObject(i);
            JSONArray involvementArray = currentUser.getJSONArray("issueInvolvements");
            ImmutableList.Builder involvementList = ImmutableList.builder();
            for (int j = 0; j < involvementArray.length(); ++j) {
                JSONObject involvement = involvementArray.getJSONObject(j);
                involvementList.add((Object)new IssueInvolvementBean(involvement.getString("id"), involvement.getString("label")));
            }
            UserIssueRelevanceBean bean = new UserIssueRelevanceBean(URI.create(currentUser.getString("self")), currentUser.getString("key"), currentUser.getString("name"), currentUser.getString("displayName"), currentUser.getBoolean("active"), currentUser.getString("emailAddress"), (Map)ImmutableMap.of(), null, null, (List)involvementList.build(), currentUser.has("highestIssueInvolvementRank") ? Optional.of(currentUser.getInt("highestIssueInvolvementRank")) : Optional.empty(), currentUser.has("latestCommentCreationTime") ? Optional.of(currentUser.getLong("latestCommentCreationTime")).map(Date::new) : Optional.empty());
            list.add((Object)bean);
        }
        return list.build();
    }

    private void createUsers() {
        this.backdoor.usersAndGroups().addUser("a\\b", "pass", "a\\b", "ab@example.com", false);
        this.backdoor.usersAndGroups().addUserToGroup("a\\b", "jira-developers");
        this.backdoor.usersAndGroups().addUser("bloblaw", "pass", "Bob Loblaw", "bob@example.com", false);
        this.backdoor.usersAndGroups().addUserToGroup("bloblaw", "jira-developers");
        this.backdoor.usersAndGroups().addUser("c/d", "pass", "c/d", "cd@example.com", false);
        this.backdoor.usersAndGroups().addUserToGroup("c/d", "jira-developers");
        this.backdoor.usersAndGroups().addUser("per%25cent", "pass", "per%25cent", "pct@example.com", false);
        this.backdoor.usersAndGroups().addUser("pl+us", "pass", "pl+us", "pl+us@example.com", false);
        this.backdoor.usersAndGroups().addUser("sp ace", "pass", "sp ace", "space@example.com", false);
        this.backdoor.usersAndGroups().addUser("%E6%84%9B", "pass", "%E6%84%9B %E6%88%B7", "love@example.com", false);
        this.backdoor.usersAndGroups().addUser("fredx", "pass", "Fred Obsolete", "fredx@example.com", false);
        this.backdoor.usersAndGroups().removeUserFromGroup("fredx", "jira-users");
        this.backdoor.userManager().setActive("fredx", false);
    }
}

