/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.PageBeanMatcher;
import com.atlassian.jira.rest.api.notification.NotificationSchemeExpandParam;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.NotificationSchemesControl;
import com.atlassian.jira.testkit.client.restclient.NotificationBean;
import com.atlassian.jira.testkit.client.restclient.NotificationSchemeBean;
import com.atlassian.jira.testkit.client.restclient.NotificationSchemeClient;
import com.atlassian.jira.testkit.client.restclient.NotificationSchemeEventBean;
import com.atlassian.jira.testkit.client.restclient.NotificationSchemePageBean;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SCHEMES, Category.REST})
public class TestNotificationSchemeResource
extends BaseJiraFuncTest {
    private static final String SCHEME_NAME = "New notification scheme";
    private NotificationSchemeClient notificationSchemeClient;
    private NotificationSchemesControl notificationSchemesControl;

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.notificationSchemeClient = new NotificationSchemeClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.notificationSchemesControl = new NotificationSchemesControl((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testGettingNotificationSchemeWithProjectRole() {
        Long newSchemeId = this.createNotificationScheme();
        ProjectRole projectRole = this.backdoor.projectRole().get("MKY", "Users");
        this.notificationSchemesControl.addProjectRoleNotification(newSchemeId.longValue(), EventType.ISSUE_CREATED_ID.longValue(), projectRole.id.longValue());
        NotificationSchemeBean notificationScheme = this.notificationSchemeClient.getNotificationScheme(newSchemeId, "projectRole");
        Assert.assertThat((Object)notificationScheme, TestNotificationSchemeResource.matchesScheme((Matcher<? super String>)Is.is((Object)SCHEME_NAME), TestNotificationSchemeResource.hasEvent(EventType.ISSUE_CREATED_ID, TestNotificationSchemeResource.projectRoleMatcher("Users"))));
    }

    @Test
    public void testGettingNotificationSchemeWithDefaultIssueUpdatedNotification() {
        Long schemeId = this.createNotificationScheme();
        NotificationSchemeBean notificationScheme = this.notificationSchemeClient.getNotificationScheme(schemeId, "notificationSchemeEvents");
        Assert.assertThat((Object)notificationScheme, TestNotificationSchemeResource.matchesScheme((Matcher<? super String>)Is.is((Object)SCHEME_NAME), (Matcher<List<NotificationSchemeEventBean>>)Matchers.allOf(TestNotificationSchemeResource.hasEvent(EventType.ISSUE_UPDATED_ID, TestNotificationSchemeResource.simpleNotificationMatcher("CurrentAssignee")), TestNotificationSchemeResource.hasEvent(EventType.ISSUE_UPDATED_ID, TestNotificationSchemeResource.simpleNotificationMatcher("Reporter")), TestNotificationSchemeResource.hasEvent(EventType.ISSUE_UPDATED_ID, TestNotificationSchemeResource.simpleNotificationMatcher("AllWatchers")))));
    }

    @Test
    public void testGettingNotificationSchemeWithUser() {
        Long eventId = EventType.ISSUE_DELETED_ID;
        Long newSchemeId = this.createNotificationScheme();
        String key = this.backdoor.usersAndGroups().addUser("username").getUserByName("username").getKey();
        this.notificationSchemesControl.addUserNotification(newSchemeId.longValue(), eventId.longValue(), key);
        NotificationSchemeBean notificationScheme = this.notificationSchemeClient.getNotificationScheme(newSchemeId, "user");
        Assert.assertThat((Object)notificationScheme, TestNotificationSchemeResource.matchesScheme((Matcher<? super String>)Is.is((Object)SCHEME_NAME), TestNotificationSchemeResource.hasEvent(eventId, TestNotificationSchemeResource.userMarcher("username"))));
    }

    @Test
    public void testGettingNotificationSchemeAndExpandingAll() {
        Long newSchemeId = this.createNotificationScheme();
        String key = this.backdoor.usersAndGroups().addUser("user").getUserByName("user").getKey();
        this.notificationSchemesControl.addUserNotification(newSchemeId.longValue(), EventType.ISSUE_DELETED_ID.longValue(), key);
        ProjectRole projectRole = this.backdoor.projectRole().get("MKY", "Users");
        this.notificationSchemesControl.addProjectRoleNotification(newSchemeId.longValue(), EventType.ISSUE_DELETED_ID.longValue(), projectRole.id.longValue());
        NotificationSchemeBean notificationScheme = this.notificationSchemeClient.getNotificationScheme(newSchemeId, "all");
        Assert.assertThat((Object)notificationScheme, TestNotificationSchemeResource.matchesScheme((Matcher<? super String>)Is.is((Object)SCHEME_NAME), TestNotificationSchemeResource.hasEvent(EventType.ISSUE_DELETED_ID, TestNotificationSchemeResource.userMarcher("user"))));
        Assert.assertThat((Object)notificationScheme, TestNotificationSchemeResource.matchesScheme((Matcher<? super String>)Is.is((Object)SCHEME_NAME), TestNotificationSchemeResource.hasEvent(EventType.ISSUE_DELETED_ID, TestNotificationSchemeResource.projectRoleMatcher("Users"))));
    }

    @Test
    public void testProvidingInvalidExpandParameter() {
        PropertyAssertions.assertWebApplicationException(() -> {
            this.notificationSchemeClient.getNotificationScheme(Long.valueOf(0L), "user, zuo");
            return null;
        }, Response.Status.BAD_REQUEST, "Unrecognized expand parameter 'zuo', supported parameters are: " + Arrays.toString(NotificationSchemeExpandParam.values()));
    }

    @Test
    public void testGettingNotificationSchemeWithGroup() {
        String groupname = "groupname";
        Long eventId = EventType.ISSUE_DELETED_ID;
        Long newSchemeId = this.createNotificationScheme();
        this.backdoor.usersAndGroups().addGroup(groupname);
        this.notificationSchemesControl.addGroupNotification(newSchemeId, eventId.longValue(), groupname);
        NotificationSchemeBean notificationScheme = this.notificationSchemeClient.getNotificationScheme(newSchemeId, "group");
        Assert.assertThat((Object)notificationScheme, TestNotificationSchemeResource.matchesScheme((Matcher<? super String>)Is.is((Object)SCHEME_NAME), TestNotificationSchemeResource.hasEvent(eventId, TestNotificationSchemeResource.groupMatcher(groupname))));
    }

    @Test
    public void testGettingNotificationSchemeWithEmailAddress() {
        String emailAddress = "emailAddress";
        Long eventId = EventType.ISSUE_DELETED_ID;
        Long newSchemeId = this.createNotificationScheme();
        this.notificationSchemesControl.addEmailNotification(newSchemeId.longValue(), eventId.longValue(), emailAddress);
        NotificationSchemeBean notificationScheme = this.notificationSchemeClient.getNotificationScheme(newSchemeId, "notificationSchemeEvents");
        Assert.assertThat((Object)notificationScheme, TestNotificationSchemeResource.matchesScheme((Matcher<? super String>)Is.is((Object)SCHEME_NAME), TestNotificationSchemeResource.hasEvent(eventId, TestNotificationSchemeResource.emailAddressMatcher(emailAddress))));
    }

    @Test
    public void testGettingNotificationSchemeWithoutPermissions() {
        Long newSchemeId = this.createNotificationScheme();
        PropertyAssertions.assertWebApplicationException(() -> {
            ((NotificationSchemeClient)this.notificationSchemeClient.loginAs("fred")).getNotificationScheme(newSchemeId, "notificationSchemeEvents");
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testGettingNotificationSchemeAnonymously() {
        Long newSchemeId = this.createNotificationScheme();
        PropertyAssertions.assertWebApplicationException(() -> {
            ((NotificationSchemeClient)this.notificationSchemeClient.anonymous()).getNotificationScheme(newSchemeId, null);
            return null;
        }, Response.Status.UNAUTHORIZED);
    }

    @Test
    public void testGettingNotificationSchemeWhichDoesntExist() {
        PropertyAssertions.assertWebApplicationException(() -> {
            this.notificationSchemeClient.getNotificationScheme(Long.valueOf(-1L), null);
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testGettingNotificationSchemesPages() {
        int maxSize = 20;
        long total = 100L;
        List<String> allSchemeNames = this.createNotificationSchemes(IntStream.range(0, (int)total), " scheme");
        List expectedFirstPage = allSchemeNames.stream().limit(maxSize).map(TestNotificationSchemeResource::schemeNameMatcher).collect(Collectors.toList());
        NotificationSchemePageBean notificationSchemes = this.notificationSchemeClient.getNotificationSchemes(Integer.valueOf(0), Integer.valueOf(maxSize), null);
        Assert.assertThat((Object)notificationSchemes, PageBeanMatcher.matcher((Matcher<Long>)Is.is((Object)0L), (Matcher<Long>)Is.is((Object)total), (Matcher<Integer>)Is.is((Object)maxSize), Matchers.contains(expectedFirstPage)));
        int secondPageMaxSize = 50;
        NotificationSchemePageBean secondPage = this.notificationSchemeClient.getNotificationSchemes(Integer.valueOf(maxSize), Integer.valueOf(secondPageMaxSize), null);
        List expectedSecondPage = allSchemeNames.stream().skip(maxSize).limit(secondPageMaxSize).map(TestNotificationSchemeResource::schemeNameMatcher).collect(Collectors.toList());
        Assert.assertThat((Object)secondPage, PageBeanMatcher.matcher((Matcher<Long>)Is.is((Object)maxSize), (Matcher<Long>)Is.is((Object)total), (Matcher<Integer>)Is.is((Object)secondPageMaxSize), Matchers.contains(expectedSecondPage)));
    }

    @Test
    public void testGettingTooManyNotificationSchemes() {
        int total = 10;
        List<String> schemeNames = this.createNotificationSchemes(IntStream.range(0, total), " scheme");
        NotificationSchemePageBean notificationSchemes = this.notificationSchemeClient.getNotificationSchemes(Integer.valueOf(5), Integer.valueOf(total), null);
        List expectedPageContent = schemeNames.stream().skip(5L).limit(total).map(TestNotificationSchemeResource::schemeNameMatcher).collect(Collectors.toList());
        Assert.assertThat((Object)notificationSchemes, PageBeanMatcher.matcher((Matcher<Long>)Is.is((Object)5L), (Matcher<Long>)Is.is((Object)10L), (Matcher<Integer>)Is.is((Object)5), Matchers.contains(expectedPageContent)));
    }

    @Test
    public void testGettingEmptyNotificationSchemesPage() {
        NotificationSchemePageBean notificationSchemes = this.notificationSchemeClient.getNotificationSchemes(Integer.valueOf(10), Integer.valueOf(10), null);
        Assert.assertThat((Object)notificationSchemes, PageBeanMatcher.matcher((Matcher<Long>)Is.is((Object)10L), (Matcher<Long>)Is.is((Object)1L), (Matcher<Integer>)Is.is((Object)0), Matchers.emptyIterable()));
    }

    @Test
    public void testGettingNotificationSchemesPageRespectMaximum() {
        this.createNotificationSchemes(IntStream.range(0, 100), "scheme");
        NotificationSchemePageBean page = this.notificationSchemeClient.getNotificationSchemes(Integer.valueOf(0), Integer.valueOf(100), null);
        Assert.assertThat((Object)page, PageBeanMatcher.matcher((Matcher<Long>)Is.is((Object)0L), (Matcher<Long>)Is.is((Object)100L), (Matcher<Integer>)Is.is((Object)50), Matchers.not((Matcher)Matchers.emptyIterable())));
    }

    private List<String> createNotificationSchemes(IntStream range, String nameSuffix) {
        List<String> names = range.mapToObj(index -> index + nameSuffix).collect(Collectors.toList());
        names.forEach(this::createNotificationScheme);
        this.notificationSchemesControl.deleteScheme(10000L);
        return names.stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList());
    }

    private Long createNotificationScheme() {
        return this.createNotificationScheme(SCHEME_NAME);
    }

    private Long createNotificationScheme(String name) {
        return this.notificationSchemesControl.copyDefaultScheme(name);
    }

    private static Matcher<NotificationBean> simpleNotificationMatcher(String notificationTypeName) {
        return Matchers.hasProperty((String)"notificationType", (Matcher)Matchers.is((Object)notificationTypeName));
    }

    private static Matcher<NotificationSchemeBean> schemeNameMatcher(String name) {
        return Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)name));
    }

    private static Matcher<NotificationBean> userMarcher(String username) {
        Matcher userMatcher = Matchers.allOf((Matcher)Matchers.hasProperty((String)"parameter"), (Matcher)Matchers.hasProperty((String)"user", (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)username)), (Matcher)Matchers.hasProperty((String)"key"), (Matcher)Matchers.hasProperty((String)"self"))));
        return Matchers.both(TestNotificationSchemeResource.simpleNotificationMatcher("User")).and(userMatcher);
    }

    private static Matcher<NotificationBean> groupMatcher(String groupname) {
        Matcher groupMatcher = Matchers.allOf((Matcher)Matchers.hasProperty((String)"parameter", (Matcher)Matchers.is((Object)groupname)), (Matcher)Matchers.hasProperty((String)"group", (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)groupname)), (Matcher)Matchers.hasProperty((String)"self"))));
        return Matchers.both(TestNotificationSchemeResource.simpleNotificationMatcher("Group")).and(groupMatcher);
    }

    private static Matcher<NotificationBean> emailAddressMatcher(String emailAddress) {
        Matcher emailMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"emailAddress", (Matcher)Matchers.is((Object)emailAddress))});
        return Matchers.both(TestNotificationSchemeResource.simpleNotificationMatcher("EmailAddress")).and(emailMatcher);
    }

    private static Matcher<NotificationBean> projectRoleMatcher(String projectRoleName) {
        Matcher projectRoleMatcher = Matchers.allOf((Matcher)Matchers.hasProperty((String)"parameter"), (Matcher)Matchers.hasProperty((String)"projectRole", (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)projectRoleName)), (Matcher)Matchers.hasProperty((String)"self"), (Matcher)Matchers.hasProperty((String)"id"), (Matcher)Matchers.hasProperty((String)"description"))));
        return Matchers.both(TestNotificationSchemeResource.simpleNotificationMatcher("ProjectRole")).and(projectRoleMatcher);
    }

    private static Matcher<NotificationSchemeBean> matchesScheme(final Matcher<? super String> nameMatcher, final @Nullable Matcher<List<NotificationSchemeEventBean>> eventsMatcher) {
        return new TypeSafeMatcher<NotificationSchemeBean>(){

            protected boolean matchesSafely(NotificationSchemeBean notificationSchemeBean) {
                return nameMatcher.matches((Object)notificationSchemeBean.getName()) && (eventsMatcher == null || eventsMatcher.matches((Object)notificationSchemeBean.getNotificationSchemeEvents()));
            }

            public void describeTo(Description description) {
                description.appendValue((Object)eventsMatcher);
            }
        };
    }

    private static Matcher<List<NotificationSchemeEventBean>> hasEvent(final Long eventTypeId, final Matcher<NotificationBean> notificationBeanMatcher) {
        return new TypeSafeMatcher<List<NotificationSchemeEventBean>>(){

            protected boolean matchesSafely(List<NotificationSchemeEventBean> notificationSchemeEventBeans) {
                return notificationSchemeEventBeans.stream().anyMatch(bean -> bean.getEvent().getId().equals(eventTypeId) && Matchers.hasItem((Matcher)notificationBeanMatcher).matches((Object)bean.getNotifications()));
            }

            public void describeTo(Description description) {
                description.appendText("Notification scheme doesn't contain event wit id").appendValue((Object)eventTypeId);
            }
        };
    }
}

