/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.ReflectionMatchers;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.beans.PermissionGrantBean;
import com.atlassian.jira.testkit.beans.PermissionHolderBean;
import com.atlassian.jira.testkit.beans.PermissionSchemeAttributeBean;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.PermissionSchemesControl;
import com.atlassian.jira.testkit.client.restclient.GenericRestClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.PermissionSchemeRestClient;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public final class TestPermissionSchemeResource
extends BaseJiraRestTest {
    private static final String EXTENDED_ADMINISTER_PROJECTS_ENABLED_ATTRIBUTE = "ADMINISTER_PROJECTS.extended.enabled";
    private static final Long NON_EXISTING_SCHEME_ID = 123L;
    @Inject
    private com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;
    private PermissionSchemeRestClient client;
    private PermissionSchemesControl permissionSchemes;
    private GenericRestClient genericRestClient;

    @Before
    public void setUp() {
        this.client = (PermissionSchemeRestClient)new PermissionSchemeRestClient((JIRAEnvironmentData)this.environmentData).loginAs("admin", "admin");
        this.genericRestClient = (GenericRestClient)new GenericRestClient().loginAs("admin", "admin");
        this.permissionSchemes = this.backdoor.permissionSchemes();
        this.backdoor.restoreBlankInstance();
    }

    @Test
    public void defaultPermissionSchemeIsReturnedOnBlankInstance() {
        List permissionSchemes = ((PermissionSchemeRestClient.PermissionSchemeListBean)this.client.getSchemes((PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body).permissionSchemes;
        Assert.assertThat((Object)permissionSchemes, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((PermissionSchemeBean)permissionSchemes.get(0)).getName(), (Matcher)Matchers.equalTo((Object)"Default Permission Scheme"));
    }

    @Test
    public void permissionsAreNotExpandedByDefaultWhenGettingSingleScheme() {
        long schemeId = this.setUpPermissionSchemeWithExpandableHolders();
        Assert.assertThat((Object)this.client.getScheme((Long)Long.valueOf((long)schemeId), (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body, (Matcher)ReflectionMatchers.hasProperty((String)"permissions", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void getReturnsCorrectPermissionScheme() {
        Long schemeId = this.permissionSchemes.createScheme("new scheme", "scheme desc");
        this.permissionSchemes.addEveryonePermission(schemeId, ProjectPermissions.ADD_COMMENTS);
        this.permissionSchemes.addGroupPermission(schemeId, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        ParsedResponse scheme = this.client.getScheme(schemeId, new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.permissions});
        this.assertSchemeEquality((PermissionSchemeBean)scheme.body, new PermissionSchemeBean().setName("new scheme").setDescription("scheme desc").setPermissions((List)ImmutableList.of((Object)new PermissionGrantBean().setPermission("ADD_COMMENTS").setHolder(new PermissionHolderBean().setType("anyone")), (Object)new PermissionGrantBean().setPermission("ASSIGN_ISSUES").setHolder(new PermissionHolderBean().setType("group").setParameter("jira-developers")))));
    }

    @Test
    public void projectAdministratorGetsOnlySchemesWhichAreAssignedToProjectsHeAdministers() {
        Long scheme1 = this.permissionSchemes.createScheme("scheme1", "permission scheme of a project fred administers");
        Long scheme2 = this.permissionSchemes.createScheme("scheme2", "another permission scheme from a project fred administers");
        this.permissionSchemes.createScheme("scheme3", "permission fred cannot see");
        long projectId = this.backdoor.project().addProject("project", "PR", "admin");
        this.backdoor.project().setPermissionScheme(projectId, scheme1);
        this.backdoor.permissionSchemes().addUserPermission(scheme1.longValue(), ProjectPermissions.ADMINISTER_PROJECTS, "fred");
        long projectId2 = this.backdoor.project().addProject("another project", "PRA", "admin");
        this.backdoor.project().setPermissionScheme(projectId2, scheme2);
        this.backdoor.permissionSchemes().addUserPermission(scheme2.longValue(), ProjectPermissions.ADMINISTER_PROJECTS, "fred");
        List responseForFred = ((PermissionSchemeRestClient.PermissionSchemeListBean)((PermissionSchemeRestClient)this.client.loginAs((String)"fred")).getSchemes((PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body).permissionSchemes;
        Assert.assertThat((Object)responseForFred, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((PermissionSchemeBean)responseForFred.get(0)).getId(), (Matcher)Matchers.equalTo((Object)scheme1));
        Assert.assertThat((Object)((PermissionSchemeBean)responseForFred.get(1)).getId(), (Matcher)Matchers.equalTo((Object)scheme2));
        Assert.assertThat((Object)((PermissionSchemeRestClient.PermissionSchemeListBean)((PermissionSchemeRestClient)this.client.loginAs((String)"admin")).getSchemes((PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body).permissionSchemes, (Matcher)Matchers.hasSize((int)4));
    }

    @Test
    public void userCanGetPermissionSchemeIfTheyAdministerTheAssociatedProject() {
        Long scheme1 = this.permissionSchemes.createScheme("scheme1", "");
        long projectId = this.backdoor.project().addProject("project", "PR", "admin");
        this.backdoor.project().setPermissionScheme(projectId, scheme1);
        this.backdoor.permissionSchemes().addUserPermission(scheme1.longValue(), ProjectPermissions.ADMINISTER_PROJECTS, "fred");
        Assert.assertThat((Object)((PermissionSchemeBean)((PermissionSchemeRestClient)this.client.loginAs((String)"fred")).getScheme((Long)scheme1, (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.permissions}).body).getId(), (Matcher)Matchers.equalTo((Object)scheme1));
    }

    @Test
    public void notFoundResponseIsReturnedWhenUserDoesNotHavePermissionToViewAScheme() {
        Long scheme1 = this.permissionSchemes.createScheme("scheme1", "");
        Assert.assertThat((Object)((PermissionSchemeRestClient)this.client.loginAs((String)"fred")).getScheme((Long)scheme1, (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void creatingPermissionSchemeWorksCorrectly() {
        PermissionSchemeBean expectedScheme = new PermissionSchemeBean().setName("new scheme").setDescription("scheme desc").addPermission(new PermissionGrantBean().setPermission("ADMINISTER_PROJECTS").setHolder(new PermissionHolderBean().setType("group").setParameter("jira-administrators")));
        ParsedResponse createdScheme = this.client.createScheme(expectedScheme, new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.permissions});
        Assert.assertThat((Object)createdScheme.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
        this.assertSchemeEquality((PermissionSchemeBean)createdScheme.body, expectedScheme);
        this.assertSchemeEquality((PermissionSchemeBean)this.client.getScheme((Long)((PermissionSchemeBean)createdScheme.body).id, (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.permissions}).body, expectedScheme);
    }

    @Test
    public void permissionsAreNotAffectedWhenUpdatingOnlyNameAndDescription() {
        Long schemeId = this.permissionSchemes.createScheme("oldName", "oldDesc");
        this.permissionSchemes.addEveryonePermission(schemeId, ProjectPermissions.ADD_COMMENTS);
        this.client.updateScheme(schemeId, new PermissionSchemeBean().setName("newName").setDescription("newDesc"), new PermissionSchemeRestClient.Expand[0]);
        ParsedResponse scheme = this.client.getScheme(schemeId, new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.permissions});
        Assert.assertThat((Object)scheme.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getName(), (Matcher)Matchers.equalTo((Object)"newName"));
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getDescription(), (Matcher)Matchers.equalTo((Object)"newDesc"));
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getPermissions(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void entireSchemeIsUpdatedWhenPermissionListIsSpecified() {
        Long schemeId = this.permissionSchemes.createScheme("oldName", "oldDesc");
        this.permissionSchemes.addEveryonePermission(schemeId, ProjectPermissions.ADD_COMMENTS);
        this.permissionSchemes.addEveryonePermission(schemeId, ProjectPermissions.BROWSE_PROJECTS);
        this.client.updateScheme(schemeId, new PermissionSchemeBean().setName("newName").setDescription("newDesc").setPermissions((List)ImmutableList.of((Object)new PermissionGrantBean().setPermission("ADMINISTER_PROJECTS").setHolder(new PermissionHolderBean().setType("group").setParameter("jira-administrators")))), new PermissionSchemeRestClient.Expand[0]);
        ParsedResponse scheme = this.client.getScheme(schemeId, new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.permissions});
        Assert.assertThat((Object)scheme.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getName(), (Matcher)Matchers.equalTo((Object)"newName"));
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getDescription(), (Matcher)Matchers.equalTo((Object)"newDesc"));
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getPermissions(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((PermissionGrantBean)((PermissionSchemeBean)scheme.body).getPermissions().get(0)).getPermission(), (Matcher)Matchers.equalTo((Object)"ADMINISTER_PROJECTS"));
    }

    @Test
    public void updatingNonExistingPermissionReturns404() {
        Assert.assertThat((Object)this.client.updateScheme((Long)Long.valueOf((long)44L), (PermissionSchemeBean)new PermissionSchemeBean().setName((String)"name"), (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void deletingPermissionSchemeWorksCorrectly() {
        Long schemeId = this.permissionSchemes.createScheme("name", "desc");
        Assert.assertThat((Object)this.client.getScheme((Long)schemeId, (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        Assert.assertThat((Object)this.client.deleteScheme((Long)schemeId).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        Assert.assertThat((Object)this.client.getScheme((Long)schemeId, (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void gettingPermissionsReturnsCorrectResults() {
        Long schemeId = this.permissionSchemes.createScheme("name", "desc");
        this.permissionSchemes.addEveryonePermission(schemeId, ProjectPermissions.ADD_COMMENTS);
        this.permissionSchemes.addGroupPermission(schemeId, ProjectPermissions.ADMINISTER_PROJECTS, "jira-administrators");
        ParsedResponse permissions = this.client.getPermissions(schemeId, new PermissionSchemeRestClient.Expand[0]);
        Assert.assertThat((Object)((PermissionSchemeRestClient.PermissionGrantListBean)permissions.body).permissions, (Matcher)Matchers.hasSize((int)2));
        this.assertPermissionsEquality(((PermissionSchemeRestClient.PermissionGrantListBean)permissions.body).permissions, (Collection<PermissionGrantBean>)ImmutableList.of((Object)new PermissionGrantBean().setPermission("ADD_COMMENTS").setHolder(new PermissionHolderBean().setType("anyone")), (Object)new PermissionGrantBean().setPermission("ADMINISTER_PROJECTS").setHolder(new PermissionHolderBean().setType("group").setParameter("jira-administrators"))));
    }

    @Test
    public void creatingSinglePermissionWorksCorrectly() {
        Long schemeId = this.permissionSchemes.createScheme("name", "desc");
        ParsedResponse permission = this.client.createPermission(schemeId, new PermissionGrantBean().setPermission("ADD_COMMENTS").setHolder(new PermissionHolderBean().setType("anyone")), new PermissionSchemeRestClient.Expand[0]);
        Assert.assertThat((Object)permission.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
        ParsedResponse createdPermission = this.client.getPermission(schemeId, ((PermissionGrantBean)permission.body).getId(), new PermissionSchemeRestClient.Expand[0]);
        Assert.assertThat((Object)((PermissionGrantBean)createdPermission.body).getPermission(), (Matcher)Matchers.equalTo((Object)"ADD_COMMENTS"));
        Assert.assertThat((Object)((PermissionGrantBean)createdPermission.body).getHolder().getType(), (Matcher)Matchers.equalTo((Object)"anyone"));
        Assert.assertThat((Object)((PermissionSchemeRestClient.PermissionGrantListBean)this.client.getPermissions((Long)schemeId, (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body).permissions, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void deletingPermissionWorksCorrectly() {
        Long schemeId = this.permissionSchemes.createScheme("name", "desc");
        this.permissionSchemes.addEveryonePermission(schemeId, ProjectPermissions.ADD_COMMENTS);
        List permissions = ((PermissionSchemeRestClient.PermissionGrantListBean)this.client.getPermissions((Long)schemeId, (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body).permissions;
        Assert.assertThat((Object)permissions, (Matcher)Matchers.hasSize((int)1));
        ParsedResponse response = this.client.deletePermission(schemeId, ((PermissionGrantBean)permissions.get(0)).getId());
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        Assert.assertThat((Object)((PermissionSchemeRestClient.PermissionGrantListBean)this.client.getPermissions((Long)schemeId, (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body).permissions, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void deletingNonExistentPermissionReturns400() {
        Long schemeId = this.permissionSchemes.createScheme("name", "desc");
        ParsedResponse response = this.client.deletePermission(schemeId, Long.valueOf(23232L));
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void selfLinksAreCorrect() {
        Long id = this.permissionSchemes.createScheme("some scheme", "with description");
        this.permissionSchemes.addEveryonePermission(id, ProjectPermissions.CREATE_ISSUES);
        for (PermissionSchemeBean schemeBean : ((PermissionSchemeRestClient.PermissionSchemeListBean)this.client.getSchemes((PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body).permissionSchemes) {
            PermissionSchemeBean scheme = (PermissionSchemeBean)this.client.getScheme((Long)schemeBean.getId(), (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.permissions}).body;
            Assert.assertThat((Object)scheme.getId(), (Matcher)Matchers.equalTo((Object)((PermissionSchemeBean)this.genericRestClient.get((URI)schemeBean.getSelf(), PermissionSchemeBean.class).body).getId()));
            for (PermissionGrantBean permission : scheme.getPermissions()) {
                Assert.assertThat((Object)this.client.getPermission((Long)scheme.getId(), (Long)permission.getId(), (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body, (Matcher)Matchers.equalTo((Object)this.genericRestClient.get((URI)permission.getSelf(), PermissionGrantBean.class).body));
            }
        }
    }

    @Test
    public void anonymousGets401forAllOperations() {
        this.client.anonymous();
        this.assertNotAuthorizedResponse(this.client.createPermission(Long.valueOf(0L), new PermissionGrantBean(), new PermissionSchemeRestClient.Expand[0]));
        this.assertNotAuthorizedResponse(this.client.createScheme(new PermissionSchemeBean(), new PermissionSchemeRestClient.Expand[0]));
        this.assertNotAuthorizedResponse(this.client.deletePermission(Long.valueOf(0L), Long.valueOf(0L)));
        this.assertNotAuthorizedResponse(this.client.deletePermission(Long.valueOf(0L), Long.valueOf(0L)));
        this.assertNotAuthorizedResponse(this.client.getPermission(Long.valueOf(0L), Long.valueOf(0L), new PermissionSchemeRestClient.Expand[0]));
        this.assertNotAuthorizedResponse(this.client.getScheme(Long.valueOf(0L), new PermissionSchemeRestClient.Expand[0]));
        this.assertNotAuthorizedResponse(this.client.getAttribute(Long.valueOf(0L), "key"));
        this.assertNotAuthorizedResponse(this.client.setAttribute(Long.valueOf(0L), new PermissionSchemeAttributeBean("key", "value")));
    }

    @Test
    public void nonAdminGets403WhenEditingPermissionSchemes() {
        this.client.loginAs("fred");
        this.assertForbiddenResponse(this.client.createPermission(Long.valueOf(0L), new PermissionGrantBean().setPermission("NOT_IMPORTANT").setHolder(new PermissionHolderBean().setType("anyone")), new PermissionSchemeRestClient.Expand[0]));
        this.assertForbiddenResponse(this.client.createScheme(new PermissionSchemeBean().setName("name"), new PermissionSchemeRestClient.Expand[0]));
        this.assertForbiddenResponse(this.client.deletePermission(Long.valueOf(0L), Long.valueOf(0L)));
        this.assertForbiddenResponse(this.client.getAttribute(Long.valueOf(0L), "key"));
        this.assertForbiddenResponse(this.client.setAttribute(Long.valueOf(0L), new PermissionSchemeAttributeBean("key", "value")));
    }

    @Test
    public void invalidInputIsHandledCorrectly() {
        this.assertInvalidInput(new PermissionSchemeBean(), "name", "Required field 'name' was not provided");
        this.assertInvalidInput(this.perfectEntity().setPermission(null), "permission", "Required field 'permission' was not provided");
        this.assertInvalidInput(this.perfectEntity().setPermission("NON_EXISTENT"), "permission", "Unrecognized permission: NON_EXISTENT");
        this.assertInvalidInput(this.perfectEntity().setHolder(new PermissionHolderBean().setType("anyone").setParameter("aa")), "holder.parameter", "Parameter must not be set for holder type: anyone");
        this.assertInvalidInput(this.perfectEntity().setHolder(new PermissionHolderBean().setType("group")), "holder.parameter", "Parameter is required for holder type: group");
        this.assertInvalidInput(this.perfectEntity().setHolder(new PermissionHolderBean().setType("aaa")), "holder.type", "Unrecognized permission holder type: aaa");
        this.assertInvalidInput(this.perfectEntity().setHolder(new PermissionHolderBean()), "holder.type", "Unrecognized holder type: null");
        this.assertInvalidInput(this.perfectEntity().setHolder(null), "holder.type", "Unrecognized holder type: null");
    }

    @Test
    public void creatingSchemeWithAlreadyExistingNameResultsInBadRequestReponse() {
        this.assertInvalidInput(new PermissionSchemeBean().setName("Default Permission Scheme"), null, "Permission scheme with name 'Default Permission Scheme' already exists");
    }

    @Test
    public void tryingToGrantPermissionToNonExistentGroupResultsInInvalidRequest() {
        this.assertInvalidInput(this.perfectEntity().setHolder(new PermissionHolderBean().setType("group").setParameter("non-existent group")), "holder.parameter", "Group 'non-existent group' does not exist");
    }

    @Test
    public void creatingPermissionWhichAlreadyExistsShouldResultIn400() {
        Long schemeId = this.permissionSchemes.createScheme("scheme", "desc");
        this.permissionSchemes.addEveryonePermission(schemeId, ProjectPermissions.ADD_COMMENTS);
        ParsedResponse result = this.client.createPermission(schemeId, new PermissionGrantBean().setPermission("ADD_COMMENTS").setHolder(new PermissionHolderBean().setType("anyone")), new PermissionSchemeRestClient.Expand[0]);
        Assert.assertThat((Object)result.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        Assert.assertThat((Object)result.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"Permission ADD_COMMENTS for ANYONE (parameter: null) already exists in scheme 10000"));
    }

    @Test
    public void everythingIsExpandedWhenExpandingAll() {
        long schemeId = this.setUpPermissionSchemeWithExpandableHolders();
        ParsedResponse scheme = this.client.getScheme(Long.valueOf(schemeId), new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.all});
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getPermissions(), (Matcher)TestPermissionSchemeResource.hasEverythingExpanded());
    }

    @Test
    public void onlySpecifiedTypesAreExpanded() {
        Long schemeId = this.setUpPermissionSchemeWithExpandableHolders();
        ParsedResponse scheme = this.client.getScheme(schemeId, new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.user, PermissionSchemeRestClient.Expand.projectRole});
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getPermissions(), (Matcher)Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"holder.user.name", (Matcher)Matchers.equalTo((Object)"admin"))));
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getPermissions(), (Matcher)Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"holder.projectRole.name", (Matcher)Matchers.equalTo((Object)"Users"))));
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getPermissions(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"holder.user.field", (Matcher)Matchers.not((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)((PermissionSchemeBean)scheme.body).getPermissions(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"holder.user.group", (Matcher)Matchers.not((Matcher)Matchers.nullValue())))));
    }

    @Test
    public void permissionsCanBeExpandedWhenGettingAllPermissionSchemes() {
        Assert.assertThat((Object)((PermissionSchemeRestClient.PermissionSchemeListBean)this.client.getSchemes((PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body).permissionSchemes, (Matcher)Matchers.contains((Matcher)ReflectionMatchers.hasProperty((String)"permissions", (Matcher)Matchers.nullValue())));
        Assert.assertThat((Object)((PermissionSchemeRestClient.PermissionSchemeListBean)this.client.getSchemes((PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.permissions}).body).permissionSchemes, (Matcher)Matchers.contains((Matcher)ReflectionMatchers.hasProperty((String)"permissions", (Matcher)Matchers.not((Matcher)Matchers.nullValue()))));
    }

    @Test
    public void permissionsAreExpandedIfAnyExpandParameterIsSpecifiedWhenGettingAllPermissionSchemes() {
        this.setUpPermissionSchemeWithExpandableHolders();
        Assert.assertThat((Object)((PermissionSchemeRestClient.PermissionSchemeListBean)this.client.getSchemes((PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.user}).body).permissionSchemes, (Matcher)Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"permissions", (Matcher)Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"holder.user.name", (Matcher)Matchers.equalTo((Object)"admin"))))));
        Assert.assertThat((Object)((PermissionSchemeRestClient.PermissionSchemeListBean)this.client.getSchemes((PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.all}).body).permissionSchemes, (Matcher)Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"permissions", (Matcher)TestPermissionSchemeResource.hasEverythingExpanded())));
    }

    @Test
    public void holdersCanBeExpandedWhenCreatingNewPermissionGrant() {
        long schemeId = this.setUpPermissionSchemeWithExpandableHolders();
        PermissionGrantBean grant = new PermissionGrantBean().setPermission("ADMINISTER_PROJECTS").setHolder(new PermissionHolderBean().setType("group").setParameter("jira-developers"));
        ParsedResponse createdPermission = this.client.createPermission(Long.valueOf(schemeId), grant, new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.group});
        Assert.assertThat((Object)createdPermission.body, (Matcher)ReflectionMatchers.hasProperty((String)"holder.group.name", (Matcher)Matchers.equalTo((Object)"jira-developers")));
    }

    @Test
    public void holdersCanBeExpandedWhenCreatingNewPermissionScheme() {
        PermissionSchemeBean newScheme = new PermissionSchemeBean().setName("name").setPermissions((List)ImmutableList.of((Object)new PermissionGrantBean().setPermission("ADMINISTER_PROJECTS").setHolder(new PermissionHolderBean().setType("group").setParameter("jira-developers"))));
        ParsedResponse createdScheme = this.client.createScheme(newScheme, new PermissionSchemeRestClient.Expand[]{PermissionSchemeRestClient.Expand.group});
        Assert.assertThat((Object)((PermissionSchemeBean)createdScheme.body).getPermissions(), (Matcher)Matchers.contains((Matcher)ReflectionMatchers.hasProperty((String)"holder.group.name", (Matcher)Matchers.equalTo((Object)"jira-developers"))));
    }

    @Test
    public void shouldReturnDefaultAttribute() {
        ParsedResponse response = this.client.getAttribute(Long.valueOf(0L), EXTENDED_ADMINISTER_PROJECTS_ENABLED_ATTRIBUTE);
        Assert.assertThat((Object)((PermissionSchemeAttributeBean)response.body).getKey(), (Matcher)Matchers.equalTo((Object)EXTENDED_ADMINISTER_PROJECTS_ENABLED_ATTRIBUTE));
        Assert.assertThat((Object)((PermissionSchemeAttributeBean)response.body).getValue(), (Matcher)Matchers.equalTo((Object)"true"));
    }

    @Test
    public void shouldReturnNotFoundWhenAskedForNonExistingAttribute() {
        ParsedResponse response = this.client.getAttribute(Long.valueOf(0L), "fake-attribute");
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void shouldUpdateAndReturnDefaultAttribute() {
        String key = EXTENDED_ADMINISTER_PROJECTS_ENABLED_ATTRIBUTE;
        PermissionSchemeAttributeBean newAttribute = new PermissionSchemeAttributeBean(EXTENDED_ADMINISTER_PROJECTS_ENABLED_ATTRIBUTE, "false");
        ParsedResponse responseForPUT = this.client.setAttribute(Long.valueOf(0L), newAttribute);
        Assert.assertThat((Object)responseForPUT.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        ParsedResponse responseForGET = this.client.getAttribute(Long.valueOf(0L), EXTENDED_ADMINISTER_PROJECTS_ENABLED_ATTRIBUTE);
        Assert.assertThat((Object)responseForGET.body, (Matcher)Matchers.equalTo((Object)newAttribute));
    }

    @Test
    public void shouldInsertAndReturnAttribute() {
        String key = "some-new-attribute";
        PermissionSchemeAttributeBean newAttribute = new PermissionSchemeAttributeBean("some-new-attribute", "true");
        ParsedResponse responseForPUT = this.client.setAttribute(Long.valueOf(0L), newAttribute);
        Assert.assertThat((Object)responseForPUT.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        ParsedResponse responseForGET = this.client.getAttribute(Long.valueOf(0L), "some-new-attribute");
        Assert.assertThat((Object)responseForGET.body, (Matcher)Matchers.equalTo((Object)newAttribute));
    }

    @Test
    public void shouldReturnNotFoundForGettingValueWhenSchemeDoesNotExist() {
        ParsedResponse response = this.client.getAttribute(NON_EXISTING_SCHEME_ID, EXTENDED_ADMINISTER_PROJECTS_ENABLED_ATTRIBUTE);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void shouldReturnNotFoundForUpdatingValueWhenSchemeDoesNotExist() {
        PermissionSchemeAttributeBean attributeBean = new PermissionSchemeAttributeBean(EXTENDED_ADMINISTER_PROJECTS_ENABLED_ATTRIBUTE, "true");
        ParsedResponse response = this.client.setAttribute(NON_EXISTING_SCHEME_ID, attributeBean);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    private static Matcher hasEverythingExpanded() {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"holder.group.name", (Matcher)Matchers.equalTo((Object)"jira-developers"))), Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"holder.user.name", (Matcher)Matchers.equalTo((Object)"admin"))), Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"holder.field.name", (Matcher)Matchers.equalTo((Object)"user-custom-field"))), Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"holder.field.name", (Matcher)Matchers.equalTo((Object)"group-custom-field"))), Matchers.hasItem((Matcher)ReflectionMatchers.hasProperty((String)"holder.projectRole.name", (Matcher)Matchers.equalTo((Object)"Users")))});
    }

    private String fieldType(String actualType) {
        return CustomFields.builtInCustomFieldKey(actualType);
    }

    private void assertInvalidInput(PermissionGrantBean bean, String field, String message) {
        ParsedResponse response = this.client.createPermission(Long.valueOf(0L), bean, new PermissionSchemeRestClient.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        Assert.assertThat((Object)response.entity.errors, (Matcher)Matchers.hasEntry((Object)field, (Object)message));
    }

    private void assertInvalidInput(PermissionSchemeBean bean, String field, String message) {
        ParsedResponse response = this.client.createScheme(bean, new PermissionSchemeRestClient.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        if (field != null) {
            Assert.assertThat((Object)response.entity.errors, (Matcher)Matchers.hasEntry((Object)field, (Object)message));
        } else {
            Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.hasItem((Object)message));
        }
    }

    private PermissionGrantBean perfectEntity() {
        return new PermissionGrantBean().setPermission("ADD_COMMENTS").setHolder(new PermissionHolderBean().setType("anyone"));
    }

    private void assertNotAuthorizedResponse(ParsedResponse<?> response) {
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.UNAUTHORIZED.getStatusCode()));
    }

    private void assertForbiddenResponse(ParsedResponse<?> response) {
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    private void assertSchemeEquality(PermissionSchemeBean actual, PermissionSchemeBean expected) {
        Assert.assertThat((Object)actual.name, (Matcher)Matchers.equalTo((Object)expected.getName()));
        Assert.assertThat((Object)actual.description, (Matcher)Matchers.equalTo((Object)expected.getDescription()));
        this.assertPermissionsEquality(actual.getPermissions(), expected.getPermissions());
    }

    private void assertPermissionsEquality(Collection<PermissionGrantBean> actual, Collection<PermissionGrantBean> expected) {
        for (PermissionGrantBean expectedEntity : expected) {
            Assert.assertThat(actual, (Matcher)Matchers.hasItem(this.grantEqualTo(expectedEntity)));
        }
        Assert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
    }

    private Matcher<PermissionGrantBean> grantEqualTo(final PermissionGrantBean expectedEntity) {
        return new TypeSafeMatcher<PermissionGrantBean>(){

            protected boolean matchesSafely(PermissionGrantBean item) {
                return item.getHolder().equals((Object)expectedEntity.getHolder()) && item.getPermission().equals(expectedEntity.getPermission());
            }

            public void describeTo(Description description) {
                description.appendText(expectedEntity.toString());
            }
        };
    }

    private long setUpPermissionSchemeWithExpandableHolders() {
        String userField = this.backdoor.customFields().createCustomField("user-custom-field", "desc", this.fieldType("userpicker"), null);
        String groupField = this.backdoor.customFields().createCustomField("group-custom-field", "desc2", this.fieldType("grouppicker"), null);
        Long schemeId = this.permissionSchemes.createScheme("scheme", "desc");
        this.permissionSchemes.addGroupPermission(schemeId, ProjectPermissions.ADD_COMMENTS, "jira-developers");
        this.permissionSchemes.addUserPermission(schemeId.longValue(), ProjectPermissions.ADD_COMMENTS, "admin");
        this.permissionSchemes.addUserCustomFieldPermission(schemeId, ProjectPermissions.ADD_COMMENTS, userField);
        this.permissionSchemes.addGroupCustomFieldPermission(schemeId, ProjectPermissions.ADD_COMMENTS, groupField);
        this.permissionSchemes.addProjectRolePermission(schemeId.longValue(), ProjectPermissions.ADD_COMMENTS, 10000L);
        return schemeId;
    }
}

