/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.PermissionMatcher;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.v2.permission.UserPermissionJsonBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestPermissionsRest.xml")
public class TestPermissionsResource
extends BaseJiraRestTest {
    private PermissionsClient permissionsClient;

    @Before
    public void setUpTest() {
        this.permissionsClient = new PermissionsClient(this.environmentData);
        this.backdoor.plugins().disablePluginModule("com.atlassian.jira.dev.func-test-plugin:func.test.global.permission");
        this.backdoor.plugins().enablePluginModule("com.atlassian.jira.dev.func-test-plugin:func.test.global.permission");
    }

    @Test
    public void testPermissionsEndpointIsForAdministratorsOnly() {
        ParsedResponse allPermissionsForAnon = ((PermissionsClient)this.permissionsClient.anonymous()).getAllPermissions();
        Assert.assertEquals((long)allPermissionsForAnon.statusCode, (long)401L);
        this.backdoor.usersAndGroups().addUser("non-admin-user");
        ParsedResponse allPermissionsForUser = ((PermissionsClient)this.permissionsClient.loginAs("non-admin-user")).getAllPermissions();
        Assert.assertEquals((long)allPermissionsForUser.statusCode, (long)403L);
    }

    @Test
    public void testCustomPermissionIsReturnedByAllPermissionsEndpoint() {
        ParsedResponse outer = this.permissionsClient.getAllPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("func.test.global.permission"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.key("func.test.global.permission"), PermissionMatcher.name("func.test.global.permission.name"), PermissionMatcher.type("GLOBAL"), PermissionMatcher.description("func.test.global.permission.description")}));
    }

    @Test
    public void testGlobalPermissionsAreReturnedByAllPermissionsEndpoint() {
        ParsedResponse outer = this.permissionsClient.getAllPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("SYSTEM_ADMIN"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.key("SYSTEM_ADMIN"), PermissionMatcher.name("Jira System Administrators"), PermissionMatcher.type("GLOBAL"), PermissionMatcher.hasNotEmptyDescription()}));
    }

    @Test
    public void testProjectPermissionsAreReturnedByAllPermissionsEndpoint() {
        ParsedResponse outer = this.permissionsClient.getAllPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("LINK_ISSUES"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.key("LINK_ISSUES"), PermissionMatcher.name("Link Issues"), PermissionMatcher.type("PROJECT"), PermissionMatcher.hasNotEmptyDescription()}));
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("BROWSE_PROJECTS"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.key("BROWSE_PROJECTS"), PermissionMatcher.name("Browse Projects"), PermissionMatcher.type("PROJECT"), PermissionMatcher.hasNotEmptyDescription()}));
    }

    @Test
    public void testCustomProjectPermissionsAreReturnedByAllPermissionsEndpoint() {
        ParsedResponse outer = this.permissionsClient.getAllPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("func.test.project.permission"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.key("func.test.project.permission"), PermissionMatcher.name("func.test.project.permission.name"), PermissionMatcher.type("PROJECT"), PermissionMatcher.description("func.test.project.permission.description")}));
    }

    @Test
    public void testGlobalPermissions() {
        ParsedResponse outer = this.permissionsClient.getPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("ADMINISTER"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.key("ADMINISTER"), PermissionMatcher.id("0"), PermissionMatcher.name("Jira Administrators"), PermissionMatcher.type("GLOBAL"), PermissionMatcher.description("Ability to perform most administration functions (excluding Import & Export, SMTP Configuration, etc.)."), PermissionMatcher.deprecatedKey(null), PermissionMatcher.havePermission(true)}));
        outer = ((PermissionsClient)this.permissionsClient.loginAs("user", "user")).getPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("ADMINISTER"), PermissionMatcher.havePermission(false));
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("func.test.global.permission"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.key("func.test.global.permission"), PermissionMatcher.name("func.test.global.permission.name"), PermissionMatcher.type("GLOBAL"), PermissionMatcher.description("func.test.global.permission.description"), PermissionMatcher.deprecatedKey(null), PermissionMatcher.havePermission(false)}));
    }

    @Test
    public void testGetLegacyProjectPermissions() {
        ParsedResponse outer = this.permissionsClient.getPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("BROWSE"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("10"), PermissionMatcher.key("BROWSE"), PermissionMatcher.name("Browse Projects"), PermissionMatcher.type("PROJECT"), PermissionMatcher.description("Ability to browse projects and the issues within them."), PermissionMatcher.deprecatedKey(true), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("COMMENT_ISSUE"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("15"), PermissionMatcher.key("COMMENT_ISSUE"), PermissionMatcher.name("Add Comments"), PermissionMatcher.type("PROJECT"), PermissionMatcher.description("Ability to comment on issues."), PermissionMatcher.deprecatedKey(true), PermissionMatcher.havePermission(true)}));
        outer = ((PermissionsClient)this.permissionsClient.loginAs("user", "user")).getPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("BROWSE"), PermissionMatcher.havePermission(false));
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("COMMENT_ISSUE"), PermissionMatcher.havePermission(false));
    }

    @Test
    public void testGetAnonymousUserPermissions() {
        ParsedResponse result = ((PermissionsClient)this.permissionsClient.anonymous()).getPermissions();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.statusCode, (Matcher)Matchers.is((Object)401));
    }

    @Test
    public void testGetProjectPermissions() {
        ParsedResponse outer = this.permissionsClient.getPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("10"), PermissionMatcher.key(ProjectPermissions.BROWSE_PROJECTS.permissionKey()), PermissionMatcher.name("Browse Projects"), PermissionMatcher.type("PROJECT"), PermissionMatcher.description("Ability to browse projects and the issues within them."), PermissionMatcher.deprecatedKey(null), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.ADD_COMMENTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("15"), PermissionMatcher.key(ProjectPermissions.ADD_COMMENTS.permissionKey()), PermissionMatcher.name("Add Comments"), PermissionMatcher.type("PROJECT"), PermissionMatcher.description("Ability to comment on issues."), PermissionMatcher.deprecatedKey(null), PermissionMatcher.havePermission(true)}));
        outer = ((PermissionsClient)this.permissionsClient.loginAs("user", "user")).getPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey()), PermissionMatcher.havePermission(false));
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.ADD_COMMENTS.permissionKey()), PermissionMatcher.havePermission(false));
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("func.test.global.permission"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.key("func.test.global.permission"), PermissionMatcher.name("func.test.global.permission.name"), PermissionMatcher.type("GLOBAL"), PermissionMatcher.description("func.test.global.permission.description"), PermissionMatcher.deprecatedKey(null), PermissionMatcher.havePermission(false)}));
    }

    @Test
    public void testLegacyProjectFilter() {
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"projectKey", (Object)"PROJECTA")).body).permissions.get("BROWSE"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("10"), PermissionMatcher.name("Browse Projects"), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"projectKey", (Object)"PROJECTB")).body).permissions.get("BROWSE"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("10"), PermissionMatcher.name("Browse Projects"), PermissionMatcher.havePermission(false)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"projectId", (Object)"10000")).body).permissions.get("BROWSE"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("10"), PermissionMatcher.name("Browse Projects"), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"projectId", (Object)"10001")).body).permissions.get("BROWSE"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("10"), PermissionMatcher.name("Browse Projects"), PermissionMatcher.havePermission(false)}));
    }

    @Test
    public void testProjectFilter() {
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"projectKey", (Object)"PROJECTA")).body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("10"), PermissionMatcher.name("Browse Projects"), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"projectKey", (Object)"PROJECTB")).body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("10"), PermissionMatcher.name("Browse Projects"), PermissionMatcher.havePermission(false)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"projectId", (Object)"10000")).body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("10"), PermissionMatcher.name("Browse Projects"), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"projectId", (Object)"10001")).body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("10"), PermissionMatcher.name("Browse Projects"), PermissionMatcher.havePermission(false)}));
    }

    @Test
    public void testLegacyIssueFiltering() {
        ParsedResponse outer = this.permissionsClient.getPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get("COMMENT_DELETE_ALL"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key("COMMENT_DELETE_ALL"), PermissionMatcher.name("Delete All Comments"), PermissionMatcher.type("PROJECT"), PermissionMatcher.description("Ability to delete all comments made on issues."), PermissionMatcher.deprecatedKey(true), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"projectKey", (Object)"PROJECTA")).body).permissions.get("COMMENT_DELETE_ALL"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key("COMMENT_DELETE_ALL"), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"issueKey", (Object)"PROJECTA-3")).body).permissions.get("COMMENT_DELETE_ALL"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key("COMMENT_DELETE_ALL"), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"issueKey", (Object)"PROJECTA-4")).body).permissions.get("COMMENT_DELETE_ALL"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key("COMMENT_DELETE_ALL"), PermissionMatcher.havePermission(false)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"issueId", (Object)"10200")).body).permissions.get("COMMENT_DELETE_ALL"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key("COMMENT_DELETE_ALL"), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"issueId", (Object)"10201")).body).permissions.get("COMMENT_DELETE_ALL"), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key("COMMENT_DELETE_ALL"), PermissionMatcher.havePermission(false)}));
    }

    @Test
    public void testIssueFiltering() {
        ParsedResponse outer = this.permissionsClient.getPermissions();
        Assert.assertThat((Object)((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), PermissionMatcher.name("Delete All Comments"), PermissionMatcher.type("PROJECT"), PermissionMatcher.description("Ability to delete all comments made on issues."), PermissionMatcher.deprecatedKey(null), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"projectKey", (Object)"PROJECTA")).body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"issueKey", (Object)"PROJECTA-3")).body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"issueKey", (Object)"PROJECTA-4")).body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), PermissionMatcher.havePermission(false)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"issueId", (Object)"10200")).body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), PermissionMatcher.havePermission(true)}));
        Assert.assertThat((Object)((PermissionsOuter)((PermissionsClient)this.permissionsClient).getPermissions((Map)ImmutableMap.of((Object)"issueId", (Object)"10201")).body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{PermissionMatcher.id("36"), PermissionMatcher.key(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey()), PermissionMatcher.havePermission(false)}));
    }

    private static class PermissionsOuter {
        @JsonProperty
        HashMap<String, UserPermissionJsonBean> permissions;

        private PermissionsOuter() {
        }
    }

    private class PermissionsClient
    extends RestApiClient<PermissionsClient> {
        protected PermissionsClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
        }

        private ParsedResponse<PermissionsOuter> getPermissions() {
            return this.toResponse(new RestApiClient.RestCall(){

                public Response call() {
                    return (Response)PermissionsClient.this.createResource().path("mypermissions").request().get(Response.class);
                }
            }, PermissionsOuter.class);
        }

        private ParsedResponse<PermissionsOuter> getPermissions(final Map<String, String> params) {
            return this.toResponse(new RestApiClient.RestCall(){

                public Response call() {
                    WebTarget path = PermissionsClient.this.createResource().path("mypermissions");
                    for (Map.Entry entry : params.entrySet()) {
                        path = path.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
                    }
                    return (Response)path.request().get(Response.class);
                }
            }, PermissionsOuter.class);
        }

        private ParsedResponse<PermissionsOuter> getAllPermissions() {
            return this.toResponse(new RestApiClient.RestCall(){

                public Response call() {
                    return (Response)PermissionsClient.this.createResource().path("permissions").request().get(Response.class);
                }
            }, PermissionsOuter.class);
        }
    }
}

