/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.PinCommentClient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestPinningViaCommentResource
extends BaseJiraRestTest {
    private static final FeatureFlag PIN_COMMENT_FLAG = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.PIN_COMMENTS.featureKey());
    private static final int MAX_PINNED_COMMENTS = 5;
    private static final String TEST_COMMENT_PERMISSIONS_XML_RESOURCE = "TestCommentPermissions.xml";
    public static final String ISSUE_KEY = "RAT-2";
    public static final String COMMENT_ID = "10002";
    private PinCommentClient pinCommentClient;
    private boolean featureEnabled;

    @Before
    public void setUpTest() {
        this.pinCommentClient = new PinCommentClient(this.environmentData);
        this.backdoor.restoreDataFromResource(TEST_COMMENT_PERMISSIONS_XML_RESOURCE);
        this.featureEnabled = this.backdoor.darkFeatures().isGlobalEnabled(PIN_COMMENT_FLAG);
        if (!this.featureEnabled) {
            this.backdoor.darkFeatures().enableForSite(PIN_COMMENT_FLAG);
        }
    }

    @After
    public void tearDownTest() {
        if (!this.featureEnabled) {
            this.backdoor.darkFeatures().disableForSite(PIN_COMMENT_FLAG);
        }
    }

    @Test
    public void testPinUnPinCommentWorks() {
        this.assertGetPinnedCommentsSuccessResponse(this.pinCommentClient.getPinnedComments(ISSUE_KEY), 0);
        this.assertPinCommentSuccessResponse(this.pinCommentClient.pinComment(ISSUE_KEY, COMMENT_ID, true));
        this.assertGetPinnedCommentsSuccessResponse(this.pinCommentClient.getPinnedComments(ISSUE_KEY), 1);
        this.assertPinCommentSuccessResponse(this.pinCommentClient.pinComment(ISSUE_KEY, COMMENT_ID, false));
        this.assertGetPinnedCommentsSuccessResponse(this.pinCommentClient.getPinnedComments(ISSUE_KEY), 0);
    }

    @Test
    public void testPinFailsWithoutPermission() {
        this.pinCommentClient.anonymous();
        this.assertPinCommentFailureResponse(this.pinCommentClient.pinComment(ISSUE_KEY, COMMENT_ID, true), HttpStatus.UNAUTHORIZED.code, Lists.newArrayList((Object[])new String[]{"You do not have the permission to pin comments on this issue."}));
    }

    @Test
    public void testPinFailsOverMaxPinnedComments() {
        int i;
        this.assertGetPinnedCommentsSuccessResponse(this.pinCommentClient.getPinnedComments(ISSUE_KEY), 0);
        for (i = 0; i < 5; ++i) {
            String commentId = ((Comment)this.addComment().body).id;
            this.assertPinCommentSuccessResponse(this.pinCommentClient.pinComment(ISSUE_KEY, commentId, true));
            this.assertGetPinnedCommentsSuccessResponse(this.pinCommentClient.getPinnedComments(ISSUE_KEY), i + 1);
        }
        this.assertGetPinnedCommentsSuccessResponse(this.pinCommentClient.getPinnedComments(ISSUE_KEY), 5);
        for (i = 0; i < 2; ++i) {
            this.addComment();
            this.assertGetPinnedCommentsSuccessResponse(this.pinCommentClient.getPinnedComments(ISSUE_KEY), 5);
        }
        String commentId2 = ((Comment)this.addComment().body).id;
        this.assertPinCommentFailureResponse(this.pinCommentClient.pinComment(ISSUE_KEY, commentId2, true), HttpStatus.CONFLICT.code, Lists.newArrayList((Object[])new String[]{"Pinned comment limit reached."}));
        this.assertGetPinnedCommentsSuccessResponse(this.pinCommentClient.getPinnedComments(ISSUE_KEY), 5);
    }

    private ParsedResponse<Comment> addComment() {
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        ParsedResponse post = this.pinCommentClient.post(ISSUE_KEY, newComment);
        Assert.assertNotNull((Object)post);
        Assert.assertEquals((long)HttpStatus.CREATED.code, (long)post.statusCode);
        Assert.assertNotNull((Object)post.body);
        return post;
    }

    private void assertPinCommentSuccessResponse(Response response) {
        Assert.assertEquals((long)HttpStatus.OK.code, (long)response.getStatus());
    }

    private void assertPinCommentFailureResponse(Response response, int statusCode, ArrayList<String> errorMessages) {
        Assert.assertEquals((long)statusCode, (long)response.getStatus());
        Assert.assertTrue((boolean)response.hasEntity());
        Errors errors = (Errors)response.readEntity(Errors.class);
        Assert.assertEquals((long)errorMessages.size(), (long)errors.errorMessages.size());
        Assert.assertTrue((boolean)errors.errorMessages.containsAll(errorMessages));
    }

    private void assertGetPinnedCommentsSuccessResponse(ParsedResponse<List<Comment>> response, int expected) {
        Assert.assertEquals((long)HttpStatus.OK.code, (long)response.statusCode);
        Assert.assertNull((Object)response.entity);
        Assert.assertNotNull((Object)response.body);
        List body = (List)response.body;
        Assert.assertEquals((long)expected, (long)body.size());
    }
}

