/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Priority;
import com.atlassian.jira.testkit.client.restclient.PriorityClient;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestPriorityResource
extends BaseJiraRestTest {
    private static final long PERMISSION_SCHEME_ID = 0L;
    private static final String PRIORITY_ID = "1";
    private PriorityClient priorityClient;

    @Before
    public void setUp() {
        this.priorityClient = new PriorityClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testAllPriorities() {
        List priorities = this.priorityClient.get();
        this.assertPrioritiesAreValid(priorities);
    }

    @Test
    public void testAllPrioritiesAnonymously() {
        ParsedResponse response = ((PriorityClient)this.priorityClient.anonymous()).getResponse();
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testAllPrioritiesAnonymouslyWithFFDisabledButProjectsVisible() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        List priorities = ((PriorityClient)this.priorityClient.anonymous()).get();
        this.assertPrioritiesAreValid(priorities);
    }

    @Test
    public void testViewPriority() {
        Priority priority = this.priorityClient.get(PRIORITY_ID);
        this.assertPriorityIsValid(priority);
    }

    @Test
    public void testViewPriorityAnonymously() {
        ParsedResponse response = ((PriorityClient)this.priorityClient.anonymous()).getResponse(PRIORITY_ID);
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testViewPriorityAnonymouslyWithFFDisabledButProjectsVisible() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        Priority priority = ((PriorityClient)this.priorityClient.anonymous()).get(PRIORITY_ID);
        this.assertPriorityIsValid(priority);
    }

    @Test
    public void testViewPriorityNotFound() {
        ParsedResponse resp123 = this.priorityClient.getResponse("123");
        Assert.assertEquals((long)404L, (long)resp123.statusCode);
        Assert.assertEquals((long)1L, (long)resp123.entity.errorMessages.size());
        Assert.assertTrue((boolean)resp123.entity.errorMessages.contains("The priority with id '123' does not exist"));
        ParsedResponse respFoo = this.priorityClient.getResponse("foo");
        Assert.assertEquals((long)404L, (long)respFoo.statusCode);
        Assert.assertTrue((boolean)respFoo.entity.errorMessages.contains("The priority with id 'foo' does not exist"));
    }

    private void assertPriorityIsValid(Priority priority) {
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/priority/" + PRIORITY_ID), (Object)priority.self());
        Assert.assertEquals((Object)"#cc0000", (Object)priority.statusColor());
        Assert.assertEquals((Object)"Blocks development and/or testing work, production could not run.", (Object)priority.description());
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/images/icons/priorities/blocker.svg"), (Object)priority.iconUrl());
        Assert.assertEquals((Object)"Blocker", (Object)priority.name());
        Assert.assertEquals((Object)PRIORITY_ID, (Object)priority.id());
    }

    private void assertPrioritiesAreValid(List<Priority> priorities) {
        this.assertPrioritiesContain(priorities, PRIORITY_ID);
        this.assertPrioritiesContain(priorities, "2");
        this.assertPrioritiesContain(priorities, "3");
        this.assertPrioritiesContain(priorities, "4");
        this.assertPrioritiesContain(priorities, "5");
    }

    private void assertPrioritiesContain(List<Priority> priorities, String id) {
        for (Priority priority : priorities) {
            if (!priority.id().equals(id)) continue;
            return;
        }
        Assert.fail((String)("Priority " + id + " not in list"));
    }
}

