/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.v2.issue.project.ProjectPickerResultWrapper;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectPickerClient;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AnyOf;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreOnce(value="TestProjectPickerResource.xml")
public class TestProjectPickerResource
extends BaseJiraFuncTest {
    private static final int DEFAULT_MAX_LIMIT = 100;
    private static final String EMPHASIS_OPENING_TAG = "<strong>";
    private static final String EMPHASIS_CLOSING_TAG = "</strong>";
    private static final String PROJECT_KEY_1 = "P1";
    private static final String PROJECT_KEY_2 = "PWVLPNWACS";
    private static final String PROJECT_KEY_3 = "APBP";
    private static final String PROJECT_KEY_4 = "MOSCOW";
    private static final String ANONYMOUS_USER = null;
    private static final String DEFAULT_PERMISSION_SCHEME_NAME = "Default Permission Scheme";
    private static final String ANYONE_ON_THE_WEB_GROUP_NAME = "";
    private static final String[] TST_PROJECTS_KEYS = (String[])IntStream.range(1, 151).mapToObj(i -> String.format("TST%03d", i)).toArray(String[]::new);
    private ProjectPickerClient projectClient;

    @Before
    public void setUp() {
        this.projectClient = new ProjectPickerClient(this.environmentData);
    }

    @After
    public void tearDownTest() {
        this.projectClient.cleanUp();
    }

    @Test
    public void testSuccessfulSearchForSingleProjectReturnsExpectedEntry() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", "Nam", PROJECT_KEY_2);
    }

    @Test
    public void testSuccessfulSearchForProjectsWithTwoWordsReturnsExpectedEntry() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", "Project 1", PROJECT_KEY_1);
    }

    @Test
    public void testSuccessfulSearchForProjectsByStartingWordReturnsExpectedEntries() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", "Proj", PROJECT_KEY_1, PROJECT_KEY_2, PROJECT_KEY_3);
    }

    @Test
    public void testSuccessfulSearchForProjectsByFollowingWordReturnsExpectedEntries() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", "very", PROJECT_KEY_2);
    }

    @Test
    public void testSuccessfulSearchForProjectsByFullMatchReturnsExpectedEntries() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", "Project 1 (One)", PROJECT_KEY_1);
    }

    @Test
    public void testSuccessfulSearchForProjectsByKeyMatchReturnsExpectedEntries() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", PROJECT_KEY_1, PROJECT_KEY_1);
    }

    @Test
    public void testSuccessfulSearchForProjectsByCaseInsensitiveUnicodeQueryReturnsExpectedEntries() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", "\u043c\u043e\u0441\u043a\u0432\u0430", PROJECT_KEY_4);
    }

    @Test
    public void testSuccessfulSearchForProjectsIsCaseInsensitive() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", "long", PROJECT_KEY_2);
    }

    @Test
    public void testEmptySearchForProjectsReturnsNoEntries() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", ANYONE_ON_THE_WEB_GROUP_NAME, new String[0]);
    }

    @Test
    public void testWhitespaceSearchForProjectsReturnsNoEntries() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", " \t  ", new String[0]);
    }

    @Test
    public void testUnsuccessfulSearchForProjectsReturnsNoEntries() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", "z", new String[0]);
    }

    @Test
    public void testRegexSearchForProjectsReturnsNoEntries() {
        this.assertUserCanViewProjectsMatchingItsQuery("admin", ".*", new String[0]);
    }

    @Test
    public void testAnonymousCanSeeOnlyPublicProjects() {
        this.allowBrowsePermissionsForAnonymous(PROJECT_KEY_1);
        this.assertUserCanViewProjectsMatchingItsQuery(ANONYMOUS_USER, "Proj", PROJECT_KEY_1);
    }

    @Test
    public void testUserCanOnlySeeTheProjectsItIsAllowedToAccess() {
        try {
            this.backdoor.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
            this.removeBrowsePermissionForJiraUsersGroup(PROJECT_KEY_1);
            this.assertUserCanViewProjectsMatchingItsQuery("bob", "Proj", PROJECT_KEY_2, PROJECT_KEY_3);
        }
        finally {
            this.backdoor.restoreDataCenterInstance("TestProjectPickerResource.xml");
        }
    }

    @Test
    public void testProvidingValidLimitReturnsSubsetOfLimitSize() {
        List<Project> expectedProjects = this.getProjectsForKeys(PROJECT_KEY_1, PROJECT_KEY_2, PROJECT_KEY_3);
        ParsedResponse<ProjectPickerResultWrapper> response = this.projectClient.getProjectsAs("Proj", 2, "admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.body, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"projects", TestProjectPickerResource.containsInAnyOrderProjectsSubset(expectedProjects, 2, "Proj")), Matchers.hasProperty((String)"total", (Matcher)Matchers.is((Object)expectedProjects.size())), Matchers.hasProperty((String)"header", (Matcher)Matchers.not((Matcher)Matchers.empty()))}));
    }

    @Test
    public void testProvidingGreaterThanMatchesLimitReturnsAllMatchedProjects() {
        List<Project> expectedProjects = this.getProjectsForKeys(PROJECT_KEY_1, PROJECT_KEY_2, PROJECT_KEY_3);
        ParsedResponse<ProjectPickerResultWrapper> response = this.projectClient.getProjectsAs("Proj", 10, "admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.body, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"projects", TestProjectPickerResource.containsInAnyOrderProjects(expectedProjects, "Proj")), Matchers.hasProperty((String)"total", (Matcher)Matchers.is((Object)expectedProjects.size())), Matchers.hasProperty((String)"header", (Matcher)Matchers.not((Matcher)Matchers.empty()))}));
    }

    @Test
    public void testProvidingNegativeLimitReturnsNoResults() {
        ParsedResponse<ProjectPickerResultWrapper> response = this.projectClient.getProjectsAs("Proj", -2, "admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.body, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"projects", (Matcher)Matchers.empty()), Matchers.hasProperty((String)"total", (Matcher)Matchers.is((Object)3)), Matchers.hasProperty((String)"header", (Matcher)Matchers.not((Matcher)Matchers.empty()))}));
    }

    @Test
    public void testProvidingZeroLimitReturnsAllMatchedProjectsWhenNotOverMaxLimit() {
        List<Project> expectedProjects = this.getProjectsForKeys(PROJECT_KEY_1, PROJECT_KEY_2, PROJECT_KEY_3);
        ParsedResponse<ProjectPickerResultWrapper> response = this.projectClient.getProjectsAs("Proj", 0, "admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.body, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"projects", TestProjectPickerResource.containsInAnyOrderProjects(expectedProjects, "Proj")), Matchers.hasProperty((String)"total", (Matcher)Matchers.is((Object)expectedProjects.size())), Matchers.hasProperty((String)"header", (Matcher)Matchers.not((Matcher)Matchers.empty()))}));
    }

    @Test
    public void testProvidingEmptyStringLimitReturnsAllMatchedProjects() {
        List<Project> expectedProjects = this.getProjectsForKeys(PROJECT_KEY_1, PROJECT_KEY_2, PROJECT_KEY_3);
        ParsedResponse<ProjectPickerResultWrapper> response = this.projectClient.getProjectsAs("Proj", ANYONE_ON_THE_WEB_GROUP_NAME, "admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.body, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"projects", TestProjectPickerResource.containsInAnyOrderProjects(expectedProjects, "Proj")), Matchers.hasProperty((String)"total", (Matcher)Matchers.is((Object)expectedProjects.size())), Matchers.hasProperty((String)"header", (Matcher)Matchers.not((Matcher)Matchers.empty()))}));
    }

    @Test
    public void testProvidingZeroLimitReturnsPartialMatchedProjectsWhenOverMaxLimit() {
        List<Project> expectedProjects = this.getProjectsForKeys(TST_PROJECTS_KEYS);
        ParsedResponse<ProjectPickerResultWrapper> response = this.projectClient.getProjectsAs("tst", 0, "admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.body, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"projects", TestProjectPickerResource.containsInAnyOrderProjectsSubset(expectedProjects, 100, "tst")), Matchers.hasProperty((String)"total", (Matcher)Matchers.is((Object)expectedProjects.size())), Matchers.hasProperty((String)"header", (Matcher)Matchers.not((Matcher)Matchers.empty()))}));
    }

    @Test
    public void testProvidingTooBigLimitTrimsResultToMaxLimit() {
        List<Project> expectedProjects = this.getProjectsForKeys(TST_PROJECTS_KEYS);
        ParsedResponse<ProjectPickerResultWrapper> response = this.projectClient.getProjectsAs("tst", 150, "admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.body, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"projects", TestProjectPickerResource.containsInAnyOrderProjectsSubset(expectedProjects, 100, "tst")), Matchers.hasProperty((String)"total", (Matcher)Matchers.is((Object)expectedProjects.size())), Matchers.hasProperty((String)"header", (Matcher)Matchers.not((Matcher)Matchers.empty()))}));
    }

    private void allowBrowsePermissionsForAnonymous(String key) {
        long projectId = this.backdoor.project().getProjectId(key);
        long schemeId = this.backdoor.permissionSchemes().copyDefaultScheme(DEFAULT_PERMISSION_SCHEME_NAME);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(schemeId), ProjectPermissions.BROWSE_PROJECTS, ANYONE_ON_THE_WEB_GROUP_NAME);
        this.backdoor.project().setPermissionScheme(projectId, schemeId);
    }

    private void removeBrowsePermissionForJiraUsersGroup(String key) {
        long projectId = this.backdoor.project().getProjectId(key);
        long schemeId = this.backdoor.permissionSchemes().copyDefaultScheme(DEFAULT_PERMISSION_SCHEME_NAME);
        this.backdoor.permissionSchemes().removeGroupPermission(schemeId, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        this.backdoor.project().setPermissionScheme(projectId, schemeId);
    }

    private void assertUserCanViewProjectsMatchingItsQuery(String user, String query, String ... expectedProjectKeys) {
        List<Project> expectedProjects = this.getProjectsForKeys(expectedProjectKeys);
        ParsedResponse<ProjectPickerResultWrapper> response = this.projectClient.getProjectsAs(query, user);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.body, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"projects", TestProjectPickerResource.containsInAnyOrderProjects(expectedProjects, query)), Matchers.hasProperty((String)"total", (Matcher)Matchers.is((Object)expectedProjects.size())), Matchers.hasProperty((String)"header", (Matcher)Matchers.not((Matcher)Matchers.empty()))}));
    }

    private List<Project> getProjectsForKeys(String ... keys) {
        return Stream.of(keys).map(key -> this.backdoor.project().getProject((String)key)).collect(Collectors.toList());
    }

    private static Matcher<Iterable<?>> containsInAnyOrderProjects(List<Project> projects, String query) {
        Matcher[] matchers = (Matcher[])projects.stream().map(project -> TestProjectPickerResource.toMatcher(project, query)).toArray(Matcher[]::new);
        return Matchers.containsInAnyOrder((Matcher[])matchers);
    }

    private static Matcher<?> containsInAnyOrderProjectsSubset(List<Project> projects, int subsetSize, String query) {
        Matcher[] allMatchers = (Matcher[])projects.stream().map(project -> TestProjectPickerResource.toMatcher(project, query)).toArray(Matcher[]::new);
        return CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasSize((int)subsetSize), TestProjectPickerResource.getIsSubsetOf(allMatchers)});
    }

    private static Matcher<? super Object> toMatcher(Project project, String query) {
        return CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"html", (Matcher)CoreMatchers.equalTo((Object)TestProjectPickerResource.generateHtml(project, query))), Matchers.hasProperty((String)"id", (Matcher)CoreMatchers.equalTo((Object)String.valueOf(project.id))), Matchers.hasProperty((String)"key", (Matcher)CoreMatchers.equalTo((Object)project.key)), Matchers.hasProperty((String)"name", (Matcher)CoreMatchers.equalTo((Object)project.name)), Matchers.hasProperty((String)"avatar", (Matcher)CoreMatchers.equalTo(project.avatarUrls.get("16x16")))});
    }

    private static String generateHtml(Project project, String query) {
        String htmlProjectName = TestProjectPickerResource.emphasizeQueryIn(TextUtils.htmlEncode((String)project.name), query);
        String htmlProjectKey = TestProjectPickerResource.emphasizeQueryIn(TextUtils.htmlEncode((String)project.key), query);
        return htmlProjectName + "&nbsp;(" + htmlProjectKey + ")";
    }

    private static String emphasizeQueryIn(String str, String query) {
        String regex = String.format("(^|\\s+|\\()(%s)", Pattern.quote(query));
        Pattern pattern = Pattern.compile(regex, 66);
        return pattern.matcher(str).replaceAll("$1<strong>$2</strong>");
    }

    private static TypeSafeMatcher<List<Object>> getIsSubsetOf(Matcher<? super Object>[] allMatchers) {
        final AnyOf anyMatcher = CoreMatchers.anyOf(allMatchers);
        return new TypeSafeMatcher<List<Object>>(){

            protected boolean matchesSafely(List<Object> items) {
                return items.stream().allMatch(arg_0 -> ((AnyOf)anyMatcher).matches(arg_0));
            }

            public void describeTo(Description description) {
                description.appendText("Projects have to be a subset of all matched projects");
            }
        };
    }
}

