/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.backdoor.WorkflowsControlExt;
import com.atlassian.jira.functest.framework.rule.IssueTypeUrls;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.BeforeBuildRule;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.matchers.RegexMatchers;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectIdentity;
import com.atlassian.jira.rest.v2.issue.project.ProjectInputBean;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.Backdoor;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.JiraHttpClient;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.ProjectUpdateField;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.matcher.CorrectlyUpdatedProjectMatcher;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ProjectCategoryClient;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestProjectResource.xml")
public class TestProjectResource
extends BaseJiraFuncTest {
    private static final String PROJECT_TYPE_KEY = "software";
    @Rule
    public IssueTypeUrls issueTypeUrls = new IssueTypeUrls();
    @Inject
    private FuncTestUrlHelper urlHelper;
    public static final GenericType<List<Project>> PROJECT_LIST_TYPE = new GenericType<List<Project>>(){};
    private static final String EXPECTED_EXPAND = "description,lead,url,projectKeys";
    public static final String LARGE_PROJECT_KEY = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private Long defaultAvatarId;
    private ProjectClient projectClient;
    private ProjectCategoryClient categoryClient;
    private static final Function<Project, Project> toSimple = new Function<Project, Project>(){

        public Project apply(Project project) {
            return project.email(null).components(null).assigneeType(null).description(null).lead(null).versions(null).issueTypes(null).roles(null);
        }
    };
    private static final Function<Project, Project> toSimpleWithDescription = new Function<Project, Project>(){

        public Project apply(Project project) {
            return project.email(null).components(null).assigneeType(null).lead(null).versions(null).issueTypes(null).roles(null);
        }
    };
    private static final Function<Project, Project> toSimpleWithLead = new Function<Project, Project>(){

        public Project apply(Project project) {
            return project.email(null).components(null).assigneeType(null).description(null).versions(null).issueTypes(null).roles(null);
        }
    };
    private static final Function<Project, Project> toSimpleWithDescriptionAndLead = new Function<Project, Project>(){

        public Project apply(Project project) {
            return project.email(null).components(null).assigneeType(null).versions(null).issueTypes(null).roles(null);
        }
    };

    @Test
    public void testCorrectInfoIsReturnedWhenUserHasAccessToProject() throws Exception {
        this.assertCorrectProjectIsReturned(this.projectMKY(), User.ADMIN, User.FRED);
        this.assertCorrectProjectIsReturned(this.projectATL(), User.ADMIN, User.FRED, User.ANONYMOUS);
        this.assertCorrectProjectIsReturned(this.projectHID(), User.ADMIN);
        this.assertCorrectProjectIsReturned(this.projectFRED(), User.ADMIN, User.FRED);
        this.assertCorrectProjectIsReturned(this.projectDODO(), User.ADMIN);
    }

    @Test
    public void testUserCannotAccessProjectByKeyIfTheyDoNotHavePermissions() throws Exception {
        this.assertCantSeeProject(User.FRED, "HID");
        this.assertCantSeeProject(User.ANONYMOUS, "MKY");
        this.assertCantSeeProject(User.ANONYMOUS, "HID");
        this.assertCantSeeProject(User.ANONYMOUS, "FRED");
    }

    @Test
    public void testUserCannotAccessProjectByIdIfTheyDoNotHavePermissions() throws Exception {
        this.assertCantSeeProject(User.FRED, 10110L);
        this.assertCantSeeProject(User.ANONYMOUS, 10001L);
        this.assertCantSeeProject(User.ANONYMOUS, 10110L);
        this.assertCantSeeProject(User.ANONYMOUS, 10111L);
    }

    @Test
    public void testAllProjectsUserHasAccessToAreReturnedWhenAskingForAllProjects() throws Exception {
        this.assertGetAllProjectsReturns(User.ADMIN, this.projectATL(), this.projectDODO(), this.projectFRED(), this.projectHID(), this.projectHSP(), this.projectMKY());
        this.assertGetAllProjectsReturns(User.FRED, this.projectATL(), this.projectFRED(), this.projectHSP(), this.projectMKY());
        this.assertGetAllProjectsReturns(User.ANONYMOUS, this.projectATL());
    }

    @Test
    public void testEmptyListIsReturnedWhenUserDoesNotHaveAnyRecentProjects() {
        this.assertGetRecentProjectsReturns(User.FRED, new Project[0]);
    }

    private void assertGetAllProjectsReturns(User user, Project ... projects) {
        List actual = this.loggedAs(user).getProjects();
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(projects), toSimple)), (Object)actual);
    }

    private void assertGetRecentProjectsReturns(User user, Project ... projects) {
        List actual = (List)this.loggedAs(user).getRecentProjects(20).readEntity(PROJECT_LIST_TYPE);
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(projects), toSimple)), (Object)actual);
    }

    @Test
    public void testNotFoundResponseIsReturnedWhenAskingForNonExistingProject() throws Exception {
        this.checkProjectNotFound("key", "XXX");
        this.checkProjectNotFound("id", "20000");
    }

    @Test
    public void testErrorIsReturnedWhenTryingToGetNegativeNumberOfRecentProjects() {
        this.assertResponseContainsAnyOfErrorMessages(this.projectClient.getRecentProjects(-1), "Number must not be negative");
    }

    private void checkProjectNotFound(String fieldName, String projectIdOrKey) {
        ParsedResponse response = this.projectClient.getResponse(projectIdOrKey);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errorMessages.size());
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{String.format("No project could be found with %s '%s'.", fieldName, projectIdOrKey)}));
    }

    @Test
    public void testViewProjectVersions() throws Exception {
        Assert.assertTrue((boolean)this.projectClient.getVersions("10001").isEmpty());
        Assert.assertTrue((boolean)this.projectClient.getVersions("MKY").isEmpty());
        Assert.assertEquals(this.createVersionsAtl(), (Object)this.projectClient.getVersions("10010"));
        Assert.assertEquals(this.createVersionsAtl(), (Object)this.projectClient.getVersions("ATL"));
    }

    @Test
    public void testViewProjectVersionsAnonymous() throws Exception {
        Assert.assertEquals(this.createVersionsAtl(), (Object)((ProjectClient)this.projectClient.anonymous()).getVersions("10010"));
        Assert.assertEquals(this.createVersionsAtl(), (Object)((ProjectClient)this.projectClient.anonymous()).getVersions("ATL"));
        this.checkProjectNotFoundForVersions("id", "10001");
        this.checkProjectNotFoundForVersions("key", "MKY");
    }

    private void checkProjectNotFoundForVersions(String field, String projectIdOrKey) {
        ParsedResponse response = this.projectClient.getVersionsResponse(projectIdOrKey);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.hasItem((Object)String.format("No project could be found with %s '%s'.", field, projectIdOrKey)));
    }

    @Test
    public void testViewProjectComponents() throws Exception {
        Assert.assertTrue((boolean)this.projectClient.getComponents("10001").isEmpty());
        Assert.assertTrue((boolean)this.projectClient.getComponents("MKY").isEmpty());
        Assert.assertEquals(this.createComponentsHsp(), (Object)this.projectClient.getComponents("10000"));
        Assert.assertEquals(this.createComponentsHsp(), (Object)this.projectClient.getComponents("HSP"));
    }

    @Test
    public void testViewProjectComponentsAnonymous() throws Exception {
        Assert.assertEquals(this.createComponentsAtlFull(), (Object)((ProjectClient)this.projectClient.anonymous()).getComponents("10010"));
        Assert.assertEquals(this.createComponentsAtlFull(), (Object)((ProjectClient)this.projectClient.anonymous()).getComponents("ATL"));
        this.checkProjectNotFoundForComponents("id", "10001");
        this.checkProjectNotFoundForComponents("key", "MKY");
    }

    private void checkProjectNotFoundForComponents(String field, String projectIdOrKey) {
        try {
            this.projectClient.getComponents(projectIdOrKey);
            Assert.fail((String)"Should throw exception.");
        }
        catch (WebApplicationException e) {
            Response response = e.getResponse();
            Assert.assertEquals((long)404L, (long)response.getStatus());
            Assert.assertThat((Object)((Errors)response.readEntity(Errors.class)).errorMessages, (Matcher)Matchers.hasItem((Object)String.format("No project could be found with %s '%s'.", field, projectIdOrKey)));
        }
    }

    @Test
    public void testAnonymousUserGetsAppropriateErrorWhenTryingToCreateProject() {
        Response response = this.loggedAs(User.ANONYMOUS).create((Object)ProjectInputBean.CREATE_EXAMPLE);
        this.assertNotAuthenticatedResponse(response);
        this.assertProjectWasNotCreated(ProjectInputBean.CREATE_EXAMPLE);
    }

    @Test
    public void testNonAdminUserGetsAppropriateErrorWhenTryingToCreateProject() {
        Response response = this.loggedAs(User.FRED).create((Object)ProjectInputBean.CREATE_EXAMPLE);
        this.assertInsufficientPrivilegesResponse(response, "You cannot delete this project.");
        this.assertProjectWasNotCreated(ProjectInputBean.CREATE_EXAMPLE);
    }

    @Test
    public void testAdminCanCreateSimpleProject() {
        ProjectInputBean projectToCreate = this.sampleProject("New project").build();
        this.assertCreationSuccess(projectToCreate, this.projectClient.create((Object)projectToCreate));
    }

    @Test
    public void testAdminCanCreateProjectUsingOnlyRequiredFields() {
        ProjectInputBean projectToCreate = ProjectInputBean.builder().setKey("REQ").setName("Only required").setLeadName("admin").setProjectTypeKey("business").build();
        this.assertCreationSuccess(projectToCreate, this.projectClient.create((Object)projectToCreate));
    }

    @Test
    public void testWhenCreatingProjectWithNonExistingAvatarIdInvalidRequestResponseIsReturned() {
        ProjectInputBean projectWithNonExistentAvatar = this.sampleProject("New project").setAvatarId(Long.valueOf(78L)).build();
        Response response = this.loggedAs(User.ADMIN).create((Object)projectWithNonExistentAvatar);
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST));
        this.assertResponseContainsAnyOfErrorMessages(response, "Avatar with id '78' does not exist.");
        this.assertProjectWasNotCreated(projectWithNonExistentAvatar);
    }

    @Test
    public void testCreatingProjectWithTheNameThatAlreadyExistsFails() {
        ProjectInputBean.Builder project = this.sampleProject("New project");
        this.assertResponseContainsAnyOfErrorMessages(this.projectClient.create((Object)project.setName("Atlassian").build()), "A project with that name already exists.");
        this.assertProjectWasNotCreated(project.build());
    }

    @Test
    public void testCreatingProjectWithTheKeyThatAlreadyExistsFails() {
        ProjectInputBean.Builder project = this.sampleProject("New Project");
        this.assertResponseContainsAnyOfErrorMessages(this.projectClient.create((Object)project.setKey("HSP").build()), "Another project uses this project key.");
        this.assertProjectWasNotCreated(project.build());
    }

    @Test
    public void testCreatingProjectWithNonExistingLeadFails() {
        ProjectInputBean project = this.sampleProject("Hello").setLeadName("Dude").build();
        this.assertResponseContainsAnyOfErrorMessages(this.projectClient.create((Object)project), "You must specify a valid project lead.");
        this.assertProjectWasNotCreated(project);
    }

    @Test
    public void testCreatingProjectWithNonExistingSchemesFails() {
        this.assertResponseContainsAnyOfErrorMessages(this.projectClient.create((Object)this.sampleProject("Hello").setIssueSecurityScheme(Long.valueOf(75L)).build()), "Unable to validate, issue security scheme could not be retrieved.");
        this.assertResponseContainsAnyOfErrorMessages(this.projectClient.create((Object)this.sampleProject("Hello").setNotificationScheme(Long.valueOf(75L)).build()), "Unable to validate, notification scheme could not be retrieved.");
        this.assertResponseContainsAnyOfErrorMessages(this.projectClient.create((Object)this.sampleProject("Hello").setPermissionScheme(Long.valueOf(75L)).build()), "Unable to validate, permission scheme could not be retrieved.");
        this.assertProjectWasNotCreated(this.sampleProject("Hello").build());
    }

    @Test
    public void testCreatingProjectWithExistingSchemesSucceeds() {
        ProjectInputBean project = this.sampleProject("Hello").setIssueSecurityScheme(Long.valueOf(10000L)).setNotificationScheme(Long.valueOf(10000L)).setPermissionScheme(Long.valueOf(10100L)).setWorkflowSchemeId(Long.valueOf(10000L)).build();
        this.assertCreationSuccess(project, this.projectClient.create((Object)project));
    }

    @Test
    public void testCreatingProjectWithNonExistentCategoryFails() {
        ProjectInputBean projectWithNonExistentCategory = this.sampleProject("Hello").setCategoryId(Long.valueOf(10042L)).build();
        Response response = this.projectClient.create((Object)projectWithNonExistentCategory);
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST));
        this.assertResponseContainsAnyOfErrorMessages(response, "The project category does not exist.");
        this.assertProjectWasNotCreated(projectWithNonExistentCategory);
    }

    @Test
    public void testProjectCanBeCreatedWithExistingCategory() {
        Long newCategory = this.categoryClient.createCategoryAndReturnId("newCategory", "Category for test");
        this.projectClient.create((Object)this.sampleProject("Hello").setCategoryId(newCategory).build());
        Project createdProject = this.backdoor.project().getProject("HELL");
        Assert.assertThat((Object)createdProject.projectCategory.name, (Matcher)CoreMatchers.equalTo((Object)"newCategory"));
        Assert.assertThat((Object)createdProject.projectCategory.description, (Matcher)CoreMatchers.equalTo((Object)"Category for test"));
    }

    private void assertProjectWasNotCreated(ProjectInputBean project) {
        try {
            Project returnedProject = this.backdoor.project().getProject(project.getKey());
            Assert.assertNotNull((Object)returnedProject);
        }
        catch (WebApplicationException ex) {
            Assert.assertThat((Object)ex.getResponse().getStatus(), (Matcher)CoreMatchers.equalTo((Object)404));
        }
    }

    @Test
    public void testEachFieldCanBeUpdatedSeparately() {
        Map<ProjectUpdateField, String> updateFields = this.generateTestUpdateValues();
        for (ProjectUpdateField field : updateFields.keySet()) {
            Project originalProject = this.projectClient.getAndExpandAll(this.projectATL().key);
            ProjectClient.UpdateBean updateBean = ProjectClient.UpdateBean.builder().with(field, (Object)updateFields.get(field)).build();
            Response response = this.loggedAs(User.ADMIN).update(this.projectATL().key, updateBean);
            Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.OK));
            Assert.assertThat((Object)this.projectClient.getAndExpandAll(originalProject.key), this.isUpdatedCorrectlyInAccordanceWith(updateBean, originalProject));
            response.close();
        }
    }

    @Test
    public void testAllFieldsCanBeUpdatedAtOnce() {
        Map<ProjectUpdateField, String> updateFields = this.generateTestUpdateValues();
        ProjectClient.UpdateBean.UpdateBeanBuilder updateBean = ProjectClient.UpdateBean.builder();
        for (ProjectUpdateField field : updateFields.keySet()) {
            updateBean = updateBean.with(field, (Object)updateFields.get(field));
        }
        Response response = this.loggedAs(User.ADMIN).update(this.projectATL().key, updateBean.build());
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.OK));
        Assert.assertThat((Object)this.projectClient.getAndExpandAll(this.projectATL().key), this.isUpdatedCorrectlyInAccordanceWith(updateBean.build(), this.projectATL()));
    }

    @Test
    public void testAnonymousGetsNotLoggedInResponseWhenUpdatingProject() {
        Response response = ((ProjectClient)this.projectClient.anonymous()).update("ATL", ProjectClient.UpdateBean.builder().with(ProjectUpdateField.URL, (Object)"http://i-am-not-logged.in").build());
        this.assertNotAuthenticatedResponse(response);
    }

    @Test
    public void testNonAdminUserGetsForbiddenResponseWhenUpdatingProject() {
        Response response = this.loggedAs(User.FRED).update("ATL", ProjectClient.UpdateBean.builder().with(ProjectUpdateField.URL, (Object)"http://i-am.fred").build());
        this.assertInsufficientPrivilegesResponse(response, "You cannot edit the configuration of this project.");
    }

    @Test
    public void testBadRequestResponseWhenUpdateDataIsNotRight() {
        Response response = this.loggedAs(User.ADMIN).update("ATL", ProjectClient.UpdateBean.builder().with(ProjectUpdateField.URL, (Object)"incorrect-url").build());
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST));
        this.assertResponseContainsAnyOfErrorMessages(response, "The URL specified is not valid - it must start with http://");
    }

    @Test
    public void test404WhenTryingToUpdateProjectThatDoesNotExist() {
        Response response = this.loggedAs(User.ADMIN).update("NULL", ProjectClient.UpdateBean.builder().build());
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND));
    }

    @Test
    public void shouldCreateProjectWithWorkflowSchemeAssignedWhenDefaultScheme() {
        long defaultWorkflowSchemeId = 10000L;
        ProjectInputBean projectInputBean = this.createProjectInput(0, defaultWorkflowSchemeId);
        Response responseProject = this.projectClient.create((Object)projectInputBean);
        this.assertCreationSuccess(projectInputBean, responseProject);
        WorkflowSchemeData projectWorkflowScheme = this.backdoor.project().getSchemes((String)projectInputBean.getKey()).workflowScheme;
        Assert.assertEquals((long)projectWorkflowScheme.getId(), (long)defaultWorkflowSchemeId);
        Assert.assertTrue((boolean)projectWorkflowScheme.isActive());
        Assert.assertFalse((boolean)projectWorkflowScheme.isDraft());
    }

    @Test
    public void shouldCreateProjectWithWorkflowSchemeAssignedWhenCommonDefaultSchemeForManyProjectAndDontCreateRubbishWorkflows() {
        List<WorkflowsControlExt.Workflow> workflowsBeforeCreation = this.backdoor.workflow().getWorkflowsDetailed();
        List workflowSchemesBeforeCreation = this.backdoor.workflowSchemes().getWorkflowSchemes();
        long commonDefaultWorkflowSchemeId = 10000L;
        for (int i = 0; i < 20; ++i) {
            ProjectInputBean projectInputBean = this.createProjectInput(i, commonDefaultWorkflowSchemeId);
            Response responseProject = this.projectClient.create((Object)projectInputBean);
            this.assertCreationSuccess(projectInputBean, responseProject);
            WorkflowSchemeData projectWorkflowScheme = this.backdoor.project().getSchemes((String)projectInputBean.getKey()).workflowScheme;
            Assert.assertEquals((long)projectWorkflowScheme.getId(), (long)commonDefaultWorkflowSchemeId);
            Assert.assertTrue((boolean)projectWorkflowScheme.isActive());
            Assert.assertFalse((boolean)projectWorkflowScheme.isDraft());
        }
        List<WorkflowsControlExt.Workflow> workflowsAfterCreation = this.backdoor.workflow().getWorkflowsDetailed();
        List workflowSchemesAfterCreation = this.backdoor.workflowSchemes().getWorkflowSchemes();
        Assert.assertEquals((long)workflowsAfterCreation.size(), (long)workflowsBeforeCreation.size());
        Assert.assertEquals((long)workflowSchemesAfterCreation.size(), (long)workflowSchemesBeforeCreation.size());
    }

    @Test
    public void shouldCreateManyProjectsWithCommonCustomWorkflowSchemeAndShouldNotCreateAnyOthersWorkflowSchemesAndWorkflows() {
        WorkflowSchemeData customWorkflowScheme = this.createCustomWorkflowScheme("workflowscheme name", "classic default workflow");
        List<WorkflowsControlExt.Workflow> workflowsBeforeCreation = this.backdoor.workflow().getWorkflowsDetailed();
        List workflowSchemesBeforeCreation = this.backdoor.workflowSchemes().getWorkflowSchemes();
        long commonCustomWorkflowSchemeId = customWorkflowScheme.getId();
        for (int i = 0; i < 20; ++i) {
            ProjectInputBean projectInputBean = this.createProjectInput(i, commonCustomWorkflowSchemeId);
            Response responseProject = this.projectClient.create((Object)projectInputBean);
            this.assertCreationSuccess(projectInputBean, responseProject);
            WorkflowSchemeData projectWorkflowScheme = this.backdoor.project().getSchemes((String)projectInputBean.getKey()).workflowScheme;
            Assert.assertEquals((long)projectWorkflowScheme.getId(), (long)commonCustomWorkflowSchemeId);
            Assert.assertTrue((boolean)projectWorkflowScheme.isActive());
            Assert.assertFalse((boolean)projectWorkflowScheme.isDraft());
        }
        List<WorkflowsControlExt.Workflow> workflowsAfterCreation = this.backdoor.workflow().getWorkflowsDetailed();
        List workflowSchemesAfterCreation = this.backdoor.workflowSchemes().getWorkflowSchemes();
        Assert.assertEquals((long)workflowsAfterCreation.size(), (long)workflowsBeforeCreation.size());
        Assert.assertEquals((long)workflowSchemesAfterCreation.size(), (long)workflowSchemesBeforeCreation.size());
    }

    private ProjectInputBean createProjectInput(Integer uniqueId, Long workflowSchemeId) {
        return ProjectInputBean.builder().setKey("TEST00" + uniqueId).setName("Project created for test" + uniqueId).setProjectTypeKey("business").setProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-project-management").setDescription("Project created with REST API 1 Project description").setLeadName("admin").setAssigneeType(ProjectBean.AssigneeType.PROJECT_LEAD).setAvatarId(this.defaultAvatarId).setWorkflowSchemeId(workflowSchemeId).build();
    }

    @Test
    public void shouldCreateProjectWithCustomWorkflowScheme() {
        WorkflowSchemeData customWorkflowScheme = this.createCustomWorkflowScheme("workflowscheme name", "classic default workflow");
        ProjectInputBean projectWithCustomScheme = this.createProjectInput(0, customWorkflowScheme.getId());
        Response responseProject = this.projectClient.create((Object)projectWithCustomScheme);
        this.assertCreationSuccess(projectWithCustomScheme, responseProject);
        WorkflowSchemeData projectWorkflowScheme = this.backdoor.project().getSchemes((String)projectWithCustomScheme.getKey()).workflowScheme;
        Assert.assertEquals((long)projectWorkflowScheme.getId(), (long)customWorkflowScheme.getId());
        Assert.assertTrue((boolean)projectWorkflowScheme.isActive());
        Assert.assertFalse((boolean)projectWorkflowScheme.isDraft());
    }

    @Test
    public void shouldCreateProjectWithCustomDraftWorkflowScheme() {
        WorkflowSchemeData customWorkflowScheme = this.createCustomWorkflowScheme("workflowscheme name", "classic default workflow");
        WorkflowSchemeData customDraftWorkflowScheme = this.backdoor.workflowSchemes().createDraftScheme(customWorkflowScheme.getId().longValue());
        Assert.assertFalse((boolean)customDraftWorkflowScheme.isActive());
        Assert.assertTrue((boolean)customDraftWorkflowScheme.isDraft());
        ProjectInputBean projectWithCustomScheme = this.createProjectInput(0, customDraftWorkflowScheme.getId());
        Response responseProject = this.projectClient.create((Object)projectWithCustomScheme);
        this.assertCreationSuccess(projectWithCustomScheme, responseProject);
        WorkflowSchemeData projectWorkflowScheme = this.backdoor.project().getSchemes((String)projectWithCustomScheme.getKey()).workflowScheme;
        Assert.assertEquals((long)projectWorkflowScheme.getId(), (long)customDraftWorkflowScheme.getId());
        Assert.assertTrue((boolean)projectWorkflowScheme.isActive());
        Assert.assertFalse((boolean)projectWorkflowScheme.isDraft());
    }

    @Test
    public void shouldNotCreateProjectWhenWorkflowSchemeDoesntExist() {
        long noneExistingWorkflowSchemeId = 10100L;
        ProjectInputBean projectWithNotExistingWorkflowScheme = this.createProjectInput(1, noneExistingWorkflowSchemeId);
        Response responseProject = this.projectClient.create((Object)projectWithNotExistingWorkflowScheme);
        Assert.assertThat((Object)responseProject.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST));
        this.assertResponseContainsAnyOfErrorMessages(responseProject, "admin.errors.project.validation.workflowScheme.scheme.not.exist");
        this.assertProjectWasNotCreated(projectWithNotExistingWorkflowScheme);
    }

    @Test
    public void shouldCreateProjectWhenWorkflowSchemeActive() {
        WorkflowSchemeData createdCustomWorkflowScheme = this.createCustomWorkflowScheme("workflowscheme name", "classic default workflow");
        ProjectInputBean projectWithCustomSchemeToActivateIt = this.createProjectInput(0, createdCustomWorkflowScheme.getId());
        this.projectClient.create((Object)projectWithCustomSchemeToActivateIt);
        WorkflowSchemeData workflowSchemeByProjectName = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectName(projectWithCustomSchemeToActivateIt.getName());
        Assert.assertTrue((boolean)workflowSchemeByProjectName.isActive());
        ProjectInputBean projectWithCustomActiveScheme = this.createProjectInput(1, createdCustomWorkflowScheme.getId());
        Response responseProject = this.projectClient.create((Object)projectWithCustomActiveScheme);
        this.assertCreationSuccess(projectWithCustomActiveScheme, responseProject);
        WorkflowSchemeData projectWorkflowScheme = this.backdoor.project().getSchemes((String)projectWithCustomActiveScheme.getKey()).workflowScheme;
        Assert.assertEquals((long)projectWorkflowScheme.getId(), (long)createdCustomWorkflowScheme.getId());
        Assert.assertTrue((boolean)projectWorkflowScheme.isActive());
        Assert.assertFalse((boolean)projectWorkflowScheme.isDraft());
    }

    private WorkflowSchemeData createCustomWorkflowScheme(String workflowSchemeName, String classicDefaultWorkflow) {
        WorkflowSchemeData newWorkflowScheme = new WorkflowSchemeData();
        newWorkflowScheme.setName(workflowSchemeName);
        newWorkflowScheme.setDefaultWorkflow(classicDefaultWorkflow);
        WorkflowSchemeData createdCustomWorkflowScheme = this.backdoor.workflowSchemes().createScheme(newWorkflowScheme);
        Assert.assertFalse((boolean)createdCustomWorkflowScheme.isActive());
        Assert.assertFalse((boolean)createdCustomWorkflowScheme.isDraft());
        return createdCustomWorkflowScheme;
    }

    @Test
    public void shouldCreateProjectWhenWorkflowSchemeIsDraft() {
        WorkflowSchemeData createdDraftScheme = this.backdoor.workflowSchemes().createDraftScheme(10000L);
        ProjectInputBean projectWithDraftScheme = this.createProjectInput(0, createdDraftScheme.getId());
        Response responseProject = this.projectClient.create((Object)projectWithDraftScheme);
        this.assertCreationSuccess(projectWithDraftScheme, responseProject);
        WorkflowSchemeData projectWorkflowScheme = this.backdoor.project().getSchemes((String)projectWithDraftScheme.getKey()).workflowScheme;
        Assert.assertEquals((long)projectWorkflowScheme.getId(), (long)createdDraftScheme.getId());
        Assert.assertTrue((boolean)projectWorkflowScheme.isActive());
        Assert.assertFalse((boolean)projectWorkflowScheme.isDraft());
    }

    @Test
    public void shouldNotCreateProjectWhenProjectTypeKeyNotExist() {
        long defaultWorkflowSchemeId = 10001L;
        ProjectInputBean projectWithNotExistingWorkflowScheme = ProjectInputBean.builder().setKey("TEST00").setName("Project created for test").setProjectTypeKey("projectTypeNoneExist").setProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-project-management").setDescription("Project created with REST API 1 Project description").setLeadName("admin").setAssigneeType(ProjectBean.AssigneeType.PROJECT_LEAD).setAvatarId(this.defaultAvatarId).setWorkflowSchemeId(Long.valueOf(defaultWorkflowSchemeId)).build();
        Response responseProject = this.projectClient.create((Object)projectWithNotExistingWorkflowScheme);
        Assert.assertThat((Object)responseProject.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST));
        this.assertResponseContainsAnyOfErrorMessages(responseProject, "An invalid project template was specified. Make sure the project template matches the project type you specified.");
        this.assertProjectWasNotCreated(projectWithNotExistingWorkflowScheme);
    }

    @Test
    public void shouldNotCreateProjectWhenProjectTypeTemplateNotExist() {
        long defaultWorkflowSchemeId = 10001L;
        ProjectInputBean projectWithNotExistingWorkflowScheme = ProjectInputBean.builder().setKey("TEST00").setName("Project created for test").setProjectTypeKey("business").setProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-project-management-not-exist").setDescription("Project created with REST API 1 Project description").setLeadName("admin").setAssigneeType(ProjectBean.AssigneeType.PROJECT_LEAD).setAvatarId(this.defaultAvatarId).setWorkflowSchemeId(Long.valueOf(defaultWorkflowSchemeId)).build();
        Response responseProject = this.projectClient.create((Object)projectWithNotExistingWorkflowScheme);
        Assert.assertThat((Object)responseProject.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST));
        this.assertResponseContainsAnyOfErrorMessages(responseProject, "The project template specified does not exist");
        try {
            Project returnedProject = this.backdoor.project().getProject(projectWithNotExistingWorkflowScheme.getKey());
            Assert.assertNotNull((Object)returnedProject);
        }
        catch (WebApplicationException ex) {
            Assert.assertThat((Object)ex.getResponse().getStatus(), (Matcher)CoreMatchers.equalTo((Object)404));
        }
    }

    @Test
    public void shouldNotCreateProjectWhenUnavailableProjectTypeRequested() {
        long defaultWorkflowSchemeId = 10000L;
        ProjectInputBean projectInputBean = ProjectInputBean.builder().setKey("TEST01").setName("Project created for test").setProjectTypeKey(PROJECT_TYPE_KEY).setProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-task-management").setDescription("Project created with REST API 1 Project description").setLeadName("admin").setAssigneeType(ProjectBean.AssigneeType.PROJECT_LEAD).setAvatarId(this.defaultAvatarId).setWorkflowSchemeId(Long.valueOf(defaultWorkflowSchemeId)).build();
        Response responseProject = this.projectClient.create((Object)projectInputBean);
        Assert.assertThat((Object)responseProject.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST));
        this.assertResponseContainsAnyOfErrorMessages(responseProject, "An invalid project type was specified. Make sure the project type is available in your Jira instance. Please talk to your Jira administrator if you need more help.");
    }

    @Test
    public void shouldNotCreateProjectWhenLoggedNotAsAdmin() {
        long defaultWorkflowSchemeId = 10001L;
        ProjectInputBean projectWithNotExistingWorkflowScheme = ProjectInputBean.builder().setKey("TEST01").setName("Project created for test").setProjectTypeKey("business").setProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-project-management").setDescription("Project created with REST API 1 Project description").setLeadName("admin").setAssigneeType(ProjectBean.AssigneeType.PROJECT_LEAD).setAvatarId(this.defaultAvatarId).setWorkflowSchemeId(Long.valueOf(defaultWorkflowSchemeId)).build();
        Response responseProject = this.loggedAs(User.ANONYMOUS).create((Object)projectWithNotExistingWorkflowScheme);
        Assert.assertThat((Object)responseProject.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.UNAUTHORIZED));
        this.assertResponseContainsAnyOfErrorMessages(responseProject, "You are not authenticated. Authentication required to perform this operation.");
        this.assertProjectWasNotCreated(projectWithNotExistingWorkflowScheme);
    }

    @Test
    public void shouldNotCreateSecondTheSameRequestForProjectCreation() {
        long defaultWorkflowSchemeId = 10000L;
        ProjectInputBean projectWorkflowScheme = ProjectInputBean.builder().setKey("TEST01").setName("Project created for test").setProjectTypeKey("business").setProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-project-management").setDescription("Project created with REST API 1 Project description").setLeadName("admin").setAssigneeType(ProjectBean.AssigneeType.PROJECT_LEAD).setAvatarId(this.defaultAvatarId).setWorkflowSchemeId(Long.valueOf(defaultWorkflowSchemeId)).build();
        Response responseProject = this.projectClient.create((Object)projectWorkflowScheme);
        Response responseProject2 = this.projectClient.create((Object)projectWorkflowScheme);
        this.assertCreationSuccess(projectWorkflowScheme, responseProject);
        Assert.assertThat((Object)responseProject2.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST));
        this.assertResponseContainsAnyOfErrorMessages(responseProject2, "A project with that name already exists.");
    }

    private Map<ProjectUpdateField, String> generateTestUpdateValues() {
        EnumMap result = Maps.newEnumMap(ProjectUpdateField.class);
        result.put(ProjectUpdateField.KEY, "TEST");
        result.put(ProjectUpdateField.ASSIGNEE_TYPE, "UNASSIGNED");
        result.put(ProjectUpdateField.AVATAR_ID, "10010");
        result.put(ProjectUpdateField.LEAD, "fred");
        result.put(ProjectUpdateField.URL, "http://new-url.test");
        result.put(ProjectUpdateField.DESCRIPTION, "Test description");
        Long categoryId = this.categoryClient.createCategoryAndReturnId("Test", "Test");
        result.put(ProjectUpdateField.CATEGORY_ID, categoryId.toString());
        Long issueSecurityScheme = this.backdoor.getTestkit().issueSecuritySchemes().createScheme("Test", "Test scheme description");
        result.put(ProjectUpdateField.ISSUE_SECURITY_SCHEME, issueSecurityScheme.toString());
        Long notificationScheme = this.backdoor.getTestkit().notificationSchemes().copyDefaultScheme("Test");
        result.put(ProjectUpdateField.NOTIFICATION_SCHEME, notificationScheme.toString());
        Long permissionsScheme = this.backdoor.permissionSchemes().copyDefaultScheme("Test");
        result.put(ProjectUpdateField.PERMISSION_SCHEME, permissionsScheme.toString());
        return result;
    }

    private Matcher<Project> isUpdatedCorrectlyInAccordanceWith(ProjectClient.UpdateBean updateBean, Project originalProject) {
        return CorrectlyUpdatedProjectMatcher.create((ProjectClient.UpdateBean)updateBean, (Project)originalProject, (Backdoor)this.backdoor.getTestkit());
    }

    @Test
    public void testDeletingProjectAsAnonymousFailsWith401() {
        this.assertNotAuthenticatedResponse(this.loggedAs(User.ANONYMOUS).delete("HSP"));
    }

    @Test
    public void testDeletingNonExistingProjectAsAnonymousFailsWith401() {
        this.assertNotAuthenticatedResponse(this.loggedAs(User.ANONYMOUS).delete("NOPE"));
    }

    @Test
    public void testDeletingProjectAsNonAdminFailsWith403() {
        this.assertInsufficientPrivilegesResponse(this.loggedAs(User.FRED).delete("HSP"), "You cannot delete this project.");
    }

    @Test
    public void testDeletingNonExistingProjectAsNonAdminFailsWith404() {
        this.assertCannotFindProject(this.loggedAs(User.FRED).delete("NOPE"), "NOPE");
    }

    @Test
    public void testDeletingProjectThatUserCannotSeeFailsWith404() {
        this.assertCannotFindProject(this.loggedAs(User.FRED).delete("HID"), "HID");
    }

    @Test
    public void testDeletingProjectWithNonsenseKeyFailsWith404() {
        this.assertCannotFindProject(this.loggedAs(User.ADMIN).delete("THIS_IS_QUITE_INVALID_KEY"), "THIS_IS_QUITE_INVALID_KEY");
    }

    @Test
    public void testDeletingExistingProjectByKeyAsAdminSucceedsWithNoContentResponse() {
        this.assertSuccessfulDelete(this.projectATL(), this.projectATL().key);
    }

    @Test
    public void testDeletingExistingProjectByIdAsAdminSucceedsWithNoContentResponse() {
        this.assertSuccessfulDelete(this.projectATL(), this.projectATL().id);
    }

    private void assertSuccessfulDelete(Project project, String idOrKey) {
        this.assertCorrectProjectIsReturned(project, User.FRED);
        Assert.assertThat((Object)this.loggedAs(User.ADMIN).delete(idOrKey).getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.NO_CONTENT));
        this.assertCantSeeProject(idOrKey, User.FRED, "(key|id)");
    }

    private void assertNotAuthenticatedResponse(Response response) {
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.UNAUTHORIZED));
        this.assertResponseContainsAnyOfErrorMessages(response, "You are not authenticated. Authentication required to perform this operation.");
    }

    private void assertInsufficientPrivilegesResponse(Response response, String message) {
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.FORBIDDEN));
        this.assertResponseContainsAnyOfErrorMessages(response, "You must have global administrator rights in order to modify projects.", message);
    }

    private void assertCannotFindProject(Response response, String key) {
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND));
        this.assertResponseContainsAnyOfErrorMessages(response, String.format("No project could be found with key '%s'.", key));
    }

    private void assertCreationSuccess(ProjectInputBean projectToCreate, Response response) {
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.CREATED));
        List locationHeaders = (List)response.getStringHeaders().get((Object)"location");
        Assert.assertThat((Object)locationHeaders, (Matcher)Matchers.hasSize((int)1));
        ProjectIdentity projectId = (ProjectIdentity)response.readEntity(ProjectIdentity.class);
        Project project = this.projectClient.get(projectId.getKey());
        Assert.assertThat(locationHeaders.get(0), (Matcher)CoreMatchers.equalTo((Object)projectId.getSelf().toString()));
        Assert.assertThat((Object)Strings.nullToEmpty((String)project.description), (Matcher)CoreMatchers.equalTo((Object)Strings.nullToEmpty((String)projectToCreate.getDescription())));
        Assert.assertThat((Object)project.name, (Matcher)CoreMatchers.equalTo((Object)projectToCreate.getName()));
        Assert.assertThat((Object)project.assigneeType.name(), (Matcher)CoreMatchers.equalTo((Object)projectToCreate.getAssigneeType().name()));
        Assert.assertThat((Object)project.lead.name, (Matcher)CoreMatchers.equalTo((Object)projectToCreate.getLead()));
        Assert.assertThat((Object)Strings.nullToEmpty((String)project.url), (Matcher)CoreMatchers.equalTo((Object)Strings.nullToEmpty((String)projectToCreate.getUrl())));
    }

    private ProjectInputBean.Builder sampleProject(String projectName) {
        return ProjectInputBean.builder().setName(projectName).setKey(projectName.replace(" ", "").toUpperCase().substring(0, 4)).setDescription("description of " + projectName).setLeadName("admin").setUrl("http://atlassian.com").setProjectTypeKey("business").setAssigneeType(ProjectBean.AssigneeType.PROJECT_LEAD);
    }

    private ProjectClient loggedAs(User user) {
        return user.loginName != null ? (ProjectClient)this.projectClient.loginAs(user.loginName) : (ProjectClient)this.projectClient.anonymous();
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=800009)
    public void testGetAvatars_normalMode() throws Exception {
        this.testGetAvatars(27);
    }

    @Test
    @BeforeBuildRule.BeforeBuild(buildNumber=800009)
    public void testGetAvatars_zduMode() throws Exception {
        this.testGetAvatars(26);
    }

    private void testGetAvatars(int noOfExpectedSystemAvatars) {
        this.checkGetAvatars("10000", noOfExpectedSystemAvatars);
        this.checkGetAvatars("HSP", noOfExpectedSystemAvatars);
    }

    private void checkGetAvatars(String projectIdOrKey, int noOfExpectedSystemAvatars) {
        Map avatars = this.projectClient.getAvatars(projectIdOrKey);
        List systemAvatars = (List)avatars.get("system");
        List customAvatars = (List)avatars.get("custom");
        Assert.assertThat((Object)systemAvatars, (Matcher)Matchers.hasSize((int)noOfExpectedSystemAvatars));
        Assert.assertThat((Object)customAvatars, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testViewProjectWithEditedKey() throws Exception {
        Project expectedProject = this.projectMKY().key("TST");
        this.backdoor.project().editProjectKey(Long.valueOf(expectedProject.id), "TST");
        Assert.assertThat((Object)this.loggedAs(User.ADMIN).get("TST"), (Matcher)CoreMatchers.equalTo((Object)expectedProject));
        Assert.assertThat((Object)this.loggedAs(User.ADMIN).get("MKY"), (Matcher)CoreMatchers.equalTo((Object)expectedProject));
    }

    @Test
    public void testViewProjectsExpandDescription() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(this.projectATL(), this.projectDODO(), this.projectFRED(), this.projectHID(), this.projectHSP(), this.projectMKY()), toSimpleWithDescription)), (Object)this.projectClient.getProjects("description"));
    }

    @Test
    public void testViewProjectsExpandLead() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(this.projectATL(), this.projectDODO(), this.projectFRED(), this.projectHID(), this.projectHSP(), this.projectMKY()), toSimpleWithLead)), (Object)this.projectClient.getProjects("lead"));
    }

    @Test
    public void testViewProjectsExpandDescriptionAndLead() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(this.projectATL(), this.projectDODO(), this.projectFRED(), this.projectHID(), this.projectHSP(), this.projectMKY()), toSimpleWithDescriptionAndLead)), (Object)this.projectClient.getProjects("description,lead"));
    }

    private void assertCantSeeProject(User user, String key) {
        this.assertCantSeeProject(key, user, "key");
    }

    private void assertCantSeeProject(User user, Long id) {
        this.assertCantSeeProject(Long.toString(id), user, "id");
    }

    private void assertCantSeeProject(String projectIdOrKey, User user, String field) {
        ParsedResponse response = this.loggedAs(user).getResponse(projectIdOrKey);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.hasItem((Matcher)RegexMatchers.regexMatches((String)String.format("No project could be found with %s '%s'.", field, projectIdOrKey))));
    }

    private void assertCorrectProjectIsReturned(Project expectedProject, User ... visibleTo) {
        this.checkProjectByKeyOrId(expectedProject.id, expectedProject, Arrays.asList(visibleTo));
        this.checkProjectByKeyOrId(expectedProject.key, expectedProject, Arrays.asList(visibleTo));
    }

    private void checkProjectByKeyOrId(String projectKeyOrId, Project expectedProject, List<User> visibleTo) {
        for (User user : visibleTo) {
            Project actualProject = this.loggedAs(user).get(projectKeyOrId);
            Assert.assertThat((Object)actualProject, (Matcher)CoreMatchers.equalTo((Object)expectedProject));
        }
    }

    private List<IssueType> createStandardIssueTypes() {
        return ImmutableList.of((Object)new IssueType().self(this.urlHelper.getRestApiUrl("issuetype/1")).id("1").name("Bug").avatarId(this.issueTypeUrls.getAvatarId("bug")).iconUrl(this.urlHelper.getBaseUrlPlus(this.issueTypeUrls.getIssueTypeUrl("bug"))).description("A problem which impairs or prevents the functions of the product."), (Object)new IssueType().self(this.urlHelper.getRestApiUrl("issuetype/2")).id("2").name("New Feature").avatarId(this.issueTypeUrls.getAvatarId("new feature")).iconUrl(this.urlHelper.getBaseUrlPlus(this.issueTypeUrls.getIssueTypeUrl("new feature"))).description("A new feature of the product, which has yet to be developed."), (Object)new IssueType().self(this.urlHelper.getRestApiUrl("issuetype/3")).id("3").name("Task").avatarId(this.issueTypeUrls.getAvatarId("task")).iconUrl(this.urlHelper.getBaseUrlPlus(this.issueTypeUrls.getIssueTypeUrl("task"))).description("A task that needs to be done."), (Object)new IssueType().self(this.urlHelper.getRestApiUrl("issuetype/4")).id("4").name("Improvement").avatarId(this.issueTypeUrls.getAvatarId("improvement")).iconUrl(this.urlHelper.getBaseUrlPlus(this.issueTypeUrls.getIssueTypeUrl("improvement"))).description("An improvement or enhancement to an existing feature or task."));
    }

    private Map<String, String> createStandardRoles(String projectKey) {
        return MapBuilder.newBuilder().add("Users", this.urlHelper.getRestApiUri("project", projectKey, "role", "10000").toString()).add("Developers", this.urlHelper.getRestApiUri("project", projectKey, "role", "10001").toString()).add("Administrators", this.urlHelper.getRestApiUri("project", projectKey, "role", "10002").toString()).toMap();
    }

    private Project projectMKY() {
        return new Project().self(this.urlHelper.getRestApiUri("project/10001")).key("MKY").name("monkey").expand(EXPECTED_EXPAND).id("10001").email("mky@example.com").lead(this.userAdmin()).description("project for monkeys").assigneeType(Project.AssigneeType.PROJECT_LEAD).issueTypes(this.createStandardIssueTypes()).roles(this.createStandardRoles("10001")).components(Collections.emptyList()).versions(Collections.emptyList()).avatarUrls(this.createProjectAvatarUrls(10001L, 10011L)).projectTypeKey(PROJECT_TYPE_KEY);
    }

    private Project projectHID() {
        return new Project().self(this.urlHelper.getRestApiUri("project/10110")).key("HID").name("HIDDEN").expand(EXPECTED_EXPAND).id("10110").description("").components(Collections.emptyList()).versions(Collections.emptyList()).assigneeType(Project.AssigneeType.PROJECT_LEAD).roles(this.createStandardRoles("10110")).issueTypes(this.createStandardIssueTypes()).lead(this.userAdmin()).avatarUrls(this.createProjectAvatarUrls(10110L, 10011L)).projectTypeKey(PROJECT_TYPE_KEY);
    }

    private Project projectHSP() {
        return new Project().self(this.urlHelper.getRestApiUri("project/10000")).key("HSP").name("homosapien").expand(EXPECTED_EXPAND).id("10000").description("project for homosapiens").versions(this.createVersionsHsp()).components(this.createComponentsHsp()).issueTypes(this.createStandardIssueTypes()).assigneeType(Project.AssigneeType.PROJECT_LEAD).roles(this.createStandardRoles("10000")).lead(this.userAdmin()).avatarUrls(this.createProjectAvatarUrls(10000L, 10140L)).projectTypeKey(PROJECT_TYPE_KEY);
    }

    private Project projectFRED() {
        return new Project().self(this.urlHelper.getRestApiUri("project/10111")).key("FRED").name("Fred").expand(EXPECTED_EXPAND).id("10111").description("").components(Collections.emptyList()).versions(Collections.emptyList()).issueTypes(this.createStandardIssueTypes()).assigneeType(Project.AssigneeType.PROJECT_LEAD).roles(this.createStandardRoles("10111")).lead(this.userFred()).avatarUrls(this.createProjectAvatarUrls(10111L, 10011L)).projectTypeKey(PROJECT_TYPE_KEY);
    }

    private Project projectDODO() {
        return new Project().self(this.urlHelper.getRestApiUri("project/10112")).key("DD").name("Dead Leader").expand(EXPECTED_EXPAND).id("10112").description("").components(Collections.emptyList()).versions(Collections.emptyList()).assigneeType(Project.AssigneeType.PROJECT_LEAD).issueTypes(this.createStandardIssueTypes()).roles(this.createStandardRoles("10112")).lead(this.userDodo()).avatarUrls(this.createProjectAvatarUrls(10112L, 10011L)).projectTypeKey(PROJECT_TYPE_KEY);
    }

    private Project projectATL() {
        return new Project().self(this.urlHelper.getRestApiUri("project/10010")).key("ATL").name("Atlassian").expand(EXPECTED_EXPAND).id("10010").description("").lead(this.userAdmin()).components(this.createComponentsAtlShort()).assigneeType(Project.AssigneeType.PROJECT_LEAD).issueTypes(this.createStandardIssueTypes()).roles(this.createStandardRoles("10010")).versions(this.createVersionsAtl()).avatarUrls(this.createProjectAvatarUrls(10010L, 10011L)).projectTypeKey(PROJECT_TYPE_KEY);
    }

    private Map<String, String> createProjectAvatarUrls(Long projectId, Long avatarId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.defaultAvatarId.equals(avatarId)) {
            builder.put((Object)"24x24", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?avatarId=" + avatarId));
        } else {
            builder.put((Object)"24x24", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=small&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=xsmall&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?size=medium&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.urlHelper.getBaseUrlPlus("secure/projectavatar?pid=" + projectId + "&avatarId=" + avatarId));
        }
        return builder.build();
    }

    private Map<String, String> createUserAvatarUrls(Long avatarId) {
        return ImmutableMap.builder().put((Object)"24x24", (Object)this.urlHelper.getBaseUrlPlus("secure/useravatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.urlHelper.getBaseUrlPlus("secure/useravatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.urlHelper.getBaseUrlPlus("secure/useravatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.urlHelper.getBaseUrlPlus("secure/useravatar?avatarId=" + avatarId)).build();
    }

    private List<Version> createVersionsAtl() {
        CollectionBuilder<Version> builder = CollectionBuilder.newBuilder();
        builder.add(new Version().self(this.createVersionUri(10014L)).archived(Boolean.valueOf(true)).released(Boolean.valueOf(false)).name("Five").description("Five").id(Long.valueOf(10014L)).projectId(Long.valueOf(10010L)));
        builder.add(new Version().self(this.createVersionUri(10013L)).archived(Boolean.valueOf(true)).released(Boolean.valueOf(true)).name("Four").description("Four").releaseDate("09/Mar/11").id(Long.valueOf(10013L)).projectId(Long.valueOf(10010L)));
        builder.add(new Version().self(this.createVersionUri(10012L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(true)).name("Three").releaseDate("09/Mar/11").id(Long.valueOf(10012L)).projectId(Long.valueOf(10010L)));
        builder.add(new Version().self(this.createVersionUri(10011L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("Two").description("Description").id(Long.valueOf(10011L)).projectId(Long.valueOf(10010L)));
        builder.add(new Version().self(this.createVersionUri(10010L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("One").releaseDate("01/Mar/11").overdue(Boolean.valueOf(true)).id(Long.valueOf(10010L)).projectId(Long.valueOf(10010L)));
        return builder.asList();
    }

    private List<Version> createVersionsHsp() {
        CollectionBuilder<Version> builder = CollectionBuilder.newBuilder();
        builder.add(new Version().self(this.createVersionUri(10000L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("New Version 1").description("Test Version Description 1").id(Long.valueOf(10000L)));
        builder.add(new Version().self(this.createVersionUri(10001L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("New Version 4").description("Test Version Description 4").id(Long.valueOf(10001L)));
        builder.add(new Version().self(this.createVersionUri(10002L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("New Version 5").description("Test Version Description 5").id(Long.valueOf(10002L)));
        return builder.asList();
    }

    private List<Component> createComponentsHsp() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new Component().self(this.createComponentUri(10000L)).id(Long.valueOf(10000L)).name("New Component 1").project("HSP").projectId(10000L).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.userAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.userAdmin()).isAssigneeTypeValid(true));
        builder.add((Object)new Component().self(this.createComponentUri(10001L)).id(Long.valueOf(10001L)).name("New Component 2").project("HSP").projectId(10000L).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.userAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.userAdmin()).isAssigneeTypeValid(true));
        builder.add((Object)new Component().self(this.createComponentUri(10002L)).id(Long.valueOf(10002L)).name("New Component 3").project("HSP").projectId(10000L).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.userAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.userAdmin()).isAssigneeTypeValid(true));
        return builder.build();
    }

    private List<Component> createComponentsAtlFull() {
        CollectionBuilder<Component> builder = CollectionBuilder.newBuilder();
        builder.add(new Component().self(this.createComponentUri(10003L)).id(Long.valueOf(10003L)).name("New Component 4").project("ATL").projectId(10010L).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.userAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.userAdmin()).isAssigneeTypeValid(true));
        builder.add(new Component().self(this.createComponentUri(10004L)).id(Long.valueOf(10004L)).name("New Component 5").project("ATL").projectId(10010L).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.userAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.userAdmin()).isAssigneeTypeValid(true));
        return builder.asList();
    }

    private List<Component> createComponentsAtlShort() {
        CollectionBuilder<Component> builder = CollectionBuilder.newBuilder();
        builder.add(new Component().self(this.createComponentUri(10003L)).id(Long.valueOf(10003L)).name("New Component 4"));
        builder.add(new Component().self(this.createComponentUri(10004L)).id(Long.valueOf(10004L)).name("New Component 5"));
        return builder.asList();
    }

    private com.atlassian.jira.testkit.client.restclient.User userAdmin() {
        return new com.atlassian.jira.testkit.client.restclient.User().self(this.createUserUri("admin")).name("admin").key("admin").displayName("Administrator").active(true).avatarUrls(this.createUserAvatarUrls(10062L));
    }

    private com.atlassian.jira.testkit.client.restclient.User userFred() {
        return new com.atlassian.jira.testkit.client.restclient.User().self(this.createUserUri("fred")).name("fred").key("fred").displayName("Fred Normal").active(true).avatarUrls(this.createUserAvatarUrls(10062L));
    }

    private com.atlassian.jira.testkit.client.restclient.User userDodo() {
        return new com.atlassian.jira.testkit.client.restclient.User().self(this.createUserUri("dodo")).name("dodo").key("dodo").displayName("dodo").active(false).avatarUrls(this.createUserAvatarUrls(10063L));
    }

    private URI createVersionUri(long id) {
        return this.urlHelper.getRestApiUri("version", String.valueOf(id));
    }

    private URI createComponentUri(long id) {
        return this.urlHelper.getRestApiUri("component", String.valueOf(id));
    }

    private URI createUserUri(String name) {
        return this.urlHelper.getRestApiUri(String.format("user?username=%s", name));
    }

    @Before
    public void setUpTest() {
        this.projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        this.categoryClient = new ProjectCategoryClient(this.environmentData);
        this.defaultAvatarId = Long.parseLong(this.backdoor.applicationProperties().getString("jira.avatar.default.id"));
    }

    @Test
    public void testChangeLeadOfProjectWithTooLongKey() {
        long id = this.getBackdoor().project().getProjectId("MKY");
        this.getBackdoor().project().editProjectKeyNoWaitForReindex(id, LARGE_PROJECT_KEY);
        Project project = this.projectClient.get(LARGE_PROJECT_KEY);
        Assert.assertEquals((Object)"admin", (Object)project.lead.name);
        this.projectClient.update(LARGE_PROJECT_KEY, ProjectClient.UpdateBean.builder().with(ProjectUpdateField.LEAD, (Object)"fred").build());
        Project withNewLead = this.projectClient.get(LARGE_PROJECT_KEY);
        Assert.assertEquals((Object)"fred", (Object)withNewLead.lead.name);
    }

    @After
    public void tearDownTest() {
        this.projectClient.cleanUp();
        this.categoryClient.cleanUp();
    }

    protected final void assertResponseContainsAnyOfErrorMessages(Response response, String ... errorMessageRegexp) {
        Errors errors = (Errors)response.readEntity(Errors.class);
        Iterable regexpMatchers = Iterables.transform(Arrays.asList(errorMessageRegexp), (Function)new Function<String, Matcher<? super String>>(){

            public Matcher<String> apply(@Nullable String input) {
                return RegexMatchers.regexMatches((String)input);
            }
        });
        Assert.assertThat((Object)ImmutableList.builder().addAll((Iterable)errors.errorMessages).addAll(errors.errors.values()).build(), (Matcher)Matchers.hasItem((Matcher)Matchers.anyOf((Iterable)regexpMatchers)));
    }

    protected final JiraHttpClient createHttpClient() {
        return new JiraHttpClient(this.environmentData.getBaseUrl().toExternalForm());
    }

    private static enum User {
        ADMIN("admin"),
        FRED("fred"),
        DODO("dodo"),
        ANONYMOUS(null);

        public final String loginName;

        private User(String loginName) {
            this.loginName = loginName;
        }
    }
}

