/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestProjectResourceDeleteProject
extends BaseJiraFuncTest {
    private ProjectClient projectClient;

    @Before
    public void setUpTest() {
        this.backdoor.project().addProject("ATLASSIAN", "ATL", "admin");
        this.backdoor.project().addProject("TEST", "TST", "admin");
        this.backdoor.versions().create(new Version().project("ATL").name("ATL Version 1"));
        this.backdoor.versions().create(new Version().project("ATL").name("ATL Version 2"));
        this.backdoor.versions().create(new Version().project("ATL").name("ATL Version 3"));
        this.backdoor.versions().create(new Version().project("TST").name("TST Version 1"));
        this.backdoor.versions().create(new Version().project("TST").name("TST Version 2"));
        this.backdoor.components().create(new Component().project("ATL").name("ATL 1"));
        this.backdoor.components().create(new Component().project("ATL").name("ATL 2"));
        this.backdoor.components().create(new Component().project("TST").name("TST 1"));
        this.backdoor.components().create(new Component().project("TST").name("TST 2"));
        String firstIssueKey = this.backdoor.issues().createIssue((String)"ATL", (String)"First issue.").key;
        String secondIssueKey = this.backdoor.issues().createIssue((String)"ATL", (String)"Second issue.").key;
        String thirdIssueKey = this.backdoor.issues().createIssue((String)"TST", (String)"Third issue.").key;
        this.backdoor.issues().setIssueFields(firstIssueKey, this.versions("ATL Version 1", "ATL Version 2", "ATL 1"));
        this.backdoor.issues().setIssueFields(secondIssueKey, this.versions("ATL Version 1", "ATL Version 3", "ATL 2"));
        this.backdoor.issues().setIssueFields(thirdIssueKey, this.versions("TST Version 1", "TST Version 2", "TST 1"));
        this.projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
    }

    private IssueFields versions(String version, String fixVersion, String component) {
        ResourceRef versionRef = ResourceRef.withName((String)version);
        ResourceRef fixVersionRef = ResourceRef.withName((String)fixVersion);
        ResourceRef componentRef = ResourceRef.withName((String)component);
        return new IssueFields().versions(new ResourceRef[]{versionRef}).fixVersions(new ResourceRef[]{fixVersionRef}).components(new ResourceRef[]{componentRef});
    }

    @Test
    public void shouldDeleteAllVersionAssociations() {
        List<Long> deletedVersions = this.getAllVersionIds("ATL");
        this.projectClient.delete("ATL");
        ImmutableMap findParams = ImmutableMap.of((Object)"sourceNodeEntity", (Object)"Issue", (Object)"sinkNodeEntity", (Object)"Version", (Object)"associationType", (Object)"IssueVersion");
        List<Map<String, Object>> issueVersionAssociations = this.getNodeAssociations((ImmutableMap<String, Object>)findParams);
        ImmutableList associatedVersions = (ImmutableList)issueVersionAssociations.stream().map(issueAssociation -> issueAssociation.get("sinkNodeId")).map(sinkNodeId -> ((Integer)sinkNodeId).longValue()).collect(CollectorsUtil.toImmutableList());
        Assert.assertThat((Object)associatedVersions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])this.toArray(deletedVersions))));
        Assert.assertThat((Object)associatedVersions, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void shouldDeleteAllFixVersionAssociations() {
        List<Long> deletedVersions = this.getAllVersionIds("ATL");
        this.projectClient.delete("ATL");
        ImmutableMap findParams = ImmutableMap.of((Object)"sourceNodeEntity", (Object)"Issue", (Object)"sinkNodeEntity", (Object)"Version", (Object)"associationType", (Object)"IssueFixVersion");
        List<Map<String, Object>> issueFixVersionAssociations = this.getNodeAssociations((ImmutableMap<String, Object>)findParams);
        ImmutableList associatedFixVersions = (ImmutableList)issueFixVersionAssociations.stream().map(issueAssociation -> issueAssociation.get("sinkNodeId")).map(sinkNodeId -> ((Integer)sinkNodeId).longValue()).collect(CollectorsUtil.toImmutableList());
        Assert.assertThat((Object)associatedFixVersions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])this.toArray(deletedVersions))));
        Assert.assertThat((Object)associatedFixVersions, (Matcher)Matchers.hasSize((int)1));
    }

    private List<Long> getAllVersionIds(String projectKey) {
        return (List)this.backdoor.project().getVersionsForProject(projectKey).stream().map(version -> version.id).collect(CollectorsUtil.toImmutableList());
    }

    @Test
    public void shouldDeleteAllComponentAssociations() {
        List<Long> deletedComponents = this.getAllComponentIds("ATL");
        this.projectClient.delete("ATL");
        ImmutableMap findParams = ImmutableMap.of((Object)"sourceNodeEntity", (Object)"Issue", (Object)"sinkNodeEntity", (Object)"Component", (Object)"associationType", (Object)"IssueComponent");
        List<Map<String, Object>> issueComponentAssociations = this.getNodeAssociations((ImmutableMap<String, Object>)findParams);
        ImmutableList associatedComponents = (ImmutableList)issueComponentAssociations.stream().map(issueAssociation -> issueAssociation.get("sinkNodeId")).map(sinkNodeId -> ((Integer)sinkNodeId).longValue()).collect(CollectorsUtil.toImmutableList());
        Assert.assertThat((Object)associatedComponents, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])this.toArray(deletedComponents))));
        Assert.assertThat((Object)associatedComponents, (Matcher)Matchers.hasSize((int)1));
    }

    private List<Long> getAllComponentIds(String projectKey) {
        return (List)this.backdoor.project().getComponentsForProject(projectKey).stream().map(version -> version.id).collect(CollectorsUtil.toImmutableList());
    }

    private List<Map<String, Object>> getNodeAssociations(ImmutableMap<String, Object> findParams) {
        return this.backdoor.entityEngine().findByAnd("NodeAssociation", (Map)findParams);
    }

    private Long[] toArray(List<Long> list) {
        return list.toArray(new Long[list.size()]);
    }

    @After
    public void tearDownTest() {
        this.projectClient.cleanUp();
    }
}

