/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestProjectRoleResource.xml")
public class TestProjectRoleResource
extends BaseJiraFuncTest {
    private ProjectRoleClient projectRoleClient;

    @Test
    public void testViewProjectRoles() throws Exception {
        this.viewProjectRoles("10001");
        this.viewProjectRoles("MKY");
    }

    private void viewProjectRoles(String projectIdOrKey) throws JSONException {
        Map mky = this.projectRoleClient.get(projectIdOrKey);
        Assert.assertEquals((long)3L, (long)mky.size());
        List<String> roles = Arrays.asList("Users", "Administrators", "Developers");
        for (String role : roles) {
            JSONObject jsonRole = this.getJSON((String)mky.get(role));
            Assert.assertEquals((Object)role, (Object)jsonRole.get("name"));
        }
    }

    @Test
    public void testViewRole() {
        this.viewRole("10001");
        this.viewRole("MKY");
    }

    private void viewRole(String projectIdOrKey) {
        ProjectRole projectRole = this.projectRoleClient.get(projectIdOrKey, "Users");
        Assert.assertEquals((Object)"Users", (Object)projectRole.name);
        Assert.assertEquals((Object)"A project role that represents users in a project", (Object)projectRole.description);
        Assert.assertNotNull((Object)projectRole.self);
        Assert.assertNotNull((Object)projectRole.id);
        Assert.assertEquals((long)2L, (long)projectRole.actors.size());
        Map<String, ProjectRole.Actor> map = this.makeMap(projectRole.actors);
        ProjectRole.Actor actor = map.get("admin");
        Assert.assertEquals((Object)"Administrator", (Object)actor.displayName);
        Assert.assertEquals((Object)"atlassian-user-role-actor", (Object)actor.type);
        Assert.assertEquals((Object)"admin", (Object)actor.name);
    }

    @Test
    public void testViewRoleActorsIsSortedByDisplayName() {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Users");
        Assert.assertEquals((long)2L, (long)projectRole.actors.size());
        ProjectRole.Actor admin = (ProjectRole.Actor)projectRole.actors.get(0);
        Assert.assertEquals((Object)"Administrator", (Object)admin.displayName);
        Assert.assertEquals((Object)"atlassian-user-role-actor", (Object)admin.type);
        Assert.assertEquals((Object)"admin", (Object)admin.name);
        ProjectRole.Actor actor = (ProjectRole.Actor)projectRole.actors.get(1);
        Assert.assertEquals((Object)"jira-users", (Object)actor.displayName);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)actor.type);
        Assert.assertEquals((Object)"jira-users", (Object)actor.name);
        this.backdoor.usersAndGroups().addUser("aaaa", "aaaa", "user", "aaa@aaa.com");
        this.backdoor.usersAndGroups().addUser("zzzz", "zzzz", "aaaa", "zzz@zzz.com");
        this.projectRoleClient.addActors("MKY", "Users", new String[0], new String[]{"aaaa", "zzzz"});
        projectRole = this.projectRoleClient.get("MKY", "Users");
        Assert.assertEquals((long)4L, (long)projectRole.actors.size());
        Assert.assertEquals((Object)"aaaa", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).displayName);
        Assert.assertEquals((Object)"Administrator", (Object)((ProjectRole.Actor)projectRole.actors.get((int)1)).displayName);
        Assert.assertEquals((Object)"jira-users", (Object)((ProjectRole.Actor)projectRole.actors.get((int)2)).displayName);
        Assert.assertEquals((Object)"user", (Object)((ProjectRole.Actor)projectRole.actors.get((int)3)).displayName);
    }

    @Test
    public void testSetRoleActors() {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Users");
        List actors = projectRole.actors;
        Assert.assertEquals((long)2L, (long)actors.size());
        ProjectRole.Actor admin = (ProjectRole.Actor)actors.get(0);
        Assert.assertEquals((Object)"Administrator", (Object)admin.displayName);
        Assert.assertEquals((Object)"atlassian-user-role-actor", (Object)admin.type);
        Assert.assertEquals((Object)"admin", (Object)admin.name);
        ProjectRole.Actor actor = (ProjectRole.Actor)actors.get(1);
        Assert.assertEquals((Object)"jira-users", (Object)actor.displayName);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)actor.type);
        Assert.assertEquals((Object)"jira-users", (Object)actor.name);
        this.backdoor.usersAndGroups().addUser("aaaa", "aaaa", "zzzz", "aaa@aaa.com");
        this.backdoor.usersAndGroups().addUser("zzzz", "zzzz", "aaaa", "zzz@zzz.com");
        this.backdoor.usersAndGroups().addGroup("ladida");
        this.projectRoleClient.setActors("MKY", "Users", (Map)ImmutableMap.builder().put((Object)"atlassian-user-role-actor", (Object)new String[]{"aaaa", "zzzz"}).put((Object)"atlassian-group-role-actor", (Object)new String[]{"ladida"}).build());
        projectRole = this.projectRoleClient.get("MKY", "Users");
        actors = projectRole.actors;
        Assert.assertEquals((long)3L, (long)actors.size());
        Assert.assertEquals((Object)"aaaa", (Object)((ProjectRole.Actor)actors.get((int)0)).displayName);
        Assert.assertEquals((Object)"atlassian-user-role-actor", (Object)((ProjectRole.Actor)actors.get((int)0)).type);
        Assert.assertEquals((Object)"zzzz", (Object)((ProjectRole.Actor)actors.get((int)0)).name);
        Assert.assertEquals((Object)"ladida", (Object)((ProjectRole.Actor)actors.get((int)1)).displayName);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)((ProjectRole.Actor)actors.get((int)1)).type);
        Assert.assertEquals((Object)"ladida", (Object)((ProjectRole.Actor)actors.get((int)1)).name);
        Assert.assertEquals((Object)"zzzz", (Object)((ProjectRole.Actor)actors.get((int)2)).displayName);
        Assert.assertEquals((Object)"atlassian-user-role-actor", (Object)((ProjectRole.Actor)actors.get((int)2)).type);
        Assert.assertEquals((Object)"aaaa", (Object)((ProjectRole.Actor)actors.get((int)2)).name);
        ParsedResponse response = this.projectRoleClient.setActors("MKY", "Users", (Map)ImmutableMap.builder().put((Object)"atlassian-user-role-actor", (Object)new String[]{"aaaa"}).put((Object)"atlassian-group-role-actor", (Object)new String[]{"azza"}).build());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        this.projectRoleClient.setActors("MKY", "Users", (Map)ImmutableMap.builder().put((Object)"atlassian-user-role-actor", (Object)new String[0]).put((Object)"atlassian-group-role-actor", (Object)new String[0]).build());
        projectRole = this.projectRoleClient.get("MKY", "Users");
        actors = projectRole.actors;
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((long)0L, (long)actors.size());
    }

    Map<String, ProjectRole.Actor> makeMap(Collection<ProjectRole.Actor> actors) {
        HashMap<String, ProjectRole.Actor> map = new HashMap<String, ProjectRole.Actor>();
        for (ProjectRole.Actor actor : actors) {
            Assert.assertFalse((boolean)map.containsKey(actor.name));
            map.put(actor.name, actor);
        }
        return map;
    }

    @Test
    public void testDeleteRoleActor() {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Users");
        Assert.assertEquals((long)2L, (long)projectRole.actors.size());
        this.projectRoleClient.deleteGroup("MKY", "Users", "jira-users");
        Assert.assertEquals((long)1L, (long)this.projectRoleClient.get((String)"MKY", (String)"Users").actors.size());
        this.projectRoleClient.deleteUser("MKY", "Users", "admin");
        Assert.assertEquals((long)0L, (long)this.projectRoleClient.get((String)"MKY", (String)"Users").actors.size());
    }

    @Test
    public void testDeleteRoleActorsWhenUserNotExists() {
        ParsedResponse responseExistingUser = this.projectRoleClient.deleteUser("MKY", "Developers", "nonexistingUser");
        Assert.assertEquals((long)Response.Status.GONE.getStatusCode(), (long)responseExistingUser.statusCode);
    }

    @Test
    public void testDeleteRoleActorsWhenGroupNotExists() {
        ParsedResponse responseExistingGroup = this.projectRoleClient.deleteGroup("MKY", "Developers", "nonexistingGroup");
        Assert.assertEquals((long)Response.Status.GONE.getStatusCode(), (long)responseExistingGroup.statusCode);
    }

    @Test
    public void testAddRoleActor() {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Developers");
        Assert.assertEquals((long)0L, (long)projectRole.actors.size());
        this.projectRoleClient.addActors("MKY", "Developers", new String[]{"jira-developers"}, null);
        projectRole = this.projectRoleClient.get("MKY", "Developers");
        Assert.assertEquals((long)1L, (long)projectRole.actors.size());
        ProjectRole.Actor actor = (ProjectRole.Actor)projectRole.actors.get(0);
        Assert.assertEquals((Object)"jira-developers", (Object)actor.name);
        Assert.assertEquals((Object)"jira-developers", (Object)actor.displayName);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)actor.type);
    }

    @Test
    public void testAddRoleActors() {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Developers");
        Assert.assertEquals((long)0L, (long)projectRole.actors.size());
        this.projectRoleClient.addActors("MKY", "Developers", new String[]{"jira-users", "jira-administrators", "jira-developers"}, new String[]{"admin"});
        projectRole = this.projectRoleClient.get("MKY", "Developers");
        Assert.assertEquals((long)4L, (long)projectRole.actors.size());
        ProjectRole.Actor admin = (ProjectRole.Actor)projectRole.actors.get(0);
        Assert.assertEquals((Object)"admin", (Object)admin.name);
        Assert.assertEquals((Object)"Administrator", (Object)admin.displayName);
        Assert.assertEquals((Object)"atlassian-user-role-actor", (Object)admin.type);
        ProjectRole.Actor administrators = (ProjectRole.Actor)projectRole.actors.get(1);
        Assert.assertEquals((Object)"jira-administrators", (Object)administrators.name);
        Assert.assertEquals((Object)"jira-administrators", (Object)administrators.displayName);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)administrators.type);
        ProjectRole.Actor developers = (ProjectRole.Actor)projectRole.actors.get(2);
        Assert.assertEquals((Object)"jira-developers", (Object)developers.name);
        Assert.assertEquals((Object)"jira-developers", (Object)developers.displayName);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)developers.type);
        ProjectRole.Actor users = (ProjectRole.Actor)projectRole.actors.get(3);
        Assert.assertEquals((Object)"jira-users", (Object)users.name);
        Assert.assertEquals((Object)"jira-users", (Object)users.displayName);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)users.type);
    }

    @Test
    public void testAddRoleActorsWhenUserExistsGroupNotExists() {
        String existingUser = "existingUser";
        this.backdoor.usersAndGroups().addUser("existingUser", "zzzz", "aaaa", "zzz@zzz.com");
        ParsedResponse responseExistingUser = this.projectRoleClient.addActors("MKY", "Developers", new String[]{"nonexisitngGroup"}, new String[]{"existingUser"});
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)responseExistingUser.statusCode);
    }

    @Test
    public void testAddRoleActorsWhenGroupExistsUserNotExists() {
        String existingGroup = "existingGroup";
        this.backdoor.usersAndGroups().addGroup("existingGroup");
        ParsedResponse responseExistingGroup = this.projectRoleClient.addActors("MKY", "Developers", new String[]{"existingGroup"}, new String[]{"nonexistingUser"});
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)responseExistingGroup.statusCode);
    }

    @Test
    public void testAddRoleActorsWhenNoUserAndNoGroupExists() {
        ParsedResponse responseExistingGroup = this.projectRoleClient.addActors("MKY", "Developers", new String[]{"nonexistingGroup"}, new String[]{"nonexistingUser"});
        Assert.assertEquals((long)Response.Status.GONE.getStatusCode(), (long)responseExistingGroup.statusCode);
    }

    @Before
    public void setUp() {
        this.projectRoleClient = new ProjectRoleClient((JIRAEnvironmentData)this.environmentData);
    }

    JSONObject getJSON(String uri) throws JSONException {
        this.tester.getDialog().gotoPage(uri);
        return new JSONObject(this.tester.getDialog().getResponseText());
    }
}

