/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectIdentity;
import com.atlassian.jira.rest.v2.issue.project.ProjectInputBean;
import com.atlassian.jira.test.util.lic.core.CoreLicenses;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import java.util.List;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestProjectTypesOnProjectResource
extends BaseJiraFuncTest {
    private static final String BUSINESS_PROJECT_KEY = "T1";
    private static final String SOFTWARE_PROJECT_KEY = "T2";
    private ProjectClient projectClient;

    @Before
    public void prepareInstance() {
        this.projectClient = new ProjectClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.backdoor.restoreDataFromResource("TestProjectTypesOnProjectResource.xml");
        this.backdoor.license().set(CoreLicenses.LICENSE_CORE.getLicenseString());
    }

    @Test
    @LoginAs(user="admin")
    public void createProjectAcceptsATypeAndResponseForGettingAProjectIncludesIt() {
        Project project = this.projectClient.get(BUSINESS_PROJECT_KEY);
        MatcherAssert.assertThat((Object)project, (Matcher)this.hasTypeOf("business"));
    }

    @Test
    @LoginAs(user="admin")
    public void createProjectWithTemplateUsesTheProjectTypeDefinedOnTheTemplate() {
        String projectId = this.createProjectWithTemplate("com.atlassian.jira-core-project-templates:jira-core-task-management");
        Project project = this.projectClient.get(projectId);
        MatcherAssert.assertThat((Object)project, (Matcher)this.hasTypeOf("business"));
    }

    @Test
    @LoginAs(user="admin")
    public void responseForGettingAllProjectsIncludesTheProjectTypeInEachOfTheProjects() {
        List projects = this.projectClient.getProjects();
        MatcherAssert.assertThat((Object)projects, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.projectWithType("business"), this.projectWithType("software")}));
    }

    @Test
    @LoginAs(user="admin")
    public void updateProjectTypeWhenUserIsNotLoggedInReturnsAnUnauthorizedResponse() throws Exception {
        ParsedResponse response = ((ProjectClient)this.projectClient.anonymous()).updateProjectType(BUSINESS_PROJECT_KEY, "any-type");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    @LoginAs(user="admin")
    public void updateProjectTypeUpdatesTheProjectTypeWhenTheUserIsLoggedInAndHasPermissions() throws Exception {
        ParsedResponse response = this.projectClient.updateProjectType(SOFTWARE_PROJECT_KEY, "business");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)200));
        MatcherAssert.assertThat((Object)response.body, (Matcher)this.hasTypeOf("business"));
    }

    @Test
    @LoginAs(user="admin")
    public void updateProjectTypeReturnsAnErrorResponseWhenTheUpdateFails() throws Exception {
        ParsedResponse response = this.projectClient.updateProjectType(BUSINESS_PROJECT_KEY, "non-existent-type");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)400));
    }

    @Test
    @LoginAs(user="admin")
    public void updateProjectTypeReturns404IfTheProjectDoesNotExist() throws Exception {
        ParsedResponse response = this.projectClient.updateProjectType("non-existent-project", "any-type");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)404));
    }

    private String createProjectWithTemplate(String projectTemplateKey) {
        return this.createProject(this.projectInputBeanWithTemplate(projectTemplateKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createProject(ProjectInputBean project) {
        try (Response response = ((ProjectClient)this.projectClient.loginAs("admin")).create((Object)project);){
            String string = ((ProjectIdentity)response.readEntity(ProjectIdentity.class)).getKey();
            return string;
        }
    }

    private ProjectInputBean projectInputBeanWithTemplate(String projectTemplateKey) {
        return ProjectInputBean.builder().setProjectTemplateKey(projectTemplateKey).setName("Project created with template").setKey("TEMPLATE").setDescription("description").setLeadName("admin").setUrl("http://atlassian.com").setAssigneeType(ProjectBean.AssigneeType.PROJECT_LEAD).build();
    }

    private ProjectTypeMatcher projectWithType(String expectedProjectType) {
        return this.hasTypeOf(expectedProjectType);
    }

    private ProjectTypeMatcher hasTypeOf(String expectedProjectType) {
        return new ProjectTypeMatcher(expectedProjectType);
    }

    private class ProjectTypeMatcher
    extends TypeSafeDiagnosingMatcher<Project> {
        private final String expectedProjectType;

        public ProjectTypeMatcher(String expectedProjectType) {
            this.expectedProjectType = expectedProjectType;
        }

        protected boolean matchesSafely(Project project, Description mismatchDescription) {
            return this.expectedProjectType.equals(project.projectTypeKey);
        }

        public void describeTo(Description description) {
            description.appendText("project with type: " + this.expectedProjectType);
        }
    }
}

