/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.IndexingControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.rest.v2.index.ReindexRequestBean;
import com.atlassian.jira.webtests.ztests.indexing.ReindexRequestClient;
import com.google.common.primitives.Longs;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestReindexRequestResource
extends BaseJiraRestTest {
    private static final Logger log = LoggerFactory.getLogger(TestReindexRequestResource.class);
    private ReindexRequestClient reindexRequestClient;

    @Before
    public void setUp() {
        this.reindexRequestClient = new ReindexRequestClient(this.environmentData);
        this.clearReindexRequests();
    }

    private void clearReindexRequests() {
        this.backdoor.indexing().clearPendingReindexRequests();
    }

    @Test
    public void testReadReindexRequestStatus() {
        ReindexRequestType type = ReindexRequestType.IMMEDIATE;
        String query = "";
        long requestId = this.makeReindexRequest(type, query, new SharedEntityType[0]);
        ReindexRequestBean request = this.reindexRequestClient.getReindexRequest(requestId);
        Assert.assertEquals((String)"Wrong ID.", (long)requestId, (long)request.getId());
        Assert.assertEquals((String)"Wrong type.", (Object)ReindexRequestType.IMMEDIATE, (Object)request.getType());
        Assert.assertEquals((String)"Wrong status.", (Object)ReindexStatus.PENDING, (Object)request.getStatus());
    }

    @Test
    public void testReadReindexRequestStatusNotFound() {
        try {
            this.reindexRequestClient.getReindexRequest(Integer.MAX_VALUE);
            Assert.fail((String)"Should get not found error.");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((String)"Wrong response status.", (long)HttpStatus.NOT_FOUND.code, (long)e.getResponse().getStatus());
        }
    }

    @Test
    public void testPerformReindex() throws InterruptedException {
        ReindexRequestType type = ReindexRequestType.IMMEDIATE;
        String query = "";
        long requestId = this.makeReindexRequest(type, query, new SharedEntityType[0]);
        List requests = Longs.asList((long[])this.reindexRequestClient.performReindex());
        Assert.assertThat((Object)requests, (Matcher)Matchers.hasItem((Object)requestId));
        this.assertReindexRequestStatusAfterCompletion(requestId, ReindexStatus.COMPLETE);
    }

    @Test
    public void testPerformReindexWithSharedEntities() throws InterruptedException {
        ReindexRequestType type = ReindexRequestType.DELAYED;
        String query = "";
        long requestId = this.makeReindexRequest(type, query, SharedEntityType.SEARCH_REQUEST);
        List requests = Longs.asList((long[])this.reindexRequestClient.performReindex());
        Assert.assertThat((Object)requests, (Matcher)Matchers.hasItem((Object)requestId));
        this.assertReindexRequestStatusAfterCompletion(requestId, ReindexStatus.COMPLETE);
    }

    @Test
    public void testReindexJustAComment() {
        IssueIndexingParams indexingParams = IssueIndexingParams.builder().withComments().withoutIssues().build();
        IndexingControl.IndexingProgress progress = this.backdoor.indexing().startInBackground(indexingParams);
        progress.waitForCompletion();
        String taskId = progress.getTaskId();
        Assert.assertEquals((String)"Reindex was not successful.", (Object)Boolean.TRUE, (Object)this.backdoor.indexing().isReindexTaskSuccessful(taskId));
    }

    private long makeReindexRequest(ReindexRequestType type, String query, SharedEntityType ... sharedEntityTypes) {
        return this.backdoor.indexing().makeReindexRequest(type, query, sharedEntityTypes);
    }

    private void assertReindexRequestStatusAfterCompletion(long requestId, ReindexStatus expectedStatus) {
        int numChecks = 0;
        try {
            ReindexRequestBean request;
            do {
                request = this.reindexRequestClient.getReindexRequest(requestId);
                Assert.assertNotNull((String)"Request not found.", (Object)request);
                log.info("Current request status: " + request.getStatus());
                Thread.sleep(500L);
            } while (request.getStatus() != expectedStatus && ++numChecks < 20);
            Assert.assertEquals((String)"Reindex did not complete with expected status.", (Object)expectedStatus, (Object)request.getStatus());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

