/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Resolution;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestResolutionResource
extends BaseJiraFuncTest {
    private static final String WONT_FIX_ID = "2";
    private LocalResolutionClient client;

    @Before
    public void setUp() {
        this.client = new LocalResolutionClient(this.getEnvironmentData());
    }

    @Test
    public void allResolutions() {
        ParsedResponse<Resolution[]> response = this.client.getResponse();
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertAllResolutions((Resolution[])response.body);
    }

    @Test
    public void allResolutionsAnonymousAccess() {
        ParsedResponse<Resolution[]> response = ((LocalResolutionClient)this.client.anonymous()).getResponse();
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)401));
    }

    @Test
    public void allResolutionsAnonymousAccessWithBrowseProjects() {
        this.getBackdoor().permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        ParsedResponse<Resolution[]> response = ((LocalResolutionClient)this.client.anonymous()).getResponse();
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertAllResolutions((Resolution[])response.body);
    }

    @Test
    public void singleResolution() {
        ParsedResponse<Resolution> response = this.client.getResponse(WONT_FIX_ID);
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertWontFixResolution((Resolution)response.body);
    }

    @Test
    public void singleResolutionNotFound() {
        ParsedResponse<Resolution> response = this.client.getResponse("999");
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errorMessages.size());
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"The resolution with id '999' does not exist"}));
    }

    @Test
    public void singleResolutionAnonymousAccess() {
        ParsedResponse<Resolution> response = ((LocalResolutionClient)this.client.anonymous()).getResponse(WONT_FIX_ID);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)401));
    }

    @Test
    public void singleResolutionAnonymousAccessWithBrowseProjects() {
        this.getBackdoor().permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        ParsedResponse<Resolution> response = ((LocalResolutionClient)this.client.anonymous()).getResponse(WONT_FIX_ID);
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertWontFixResolution((Resolution)response.body);
    }

    private void assertWontFixResolution(Resolution body) {
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/resolution/2"), (Object)body.self);
        Assert.assertEquals((Object)"The problem described is an issue which will never be fixed.", (Object)body.description);
        Assert.assertEquals((Object)WONT_FIX_ID, (Object)body.id);
        Assert.assertEquals((Object)"Won't Fix", (Object)body.name);
    }

    private void assertAllResolutions(Resolution[] resolutions) {
        Assert.assertEquals((long)5L, (long)resolutions.length);
        MatcherAssert.assertThat(Arrays.stream(resolutions).map(r -> r.id).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"1", WONT_FIX_ID, "3", "4", "5"}));
    }

    private static class LocalResolutionClient
    extends RestApiClient<LocalResolutionClient> {
        protected LocalResolutionClient(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        public ParsedResponse<Resolution> getResponse(String resolutionID) {
            return this.toResponse(() -> (Response)this.resource(resolutionID).request().get(Response.class), Resolution.class);
        }

        public ParsedResponse<Resolution[]> getResponse() {
            GenericType type = new GenericType(TypeUtils.genericArrayType(Resolution[].class).getGenericComponentType());
            return this.toResponse(() -> (Response)this.resource().request().get(Response.class), type);
        }

        private WebTarget resource(String id) {
            return this.createResource().path("resolution").path(id);
        }

        private WebTarget resource() {
            return this.createResource().path("resolution");
        }
    }
}

