/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.DevMode;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.Screen;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.MoveField;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Screen;
import com.atlassian.jira.testkit.client.restclient.ScreenField;
import com.atlassian.jira.testkit.client.restclient.ScreenTab;
import com.atlassian.jira.testkit.client.restclient.ScreensClient;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@DevMode(enabled=false)
public class TestScreensResource
extends BaseJiraRestTest {
    public static final String PROJECT_ADMIN = "bob";
    private ScreensClient screensClient;
    private long newTabId;

    @Before
    public void setUpTest() {
        this.backdoor.restoreInstance("TestScreensResource.xml", LicenseKeys.COMMERCIAL);
        this.screensClient = this.createScreensClient(1L);
        this.newTabId = ((Screen.Tab)this.backdoor.screens().addTabToScreenResponse((String)"Default Screen", (String)"Scotts Tab").body).getId();
        this.backdoor.screens().addTabToScreen("Default Screen", "Scotts Tab 2");
    }

    @Test
    public void testGettingTabsAsAdmin() throws Exception {
        List allTabs = this.screensClient.getAllTabs();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new ScreenTab[]{new ScreenTab("Field Tab"), new ScreenTab("Scotts Tab"), new ScreenTab("Scotts Tab 2")}), (Object)allTabs);
    }

    @Test
    public void testGettingTabsAsProjectAdmin() throws Exception {
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        List allTabs = this.screensClient.getAllTabs("BP");
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new ScreenTab[]{new ScreenTab("Field Tab"), new ScreenTab("Scotts Tab"), new ScreenTab("Scotts Tab 2")}), (Object)allTabs);
    }

    @Test
    public void testGettingTabsAsProjectAdminDifferentProject() throws Exception {
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        ParsedResponse allTabsResponse = this.screensClient.getAllTabsResponse("MKY");
        Assert.assertEquals((long)401L, (long)allTabsResponse.statusCode);
    }

    @Test
    public void testGettingTabsNotAdminOrProjectAdminError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        ParsedResponse allTabsResponse = this.screensClient.getAllTabsResponse();
        Assert.assertEquals((long)401L, (long)allTabsResponse.statusCode);
    }

    @Test
    public void testCreatingTab() throws Exception {
        ScreenTab tab = this.screensClient.createTab("My Tab");
        Assert.assertEquals((Object)tab.name, (Object)"My Tab");
        List allTabs = this.screensClient.getAllTabs();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new ScreenTab[]{new ScreenTab("Field Tab"), new ScreenTab("Scotts Tab"), new ScreenTab("Scotts Tab 2"), new ScreenTab("My Tab")}), (Object)allTabs);
    }

    @Test
    public void testCreatingTabAsProjectAdmin() throws Exception {
        this.screensClient = this.createScreensClient(10000L);
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        ScreenTab tab = this.screensClient.createTab("My Tab");
        Assert.assertEquals((Object)tab.name, (Object)"My Tab");
        List allTabs = this.screensClient.getAllTabs();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new ScreenTab[]{new ScreenTab("Field Tab"), new ScreenTab("My Tab")}), (Object)allTabs);
    }

    @Test
    public void testCreateTabError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        ParsedResponse res = this.screensClient.createTabWithResponse("My Tab");
        Assert.assertEquals((long)res.statusCode, (long)401L);
        this.screensClient.loginAs("admin", "admin");
        res = this.screensClient.createTabWithResponse("Field Tab");
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"Tab Field Tab already exists", res.entity.errors.get("name"));
        res = this.screensClient.createTabWithResponse("");
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"Tab name cannot be empty", res.entity.errors.get("name"));
    }

    @Test
    public void testRemoveTab() throws Exception {
        this.screensClient.deleteTab(Long.valueOf(10000L));
        this.screensClient.deleteTab(Long.valueOf(this.newTabId));
        List allTabs = this.screensClient.getAllTabs();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new ScreenTab[]{new ScreenTab("Scotts Tab 2")}), (Object)allTabs);
    }

    @Test
    public void testRemoveTabAsProjectAdmin() throws Exception {
        this.screensClient = this.createScreensClient(10000L);
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        ScreenTab tab = this.screensClient.createTab("My Tab");
        Assert.assertEquals((long)2L, (long)this.screensClient.getAllTabs().size());
        this.screensClient.deleteTab(tab.id);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new ScreenTab[]{new ScreenTab("Field Tab")}), (Object)this.screensClient.getAllTabs());
    }

    @Test
    public void testRemoveLastTabAsProjectAdmin() throws Exception {
        this.screensClient = this.createScreensClient(10000L);
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        ParsedResponse res = this.screensClient.deleteTabWithResponse(Long.valueOf(10010L));
        Assert.assertEquals((long)res.statusCode, (long)412L);
        Assert.assertEquals((long)1L, (long)this.screensClient.getAllTabs().size());
    }

    @Test
    public void testRemoveTabError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        ParsedResponse res = this.screensClient.deleteTabWithResponse(Long.valueOf(10000L));
        Assert.assertEquals((long)res.statusCode, (long)401L);
    }

    @Test
    public void testRenameTab() throws Exception {
        this.screensClient.renameTab(Long.valueOf(10000L), "Renamed Tab");
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"Renamed Tab", "Scotts Tab", "Scotts Tab 2"}), this.screensClient.getAllTabs());
    }

    @Test
    public void testRenameTabError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        ParsedResponse res = this.screensClient.renameTabWithResponse(Long.valueOf(10000L), "My Tab");
        Assert.assertEquals((long)res.statusCode, (long)401L);
        this.screensClient.loginAs("admin", "admin");
        res = this.screensClient.renameTabWithResponse(Long.valueOf(10000L), "Scotts Tab");
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"Tab Scotts Tab already exists", res.entity.errors.get("name"));
        res = this.screensClient.renameTabWithResponse(Long.valueOf(10000L), "");
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"Tab name cannot be empty", res.entity.errors.get("name"));
    }

    @Test
    public void testMoveTab() throws Exception {
        this.screensClient.moveTab(Long.valueOf(10000L), Integer.valueOf(2));
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"Scotts Tab", "Scotts Tab 2", "Field Tab"}), this.screensClient.getAllTabs());
    }

    @Test
    public void testMoveTabAsProjectAdmin() throws Exception {
        this.screensClient = this.createScreensClient(10000L);
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        this.screensClient.createTab("My Tab");
        this.screensClient.createTab("My Tab 1");
        this.screensClient.moveTab(Long.valueOf(10010L), Integer.valueOf(2));
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"My Tab", "My Tab 1", "Field Tab"}), this.screensClient.getAllTabs());
    }

    @Test
    public void testMoveTabError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        ParsedResponse res = this.screensClient.moveTabWithResponse(Long.valueOf(10000L), Integer.valueOf(1));
        Assert.assertEquals((long)res.statusCode, (long)401L);
        this.screensClient.loginAs("admin", "admin");
        res = this.screensClient.moveTabWithResponse(Long.valueOf(10000L), Integer.valueOf(-1));
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"Incorrect position, tab position much be between 0 and 2", res.entity.errorMessages.get(0));
        res = this.screensClient.moveTabWithResponse(Long.valueOf(10000L), Integer.valueOf(5));
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"Incorrect position, tab position much be between 0 and 2", res.entity.errorMessages.get(0));
    }

    @Test
    public void testAddingFields() throws Exception {
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver", "Linked Issues", "Resolution"}), this.screensClient.getAvailableFields());
        this.screensClient.addField(Long.valueOf(10000L), "issuelinks");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver", "Resolution"}), this.screensClient.getAvailableFields());
        this.screensClient.addField(Long.valueOf(this.newTabId), "resolution");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver"}), this.screensClient.getAvailableFields());
        List fieldsTabFields = this.screensClient.getFields(Long.valueOf(10000L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Summary", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Labels", "Linked Issues"}), fieldsTabFields);
        List scottsTabFields = this.screensClient.getFields(Long.valueOf(this.newTabId));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Resolution"}), scottsTabFields);
    }

    @Test
    @DevMode
    public void testAddingFieldsWithArchiving() throws Exception {
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver", "Linked Issues", "Resolution"}), this.screensClient.getAvailableFields());
        this.screensClient.addField(Long.valueOf(10000L), "issuelinks");
        this.screensClient.addField(Long.valueOf(10000L), "archiveddate");
        this.screensClient.addField(Long.valueOf(this.newTabId), "resolution");
        this.screensClient.addField(Long.valueOf(this.newTabId), "archivedby");
        this.assertFields(Collections.emptyList(), this.screensClient.getAvailableFields());
        List fieldsTabFields = this.screensClient.getFields(Long.valueOf(10000L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Summary", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Labels", "Linked Issues", "Archived"}), fieldsTabFields);
        List scottsTabFields = this.screensClient.getFields(Long.valueOf(this.newTabId));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Resolution", "Archiver"}), scottsTabFields);
    }

    @Test
    public void testAddingFieldsAsProjectAdmin() throws Exception {
        this.screensClient = this.createScreensClient(10000L);
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver", "Labels", "Linked Issues", "Resolution"}), this.screensClient.getAvailableFields());
        this.screensClient.addField(Long.valueOf(10010L), "labels");
        this.screensClient.addField(Long.valueOf(10010L), "issuelinks");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver", "Resolution"}), this.screensClient.getAvailableFields());
        this.screensClient.addField(Long.valueOf(10010L), "resolution");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver"}), this.screensClient.getAvailableFields());
        List fieldsTabFields = this.screensClient.getFields(Long.valueOf(10010L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Summary", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Labels", "Linked Issues", "Resolution"}), fieldsTabFields);
    }

    @Test
    public void testAddingFieldError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        ParsedResponse res = this.screensClient.addFieldWithResponse(Long.valueOf(10000L), "Linked Issues");
        Assert.assertEquals((long)res.statusCode, (long)401L);
        this.screensClient.loginAs("admin", "admin");
        res = this.screensClient.addFieldWithResponse(Long.valueOf(10000L), "summary");
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"The field with id summary already exists on the screen.", res.entity.errors.get("fieldId"));
        res = this.screensClient.addFieldWithResponse(Long.valueOf(10000L), "fgdfdgfds");
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"Invalid Field Id: fgdfdgfds", res.entity.errors.get("fieldId"));
    }

    @Test
    public void testRemovingFields() throws Exception {
        this.screensClient.removeField(Long.valueOf(10000L), "summary");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver", "Linked Issues", "Resolution", "Summary"}), this.screensClient.getAvailableFields());
        this.screensClient.removeField(Long.valueOf(10000L), "issuetype");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver", "Issue Type", "Linked Issues", "Resolution", "Summary"}), this.screensClient.getAvailableFields());
        List fieldsTabFields = this.screensClient.getFields(Long.valueOf(10000L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Labels"}), fieldsTabFields);
    }

    @Test
    public void testRemovingFieldsAsProjectAdmin() throws Exception {
        this.screensClient = this.createScreensClient(10000L);
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        this.screensClient.removeField(Long.valueOf(10010L), "summary");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver", "Labels", "Linked Issues", "Resolution", "Summary"}), this.screensClient.getAvailableFields());
        this.screensClient.removeField(Long.valueOf(10010L), "issuetype");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Archived", "Archiver", "Issue Type", "Labels", "Linked Issues", "Resolution", "Summary"}), this.screensClient.getAvailableFields());
        List fieldsTabFields = this.screensClient.getFields(Long.valueOf(10010L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment"}), fieldsTabFields);
    }

    @Test
    public void testRemovingFieldError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        ParsedResponse res = this.screensClient.removeFieldWithResponse(Long.valueOf(10000L), "Linked Issues");
        Assert.assertEquals((long)res.statusCode, (long)401L);
        this.screensClient.loginAs("admin", "admin");
        res = this.screensClient.removeFieldWithResponse(Long.valueOf(10000L), "issuelinks");
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"The field with id issuelinks does not exist on this tab.", res.entity.errorMessages.get(0));
        res = this.screensClient.removeFieldWithResponse(Long.valueOf(10000L), "fgdfdgfds");
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"The field with id fgdfdgfds does not exist on this tab.", res.entity.errorMessages.get(0));
    }

    @Test
    public void testMoveField() throws Exception {
        MoveField moveField = new MoveField();
        moveField.after = new URI("/summary");
        this.screensClient.moveField(Long.valueOf(10000L), "assignee", moveField);
        moveField = new MoveField();
        moveField.position = MoveField.Position.Last;
        this.screensClient.moveField(Long.valueOf(10000L), "summary", moveField);
        moveField = new MoveField();
        moveField.position = MoveField.Position.First;
        this.screensClient.moveField(Long.valueOf(10000L), "labels", moveField);
        List fields = this.screensClient.getFields(Long.valueOf(10000L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Labels", "Assignee", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Summary"}), fields);
    }

    @Test
    public void testMoveFieldAsProjectAdmin() throws Exception {
        this.screensClient = this.createScreensClient(10000L);
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        MoveField moveField = new MoveField();
        moveField.after = new URI("/summary");
        this.screensClient.moveField(Long.valueOf(10010L), "assignee", moveField);
        moveField = new MoveField();
        moveField.position = MoveField.Position.Last;
        this.screensClient.moveField(Long.valueOf(10010L), "summary", moveField);
        moveField = new MoveField();
        moveField.position = MoveField.Position.First;
        this.screensClient.moveField(Long.valueOf(10010L), "reporter", moveField);
        List fields = this.screensClient.getFields(Long.valueOf(10010L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Reporter", "Assignee", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Environment", "Description", "Time Tracking", "Attachment", "Summary"}), fields);
    }

    @Test
    public void testMoveFieldError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        MoveField moveField = new MoveField();
        moveField.after = new URI("/summary");
        ParsedResponse res = this.screensClient.moveFieldWithResponse(Long.valueOf(10000L), "assignee", moveField);
        Assert.assertEquals((long)res.statusCode, (long)401L);
        this.screensClient.loginAs("admin", "admin");
        moveField = new MoveField();
        moveField.after = new URI("/reporter");
        res = this.screensClient.moveFieldWithResponse(Long.valueOf(10000L), "issuelinks", moveField);
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"The field with id issuelinks does not exist on this tab.", res.entity.errorMessages.get(0));
        moveField.after = new URI("/issuelinks");
        res = this.screensClient.moveFieldWithResponse(Long.valueOf(10000L), "reporter", moveField);
        Assert.assertEquals((long)res.statusCode, (long)400L);
        Assert.assertEquals((Object)"The field with id reporter cannot be moved after the issuelinks as it doesn't exist.", res.entity.errorMessages.get(0));
    }

    @Test
    public void testCopyAfterTabRenameHasSameTabNames() {
        this.screensClient.renameTab(Long.valueOf(10000L), "Renamed Tab");
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"Renamed Tab", "Scotts Tab", "Scotts Tab 2"}), this.screensClient.getAllTabs());
        Long copyId = this.backdoor.screens().copy("Default Screen", "Default Screen Copy", "-");
        ScreensClient copyClient = this.createScreensClient(copyId);
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"Renamed Tab", "Scotts Tab", "Scotts Tab 2"}), copyClient.getAllTabs());
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"Renamed Tab", "Scotts Tab", "Scotts Tab 2"}), this.screensClient.getAllTabs());
    }

    @Test
    public void testGetAllFieldsAsAdmin() throws Exception {
        List allFields = this.screensClient.getFields(Long.valueOf(10000L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Summary", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Labels"}), allFields);
    }

    @Test
    public void testGetAllFieldsAsProjectAdmin() throws Exception {
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        List allFields = this.screensClient.getFields(Long.valueOf(10000L), "BP");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Summary", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Labels"}), allFields);
    }

    @Test
    public void testGetAllFieldsAsProjectAdminDifferentProject() throws Exception {
        this.screensClient.loginAs(PROJECT_ADMIN, PROJECT_ADMIN);
        ParsedResponse allFieldsResponse = this.screensClient.getFieldsResponse(Long.valueOf(10000L), "MKY");
        Assert.assertEquals((long)401L, (long)allFieldsResponse.statusCode);
    }

    @Test
    public void testGetAllScreensAsNormalUser() {
        this.screensClient.loginAs("fred");
        ParsedResponse response = this.screensClient.getAllScreensResponse();
        Assert.assertEquals((long)403L, (long)response.statusCode);
    }

    @Test
    public void testGetAllScreensAsAdmin() {
        this.screensClient.loginAs("admin");
        List response = this.screensClient.getAllScreens();
        Assert.assertThat((Object)response, (Matcher)Matchers.containsInAnyOrder((Object[])this.getExpectedScreens().toArray(new Screen[0])));
    }

    @Test
    public void testGetAllScreensAsAnonymous() {
        this.screensClient.anonymous();
        ParsedResponse response = this.screensClient.getAllScreensResponse();
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    private ScreensClient createScreensClient(long id) {
        return new ScreensClient((JIRAEnvironmentData)this.environmentData, Long.valueOf(id));
    }

    private List<Screen> getExpectedScreens() {
        return Arrays.asList(new Screen(Long.valueOf(10000L), "Bob's Only Screen", "Allows to update all system fields.", "fieldScreenSchemes,fieldScreenWorkflows,deletable,fieldScreenTabs"), new Screen(Long.valueOf(10100L), "Shared Screen", "", "fieldScreenSchemes,fieldScreenWorkflows,deletable,fieldScreenTabs"), new Screen(Long.valueOf(1L), "Default Screen", "Allows to update all system fields.", "fieldScreenSchemes,fieldScreenWorkflows,deletable,fieldScreenTabs"), new Screen(Long.valueOf(2L), "Workflow Screen", "This screen is used in the workflow and enables you to assign issues", "fieldScreenSchemes,fieldScreenWorkflows,deletable,fieldScreenTabs"), new Screen(Long.valueOf(3L), "Resolve Issue Screen", "Allows to set resolution, change fix versions and assign an issue.", "fieldScreenSchemes,fieldScreenWorkflows,deletable,fieldScreenTabs"));
    }

    private void assertTabs(List<String> expecting, List<ScreenTab> actual) {
        Assert.assertEquals(expecting, this.getTabLabels(actual));
    }

    private List<String> getTabLabels(List<ScreenTab> tabs) {
        ArrayList<String> labels = new ArrayList<String>();
        for (ScreenTab tab : tabs) {
            labels.add(tab.name);
        }
        return labels;
    }

    private void assertFields(List<String> expecting, List<ScreenField> actual) {
        Assert.assertEquals(expecting, this.getFieldLabels(actual));
    }

    private List<String> getFieldLabels(List<ScreenField> fields) {
        ArrayList<String> labels = new ArrayList<String>();
        for (ScreenField field : fields) {
            labels.add(field.name);
        }
        return labels;
    }
}

