/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.PluginIndexConfigurationControl;
import com.atlassian.jira.functest.framework.backdoor.search.AutoCompleteData;
import com.atlassian.jira.functest.framework.backdoor.search.AutoCompleteField;
import com.atlassian.jira.functest.framework.backdoor.search.SearchAutoCompleteControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.ReferencePluginReloadHelper;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.JQL, Category.REFERENCE_PLUGIN})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestSearchAutoCompleteResource
extends BaseJiraRestTest {
    private static final String CUSTOM_FIELD_TYPE = String.format("%s:%s", "com.atlassian.jira.plugin.system.customfieldtypes", "textfield");
    private SearchAutoCompleteControl client;
    private PluginIndexConfigurationControl configurationControlClient;

    @Before
    public void setUpTest() {
        this.client = new SearchAutoCompleteControl(this.environmentData);
        this.configurationControlClient = new PluginIndexConfigurationControl(this.environmentData);
    }

    @Test
    public void testAutoCompleteControlContainsJqlAlias() throws Exception {
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "com.atlassian.jira.dev.reference-plugin", "pluginindexconfiguration1.xml", this.configurationControlClient);
        AutoCompleteData autoCompleteData = this.client.getAutoCompleteData();
        AutoCompleteField labelField = this.createAutoCompleteField("label", "label", true, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, String.class, true);
        AutoCompleteField labelDate = this.createAutoCompleteField("labelDate", "labelDate", false, OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, Date.class, true);
        AutoCompleteField labelDescription = this.createAutoCompleteField("labelDescription", "labelDescription", false, OperatorClasses.TEXT_OPERATORS, String.class, true);
        AutoCompleteField labelId = this.createAutoCompleteField("labelId", "labelId", false, OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, Number.class, true);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItems((Object[])new AutoCompleteField[]{labelField, labelDate, labelDescription, labelId}));
    }

    @Test
    public void testAutoCompleteWithConflictingAliases() throws Exception {
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "plugin 1", "conflict_indexconf1.xml", this.configurationControlClient);
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "plugin 2", "conflict_indexconf2.xml", this.configurationControlClient);
        AutoCompleteData autoCompleteData = this.client.getAutoCompleteData();
        AutoCompleteField firstLabelField = this.createAutoCompleteField("issue.property[label].value", "conflict - plugin 1", true, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, String.class, true);
        AutoCompleteField secondLabelField = this.createAutoCompleteField("issue.property[conflicting_alias].value", "conflict - plugin 2", true, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, String.class, true);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItems((Object[])new AutoCompleteField[]{firstLabelField, secondLabelField}));
    }

    @Test
    public void testAutoCompleteWithConflictingAliasesAndCustomFields() {
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "plugin 1", "conflict_indexconf1.xml", this.configurationControlClient);
        this.backdoor.customFields().createCustomField("conflict", "some description", CUSTOM_FIELD_TYPE, null);
        AutoCompleteData autoCompleteData = this.client.getAutoCompleteData();
        AutoCompleteField firstLabelField = this.createAutoCompleteField("issue.property[label].value", "conflict - plugin 1", true, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, String.class, true);
        AutoCompleteField customField = this.createAutoCompleteField("cf[10000]", "conflict - cf[10000]", false, Sets.newHashSet(), Object.class, false);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItems((Object[])new AutoCompleteField[]{firstLabelField, customField}));
    }

    @Test
    public void testAutoCompleteWithSingleCustomField() {
        this.backdoor.customFields().createCustomField("conflict", "some description", CUSTOM_FIELD_TYPE, null);
        AutoCompleteData autoCompleteData = this.client.getAutoCompleteData();
        AutoCompleteField customField = this.createAutoCompleteField("conflict", "conflict - cf[10000]", false, Sets.newHashSet(), Object.class, false);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItem((Object)customField));
    }

    @Test
    public void testAutoCompleteWithTwoConflictingCustomFields() {
        this.backdoor.customFields().createCustomField("conflict", "some description", CUSTOM_FIELD_TYPE, null);
        this.backdoor.customFields().createCustomField("conflict", "some description", CUSTOM_FIELD_TYPE, null);
        AutoCompleteData autoCompleteData = this.client.getAutoCompleteData();
        AutoCompleteField customField1 = this.createAutoCompleteField("cf[10000]", "conflict - cf[10000]", false, Sets.newHashSet(), Object.class, false);
        AutoCompleteField customField2 = this.createAutoCompleteField("cf[10001]", "conflict - cf[10001]", false, Sets.newHashSet(), Object.class, false);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItems((Object[])new AutoCompleteField[]{customField1, customField2}));
    }

    private AutoCompleteField createAutoCompleteField(String name, String displayName, Boolean auto, Set<Operator> operators, Class<?> type, Boolean searchable) {
        String[] operatorsArray = (String[])Iterables.toArray((Iterable)Iterables.transform(operators, (Function)new Function<Operator, String>(){

            public String apply(Operator operator) {
                return operator.getDisplayString();
            }
        }), String.class);
        return new AutoCompleteField(name, displayName, auto.toString(), searchable.toString(), operatorsArray, new String[]{type.getCanonicalName()});
    }

    @Test
    public void testAutoCompleteNotAccessibleWithoutPermissions() {
        this.backdoor.customFields().createCustomField("conflict", "some description", CUSTOM_FIELD_TYPE, null);
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        ParsedResponse response = ((SearchAutoCompleteControl)this.client.loginAs("fred")).getAutoCompleteDataResponse();
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testAutoCompleteAccessibleByUserWithPermissions() {
        this.backdoor.customFields().createCustomField("conflict", "some description", CUSTOM_FIELD_TYPE, null);
        AutoCompleteData autoCompleteData = ((SearchAutoCompleteControl)this.client.loginAs("fred")).getAutoCompleteData();
        AutoCompleteField customField = this.createAutoCompleteField("conflict", "conflict - cf[10000]", false, Sets.newHashSet(), Object.class, false);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItem((Object)customField));
    }
}

