/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.matcher.ContainsStringThatStartsWith;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestIssueSearch.xml")
public class TestSearchResource
extends BaseJiraRestTest {
    private static final String HSP = "HSP";
    private static final String MKY = "MKY";
    private static final String HSP_1 = "HSP-1";
    private static final String HSP_5 = "HSP-5";
    private SearchClient searchClient;

    @Before
    public void setUpTest() {
        this.searchClient = new SearchClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testSearchShouldFilterOutIssuesFromNonBrowseableProjects() throws Exception {
        ParsedResponse response = this.searchClient.postSearchResponse(new SearchRequest().jql(""));
        SearchResult allResults = (SearchResult)response.body;
        Assert.assertThat((Object)allResults.total, (Matcher)CoreMatchers.equalTo((Object)9));
        response = ((SearchClient)this.searchClient.anonymous()).postSearchResponse(new SearchRequest().jql("project = HSP"));
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errorMessages.size());
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"The value 'HSP' does not exist for the field 'project'."));
        response = ((SearchClient)this.searchClient.anonymous()).postSearchResponse(new SearchRequest().jql("project = MKY"));
        SearchResult mkyResults = (SearchResult)response.body;
        Assert.assertThat((Object)mkyResults.total, (Matcher)CoreMatchers.equalTo((Object)4));
        Assert.assertThat((Object)mkyResults.issues.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        response = ((SearchClient)this.searchClient.anonymous()).postSearchResponse(new SearchRequest().jql(""));
        SearchResult anonResults = (SearchResult)response.body;
        Assert.assertThat((Object)anonResults.issues, (Matcher)CoreMatchers.equalTo((Object)mkyResults.issues));
    }

    @Test
    public void testSearchMaxResultsShouldDefaultTo50() throws Exception {
        SearchResult results = this.searchClient.postSearch(new SearchRequest());
        Assert.assertThat((Object)results.maxResults, (Matcher)CoreMatchers.equalTo((Object)50));
    }

    @Test
    public void testSearchMaxResultsIsNotAllowedToExceed1000() throws Exception {
        SearchResult results = this.searchClient.postSearch(new SearchRequest().maxResults(Integer.valueOf(2000)));
        Assert.assertThat((Object)results.maxResults, (Matcher)CoreMatchers.equalTo((Object)1000));
    }

    @Test
    public void testSearchShouldReturnPagesWithAtMostThreeIssues() throws Exception {
        int startAt;
        int issueCount = 9;
        int pageSize = 3;
        int pageNum = 0;
        HashSet keysReturnedInPreviousPage = Sets.newHashSet();
        while ((startAt = 3 * pageNum++) < 9) {
            SearchResult page = this.searchClient.postSearch(new SearchRequest().jql("order by key").maxResults(Integer.valueOf(3)).startAt(Integer.valueOf(startAt)));
            Assert.assertThat((Object)page.startAt, (Matcher)CoreMatchers.equalTo((Object)startAt));
            Assert.assertThat((Object)page.total, (Matcher)CoreMatchers.equalTo((Object)9));
            Assert.assertThat((Object)page.issues.size(), (Matcher)CoreMatchers.equalTo((Object)Math.min(3, 9 - startAt)));
            Assert.assertTrue((boolean)Sets.intersection((Set)keysReturnedInPreviousPage, (Set)Sets.newHashSet((Iterable)page.issues)).isEmpty());
            keysReturnedInPreviousPage.addAll(page.issues);
        }
    }

    @Test
    public void testSearchShouldReturnPagesWithAtMaxReturnZero() throws Exception {
        int issueCount = 9;
        int startAt = 3;
        boolean pageSize = false;
        SearchResult page = this.searchClient.postSearch(new SearchRequest().jql("order by key").maxResults(Integer.valueOf(0)).startAt(Integer.valueOf(startAt)));
        Assert.assertThat((Object)page.startAt, (Matcher)CoreMatchers.equalTo((Object)startAt));
        Assert.assertThat((Object)page.total, (Matcher)CoreMatchers.equalTo((Object)9));
        Assert.assertTrue((boolean)page.issues.isEmpty());
    }

    @Test
    public void testSearchStartAtAndMaxResultsShouldHaveDefaultValues() throws Exception {
        SearchResult results = this.searchClient.postSearch(new SearchRequest());
        Assert.assertThat((Object)results.startAt, (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)results.maxResults, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testSearchWithBadJqlShouldReturnStatusCode400() throws Exception {
        ParsedResponse results = this.searchClient.postSearchResponse(new SearchRequest().jql("zomg!!!11111"));
        Assert.assertThat((Object)results.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertThat((Object)results.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"Error in the JQL Query:"));
    }

    @Test
    public void testSearchWithNoJqlShouldReturnAllIssues() throws Exception {
        SearchRequest searchRequest = new SearchRequest().jql(null);
        Assert.assertFalse((boolean)this.searchClient.getSearch((SearchRequest)searchRequest).issues.isEmpty());
        Assert.assertFalse((boolean)this.searchClient.postSearch((SearchRequest)searchRequest).issues.isEmpty());
    }

    @Test
    public void testSearchUsingGetReturnsTheSameAsUsingPost() throws Exception {
        SearchRequest aSearch = new SearchRequest().fields(new String[]{"summary", "status"}).expand(new String[]{"names", "schema"});
        SearchResult postResults = this.searchClient.postSearch(aSearch);
        SearchResult getResults = this.searchClient.getSearch(aSearch);
        Assert.assertThat((Object)getResults, (Matcher)CoreMatchers.equalTo((Object)postResults));
    }

    @Test
    public void testSearchShouldRespectFieldsQueryParam() throws Exception {
        List<String> fieldsToInclude = Arrays.asList("summary,status,assignee");
        SearchRequest request = new SearchRequest().jql("key = HSP-5").fields(fieldsToInclude);
        SearchResult result = this.searchClient.getSearch(request);
        Assert.assertEquals((long)1L, (long)result.issues.size());
        Issue.Fields fields = ((Issue)result.issues.get((int)0)).fields;
        Assert.assertNotNull((Object)fields.get("summary"));
        Assert.assertNotNull((Object)fields.get("status"));
        Assert.assertNotNull((Object)fields.get("assignee"));
        Set idSet = fields.idSet();
        idSet.remove("summary");
        idSet.remove("status");
        idSet.remove("assignee");
        for (String id : idSet) {
            Assert.assertNull((Object)fields.get(id));
        }
    }

    @Test
    public void testSearchShouldRespectFieldsQueryParamForCustomFields() throws Exception {
        List<String> fieldsToInclude = Arrays.asList("summary,status,assignee,customfield_10001");
        SearchRequest request = new SearchRequest().jql("key = HSP-5").fields(fieldsToInclude);
        SearchResult result = this.searchClient.getSearch(request);
        Assert.assertEquals((long)1L, (long)result.issues.size());
        Issue.Fields fields = ((Issue)result.issues.get((int)0)).fields;
        Assert.assertNotNull((Object)fields.get("summary"));
        Assert.assertNotNull((Object)fields.get("status"));
        Assert.assertNotNull((Object)fields.get("assignee"));
        Assert.assertNotNull((Object)fields.get("customfield_10001"));
        Set idSet = fields.idSet();
        idSet.remove("summary");
        idSet.remove("status");
        idSet.remove("assignee");
        idSet.remove("customfield_10001");
        for (String id : idSet) {
            Assert.assertNull((Object)fields.get(id));
        }
    }

    @Test
    public void testNamesAndSchemaShouldBeAtTheTopLevelOfTheSearchResource() throws Exception {
        List<String> fields = Arrays.asList("summary");
        List<String> expand = Arrays.asList("names", "schema");
        SearchRequest search = new SearchRequest().fields(fields).expand(expand);
        SearchResult results = this.searchClient.getSearch(search);
        for (String field : expand) {
            Assert.assertThat((Object)results.expand, (Matcher)Matchers.containsString((String)field));
        }
        Assert.assertNotNull((Object)results.names);
        Assert.assertNotNull((Object)results.schema);
        for (String field : fields) {
            Assert.assertNotNull(results.names.get(field));
            Assert.assertNotNull(results.schema.get(field));
        }
        for (Issue issue : results.issues) {
            Assert.assertNull((Object)issue.names);
            Assert.assertNull((Object)issue.schema);
        }
    }

    @Test
    public void testQueryValidationCanBeDisabled() throws Exception {
        String hsp1 = HSP_1;
        String hsp123 = "HSP-123";
        String query = String.format("key in (%s, %s)", HSP_1, "HSP-123");
        ParsedResponse validateResults = this.searchClient.getSearchResponse(new SearchRequest().jql(query));
        Assert.assertThat((Object)validateResults.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        SearchResult noValidateResults = this.searchClient.getSearch(new SearchRequest().jql(query).validateQuery(false));
        Assert.assertThat((Object)noValidateResults.issues, (Matcher)TestSearchResource.containsIssueWithKey(HSP_1));
        Assert.assertThat((Object)noValidateResults.issues, (Matcher)CoreMatchers.not((Matcher)TestSearchResource.containsIssueWithKey("HSP-123")));
    }

    private static ContainsIssueMatcher containsIssueWithKey(String issueKey) {
        return new ContainsIssueMatcher(issueKey);
    }

    static class ContainsIssueMatcher
    extends TypeSafeMatcher<List<Issue>> {
        private final String issueKey;

        public ContainsIssueMatcher(String issueKey) {
            this.issueKey = issueKey;
        }

        protected boolean matchesSafely(List<Issue> issues) {
            for (Issue issue : issues) {
                if (!this.issueKey.equals(issue.key)) continue;
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("a list of Issue containing " + this.issueKey);
        }
    }
}

