/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.JIRAServerSetup;
import com.atlassian.jira.webtests.ztests.email.ShareClient;
import com.google.common.collect.Sets;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.net.BindException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.EMAIL})
@RestoreBlankInstance
public final class TestShareResource
extends EmailBaseFuncTestCase {
    public static final String FAKE_EMAIL = "fake@example.com";
    private static final String SHARED_FILTER_ID_TEMPLATE = "filter={0}";
    @Inject
    private FuncTestLogger funcTestLogger;
    private String issueKey;
    private ShareClient shareClient;

    @Before
    public void setUpShareResource() {
        try {
            this.mailService.configureAndStartGreenMail(JIRAServerSetup.SMTP);
        }
        catch (BindException e) {
            Assert.fail((String)"Error: Could not start green mail server. See log for details.");
        }
        int smtpPort = this.mailService.getSmtpPort();
        this.backdoor.mailServers().addSmtpServer(smtpPort);
        this.issueKey = this.backdoor.issues().createIssue(10000L, "Issue 1", "admin").key();
        this.shareClient = new ShareClient(this.getEnvironmentData());
        this.mailService.addUser("bob@stuff.com.com", "bob", "bob");
        this.mailService.addUser("fred@example.com", "fred", "fred");
        this.mailService.addUser(FAKE_EMAIL, "fake", "fake");
        this.backdoor.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.backdoor.usersAndGroups().addUserToGroup("bob", "jira-developers");
        this.backdoor.userProfile().changeUserNotificationType("bob", "text");
        this.backdoor.userProfile().changeUserNotificationType("fred", "html");
    }

    @Test
    public void testShareIssueWithSelf() throws Exception {
        ParsedResponse response = this.shareClient.shareIssue(this.issueKey, Sets.newHashSet((Object[])new String[]{"admin"}), Sets.newHashSet(), "This should be sent!");
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.flushMailQueueAndWait(0);
        Assert.assertThat((Object)this.mailService.getReceivedMessages().length, (Matcher)IsEqual.equalTo((Object)1));
    }

    @Test
    public void testAlsoSharedWithInTextNotification() throws Exception {
        HashSet userNames = Sets.newHashSet((Object[])new String[]{"bob"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{FAKE_EMAIL});
        ParsedResponse response = this.shareClient.shareIssue(this.issueKey, userNames, emails, "This shouldn't be sent!");
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.flushMailQueueAndWait(0);
        MimeMessage fredMessage = this.getMessagesForRecipient("bob@stuff.com.com").get(0);
        this.assertEmailBodyContains(fredMessage, "Also shared with");
        this.assertEmailBodyContains(fredMessage, FAKE_EMAIL);
        this.assertEmailBodyDoesntContain(fredMessage, "</html");
    }

    @Test
    public void testAlsoSharedWithInHtmlNotification() throws Exception {
        HashSet userNames = Sets.newHashSet((Object[])new String[]{"fred"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{FAKE_EMAIL});
        ParsedResponse response = this.shareClient.shareIssue(this.issueKey, userNames, emails, "This shouldn't be sent!");
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.flushMailQueueAndWait(0);
        MimeMessage fredMessage = this.getMessagesForRecipient("fred@example.com").get(0);
        this.assertEmailBodyContains(fredMessage, "Also shared with");
        this.assertEmailBodyContains(fredMessage, FAKE_EMAIL);
        this.assertEmailBodyContains(fredMessage, "</html>");
    }

    @Test
    public void testShouldSentShareEvenIfMoreThanSixRecipients() throws Exception {
        HashSet userNames = Sets.newHashSet();
        HashSet emails = Sets.newHashSet((Object[])new String[]{"1@example.com", "2@example.com", "3@example.com", "4@example.com", "5@example.com", "6@example.com", "7@example.com"});
        this.addMailsToService(emails);
        ParsedResponse response = this.shareClient.shareIssue(this.issueKey, userNames, emails, "This shouldn't be sent!");
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.flushMailQueueAndWait(0);
        for (String email : emails) {
            MimeMessage message = this.getMessagesForRecipient(email).get(0);
            this.assertEmailBodyContains(message, "Also shared with");
            this.assertMessageContainsSharedWithWithoutRecipient(email, emails, message);
        }
    }

    @Test
    public void testShouldNotIncludeAuthorInSharedWithListButSendHimMessage() throws Exception {
        this.shareClient.loginAs("bob");
        HashSet userNames = Sets.newHashSet((Object[])new String[]{"fred", "bob"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{FAKE_EMAIL});
        ParsedResponse response = this.shareClient.shareIssue(this.issueKey, userNames, emails, "This shouldn't be sent!");
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.flushMailQueueAndWait(0);
        Assert.assertThat(this.getMessagesForRecipient("bob@stuff.com.com"), (Matcher)Matchers.hasSize((int)1));
        this.assertThatAuthorIsNotPresentInAlsoSharedWithList();
    }

    @Test
    public void testShouldNotSendShareMessageWhenUserHaveNoRights() throws Exception {
        this.shareClient.loginAs("fred");
        HashSet userNames = Sets.newHashSet((Object[])new String[]{"bob"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{FAKE_EMAIL});
        ParsedResponse response = this.shareClient.shareIssue(this.issueKey, userNames, emails, "Fred have no rights to share!");
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        this.flushMailQueueAndWait(0);
        Assert.assertThat((Object)this.mailService.getReceivedMessages().length, (Matcher)IsEqual.equalTo((Object)0));
    }

    @Test
    public void testShouldSendShareJql() throws Exception {
        HashSet userNames = Sets.newHashSet((Object[])new String[]{"bob"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{FAKE_EMAIL});
        String jql = "Some_JQL_in_here";
        ParsedResponse response = this.shareClient.shareSearchQuery("Some_JQL_in_here", userNames, emails, "Share Jql");
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.flushMailQueueAndWait(0);
        MimeMessage mailMessage = this.getMessagesForRecipient("bob@stuff.com.com").get(0);
        this.assertEmailBodyContains(mailMessage, "Some_JQL_in_here");
    }

    @Test
    public void testShouldSendShareSavedFilter() throws Exception {
        HashSet userNames = Sets.newHashSet((Object[])new String[]{"bob"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{FAKE_EMAIL});
        String jql = "issuekey=HSP-1";
        String savedFilterId = this.backdoor.filters().createFilter("issuekey=HSP-1", "FilterName", "admin", "jira-developers");
        ParsedResponse response = this.shareClient.shareSavedSearch(savedFilterId, userNames, emails, "Share saved filter");
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.flushMailQueueAndWait(0);
        MimeMessage mailMessage = this.getMessagesForRecipient("bob@stuff.com.com").get(0);
        this.assertEmailBodyContains(mailMessage, MessageFormat.format(SHARED_FILTER_ID_TEMPLATE, savedFilterId));
        this.assertEmailBodyDoesntContain(mailMessage, "issuekey=HSP-1");
    }

    @Test
    public void testShouldSendShareJqlInsteadOfSavedFilterIfRecipientHaveNoPermissionsToViewThatFilter() throws Exception {
        HashSet userNames = Sets.newHashSet((Object[])new String[]{"fred"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{FAKE_EMAIL});
        String jql = "issuekey=HSP-1";
        String savedFilterId = this.backdoor.filters().createFilter("issuekey=HSP-1", "FilterName", "admin", "jira-developers");
        ParsedResponse response = this.shareClient.shareSavedSearch(savedFilterId, userNames, emails, "Share saved filter");
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.flushMailQueueAndWait(0);
        MimeMessage mailMessage = this.getMessagesForRecipient("fred@example.com").get(0);
        this.assertEmailBodyContains(mailMessage, this.toUrlParam("issuekey=HSP-1"));
        this.assertEmailBodyDoesntContain(mailMessage, MessageFormat.format(SHARED_FILTER_ID_TEMPLATE, savedFilterId));
    }

    @Test
    public void testShouldNotSendShareMessageWhenNoRecipientsSpecified() throws Exception {
        this.shareClient.loginAs("bob");
        ParsedResponse response = this.shareClient.shareIssue(this.issueKey, Sets.newHashSet(), Sets.newHashSet(), "No recipients specified!");
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        this.flushMailQueueAndWait(0);
        Assert.assertThat((Object)this.mailService.getReceivedMessages().length, (Matcher)IsEqual.equalTo((Object)0));
    }

    private String toUrlParam(String jql) {
        return JiraUrlCodec.encode((String)jql, (String)"UTF-8");
    }

    private void assertThatAuthorIsNotPresentInAlsoSharedWithList() throws MessagingException {
        MimeMessage mailMessage = this.getMessagesForRecipient("fred@example.com").get(0);
        String mailBody = GreenMailUtil.getBody((Part)mailMessage);
        String footerPartOfBody = mailBody.substring(mailBody.indexOf("Also shared with"));
        String footerWithoutAvatars = footerPartOfBody.substring(0, footerPartOfBody.indexOf("</html>"));
        Assert.assertThat((Object)footerWithoutAvatars, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)FAKE_EMAIL), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"bob"))));
    }

    private void assertMessageContainsSharedWithWithoutRecipient(String email, Set<String> emails, MimeMessage message) throws Exception {
        Sets.SetView otherRecipients = Sets.difference(emails, Collections.singleton(email));
        for (String otherRecipient : otherRecipients) {
            this.assertEmailBodyContains(message, otherRecipient);
        }
    }

    private void addMailsToService(Set<String> emails) {
        for (String email : emails) {
            this.mailService.addUser(email, email, email);
        }
    }
}

