/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.DarkFeature;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.SiteDarkFeaturesClientExt;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestSiteDarkFeaturesResource
extends BaseJiraRestTest {
    private static final String DARK_FEATURE_KEY = "my.dark.feature";
    private static final String DARK_FEATURE_OTHER_KEY = "my.other.dark.feature";
    private SiteDarkFeaturesClientExt client;

    @Before
    public void setUpTest() {
        this.client = new SiteDarkFeaturesClientExt(this.environmentData);
    }

    @Test
    public void testGet() throws Exception {
        this.client.loginAs("admin", "admin");
        DarkFeature darkFeature = this.client.get(DARK_FEATURE_KEY);
        Assert.assertFalse((boolean)darkFeature.enabled);
        this.backdoor.darkFeatures().enableForSite(DARK_FEATURE_KEY);
        darkFeature = this.client.get(DARK_FEATURE_KEY);
        Assert.assertTrue((boolean)darkFeature.enabled);
    }

    @Test
    public void testEnable() throws Exception {
        this.client.loginAs("admin", "admin");
        Assert.assertFalse((boolean)this.backdoor.darkFeatures().isGlobalEnabled(DARK_FEATURE_KEY));
        this.client.put(DARK_FEATURE_KEY, true);
        Assert.assertTrue((boolean)this.backdoor.darkFeatures().isGlobalEnabled(DARK_FEATURE_KEY));
    }

    @Test
    public void testDisable() throws Exception {
        this.backdoor.darkFeatures().enableForSite(DARK_FEATURE_KEY);
        Assert.assertTrue((boolean)this.backdoor.darkFeatures().isGlobalEnabled(DARK_FEATURE_KEY));
        this.client.loginAs("admin", "admin");
        this.client.put(DARK_FEATURE_KEY, false);
        Assert.assertFalse((boolean)this.backdoor.darkFeatures().isGlobalEnabled(DARK_FEATURE_KEY));
    }

    @Test
    public void testNonAdministrator() throws Exception {
        this.client.loginAs("fred");
        ParsedResponse response = this.client.putResponse(DARK_FEATURE_KEY, true);
        Assert.assertEquals((long)403L, (long)response.statusCode);
        response = this.client.putResponse(DARK_FEATURE_KEY, false);
        Assert.assertEquals((long)403L, (long)response.statusCode);
        response = this.client.getResponse(DARK_FEATURE_KEY);
        Assert.assertEquals((long)403L, (long)response.statusCode);
    }

    @Test
    public void testBatchUpdateDarkFeature() throws Exception {
        Map<String, DarkFeature> enabledFeatures_1 = this.client.post((Map<String, DarkFeature>)ImmutableMap.of((Object)DARK_FEATURE_KEY, (Object)new DarkFeature((boolean)true), (Object)DARK_FEATURE_OTHER_KEY, (Object)new DarkFeature((boolean)true))).siteFeatures;
        MatcherAssert.assertThat(enabledFeatures_1, (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)DARK_FEATURE_KEY), (Matcher)Matchers.hasKey((Object)DARK_FEATURE_OTHER_KEY)));
        MatcherAssert.assertThat((Object)enabledFeatures_1.get((Object)DARK_FEATURE_KEY).enabled, (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)enabledFeatures_1.get((Object)DARK_FEATURE_OTHER_KEY).enabled, (Matcher)Matchers.is((Object)Boolean.TRUE));
        Map<String, DarkFeature> enabledFeatures_2 = this.client.post((Map<String, DarkFeature>)ImmutableMap.of((Object)DARK_FEATURE_KEY, (Object)new DarkFeature((boolean)false), (Object)DARK_FEATURE_OTHER_KEY, (Object)new DarkFeature((boolean)true))).siteFeatures;
        MatcherAssert.assertThat(enabledFeatures_2, (Matcher)Matchers.allOf((Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)DARK_FEATURE_KEY)), (Matcher)Matchers.hasKey((Object)DARK_FEATURE_OTHER_KEY)));
        Assert.assertTrue((boolean)enabledFeatures_2.get((Object)DARK_FEATURE_OTHER_KEY).enabled);
        Map<String, DarkFeature> enabledFeatures_3 = this.client.post((Map<String, DarkFeature>)ImmutableMap.of((Object)DARK_FEATURE_KEY, (Object)new DarkFeature((boolean)true), (Object)DARK_FEATURE_OTHER_KEY, (Object)new DarkFeature((boolean)false))).siteFeatures;
        MatcherAssert.assertThat(enabledFeatures_3, (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)DARK_FEATURE_KEY), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)DARK_FEATURE_OTHER_KEY))));
        Assert.assertTrue((boolean)enabledFeatures_3.get((Object)DARK_FEATURE_KEY).enabled);
    }
}

