/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.ColumnControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestSystemColumns
extends BaseJiraFuncTest {
    private Function<ColumnControl.ColumnItem, String> COLUMNITEM_TO_STRING = input -> input.value;

    @Test
    public void testGetAndSetSystemDefaultColumnsNotAdmin() {
        boolean hasException;
        block2: {
            this.backdoor.usersAndGroups().removeUserFromGroup("admin", "jira-administrators");
            Assert.assertFalse((String)"Non admin has no access to set system columns", (boolean)this.backdoor.columnControl().setSystemDefaultColumns(Lists.newArrayList()));
            hasException = false;
            try {
                this.backdoor.columnControl().getSystemDefaultColumns();
            }
            catch (WebApplicationException e) {
                if (e.getResponse().getStatus() != 403) break block2;
                hasException = true;
            }
        }
        Assert.assertTrue((String)"Non admin has no access to get system columns", (boolean)hasException);
        this.backdoor.usersAndGroups().addUserToGroup("admin", "jira-administrators");
    }

    @Test
    public void testGetAndSetSystemDefaultColumns() {
        ArrayList defaultColumns = Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "summary", "assignee", "reporter", "priority", "status", "resolution", "created", "updated", "duedate"});
        Assert.assertEquals((Object)defaultColumns, (Object)Lists.transform(this.backdoor.columnControl().getSystemDefaultColumns(), this.COLUMNITEM_TO_STRING));
        ArrayList systemColumns = Lists.newArrayList((Iterable)defaultColumns);
        systemColumns.add("description");
        systemColumns.add("resolutiondate");
        systemColumns.remove("summary");
        systemColumns.remove("status");
        Assert.assertTrue((String)"No errors when setting the column", (boolean)this.backdoor.columnControl().setSystemDefaultColumns(systemColumns));
        Assert.assertEquals((Object)systemColumns, (Object)Lists.transform(this.backdoor.columnControl().getSystemDefaultColumns(), this.COLUMNITEM_TO_STRING));
        Assert.assertEquals((Object)systemColumns, (Object)Lists.transform(this.backdoor.columnControl().getLoggedInUserColumns(), this.COLUMNITEM_TO_STRING));
        ArrayList userColumns = Lists.newArrayList((Iterable)systemColumns);
        userColumns.add("status");
        userColumns.add("summary");
        Assert.assertTrue((String)"No errors when setting the column", (boolean)this.backdoor.columnControl().setLoggedInUserColumns(userColumns));
        Assert.assertEquals((Object)userColumns, (Object)Lists.transform(this.backdoor.columnControl().getLoggedInUserColumns(), this.COLUMNITEM_TO_STRING));
        Assert.assertEquals((Object)systemColumns, (Object)Lists.transform(this.backdoor.columnControl().getSystemDefaultColumns(), this.COLUMNITEM_TO_STRING));
        Assert.assertTrue((String)"No errors when removing all columns", (boolean)this.backdoor.columnControl().setSystemDefaultColumns(Lists.newArrayList()));
        Assert.assertEquals((long)0L, (long)this.backdoor.columnControl().getSystemDefaultColumns().size());
    }
}

