/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.backdoor.ColumnControl;
import com.atlassian.jira.functest.framework.backdoor.WorkflowsControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Group;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserClient;
import com.atlassian.jira.testkit.client.restclient.UserPickerResults;
import com.atlassian.jira.testkit.client.restclient.UserPickerUser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestUserResource.xml")
public class TestUserResource
extends BaseJiraFuncTest {
    private static final String USER_PATH = "user";
    private static final String REST_PATH = "rest/api/2";
    private static final String REST_USER_URL = "rest/api/2/user";
    public static final String NOT_EXISTING_USERNAME = "not-existing-user";
    private static final Condition<WebApplicationException> badRequest = new Condition<WebApplicationException>(){

        public boolean matches(WebApplicationException e) {
            return e.getResponse().getStatusInfo().equals(Response.Status.BAD_REQUEST);
        }
    };
    private UserClient userClient;
    private ManualClient manualClient;
    @Inject
    private GeneralConfiguration generalConfiguration;

    @Before
    public void setUpTest() {
        this.userClient = new UserClient((JIRAEnvironmentData)this.environmentData);
        this.manualClient = new ManualClient(this.environmentData);
    }

    @Test
    public void testUserResourceNoUsernameNorKey() {
        ParsedResponse response = this.userClient.getUserResponse(null);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("Either the 'username' or the 'key' query parameters need to be provided"));
    }

    @Test
    public void testUserResourceForUserByNameThatDoesntExist() {
        ParsedResponse response = this.userClient.getUserResponse("bofh");
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("The user named 'bofh' does not exist"));
    }

    @Test
    public void testUserResourceForUserByNameThatDoesntExistIncludeDeleted() {
        ParsedResponse response = this.userClient.getUserResponse("bofh", true);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("The user named 'bofh' does not exist"));
    }

    @Test
    public void testUserResourceForUserByKeyThatDoesntExist() {
        ParsedResponse response = this.userClient.getUserResponseByKey("bofh");
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("The user with the key 'bofh' does not exist"));
    }

    @Test
    public void testUserResourceForUserByKeyThatDoesntExistIncludeDeleted() {
        ParsedResponse response = this.userClient.getUserResponseByKey("bofh", true);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("The user with the key 'bofh' does not exist"));
    }

    @Test
    public void testUserResourceForUserByName() {
        User fred = this.userClient.get("bloblaw", new User.Expand[0]);
        Assert.assertNotNull((Object)fred);
        Assert.assertEquals((Object)"bloblaw", (Object)fred.name);
        Assert.assertEquals((Object)"bob", (Object)fred.key);
        MatcherAssert.assertThat((Object)fred.deleted, (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)fred.active, (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testUserResourceForUserByKey() {
        User fred = this.userClient.getByKey("bob", new User.Expand[0]);
        Assert.assertNotNull((Object)fred);
        Assert.assertEquals((Object)"bloblaw", (Object)fred.name);
        Assert.assertEquals((Object)"bob", (Object)fred.key);
        MatcherAssert.assertThat((Object)fred.deleted, (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)fred.active, (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testUserResourceForUserByNameIncludeDeleted() {
        User fred = this.userClient.get("bloblaw", true, new User.Expand[0]);
        Assert.assertNotNull((Object)fred);
        Assert.assertEquals((Object)"bloblaw", (Object)fred.name);
        Assert.assertEquals((Object)"bob", (Object)fred.key);
    }

    @Test
    public void testUserResourceForUserByKeyIncludeDeleted() {
        User fred = this.userClient.getByKey("bob", true, new User.Expand[0]);
        Assert.assertNotNull((Object)fred);
        Assert.assertEquals((Object)"bloblaw", (Object)fred.name);
        Assert.assertEquals((Object)"bob", (Object)fred.key);
    }

    @Test
    public void testUserResourceForDeletedUserByNameIncludeDeleted() {
        this.backdoor.usersAndGroups().deleteUser("bloblaw");
        User fred = this.userClient.get("bloblaw", true, new User.Expand[0]);
        Assert.assertNotNull((Object)fred);
        Assert.assertEquals((Object)"bloblaw", (Object)fred.name);
        Assert.assertEquals((Object)"bloblaw", (Object)fred.displayName);
        Assert.assertEquals((Object)"bob", (Object)fred.key);
        Assert.assertEquals((Object)"?", (Object)fred.emailAddress);
        MatcherAssert.assertThat((Object)fred.deleted, (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)fred.active, (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testUserResourceForDeletedUserByKeyIncludeDeleted() {
        this.backdoor.usersAndGroups().deleteUser("bloblaw");
        User fred = this.userClient.getByKey("bob", true, new User.Expand[0]);
        Assert.assertNotNull((Object)fred);
        Assert.assertEquals((Object)"bloblaw", (Object)fred.name);
        Assert.assertEquals((Object)"bloblaw", (Object)fred.displayName);
        Assert.assertEquals((Object)"bob", (Object)fred.key);
        Assert.assertEquals((Object)"?", (Object)fred.emailAddress);
        MatcherAssert.assertThat((Object)fred.deleted, (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)fred.active, (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testUserResourceForDeletedUserByKeyIncludeDeletedShouldNotAllowNonAdminUsers() {
        this.backdoor.usersAndGroups().deleteUser("bloblaw");
        ParsedResponse responseAdmin = this.userClient.getUserResponseByKey("bob", true);
        MatcherAssert.assertThat((Object)responseAdmin.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        ParsedResponse responseUser = ((UserClient)this.userClient.loginAs("fred")).getUserResponseByKey("bob", true);
        MatcherAssert.assertThat((Object)responseUser.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testUserResourceForDeletedUserByUsernameIncludeDeletedShouldNotAllowNonAdminUsers() {
        this.backdoor.usersAndGroups().deleteUser("bloblaw");
        ParsedResponse responseAdmin = this.userClient.getUserResponseByKey("bloblaw", true);
        MatcherAssert.assertThat((Object)responseAdmin.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        ParsedResponse responseUser = ((UserClient)this.userClient.loginAs("fred")).getUserResponseByKey("bloblaw", true);
        MatcherAssert.assertThat((Object)responseUser.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testUserResourceForUserByUsernameAndKey() {
        WebTarget webResource = this.manualClient.createResource().path(USER_PATH).queryParam("username", new Object[]{"blobblaw"}).queryParam("key", new Object[]{"bob"});
        Assert.assertEquals((long)this.manualClient.getResponse((WebTarget)webResource).statusCode, (long)400L);
    }

    @Test
    public void testUserResourceTimeZone() {
        User user = this.userClient.get("admin", new User.Expand[0]);
        Assert.assertEquals((Object)"Australia/Sydney", (Object)user.timeZone);
    }

    @Test
    public void testUserResourceLocale() {
        User user = this.userClient.get("admin", new User.Expand[0]);
        Assert.assertEquals((Object)"en_AU", (Object)user.locale);
    }

    @Test
    public void testSearchUsers() {
        List users = this.userClient.search("fre", "0", null);
        Assert.assertEquals((long)1L, (long)users.size());
        User user = (User)users.get(0);
        Assert.assertEquals((Object)"fred", (Object)user.name);
        Assert.assertEquals((Object)"Fred Normal", (Object)user.displayName);
        users = this.userClient.search("", "0", null);
        Assert.assertEquals((long)0L, (long)users.size());
        users = this.userClient.search("love", "0", null);
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"\u611b", (Object)((User)users.get((int)0)).name);
        users = this.userClient.search("a", null, null);
        Assert.assertEquals((long)3L, (long)users.size());
        Assert.assertEquals((Object)"a\\b", (Object)((User)users.get((int)0)).name);
        Assert.assertEquals((Object)"admin", (Object)((User)users.get((int)1)).name);
        Assert.assertEquals((Object)"sp ace", (Object)((User)users.get((int)2)).name);
        users = this.userClient.search("a", "0", "1");
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"a\\b", (Object)((User)users.get((int)0)).name);
        users = this.userClient.search("a", "1", "30");
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertEquals((Object)"admin", (Object)((User)users.get((int)0)).name);
        Assert.assertEquals((Object)"sp ace", (Object)((User)users.get((int)1)).name);
        users = this.userClient.search("fred", null, null, null, null);
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"fred", (Object)((User)users.get((int)0)).name);
        users = this.userClient.search("fred", null, null, null, Boolean.valueOf(true));
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertEquals((Object)"fred", (Object)((User)users.get((int)0)).name);
        Assert.assertEquals((Object)"fredx", (Object)((User)users.get((int)1)).name);
        users = this.userClient.search("fred", null, null, Boolean.valueOf(true), Boolean.valueOf(true));
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertEquals((Object)"fred", (Object)((User)users.get((int)0)).name);
        Assert.assertEquals((Object)"fredx", (Object)((User)users.get((int)1)).name);
        users = this.userClient.search("fred", null, null, Boolean.valueOf(false), Boolean.valueOf(true));
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"fredx", (Object)((User)users.get((int)0)).name);
        users = this.userClient.search("fred", null, null, Boolean.valueOf(false), Boolean.valueOf(false));
        Assert.assertEquals((long)0L, (long)users.size());
        users = this.userClient.search("blo", null, null, Boolean.valueOf(true), Boolean.valueOf(false));
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"bloblaw", (Object)((User)users.get((int)0)).name);
        Assert.assertEquals((Object)"bob", (Object)((User)users.get((int)0)).key);
    }

    @Test
    public void testSearchWithMultipleTokensInQuery() {
        List users = this.userClient.search("Fred Normal", "0", null);
        Assert.assertEquals((long)1L, (long)users.size());
        User user = (User)users.get(0);
        Assert.assertEquals((Object)"fred", (Object)user.name);
        Assert.assertEquals((Object)"Fred Normal", (Object)user.displayName);
    }

    @Test
    public void testSearchIsCaseInsensitive() {
        List users = this.userClient.search("fReD", "0", null);
        Assert.assertEquals((long)1L, (long)users.size());
        User user = (User)users.get(0);
        Assert.assertEquals((Object)"fred", (Object)user.name);
        Assert.assertEquals((Object)"Fred Normal", (Object)user.displayName);
    }

    @Test
    public void testHandleEdgeCaseOffset() throws IOException {
        int maxResultsLimit = this.getMaxResultsLimit();
        for (String term : ImmutableList.of((Object)"", (Object)"u", (Object)USER_PATH)) {
            int numOfIssues = this.searchWithOffset(term, 0).size();
            int offsetOutOfBounds = numOfIssues + 1;
            Assert.assertEquals((long)0L, (long)this.searchWithOffset(term, offsetOutOfBounds).size());
            Assert.assertEquals((long)0L, (long)this.searchWithOffset(term, maxResultsLimit - 50).size());
            Assertions.assertThatExceptionOfType(WebApplicationException.class).isThrownBy(() -> this.searchWithOffset(term, -1)).is(badRequest);
            Assertions.assertThatExceptionOfType(WebApplicationException.class).isThrownBy(() -> this.searchWithOffset(term, maxResultsLimit - 50 + 1)).is(badRequest);
        }
    }

    private int getMaxResultsLimit() throws IOException {
        String propertyValue = this.manualClient.getPropertyValue("jira.user.search.maxresults.limit");
        int maxResultsLimit = Integer.parseInt(propertyValue);
        return maxResultsLimit;
    }

    private List<?> searchWithOffset(String term, int startAt) {
        return this.userClient.search(term, String.valueOf(startAt), "");
    }

    private List<?> multiProjectSearchWithOffset(String term, int startAt) {
        return this.userClient.multiProjectSearchAssignable(term, "HSP", String.valueOf(startAt), "");
    }

    @Test
    public void testSearchUsersWithMultipleTokensInUsername() {
        ImmutableList separators = ImmutableList.of((Object)" ", (Object)"@", (Object)".", (Object)"-", (Object)"\"", (Object)",", (Object)"'", (Object)"(");
        List multiTokenUsernames = separators.stream().map(separator -> "yyy" + separator + "zz").collect(Collectors.toList());
        for (String username : multiTokenUsernames) {
            this.backdoor.usersAndGroups().addUser(username);
        }
        List foundUserNames = this.userClient.search("zz", "0", null).stream().map(user -> user.name).collect(Collectors.toList());
        MatcherAssert.assertThat(foundUserNames, (Matcher)Matchers.containsInAnyOrder((Object[])multiTokenUsernames.toArray()));
    }

    @Test
    public void testSearchDoesNotIgnoreDiacritics() {
        List users = this.userClient.search("fr\u00ef\u00bf\u00bdd", "0", null);
        Assert.assertEquals((long)0L, (long)users.size());
    }

    @Test
    public void testSearchBySeparatorCharacter() {
        this.backdoor.usersAndGroups().addUser("fr,,ed");
        List users = this.userClient.search(",", "0", "100");
        Assert.assertEquals((long)10L, (long)users.size());
    }

    @Test
    public void testQueryWithInfixSeparator() {
        this.backdoor.usersAndGroups().addUser("a@z");
        this.backdoor.usersAndGroups().addUser("aa@z");
        this.backdoor.usersAndGroups().addUser("aaa@z");
        List users = this.userClient.search("a@z", "0", "100");
        Assert.assertEquals((long)3L, (long)users.size());
    }

    @Test
    public void testPickerUsers() {
        UserPickerResults results = this.userClient.picker("fre", null);
        Assert.assertEquals((long)1L, (long)results.users.size());
        UserPickerUser user = (UserPickerUser)results.users.get(0);
        Assert.assertEquals((Object)"fred", (Object)user.name);
        Assert.assertEquals((Object)"fred", (Object)user.key);
        Assert.assertEquals((Object)"Fred Normal", (Object)user.displayName);
        Assert.assertEquals((Object)"<strong>Fre</strong>d Normal - <strong>fre</strong>d@example.com (<strong>fre</strong>d)", (Object)user.html);
        Assert.assertEquals((Object)"Showing 1 of 1 matching users", (Object)results.header);
        results = this.userClient.picker("love", null);
        Assert.assertEquals((long)1L, (long)results.users.size());
        Assert.assertEquals((Object)"\u611b", (Object)((UserPickerUser)results.users.get((int)0)).name);
        Assert.assertEquals((Object)"Showing 1 of 1 matching users", (Object)results.header);
        results = this.userClient.picker("a", null);
        Assert.assertEquals((long)3L, (long)results.users.size());
        Assert.assertEquals((Object)"<strong>a</strong>\\b - <strong>a</strong>b@example.com (<strong>a</strong>\\b)", (Object)((UserPickerUser)results.users.get((int)0)).html);
        Assert.assertEquals((Object)"<strong>A</strong>dministrator - <strong>a</strong>dmin@example.com (<strong>a</strong>dmin)", (Object)((UserPickerUser)results.users.get((int)1)).html);
        Assert.assertEquals((Object)"sp <strong>a</strong>ce - space@example.com (sp <strong>a</strong>ce)", (Object)((UserPickerUser)results.users.get((int)2)).html);
        Assert.assertEquals((Object)"Showing 3 of 3 matching users", (Object)results.header);
        results = this.userClient.picker("example.com", null);
        Assert.assertEquals((long)9L, (long)results.users.size());
        Assert.assertEquals((Object)"a\\b - ab@<strong>example.com</strong> (a\\b)", (Object)((UserPickerUser)results.users.get((int)0)).html);
        Assert.assertEquals((Object)"Administrator - admin@<strong>example.com</strong> (admin)", (Object)((UserPickerUser)results.users.get((int)1)).html);
        Assert.assertEquals((Object)"Bob Loblaw - bob@<strong>example.com</strong> (bloblaw)", (Object)((UserPickerUser)results.users.get((int)2)).html);
        Assert.assertEquals((Object)"c/d - cd@<strong>example.com</strong> (c/d)", (Object)((UserPickerUser)results.users.get((int)3)).html);
        Assert.assertEquals((Object)"Fred Normal - fred@<strong>example.com</strong> (fred)", (Object)((UserPickerUser)results.users.get((int)4)).html);
        Assert.assertEquals((Object)"per%cent - pct@<strong>example.com</strong> (per%cent)", (Object)((UserPickerUser)results.users.get((int)5)).html);
        Assert.assertEquals((Object)"pl+us - pl+us@<strong>example.com</strong> (pl+us)", (Object)((UserPickerUser)results.users.get((int)6)).html);
        Assert.assertEquals((Object)"sp ace - space@<strong>example.com</strong> (sp ace)", (Object)((UserPickerUser)results.users.get((int)7)).html);
        Assert.assertTrue((boolean)((UserPickerUser)results.users.get((int)8)).html.contains(" - love@<strong>example.com</strong> ("));
        Assert.assertEquals((Object)"Showing 9 of 9 matching users", (Object)results.header);
    }

    @Test
    public void testUsersByPermission() {
        String mike = "Mike";
        String theresa = "Theresa";
        String groupName = "group";
        this.backdoor.usersAndGroups().addGroup(groupName);
        this.backdoor.usersAndGroups().addUser(mike);
        this.backdoor.usersAndGroups().addUserToGroup(mike, groupName);
        this.backdoor.usersAndGroups().addUser(theresa);
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.EDIT_ALL_COMMENTS, theresa);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_OWN_COMMENTS, groupName);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGNABLE_USER, groupName);
        this.backdoor.permissionSchemes().addCurrentAssigneePermission(0L, ProjectPermissions.DELETE_OWN_COMMENTS);
        Assert.assertEquals((Object)"HSP-1", (Object)this.backdoor.issues().createIssue((String)"HSP", (String)"Permissions test").key);
        Matcher allUsersMatcher = Matchers.contains((Object[])new String[]{"a\\b", "admin", "bloblaw", "c/d", mike});
        List<String> usersWhenQueryNotDefined = this.getUserNames(this.userClient.searchByPermission(null, "ASSIGNABLE_USER", "HSP-1", null, null, null));
        MatcherAssert.assertThat(usersWhenQueryNotDefined, (Matcher)allUsersMatcher);
        List<String> usersWhenQueryEmpty = this.getUserNames(this.userClient.searchByPermission("", "ASSIGNABLE_USER", "HSP-1", null, null, null));
        MatcherAssert.assertThat(usersWhenQueryEmpty, (Matcher)allUsersMatcher);
        Assert.assertEquals((Object)ImmutableList.of((Object)mike), this.getUserNames(this.userClient.searchByPermission("mi", "ASSIGNABLE_USER", "HSP-1", null, "0", "1")));
        Assert.assertEquals((Object)ImmutableList.of((Object)"admin", (Object)"bloblaw"), this.getUserNames(this.userClient.searchByPermission("", "ASSIGNABLE_USER", "HSP-1", null, "1", "2")));
        List<String> commentEditAllUsersForIssue = this.getUserNames(this.userClient.searchByPermission("", "COMMENT_EDIT_ALL", "HSP-1", null, null, null));
        MatcherAssert.assertThat(commentEditAllUsersForIssue, (Matcher)Matchers.contains((Object[])new String[]{theresa}));
        List<String> commentEditAllForProject = this.getUserNames(this.userClient.searchByPermission("", "COMMENT_EDIT_ALL", null, "HSP", null, null));
        MatcherAssert.assertThat(commentEditAllForProject, (Matcher)Matchers.contains((Object[])new String[]{theresa}));
        List<String> commentEditAndDeleteUsers1 = this.getUserNames(this.userClient.searchByPermission("", "COMMENT_EDIT_OWN,COMMENT_DELETE_OWN", "HSP-1", null, null, null));
        MatcherAssert.assertThat(commentEditAndDeleteUsers1, (Matcher)Matchers.empty());
        this.backdoor.issues().assignIssue("HSP-1", mike);
        List<String> commentEditAndDeleteUsers2 = this.getUserNames(this.userClient.searchByPermission("", "COMMENT_EDIT_OWN,COMMENT_DELETE_OWN", "HSP-1", null, null, null));
        MatcherAssert.assertThat(commentEditAndDeleteUsers2, (Matcher)Matchers.contains((Object[])new String[]{mike}));
        List<String> permissionForProjectUsers = this.getUserNames(this.userClient.searchByPermission("", "COMMENT_DELETE_OWN", null, "HSP", null, null));
        MatcherAssert.assertThat(permissionForProjectUsers, (Matcher)Matchers.empty());
        List<String> permissionForProjectAndIssueUsers = this.getUserNames(this.userClient.searchByPermission("", "COMMENT_DELETE_OWN", "HSP-1", "HSP", null, null));
        MatcherAssert.assertThat(permissionForProjectAndIssueUsers, (Matcher)Matchers.contains((Object[])new String[]{mike}));
        ParsedResponse userResponse = ((UserClient)this.userClient.loginAs("fred")).searchByPermissionResponse("", "ASSIGNABLE_USER", "HSP-1", null, null, null);
        Assert.assertEquals((long)403L, (long)userResponse.statusCode);
    }

    @Test
    public void testAssignableAndViewableUsers() {
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-administrators");
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-developers");
        String issueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"Sample Issue").key;
        List users = this.userClient.search("a", null, null);
        Assert.assertEquals((long)3L, (long)users.size());
        Assert.assertEquals((Object)"a\\b", (Object)((User)users.get((int)0)).name);
        Assert.assertEquals((Object)"admin", (Object)((User)users.get((int)1)).name);
        Assert.assertEquals((Object)"sp ace", (Object)((User)users.get((int)2)).name);
        users = this.userClient.searchAssignable("a", issueKey, null, null);
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"admin", (Object)((User)users.get((int)0)).name);
        users = this.userClient.searchViewableIssue("a", issueKey, null, null);
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertEquals((Object)"a\\b", (Object)((User)users.get((int)0)).name);
        Assert.assertEquals((Object)"admin", (Object)((User)users.get((int)1)).name);
    }

    @Test
    public void testUnprivilegedAccessToBrowseUsersYieldsNoResults() {
        String issueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"Sample Issue").key;
        this.backdoor.permissions().removeGlobalPermission(27, "jira-users");
        this.backdoor.permissions().removeGlobalPermission(27, "jira-developers");
        this.backdoor.permissions().addGlobalPermission(27, "jira-administrators");
        List users = this.userClient.searchViewableIssue("a", issueKey, null, null);
        MatcherAssert.assertThat(users.stream().map(user -> user.name).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"a\\b", "admin", "sp ace"}));
        this.userClient.loginAs("fred");
        users = this.userClient.searchViewableIssue("a", issueKey, null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testUnprivilegedAccessToAssignableUsersIsDenied() {
        String issueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"Sample Issue").key;
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        ParsedResponse response = this.userClient.getResponse(this.userClient.getSearchAssignableResource("a", issueKey, null, null));
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testDoNotRequireBrowseUserPermissionToListAssignableUsers() {
        String issueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"Sample Issue").key;
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-administrators");
        this.backdoor.permissions().removeGlobalPermission(27, "jira-users");
        this.backdoor.permissions().removeGlobalPermission(27, "jira-developers");
        this.backdoor.permissions().removeGlobalPermission(27, "jira-administrators");
        this.userClient.loginAs("c/d", "c/d");
        List users = this.userClient.searchAssignable("a", issueKey, null, null);
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"admin", (Object)((User)users.get((int)0)).name);
    }

    @Test
    public void testDoNotRequireBrowseUserPermissionToListAssignableUsersBulk() {
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-administrators");
        this.backdoor.permissions().removeGlobalPermission(27, "jira-users");
        this.backdoor.permissions().removeGlobalPermission(27, "jira-developers");
        this.backdoor.permissions().removeGlobalPermission(27, "jira-administrators");
        this.userClient.loginAs("c/d", "c/d");
        List users = this.userClient.multiProjectSearchAssignable("a", "HSP", null, null);
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"admin", (Object)((User)users.get((int)0)).name);
    }

    @Test
    public void testUsernameParamIsNotMandatoryForAssignableSearchResource() {
        String issueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"Sample Issue").key;
        WebTarget resource = this.manualClient.createResource().path(USER_PATH).path("assignable").path("search").queryParam("issueKey", new Object[]{issueKey});
        ParsedResponse response = this.manualClient.getResponse(resource);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)200));
    }

    @Test
    public void testUsernameParamIsNotMandatoryForAssignableMultiProjectSearchResource() {
        this.backdoor.issues().createIssue("HSP", "Sample Issue");
        WebTarget resource = this.manualClient.createResource().path(USER_PATH).path("assignable").path("multiProjectSearch").queryParam("projectKeys", new Object[]{"HSP"});
        ParsedResponse response = this.manualClient.getResponse(resource);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)200));
    }

    @Test
    public void testProjectParamIsMandatoryForAssignableMultiProjectSearchResource() {
        this.backdoor.issues().createIssue("HSP", "Sample Issue");
        WebTarget resource = this.manualClient.createResource().path(USER_PATH).path("assignable").path("multiProjectSearch");
        ParsedResponse response = this.manualClient.getResponse(resource);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)400));
    }

    @Test
    public void testUserResourceGroupsAndRolesNotExpanded() {
        String username = "fred";
        String userPath = this.getPathFor("fred");
        User user = this.userClient.get("fred", new User.Expand[0]);
        Assert.assertEquals((Object)this.getBaseUrlPlus(userPath), (Object)user.self);
        Assert.assertEquals((Object)"groups,applicationRoles", (Object)user.expand);
        Assert.assertNotNull((Object)user.groups.size);
        Assert.assertEquals((long)1L, (long)user.groups.size);
        Assert.assertNotNull((Object)user.groups.items);
        Assert.assertTrue((boolean)user.groups.items.isEmpty());
    }

    @Test
    public void testUserResourceGroupsExpanded() {
        String username = "fred";
        String userPath = this.getPathFor("fred");
        User user = this.userClient.get("fred", new User.Expand[]{User.Expand.groups});
        Assert.assertEquals((Object)this.getBaseUrlPlus(userPath), (Object)user.self);
        Assert.assertNotNull((Object)user.groups);
        Assert.assertEquals((long)1L, (long)user.groups.size);
        Assert.assertNotNull((Object)user.groups.items);
        Assert.assertEquals((long)1L, (long)user.groups.items.size());
        Assert.assertEquals((Object)"jira-users", (Object)((Group)user.groups.items.get(0)).name());
    }

    @Test
    public void testGetAnonymouslyUserResource() {
        ParsedResponse response = ((UserClient)this.userClient.anonymous()).getUserResponse("fred");
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testAnonymouslySearch() {
        ParsedResponse response = this.getResponse(((UserClient)this.userClient.anonymous()).getSearchResource("fred", "0", "1", null, null));
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    private ParsedResponse getResponse(WebTarget resource) {
        return this.userClient.getResponse(resource);
    }

    @Test
    public void testAnonymouslySearchAssignable() {
        ParsedResponse response = this.getResponse(((UserClient)this.userClient.anonymous()).getSearchAssignableResource("fred", "TEST", "0", "1"));
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testAnonymouslySearchPicker() {
        ParsedResponse response = this.getResponse(((UserClient)this.userClient.anonymous()).getPickerResource("fred", "1"));
        Assert.assertEquals((long)404L, (long)response.statusCode);
    }

    @Test
    public void testAnonymouslySearchPickerWhileBrowseUsersSetToAnyone() {
        this.backdoor.permissions().addAnyoneGlobalPermission(27);
        UserPickerResults results = ((UserClient)this.userClient.anonymous()).picker("fred", "");
        Assert.assertEquals((long)results.users.size(), (long)1L);
        Assert.assertEquals((Object)((UserPickerUser)results.users.get((int)0)).name, (Object)"fred");
        results = ((UserClient)this.userClient.anonymous()).picker("a", "");
        Assert.assertEquals((long)results.users.size(), (long)3L);
    }

    @Test
    public void testAnonymouslySearchPickerWithFeatureFlagEnabled() {
        this.backdoor.instanceFeaturesControl().enable("jira.issue.users.find.by.name");
        UserPickerResults results = ((UserClient)this.userClient.anonymous()).picker("fred", "");
        Assert.assertEquals((long)results.users.size(), (long)1L);
        Assert.assertEquals((Object)((UserPickerUser)results.users.get((int)0)).name, (Object)"fred");
        results = ((UserClient)this.userClient.anonymous()).picker("a", "");
        Assert.assertEquals((long)results.users.size(), (long)0L);
        this.backdoor.instanceFeaturesControl().disable("jira.issue.users.find.by.name");
    }

    @Test
    public void testSearchPickerWithoutBrowseUsersPermByLoggedInUser() {
        this.backdoor.permissions().removeGlobalPermission(27, "jira_users");
        this.userClient.loginAs("fred");
        UserPickerResults results = this.userClient.picker("fred", "");
        Assert.assertEquals((long)results.users.size(), (long)1L);
        Assert.assertEquals((Object)((UserPickerUser)results.users.get((int)0)).name, (Object)"fred");
        results = this.userClient.picker("admin", "");
        Assert.assertEquals((long)results.users.size(), (long)1L);
        Assert.assertEquals((Object)((UserPickerUser)results.users.get((int)0)).name, (Object)"admin");
        results = this.userClient.picker("a", "");
        Assert.assertEquals((long)results.users.size(), (long)0L);
    }

    @Test
    public void testAnonymouslySearchByPermissions() {
        ParsedResponse response = this.getResponse(((UserClient)this.userClient.anonymous()).getSearchByPermissionResource("", "", "", "", "", ""));
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testAnonymouslyMultiProjectSearchAssignableWithoutProjectKeysParam() {
        ParsedResponse response = this.getResponse(((UserClient)this.userClient.anonymous()).getMultiProjectSearchAssignableResource("", "", "", ""));
        Assert.assertEquals((long)400L, (long)response.statusCode);
    }

    @Test
    public void testAnonymouslyMultiProjectSearchAssignableWithNoPermission() {
        ParsedResponse response = this.getResponse(((UserClient)this.userClient.anonymous()).getMultiProjectSearchAssignableResource("", "HSP", "", ""));
        Assert.assertEquals((long)404L, (long)response.statusCode);
    }

    @Test
    public void testAnonymouslyMultiProjectSearchAssignableWithPermissions() {
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.ASSIGN_ISSUES, null);
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.BROWSE_PROJECTS, null);
        List results = ((UserClient)this.userClient.anonymous()).multiProjectSearchAssignable("bloblaw", "HSP", "", "");
        Assert.assertEquals((long)results.size(), (long)1L);
        Assert.assertEquals((Object)((User)results.get((int)0)).name, (Object)"bloblaw");
        results = this.userClient.multiProjectSearchAssignable("", "HSP", "", "");
        Assert.assertEquals((long)results.size(), (long)4L);
    }

    @Test
    public void testAnonymouslyMultiProjectSearchAssignableWithPermissionToBrowseProjectOnly() {
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.BROWSE_PROJECTS, null);
        List results = ((UserClient)this.userClient.anonymous()).multiProjectSearchAssignable("", "HSP", "", "");
        Assert.assertEquals((long)results.size(), (long)0L);
    }

    @Test
    public void testAnonymouslySearchViewableIssueResource() {
        ParsedResponse response = this.getResponse(((UserClient)this.userClient.anonymous()).getSearchViewableIssueResource("", "", "", ""));
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testUnicodeCharacters() {
        String username = "\u611b";
        String userPath = this.getPathFor("%E6%84%9B");
        User user = this.userClient.get("\u611b", new User.Expand[0]);
        Assert.assertEquals((Object)this.getBaseUrlPlus(userPath), (Object)user.self);
        Assert.assertEquals((Object)"\u611b", (Object)user.name);
        Assert.assertEquals((Object)"\u611b \u6237", (Object)user.displayName);
        Assert.assertEquals((Object)this.getBaseUrlPlus("rest/api/2/user?username=%E6%84%9B"), (Object)user.self);
    }

    @Test
    public void testAvatarUrls() {
        String username = "fred";
        User user = this.userClient.get("fred", new User.Expand[0]);
        MatcherAssert.assertThat((Object)user.avatarUrls, (Matcher)CoreMatchers.equalTo(this.createUserAvatarUrls(10062L)));
    }

    @Test
    public void testUsernamesWithInterestingCharacters() {
        this.assertUserRepresentationIsOK("a\\b", "a%5Cb");
        this.assertUserRepresentationIsOK("c/d", "c%2Fd");
        this.assertUserRepresentationIsOK("sp ace", "sp+ace");
        this.assertUserRepresentationIsOK("pl+us", "pl%2Bus");
        this.assertUserRepresentationIsOK("per%cent", "per%25cent");
        this.assertUserRepresentationIsOK("\u611b", "%E6%84%9B");
    }

    @Test
    @LoginAs(user="admin")
    public void testUserResourceShouldMaskEmailAddresses() {
        this.generalConfiguration.setUserEmailVisibility(GeneralConfiguration.EmailVisibility.MASKED);
        User user = this.userClient.get("fred", new User.Expand[0]);
        MatcherAssert.assertThat((Object)user.emailAddress, (Matcher)CoreMatchers.equalTo((Object)"fred at example dot com"));
    }

    @Test
    @LoginAs(user="admin")
    public void testUserResourceShouldHideEmailAddresses() {
        this.generalConfiguration.setUserEmailVisibility(GeneralConfiguration.EmailVisibility.HIDDEN);
        User user = this.userClient.get("fred", new User.Expand[0]);
        Assert.assertNull((Object)user.emailAddress);
    }

    @Test
    public void testUserGetAndSetColumns() {
        List<ColumnControl.ColumnItem> items = this.backdoor.columnControl().getLoggedInUserColumns();
        ArrayList defaultColumns = Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "summary", "assignee", "reporter", "priority", "status", "resolution", "created", "updated", "duedate"});
        for (int i = 0; i < items.size(); ++i) {
            Assert.assertEquals(defaultColumns.get(0), (Object)items.get((int)0).value);
        }
        Assert.assertEquals((long)defaultColumns.size(), (long)items.size());
        ArrayList newColumns = Lists.newArrayList((Iterable)defaultColumns);
        newColumns.add("description");
        newColumns.add("resolutiondate");
        newColumns.remove("summary");
        newColumns.remove("status");
        Assert.assertTrue((String)"No errors when setting the column", (boolean)this.backdoor.columnControl().setLoggedInUserColumns(newColumns));
        items = this.backdoor.columnControl().getLoggedInUserColumns();
        for (int i = 0; i < items.size(); ++i) {
            Assert.assertEquals(newColumns.get(0), (Object)items.get((int)0).value);
        }
        Assert.assertEquals((long)newColumns.size(), (long)items.size());
        Assert.assertTrue((String)"No errors when removing all columns", (boolean)this.backdoor.columnControl().setLoggedInUserColumns(Lists.newArrayList()));
        Assert.assertEquals((long)0L, (long)this.backdoor.columnControl().getLoggedInUserColumns().size());
    }

    @Ignore(value="UCACHE-92")
    @Test
    public void testWorkflowAssignableOverride() {
        this.backdoor.projectRole().addActors("HSP", "Administrators", new String[]{"jira-administrators"}, null);
        this.userClient.loginAs("c/d", "c/d");
        IssueCreateResponse r = this.backdoor.issues().createIssue("HSP", "New issue");
        String issueKey = r.key();
        WorkflowsControlExt workflowControl = this.backdoor.workflow();
        workflowControl.addMetaAttributeToWorkflowStep("classic default workflow", "Resolved", "jira.permission.assignable.projectrole", String.valueOf(10002L));
        List<User> users = this.searchAssignable("a", "HSP", issueKey, "5");
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"admin", (Object)users.get((int)0).name);
    }

    @Test
    public void testWorkflowAssignableOverrideDifferentState() {
        this.backdoor.projectRole().addActors("HSP", "Administrators", new String[]{"jira-administrators"}, null);
        this.userClient.loginAs("c/d", "c/d");
        IssueCreateResponse r = this.backdoor.issues().createIssue("HSP", "New issue");
        String issueKey = r.key();
        WorkflowsControlExt workflowControl = this.backdoor.workflow();
        workflowControl.addMetaAttributeToWorkflowStep("classic default workflow", "Resolved", "jira.permission.assignable.projectrole", String.valueOf(10002L));
        List<User> users = this.searchAssignable("a", "HSP", issueKey, "2");
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertEquals((Object)"a\\b", (Object)users.get((int)0).name);
        Assert.assertEquals((Object)"admin", (Object)users.get((int)1).name);
    }

    @Test
    public void test401WhenAnonymousWantsToStoreAvatarForNotExistingUser() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.storeTemporaryAvatarFor(NOT_EXISTING_USERNAME);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    public void test401WhenAnonymousWantsToStoreAvatarForExistingUser() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.storeTemporaryAvatarFor("admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    public void test401WhenAnonymousWantsToStoreAvatarWithMultipartForNotExistingUser() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.storeTemporaryAvatarUsingMultipartFor(NOT_EXISTING_USERNAME);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    public void test401WhenAnonymousWantsToStoreAvatarWithMultipartForExistingUser() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.storeTemporaryAvatarUsingMultipartFor("admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    public void test401WhenAnonymousWantsToCreateAvatarFromTemporaryForNotExistingUser() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.createAvatarFromTemporaryFor(NOT_EXISTING_USERNAME);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    public void test401WhenAnonymousWantsToCreateAvatarFromTemporaryForExistingUser() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.createAvatarFromTemporaryFor("admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    public void test401WhenAnonymousWantsToUpdateAvatarForNotExistingUser() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.updateUserAvatarFor(NOT_EXISTING_USERNAME);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    public void test401WhenAnonymousWantsToUpdateAvatarForExistingUser() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.updateUserAvatarFor("admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    public void test401WhenAnonymousUserTriesToDeleteAvatarForNotExistingUser() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.deleteAvatarFor(NOT_EXISTING_USERNAME);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    public void test401WhenAnonymousUserTriesToDeleteAvatarForExistingUser() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.deleteAvatarFor("admin");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    @Test
    public void testDuplicatedUsersCountUnauthorized() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.getDuplicatedUsersCount();
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testDuplicatedUsersCountNonAdmin() {
        this.manualClient.loginAs("fred");
        ParsedResponse response = this.manualClient.getDuplicatedUsersCount();
        Assert.assertEquals((long)403L, (long)response.statusCode);
    }

    @Test
    public void testDuplicatedUsersCountAdmin() {
        this.manualClient.loginAs("admin");
        ParsedResponse response = this.manualClient.getDuplicatedUsersCount();
        Assert.assertEquals((long)200L, (long)response.statusCode);
    }

    @Test
    public void testDuplicatedUsersMappingUnauthorized() {
        this.manualClient.anonymous();
        ParsedResponse response = this.manualClient.getDuplicatedUsersList();
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testDuplicatedUsersMappingNonAdmin() {
        this.manualClient.loginAs("fred");
        ParsedResponse response = this.manualClient.getDuplicatedUsersList();
        Assert.assertEquals((long)403L, (long)response.statusCode);
    }

    @Test
    public void testDuplicatedUsersMappingAdmin() {
        this.manualClient.loginAs("admin");
        ParsedResponse response = this.manualClient.getDuplicatedUsersList();
        Assert.assertEquals((long)200L, (long)response.statusCode);
    }

    @Test
    public void testGettingLastLoginTimeFormatWithSystemDefaultTimezoneAndLocale() {
        this.testGettingLastLoginTimeFormat();
    }

    @Test
    public void testGettingLastLoginTimeFormatWithDifferentTimezoneAndLocale() {
        this.backdoor.userProfile().changeUserLanguage("admin", "Polish");
        this.backdoor.userProfile().changeUserTimezone("admin", "Europe/Warsaw");
        this.testGettingLastLoginTimeFormat();
    }

    @Test
    public void testGettingLastLoginTimeForJustDeletedUser() {
        this.manualClient.loginAs("fred");
        this.backdoor.usersAndGroups().deleteUser("fred");
        this.testGettingLastLoginTimeEmpty("fred", true);
    }

    @Test
    public void testGettingLastLoginTimeForJustCreatedUser() {
        String username = "test";
        this.backdoor.usersAndGroups().addUser(username);
        this.testGettingLastLoginTimeEmpty(username, false);
    }

    private void testGettingLastLoginTimeFormat() {
        Pattern dateTimePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\+\\d{2,4}");
        this.manualClient.loginAs("admin");
        String lastLoginTime = this.manualClient.getUserInfo("admin", false).getLastLoginTime();
        MatcherAssert.assertThat((Object)dateTimePattern.matcher(lastLoginTime).matches(), (Matcher)Is.is((Object)true));
    }

    private void testGettingLastLoginTimeEmpty(String username, boolean includeDeleted) {
        this.manualClient.loginAs("admin");
        String lastLoginTime = this.manualClient.getUserInfo(username, includeDeleted).getLastLoginTime();
        MatcherAssert.assertThat((Object)lastLoginTime, (Matcher)Matchers.isEmptyString());
    }

    private List<User> searchAssignable(String prefix, String projectId, String issueId, String actionDescriptorId) {
        WebTarget resource = this.userClient.getSearchAssignableResource(prefix, issueId, null, "50").queryParam("projectKeys", new Object[]{projectId}).queryParam("actionDescriptorId", new Object[]{actionDescriptorId});
        return Arrays.asList((Object[])resource.request().get(User[].class));
    }

    protected String getPathFor(String username) {
        return this.getPathFor(username, Collections.emptyMap());
    }

    private void assertUserRepresentationIsOK(String username, String encodedUsername) {
        User user = this.userClient.get(username, new User.Expand[0]);
        Assert.assertEquals((Object)username, (Object)user.name);
        Assert.assertEquals((String)"The username is not encoded in the self link", (Object)this.getBaseUrlPlus("rest/api/2/user?username=" + encodedUsername), (Object)user.self);
    }

    protected String getPathFor(String username, Map<?, ?> queryParams) {
        return "rest/api/2/user?username=" + username + StringUtils.join((Iterable)Collections2.transform(queryParams.entrySet(), (Function)new Function<Map.Entry, Object>(){

            public Object apply(Map.Entry from) {
                return String.format("&%s=%s", from.getKey(), from.getValue());
            }
        }), (String)"");
    }

    private Map<String, String> createUserAvatarUrls(Long avatarId) {
        return ImmutableMap.builder().put((Object)"24x24", (Object)this.getBaseUrlPlus("secure/useravatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.getBaseUrlPlus("secure/useravatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.getBaseUrlPlus("secure/useravatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.getBaseUrlPlus("secure/useravatar?avatarId=" + avatarId)).build();
    }

    private List<String> getUserNames(List<User> users) {
        return users.stream().map(user -> user.name).collect(Collectors.toList());
    }

    private String getBaseUrlPlus(String ... paths) {
        Iterable pathsNoLeadingSlashes = Iterables.transform(Arrays.asList(paths), path -> path.startsWith("/") ? path.substring(1) : path);
        String path2 = StringUtils.join((Iterable)Lists.newArrayList((Iterable)pathsNoLeadingSlashes), (char)'/');
        return String.format("%s/%s", this.environmentData.getBaseUrl().toExternalForm(), path2);
    }

    class ManualClient
    extends RestApiClient<ManualClient> {
        public static final String X_ATLASSIAN_TOKEN = "X-Atlassian-Token";
        public static final String NO_CHECK = "no-check";
        public static final String USERNAME_PARAM = "username";

        protected ManualClient(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        public WebTarget createResource() {
            return super.createResource();
        }

        public String getPropertyValue(String key) throws IOException {
            WebTarget target = this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("api").path("latest").path("application-properties").queryParam("key", new Object[]{key});
            Response response = (Response)target.request().get(Response.class);
            String output = (String)response.readEntity(String.class);
            Map jsonOutput = (Map)new ObjectMapper().readValue(output, HashMap.class);
            return (String)jsonOutput.get("value");
        }

        public ParsedResponse getResponse(WebTarget target) {
            return this.toResponse(() -> (Response)target.request().get(Response.class));
        }

        public ParsedResponse storeTemporaryAvatarFor(String username) {
            Invocation.Builder resource = this.getUserTemporaryAvatarResource().queryParam(USERNAME_PARAM, new Object[]{username}).queryParam("filename", new Object[]{"image.jpeg"}).queryParam("size", new Object[]{"1024"}).request().header(X_ATLASSIAN_TOKEN, (Object)NO_CHECK).header("Content-Type", (Object)"image/jpeg");
            return this.postResponse(resource);
        }

        public ParsedResponse storeTemporaryAvatarUsingMultipartFor(String username) {
            Invocation.Builder resource = this.getUserTemporaryAvatarResource().queryParam(USERNAME_PARAM, new Object[]{username}).request().header(X_ATLASSIAN_TOKEN, (Object)NO_CHECK).header("Content-Type", (Object)"multipart/form-data");
            return this.postResponse(resource, Entity.entity((Object)"avatar=some-binary", (String)"image/jpeg"));
        }

        public ParsedResponse createAvatarFromTemporaryFor(String username) {
            Invocation.Builder invocation = this.getUserAvatarResource().queryParam(USERNAME_PARAM, new Object[]{username}).request().header(X_ATLASSIAN_TOKEN, (Object)NO_CHECK);
            return this.postResponse(invocation, Entity.json((Object)new AvatarCroppingBean()));
        }

        public ParsedResponse updateUserAvatarFor(final String username) {
            Invocation.Builder invocation = this.getUserAvatarResource().queryParam(USERNAME_PARAM, new Object[]{username}).request().header(X_ATLASSIAN_TOKEN, (Object)NO_CHECK).header("Content-Type", (Object)"application/json");
            return this.putResponse(invocation, Entity.json((Object)new HashMap<String, String>(){
                {
                    this.put("id", "10000");
                    this.put("owner", username);
                    this.put("isSystemAvatar", "false");
                    this.put("isSelected", "true");
                    this.put("isDeletable", "true");
                    this.put("selected", "true");
                }
            }));
        }

        public ParsedResponse deleteAvatarFor(String username) {
            Invocation.Builder resource = this.getUserAvatarResource().path("10000").queryParam(USERNAME_PARAM, new Object[]{username}).request().header(X_ATLASSIAN_TOKEN, (Object)NO_CHECK).header("Content-Type", (Object)"application/json");
            return this.deleteResponse(resource);
        }

        public ParsedResponse getDuplicatedUsersCount() {
            WebTarget resource = this.getDuplicatedUsersResource().path("count");
            return this.getResponse(resource);
        }

        public ParsedResponse getDuplicatedUsersList() {
            WebTarget resource = this.getDuplicatedUsersResource().path("list");
            return this.getResponse(resource);
        }

        public UserBean getUserInfo(String username, boolean includeDeleted) {
            return (UserBean)this.getUserInfoResource().queryParam(USERNAME_PARAM, new Object[]{username}).queryParam("includeDeleted", new Object[]{String.valueOf(includeDeleted)}).request().get(UserBean.class);
        }

        public ParsedResponse postResponse(Invocation.Builder invocation) {
            return this.toResponse(() -> (Response)invocation.post(null, Response.class));
        }

        public ParsedResponse postResponse(Invocation.Builder invocation, Entity entity) {
            return this.toResponse(() -> (Response)invocation.post(entity, Response.class));
        }

        public ParsedResponse deleteResponse(Invocation.Builder resource) {
            return this.toResponse(() -> (Response)resource.delete(Response.class));
        }

        public ParsedResponse putResponse(Invocation.Builder resource) {
            return this.toResponse(() -> (Response)resource.put(null, Response.class));
        }

        public ParsedResponse putResponse(Invocation.Builder resource, Entity entity) {
            return this.toResponse(() -> (Response)resource.put(entity, Response.class));
        }

        private WebTarget getDuplicatedUsersResource() {
            return this.createResource().path(TestUserResource.USER_PATH).path("duplicated");
        }

        private WebTarget getUserAvatarResource() {
            return this.createResource().path(TestUserResource.USER_PATH).path("avatar");
        }

        private WebTarget getUserTemporaryAvatarResource() {
            return this.getUserAvatarResource().path("temporary");
        }

        private WebTarget getUserInfoResource() {
            return this.createResource().path(TestUserResource.USER_PATH);
        }
    }
}

