/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.ApplicationRole;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserBean;
import com.atlassian.jira.testkit.client.restclient.UserClient;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RestoreBlankInstance
@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestUserResourceWithRolesEnabled
extends BaseJiraRestTest {
    public static final String FRED_USERNAME = "fred";
    public static final String CHARLIE_USERNAME = "charlie";
    public static final String SUPERUSER_USERNAME = "superuser";
    private UserClient userClient;

    @Before
    public void setUpInstance() {
        this.backdoor.restoreBlankInstance(LicenseKeys.MULTI_ROLE_DC);
        this.backdoor.usersAndGroups().addGroup("jira-software-group");
        this.backdoor.applicationRoles().putRoleAndSetDefault("jira-software", "jira-software-group");
        this.backdoor.usersAndGroups().addUserToGroup(FRED_USERNAME, "jira-software-group");
        this.backdoor.usersAndGroups().addGroup("test-group");
        this.backdoor.applicationRoles().putRoleAndSetDefault("jira-func-test", "test-group");
        this.userClient = new UserClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void shouldReturnUserRoles() throws Exception {
        User user = this.userClient.get(FRED_USERNAME, new User.Expand[]{User.Expand.applicationRoles});
        Assert.assertThat((Object)user.applicationRoles.items, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{TestUserResourceWithRolesEnabled.roleWithKeyAndName("jira-core", "Jira Core"), TestUserResourceWithRolesEnabled.roleWithKeyAndName("jira-software", "Jira Software")}));
    }

    @Test
    public void shouldAddUserToApplication() throws Exception {
        this.backdoor.usersAndGroups().addUser(CHARLIE_USERNAME);
        this.userClient.addUserToApplication(CHARLIE_USERNAME, "jira-core");
        User user = this.userClient.get(CHARLIE_USERNAME, new User.Expand[]{User.Expand.applicationRoles});
        Assert.assertThat((Object)user.applicationRoles.items, (Matcher)Matchers.contains(TestUserResourceWithRolesEnabled.roleWithKeyAndName("jira-core", "Jira Core")));
        this.userClient.addUserToApplication(CHARLIE_USERNAME, "jira-func-test");
        user = this.userClient.get(CHARLIE_USERNAME, new User.Expand[]{User.Expand.applicationRoles});
        Assert.assertThat((Object)user.applicationRoles.items, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{TestUserResourceWithRolesEnabled.roleWithKeyAndName("jira-core", "Jira Core"), TestUserResourceWithRolesEnabled.roleWithKeyAndName("jira-func-test", "Test Product")}));
    }

    @Test
    public void shouldRemoveUserFromApplication() throws Exception {
        UserBean userBean = UserBean.builder().setName(SUPERUSER_USERNAME).setDisplayName(SUPERUSER_USERNAME).setEmailAddress("email@email.com").setApplicationKeys((List)ImmutableList.of((Object)"jira-core", (Object)"jira-func-test")).build();
        this.userClient.createUser(userBean);
        User user = this.userClient.get(SUPERUSER_USERNAME, new User.Expand[]{User.Expand.applicationRoles});
        Assert.assertThat((Object)user.applicationRoles.items, (Matcher)Matchers.contains((Matcher[])new Matcher[]{TestUserResourceWithRolesEnabled.roleWithKeyAndName("jira-func-test", "Test Product"), TestUserResourceWithRolesEnabled.roleWithKeyAndName("jira-core", "Jira Core")}));
        this.userClient.removeUserFromApplication(SUPERUSER_USERNAME, "jira-func-test");
        user = this.userClient.get(SUPERUSER_USERNAME, new User.Expand[]{User.Expand.applicationRoles});
        Assert.assertThat((Object)user.applicationRoles.items, (Matcher)Matchers.contains(TestUserResourceWithRolesEnabled.roleWithKeyAndName("jira-core", "Jira Core")));
        this.userClient.removeUserFromApplication(SUPERUSER_USERNAME, "jira-core");
        user = this.userClient.get(SUPERUSER_USERNAME, new User.Expand[]{User.Expand.applicationRoles});
        Assert.assertThat((Object)user.applicationRoles.items, (Matcher)Matchers.empty());
    }

    @Test
    public void shouldDoNothingWhenUserIsNotInApplicationAndTryToRemove() {
        UserBean userBean = UserBean.builder().setName("user-without-application").setDisplayName("display-name").setEmailAddress("email@email.address.com").setApplicationKeys((List)ImmutableList.of((Object)"jira-core")).build();
        this.userClient.createUser(userBean);
        this.userClient.removeUserFromApplication(userBean.getName(), "jira-func-test");
        User user = this.userClient.get(userBean.getName(), new User.Expand[]{User.Expand.applicationRoles});
        Assert.assertThat((Object)user.applicationRoles.items, (Matcher)Matchers.contains(TestUserResourceWithRolesEnabled.roleWithKeyAndName("jira-core", "Jira Core")));
    }

    @Test
    public void shouldReturnErrorWhenTryToAddUserToApplication() {
        UserBean userBean = this.createUserWithoutApplications("user-without-application");
        ParsedResponse response = this.userClient.removeUserFromApplicationResponse(userBean.getName(), "non-existing-application");
        Assert.assertEquals((long)response.statusCode, (long)400L);
    }

    @Test
    public void shouldNotAddUserToApplicationWhenUserIsNotAdmin() {
        UserBean userBean = this.createUserWithoutApplications("user");
        String NONADMIN_USERNAME = "nonadmin";
        this.backdoor.usersAndGroups().addUser("nonadmin", "nonadmin", "nonadmin", "nonadmin@nonadmin.com");
        this.userClient.loginAs("nonadmin");
        ParsedResponse response = this.userClient.addUserToApplicationResponse(userBean.getName(), "jira-core");
        Assert.assertEquals((long)response.statusCode, (long)401L);
    }

    private UserBean createUserWithoutApplications(String username) {
        UserBean userBean = UserBean.builder().setName(username).setDisplayName(username + "display-name").setEmailAddress(username + "email@email.address.com").build();
        this.userClient.createUser(userBean);
        return userBean;
    }

    private static Matcher<ApplicationRole> roleWithKeyAndName(final String key, final String name) {
        return new TypeSafeMatcher<ApplicationRole>(){

            protected boolean matchesSafely(ApplicationRole item) {
                return item.name.equals(name) && item.key.equals(key);
            }

            public void describeTo(Description description) {
                description.appendText("ApplicationRole with key ").appendValue((Object)key).appendText(" and name ").appendValue((Object)name);
            }
        };
    }
}

