/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ChangeLog;
import com.atlassian.jira.testkit.client.restclient.DeleteVersionWithCustomFieldParameters;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.VersionClient;
import com.atlassian.jira.testkit.client.restclient.VersionIssueCounts;
import com.atlassian.jira.testkit.client.restclient.VersionMove;
import com.atlassian.jira.testkit.client.restclient.VersionUnresolvedIssueCount;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestVersionResource.xml")
public class TestVersionResource
extends BaseJiraFuncTest {
    private static final String DATE_FORMAT = "dd/MMM/yy";
    private VersionClient versionClient;
    private ProjectClient projectClient;
    private SearchClient searchClient;

    @Before
    public void setUp() {
        this.versionClient = new VersionClient((JIRAEnvironmentData)this.environmentData);
        this.projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        this.searchClient = new SearchClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testEditDescription() {
        Version expectedVersion = this.getInitialVersion();
        Version editVersion = new Version().description("my new description").self(expectedVersion.self);
        expectedVersion.description = editVersion.description;
        expectedVersion.projectId = 10000L;
        this.verifyEdit(expectedVersion, editVersion);
    }

    private void verifyEdit(Version expectedVersion, Version editVersion) {
        this.versionClient.putResponse(editVersion);
        Assert.assertThat((Object)this.versionClient.get(this.getVersionId(expectedVersion)), (Matcher)CoreMatchers.equalTo((Object)expectedVersion));
    }

    @Test
    public void testEditName() {
        Version expectedVersion = this.getInitialVersion();
        Version editVersion = new Version().name("Super Version").self(expectedVersion.self);
        expectedVersion.name = editVersion.name;
        this.verifyEdit(expectedVersion, editVersion);
    }

    @Test
    public void testEditNameErrors() {
        Version editVersion = new Version().name("").self(this.getInitialVersion().self);
        ParsedResponse response = this.versionClient.putResponse(editVersion);
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        Assert.assertThat((Object)response.entity, (Matcher)CoreMatchers.equalTo((Object)new Errors().addError("name", "You must specify a valid version name")));
        editVersion = new Version().name("New Version 4").self(this.getInitialVersion().self);
        response = this.versionClient.putResponse(editVersion);
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        Assert.assertThat((Object)response.entity, (Matcher)CoreMatchers.equalTo((Object)new Errors().addError("name", "A version with this name already exists in this project.")));
    }

    private Version getInitialVersion() {
        String versionID = "10000";
        Version actualVersion = this.versionClient.get("10000");
        Version expectedVersion = new Version().self(this.createSelfLink(Long.valueOf("10000"))).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("New Version 1").description("Test Version Description 1").id(Long.valueOf(10000L)).projectId(Long.valueOf(10000L));
        Assert.assertThat((Object)actualVersion, (Matcher)CoreMatchers.equalTo((Object)expectedVersion));
        return actualVersion;
    }

    private String getVersionId(Version version) {
        String[] selfParts = version.self.split("/");
        return selfParts[selfParts.length - 1];
    }

    @Test
    public void testArchiveUnarchive() {
        Version expectedVersion = this.getInitialVersion();
        Version editVersion = new Version().archived(Boolean.valueOf(true)).self(expectedVersion.self);
        expectedVersion.archived = editVersion.archived;
        this.verifyEdit(expectedVersion, editVersion);
        editVersion = new Version().archived(Boolean.valueOf(false)).self(expectedVersion.self);
        expectedVersion.archived = editVersion.archived;
        this.verifyEdit(expectedVersion, editVersion);
    }

    @Test
    public void testReleaseUnrelease() {
        Version expectedVersion = this.getInitialVersion();
        LocalDate releaseDate = new LocalDate().plusDays(1);
        Version editVersion = new Version().released(Boolean.valueOf(true)).releaseDate(releaseDate).self(expectedVersion.self);
        expectedVersion.released = editVersion.released;
        expectedVersion.releaseDate = editVersion.releaseDate;
        expectedVersion.userReleaseDate = releaseDate.toString(DATE_FORMAT);
        expectedVersion.projectId = 10000L;
        this.verifyEdit(expectedVersion, editVersion);
        editVersion = new Version().released(Boolean.valueOf(false)).self(expectedVersion.self);
        expectedVersion.released = editVersion.released;
        expectedVersion.overdue = false;
        this.verifyEdit(expectedVersion, editVersion);
    }

    @Test
    public void testEditStartDate() {
        Version expectedVersion = this.getInitialVersion();
        LocalDate startDate = LocalDate.fromDateFields((Date)new Date(0L));
        Version editVersion = new Version().startDate(startDate).self(expectedVersion.self);
        expectedVersion.startDate = editVersion.startDate;
        expectedVersion.userStartDate = startDate.toString(DATE_FORMAT);
        this.verifyEdit(expectedVersion, editVersion);
        LocalDate aDate = new LocalDate().plusDays(1);
        editVersion = new Version().userStartDate(aDate.toString(DATE_FORMAT)).self(expectedVersion.self);
        expectedVersion.startDate = aDate;
        expectedVersion.userStartDate = aDate.toString(DATE_FORMAT);
        this.verifyEdit(expectedVersion, editVersion);
        editVersion = new Version().userStartDate("").self(expectedVersion.self);
        expectedVersion.startDate = null;
        expectedVersion.userStartDate = null;
        expectedVersion.overdue = null;
        this.verifyEdit(expectedVersion, editVersion);
    }

    @Test
    public void testEditReleaseDate() {
        Version expectedVersion = this.getInitialVersion();
        LocalDate releaseDate = LocalDate.fromDateFields((Date)new Date(0L));
        Version editVersion = new Version().releaseDate(releaseDate).self(expectedVersion.self);
        expectedVersion.releaseDate = editVersion.releaseDate;
        expectedVersion.userReleaseDate = releaseDate.toString(DATE_FORMAT);
        expectedVersion.overdue = true;
        this.verifyEdit(expectedVersion, editVersion);
        LocalDate aDate = new LocalDate().plusDays(1);
        editVersion = new Version().userReleaseDate(aDate.toString(DATE_FORMAT)).self(expectedVersion.self);
        expectedVersion.releaseDate = aDate;
        expectedVersion.userReleaseDate = aDate.toString(DATE_FORMAT);
        expectedVersion.overdue = false;
        this.verifyEdit(expectedVersion, editVersion);
        editVersion = new Version().userReleaseDate("").self(expectedVersion.self);
        expectedVersion.releaseDate = null;
        expectedVersion.userReleaseDate = null;
        expectedVersion.overdue = null;
        this.verifyEdit(expectedVersion, editVersion);
    }

    @Test
    public void testVersionReleaseDateShouldBeInUserTimeZone() {
        String versionId = "10011";
        String releaseDateDublin = "01/Mar/11";
        String releaseDateMidway = "28/Feb/11";
        String releaseDateKiritimati = "01/Mar/11";
        this.backdoor.userProfile().changeUserTimezone("admin", "Europe/Dublin");
        this.backdoor.userProfile().changeUserTimezone("fred", "Pacific/Midway");
        this.backdoor.userProfile().changeUserTimezone("bob", "Pacific/Kiritimati");
        this.assertReleaseDatesShowInUserTimeZone("01/Mar/11", "28/Feb/11", "01/Mar/11");
        String updatedDateDublin = "04/Mar/11";
        String updatedDateMidway = "03/Mar/11";
        String updatedDateKiritimati = "05/Mar/11";
        Version updatedVersion = ((VersionClient)this.versionClient.loginAs("fred")).get("10011").releaseDate("05/Mar/11", null);
        ParsedResponse r = ((VersionClient)this.versionClient.loginAs("bob")).putResponse(updatedVersion);
        Assert.assertThat((String)String.valueOf(r.entity), (Object)r.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        this.assertReleaseDatesShowInUserTimeZone("04/Mar/11", "03/Mar/11", "05/Mar/11");
    }

    @Test
    public void testViewVersion() {
        Version actualVersion = this.versionClient.get("10000");
        Version expectedVersion = new Version().self(this.createSelfLink(10000L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("New Version 1").description("Test Version Description 1").id(Long.valueOf(10000L)).projectId(Long.valueOf(10000L));
        Assert.assertThat((Object)expectedVersion, (Matcher)CoreMatchers.equalTo((Object)actualVersion));
        actualVersion = this.versionClient.get("10001");
        expectedVersion = new Version().self(this.createSelfLink(10001L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("New Version 4").description("Test Version Description 4").id(Long.valueOf(10001L)).projectId(Long.valueOf(10000L));
        Assert.assertThat((Object)expectedVersion, (Matcher)CoreMatchers.equalTo((Object)actualVersion));
        actualVersion = this.versionClient.get("10002");
        expectedVersion = new Version().self(this.createSelfLink(10002L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("New Version 5").description("Test Version Description 5").id(Long.valueOf(10002L)).projectId(Long.valueOf(10000L));
        Assert.assertThat((Object)expectedVersion, (Matcher)CoreMatchers.equalTo((Object)actualVersion));
        actualVersion = this.versionClient.get("10010");
        expectedVersion = new Version().self(this.createSelfLink(10010L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("One").id(Long.valueOf(10010L)).projectId(Long.valueOf(10001L));
        Assert.assertThat((Object)expectedVersion, (Matcher)CoreMatchers.equalTo((Object)actualVersion));
        actualVersion = this.versionClient.get("10011");
        expectedVersion = new Version().self(this.createSelfLink(10011L)).name("Two").description("Two").releaseDate("01/Mar/11").archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).overdue(Boolean.valueOf(true)).id(Long.valueOf(10011L)).projectId(Long.valueOf(10001L));
        Assert.assertThat((Object)expectedVersion, (Matcher)CoreMatchers.equalTo((Object)actualVersion));
        actualVersion = this.versionClient.get("10012");
        expectedVersion = new Version().self(this.createSelfLink(10012L)).name("Three").description("Three").releaseDate("09/Mar/11").archived(Boolean.valueOf(false)).released(Boolean.valueOf(true)).id(Long.valueOf(10012L)).projectId(Long.valueOf(10001L));
        Assert.assertThat((Object)expectedVersion, (Matcher)CoreMatchers.equalTo((Object)actualVersion));
        actualVersion = this.versionClient.get("10013");
        expectedVersion = new Version().self(this.createSelfLink(10013L)).name("Four").archived(Boolean.valueOf(true)).released(Boolean.valueOf(false)).id(Long.valueOf(10013L)).projectId(Long.valueOf(10001L));
        Assert.assertThat((Object)expectedVersion, (Matcher)CoreMatchers.equalTo((Object)actualVersion));
        actualVersion = this.versionClient.get("10014");
        expectedVersion = new Version().self(this.createSelfLink(10014L)).name("Five").description("Five").archived(Boolean.valueOf(true)).released(Boolean.valueOf(true)).id(Long.valueOf(10014L)).projectId(Long.valueOf(10001L));
        Assert.assertThat((Object)expectedVersion, (Matcher)CoreMatchers.equalTo((Object)actualVersion));
        actualVersion = this.versionClient.get("10110");
        expectedVersion = new Version().self(this.createSelfLink(10110L)).name("Hidden").archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).id(Long.valueOf(10110L)).projectId(Long.valueOf(10010L));
        Assert.assertThat((Object)expectedVersion, (Matcher)CoreMatchers.equalTo((Object)actualVersion));
        actualVersion = ((VersionClient)this.versionClient.loginAs("fred")).get("10110");
        expectedVersion = new Version().self(this.createSelfLink(10110L)).name("Hidden").archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).id(Long.valueOf(10110L)).projectId(Long.valueOf(10010L));
        Assert.assertThat((Object)expectedVersion, (Matcher)CoreMatchers.equalTo((Object)actualVersion));
    }

    @Test
    public void testViewVersionNotFound() {
        ParsedResponse resp1 = this.versionClient.getResponse("1");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Could not find version for id '1'"));
        ParsedResponse respZbing = this.versionClient.getResponse("zbing");
        Assert.assertThat((Object)respZbing.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)respZbing.entity.errorMessages.contains("Could not find version for id 'zbing'"));
    }

    @Test
    public void testCreateVersionErrors() {
        ParsedResponse response = this.versionClient.createResponse(new Version());
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        String message = "Project must be specified to create a version.";
        Assert.assertThat((Object)response.entity, (Matcher)CoreMatchers.equalTo((Object)new Errors().addError(message)));
        response = this.versionClient.createResponse(new Version().releaseDate("1/Jan/2000").project("IGNORED"));
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        message = "Only one of 'releaseDate' and 'userReleaseDate' can be specified when creating a version.";
        Assert.assertThat((Object)response.entity, (Matcher)CoreMatchers.equalTo((Object)new Errors().addError(message)));
        response = this.versionClient.createResponse(new Version().project("BAD"));
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        message = "Project with key 'BAD' either does not exist or you do not have permission to create versions in it.";
        Assert.assertThat((Object)response.entity, (Matcher)CoreMatchers.equalTo((Object)new Errors().addError(message)));
        response = ((VersionClient)this.versionClient.loginAs("fred")).createResponse(new Version().project("MKY"));
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        message = "Project with key 'MKY' either does not exist or you do not have permission to create versions in it.";
        Assert.assertThat((Object)response.entity, (Matcher)CoreMatchers.equalTo((Object)new Errors().addError(message)));
        response = ((VersionClient)this.versionClient.loginAs("admin")).createResponse(new Version().project("MKY"));
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        message = "You must specify a valid version name";
        Assert.assertThat((Object)response.entity, (Matcher)CoreMatchers.equalTo((Object)new Errors().addError("name", message)));
    }

    @Test
    public void testCreateVersion() {
        LocalDate tenDaysAgo = new LocalDate().dayOfYear().addToCopy(-10);
        Version inputVersion = new Version().project("MKY").name("New Version");
        Version newVersion = this.versionClient.create(inputVersion);
        Assert.assertThat((Object)newVersion, (Matcher)CoreMatchers.equalTo((Object)this.addNewAttributes(inputVersion, newVersion).projectId(Long.valueOf(10001L))));
        inputVersion = new Version().project("MKY").name("New Version2").description("Description 2");
        newVersion = this.versionClient.create(inputVersion);
        Assert.assertThat((Object)newVersion, (Matcher)CoreMatchers.equalTo((Object)this.addNewAttributes(inputVersion, newVersion).projectId(Long.valueOf(10001L))));
        inputVersion = new Version().project("MKY").name("New Version3").description("Description 3").releaseDate("12/Oct/81", null);
        newVersion = this.versionClient.create(inputVersion);
        Assert.assertThat((Object)newVersion, (Matcher)CoreMatchers.equalTo((Object)this.addNewAttributes(inputVersion, newVersion).overdue(Boolean.valueOf(true)).releaseDate("12/Oct/81").projectId(Long.valueOf(10001L))));
        inputVersion = new Version().project("MKY").name("New Version4").description("Description 4").releaseDate(null, tenDaysAgo);
        newVersion = this.versionClient.create(inputVersion);
        Assert.assertThat((Object)newVersion, (Matcher)CoreMatchers.equalTo((Object)this.addNewAttributes(inputVersion, newVersion).overdue(Boolean.valueOf(true)).releaseDate(tenDaysAgo).projectId(Long.valueOf(10001L)).userReleaseDate(tenDaysAgo.toString(DATE_FORMAT))));
        LocalDate tenDaysFromNow = tenDaysAgo.dayOfYear().addToCopy(20);
        inputVersion = new Version().project("HIDDEN").name("Hidden1").releaseDate(null, tenDaysFromNow);
        newVersion = this.versionClient.create(inputVersion);
        Assert.assertThat((Object)newVersion, (Matcher)CoreMatchers.equalTo((Object)this.addNewAttributes(inputVersion, newVersion).releaseDate(tenDaysFromNow).overdue(Boolean.valueOf(false)).userReleaseDate(tenDaysFromNow.toString(DATE_FORMAT)).projectId(Long.valueOf(10010L))));
        inputVersion = new Version().project("HIDDEN").name("Hidden2");
        newVersion = ((VersionClient)this.versionClient.loginAs("fred")).create(inputVersion);
        Assert.assertThat((Object)newVersion, (Matcher)CoreMatchers.equalTo((Object)this.addNewAttributes(inputVersion, newVersion).projectId(Long.valueOf(10010L))));
    }

    @Test
    public void testMoveVersion() {
        this.assertVersionSequence("MKY", "Five", "One", "Two", "Three", "Four");
        VersionMove vm = new VersionMove().position("Later");
        this.versionClient.move("10014", vm);
        this.assertVersionSequence("MKY", "One", "Five", "Two", "Three", "Four");
        vm = new VersionMove().position("Later");
        this.versionClient.move("10014", vm);
        this.assertVersionSequence("MKY", "One", "Two", "Five", "Three", "Four");
        vm = new VersionMove().position("Earlier");
        this.versionClient.move("10011", vm);
        this.assertVersionSequence("MKY", "Two", "One", "Five", "Three", "Four");
        vm = new VersionMove().position("Earlier");
        this.versionClient.move("10013", vm);
        this.assertVersionSequence("MKY", "Two", "One", "Five", "Four", "Three");
        vm = new VersionMove().position("Earlier");
        this.versionClient.move("10011", vm);
        this.assertVersionSequence("MKY", "Two", "One", "Five", "Four", "Three");
        vm = new VersionMove().position("Later");
        this.versionClient.move("10012", vm);
        this.assertVersionSequence("MKY", "Two", "One", "Five", "Four", "Three");
        vm = new VersionMove().position("First");
        this.versionClient.move("10013", vm);
        this.assertVersionSequence("MKY", "Four", "Two", "One", "Five", "Three");
        vm = new VersionMove().position("First");
        this.versionClient.move("10013", vm);
        this.assertVersionSequence("MKY", "Four", "Two", "One", "Five", "Three");
        vm = new VersionMove().position("Last");
        this.versionClient.move("10011", vm);
        this.assertVersionSequence("MKY", "Four", "One", "Five", "Three", "Two");
        vm = new VersionMove().position("Last");
        this.versionClient.move("10011", vm);
        this.assertVersionSequence("MKY", "Four", "One", "Five", "Three", "Two");
        vm = new VersionMove().position("First");
        this.versionClient.move("10010", vm);
        vm = new VersionMove().after(this.createSelfLink(10010L));
        this.versionClient.move("10014", vm);
        vm = new VersionMove().after(this.createSelfLink(10010L));
        this.versionClient.move("10013", vm);
        vm = new VersionMove().after(this.createSelfLink(10010L));
        this.versionClient.move("10012", vm);
        vm = new VersionMove().after(this.createSelfLink(10010L));
        this.versionClient.move("10011", vm);
        this.assertVersionSequence("MKY", "One", "Two", "Three", "Four", "Five");
    }

    @Test
    public void testMoveVersionErrors() {
        VersionMove vm = new VersionMove().position("Later");
        ParsedResponse response = this.versionClient.moveResponse("99914", vm);
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        String message = "Could not find version for id '99914'";
        Assert.assertThat((Object)response.entity, (Matcher)CoreMatchers.equalTo((Object)new Errors().addError(message)));
        vm = new VersionMove().after(this.createSelfLink(19910L));
        response = this.versionClient.moveResponse("10014", vm);
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        message = "Could not find version with id '19910' for project 'MKY'";
        Assert.assertThat((Object)response.entity, (Matcher)CoreMatchers.equalTo((Object)new Errors().addError(message)));
        vm = new VersionMove().after(this.createSelfLink(10000L));
        response = this.versionClient.moveResponse("10014", vm);
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        message = "Could not find version with id '10000' for project 'MKY'";
        Assert.assertThat((Object)response.entity, (Matcher)CoreMatchers.equalTo((Object)new Errors().addError(message)));
    }

    @Test
    public void testDeleteVersion() {
        this.versionClient.delete("10010");
        ParsedResponse resp1 = this.versionClient.getResponse("10010");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Could not find version for id '10010'"));
        String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.navigation.issue().setFixVersions(issueKey, "Two");
        this.navigation.issue().setAffectsVersions(issueKey, "Two");
        this.versionClient.delete("10011", this.createSelfLink(10013L), this.createSelfLink(10014L));
        resp1 = this.versionClient.getResponse("10011");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Could not find version for id '10011'"));
        SearchResult fixFourResults = this.searchClient.postSearch(new SearchRequest().jql("fixVersion = Four"));
        Assert.assertThat((Object)fixFourResults.total, (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)fixFourResults.issues.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        SearchResult affectedFive = this.searchClient.postSearch(new SearchRequest().jql("affectedVersion = Five"));
        Assert.assertThat((Object)affectedFive.total, (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)affectedFive.issues.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.versionClient.delete("10013");
        resp1 = this.versionClient.getResponse("10013");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Could not find version for id '10013'"));
        ParsedResponse result = this.searchClient.postSearchResponse(new SearchRequest().jql("fixVersion = Four"));
        Assert.assertThat((Object)result.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertTrue((boolean)result.entity.errorMessages.contains("The value 'Four' does not exist for the field 'fixVersion'."));
        affectedFive = this.searchClient.postSearch(new SearchRequest().jql("affectedVersion = Five"));
        Assert.assertThat((Object)affectedFive.total, (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)affectedFive.issues.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.versionClient.delete("10014");
        resp1 = this.versionClient.getResponse("10014");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Could not find version for id '10014'"));
        result = this.searchClient.postSearchResponse(new SearchRequest().jql("fixVersion = Four"));
        Assert.assertThat((Object)result.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertTrue((boolean)result.entity.errorMessages.contains("The value 'Four' does not exist for the field 'fixVersion'."));
        result = this.searchClient.postSearchResponse(new SearchRequest().jql("affectedVersion = Five"));
        Assert.assertThat((Object)result.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertTrue((boolean)result.entity.errorMessages.contains("The value 'Five' does not exist for the field 'affectedVersion'."));
    }

    @Test
    public void testDeleteVersionErrorConditions() {
        ParsedResponse resp1 = this.versionClient.delete("99010");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Could not find version for id '99010'"));
        resp1 = ((VersionClient)this.versionClient.loginAs("fred")).delete("10010");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)401));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("The user fred does not have permission to complete this operation."));
        String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.navigation.issue().setFixVersions(issueKey, "Two");
        this.navigation.issue().setAffectsVersions(issueKey, "Two");
        resp1 = ((VersionClient)this.versionClient.loginAs("admin")).delete("10011", this.createSelfLink(10011L), this.createSelfLink(10014L));
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("You cannot move the issues to the version being deleted."));
        resp1 = ((VersionClient)this.versionClient.loginAs("admin")).delete("10011", this.createSelfLink(10012L), this.createSelfLink(10011L));
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("You cannot move the issues to the version being deleted."));
        resp1 = ((VersionClient)this.versionClient.loginAs("admin")).delete("10011", this.createSelfLink(10011L), this.createSelfLink(23014L));
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("The affects version with id 23014 does not exist."));
        resp1 = ((VersionClient)this.versionClient.loginAs("admin")).delete("10011", this.createSelfLink(23011L), this.createSelfLink(10014L));
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("The fix version with id 23011 does not exist."));
    }

    @Test
    public void testGetVersionIssueCounts() {
        VersionIssueCounts counts = this.versionClient.getVersionIssueCounts("10000");
        Assert.assertThat((Object)counts.issuesFixedCount, (Matcher)CoreMatchers.equalTo((Object)0L));
        Assert.assertThat((Object)counts.issuesAffectedCount, (Matcher)CoreMatchers.equalTo((Object)0L));
        String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.navigation.issue().setFixVersions(issueKey, "Two");
        this.navigation.issue().setAffectsVersions(issueKey, "Two");
        counts = this.versionClient.getVersionIssueCounts("10011");
        Assert.assertThat((Object)counts.issuesFixedCount, (Matcher)CoreMatchers.equalTo((Object)1L));
        Assert.assertThat((Object)counts.issuesAffectedCount, (Matcher)CoreMatchers.equalTo((Object)1L));
        issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.navigation.issue().setFixVersions(issueKey, "Two");
        counts = this.versionClient.getVersionIssueCounts("10011");
        Assert.assertThat((Object)counts.issuesFixedCount, (Matcher)CoreMatchers.equalTo((Object)2L));
        Assert.assertThat((Object)counts.issuesAffectedCount, (Matcher)CoreMatchers.equalTo((Object)1L));
        issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.navigation.issue().setFixVersions(issueKey, "Two");
        this.navigation.issue().setAffectsVersions(issueKey, "Three");
        counts = this.versionClient.getVersionIssueCounts("10011");
        Assert.assertThat((Object)counts.issuesFixedCount, (Matcher)CoreMatchers.equalTo((Object)3L));
        Assert.assertThat((Object)counts.issuesAffectedCount, (Matcher)CoreMatchers.equalTo((Object)1L));
        counts = this.versionClient.getVersionIssueCounts("10012");
        Assert.assertThat((Object)counts.issuesFixedCount, (Matcher)CoreMatchers.equalTo((Object)0L));
        Assert.assertThat((Object)counts.issuesAffectedCount, (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void testGetVersionIssueCountsNotFound() {
        ParsedResponse resp1 = this.versionClient.getVersionIssueCountsResponse("1");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Could not find version for id '1'"));
        ParsedResponse respZbing = this.versionClient.getVersionIssueCountsResponse("zbing");
        Assert.assertThat((Object)respZbing.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)respZbing.entity.errorMessages.contains("Could not find version for id 'zbing'"));
    }

    @Test
    public void testGetVersionUnresolvedIssueCount() {
        VersionUnresolvedIssueCount counts = this.versionClient.getVersionUnresolvedIssueCount("10000");
        Assert.assertThat((Object)counts.issuesUnresolvedCount, (Matcher)CoreMatchers.equalTo((Object)0L));
        String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.navigation.issue().setFixVersions(issueKey, "Two");
        counts = this.versionClient.getVersionUnresolvedIssueCount("10011");
        Assert.assertThat((Object)counts.issuesUnresolvedCount, (Matcher)CoreMatchers.equalTo((Object)1L));
        issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.navigation.issue().setFixVersions(issueKey, "Two");
        counts = this.versionClient.getVersionUnresolvedIssueCount("10011");
        Assert.assertThat((Object)counts.issuesUnresolvedCount, (Matcher)CoreMatchers.equalTo((Object)2L));
        issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.navigation.issue().setFixVersions(issueKey, "Two");
        counts = this.versionClient.getVersionUnresolvedIssueCount("10011");
        Assert.assertThat((Object)counts.issuesUnresolvedCount, (Matcher)CoreMatchers.equalTo((Object)3L));
        counts = this.versionClient.getVersionUnresolvedIssueCount("10012");
        Assert.assertThat((Object)counts.issuesUnresolvedCount, (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void testGetVersionUnresolvedIssueCountNotFound() {
        ParsedResponse resp1 = this.versionClient.getVersionUnresolvedIssueCountResponse("1");
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("Could not find version for id '1'"));
        ParsedResponse respZbing = this.versionClient.getVersionUnresolvedIssueCountResponse("zbing");
        Assert.assertThat((Object)respZbing.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertTrue((boolean)respZbing.entity.errorMessages.contains("Could not find version for id 'zbing'"));
    }

    private void assertVersionSequence(String project, String ... names) {
        List versions = this.projectClient.getVersions(project);
        Assert.assertThat((Object)versions.size(), (Matcher)CoreMatchers.equalTo((Object)names.length));
        this.assertVersionSequence(versions, names);
    }

    private void assertVersionSequence(List<Version> versions, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Assert.assertThat((Object)versions.get((int)i).name, (Matcher)CoreMatchers.equalTo((Object)name));
        }
    }

    private Version addNewAttributes(Version version, Version newVersion) {
        return version.self(newVersion.self).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).project(null).id(newVersion.id);
    }

    private URI createSelfLink(long id) {
        return URI.create(this.environmentData.getBaseUrl() + "/rest/api/2/version/" + id);
    }

    private void assertReleaseDatesShowInUserTimeZone(String releaseDateDublin, String releaseDateMidway, String releaseDateKiritimati) {
        String versionId = "10011";
        Version adminsVersion = ((VersionClient)this.versionClient.loginAs("admin")).get("10011");
        Version bobsVersion = ((VersionClient)this.versionClient.loginAs("bob")).get("10011");
        Version fredsVersion = ((VersionClient)this.versionClient.loginAs("fred")).get("10011");
        Assert.assertThat((String)String.format("Release date is wrong in %s", adminsVersion), (Object)adminsVersion.userReleaseDate, (Matcher)CoreMatchers.equalTo((Object)releaseDateDublin));
        Assert.assertThat((String)String.format("Release date is wrong in %s", fredsVersion), (Object)fredsVersion.userReleaseDate, (Matcher)CoreMatchers.equalTo((Object)releaseDateMidway));
        Assert.assertThat((String)String.format("Release date is wrong in %s", bobsVersion), (Object)bobsVersion.userReleaseDate, (Matcher)CoreMatchers.equalTo((Object)releaseDateKiritimati));
    }

    @Test
    @Restore(value="TestVersionCustomFields.xml")
    public void testShouldRemoveVersionReferenceFromCustomFields() {
        String versionToRemoveId = "10011";
        String issuesWithVersionsToRemoveJql = String.format("\"multi version picker cf\" = \"%s\"", versionToRemoveId);
        ParsedResponse resultPre = this.searchClient.postSearchResponse(new SearchRequest().jql(issuesWithVersionsToRemoveJql));
        Assert.assertThat((Object)resultPre.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)((SearchResult)resultPre.body).issues, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        ParsedResponse deleteResponse = this.versionClient.delete(versionToRemoveId, this.createSelfLink(10010L), this.createSelfLink(10010L));
        Assert.assertThat((Object)deleteResponse.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        ParsedResponse resp1 = this.versionClient.getResponse(versionToRemoveId);
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertThat((Object)resp1.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{String.format("Could not find version for id '%s'", versionToRemoveId)}));
        ParsedResponse result = this.searchClient.postSearchResponse(new SearchRequest().jql(issuesWithVersionsToRemoveJql));
        Assert.assertThat((Object)result.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertThat((Object)result.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{String.format("The value '%s' does not exist for the field 'multi version picker cf'.", versionToRemoveId)}));
    }

    @Test
    @Restore(value="TestVersionCustomFields.xml")
    public void testShouldShowIssuesThatReferToIssueBySingleVersionCustomField() {
        VersionIssueCounts versionIssueCounts = this.versionClient.getVersionIssueCounts("10011");
        Assert.assertThat((Object)versionIssueCounts.issueCountWithCustomFieldsShowingVersion, (Matcher)CoreMatchers.equalTo((Object)2L));
        Assert.assertThat((Object)versionIssueCounts.customFieldUsage, (Matcher)Matchers.containsInAnyOrder((Object[])new VersionIssueCounts.VersionUsageInCustomFields[]{new VersionIssueCounts.VersionUsageInCustomFields(10000L, "multi version picker cf", 1L), new VersionIssueCounts.VersionUsageInCustomFields(10001L, "single version picker cf", 1L)}));
    }

    @Test
    @Restore(value="TestVersionCustomFields.xml")
    public void testShouldShowIssuesThatReferToIssueByMultiVersionCustomField() {
        VersionIssueCounts versionIssueCounts = this.versionClient.getVersionIssueCounts("10010");
        Assert.assertThat((Object)versionIssueCounts.issueCountWithCustomFieldsShowingVersion, (Matcher)CoreMatchers.equalTo((Object)1L));
        Assert.assertThat((Object)versionIssueCounts.customFieldUsage, (Matcher)Matchers.contains((Object[])new VersionIssueCounts.VersionUsageInCustomFields[]{new VersionIssueCounts.VersionUsageInCustomFields(10000L, "multi version picker cf", 1L)}));
    }

    @Test
    @Restore(value="TestVersionCustomFieldsMerge.xml")
    public void testShouldMergeVersionInCustomFields() {
        String removedVersionId = "10020";
        String mergeToVersionId = "10021";
        ParsedResponse mergeResponse = this.versionClient.merge("10020", "10021");
        Assert.assertThat((Object)mergeResponse.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        ParsedResponse searchMergedVersionResultMultiVersion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("\"multi version picker cf\" = \"%s\"", "10020")));
        Assert.assertThat((Object)searchMergedVersionResultMultiVersion.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertThat((Object)searchMergedVersionResultMultiVersion.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{String.format("The value '%s' does not exist for the field 'multi version picker cf'.", "10020")}));
        ParsedResponse searchNewVersionResultMultiversion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("\"multi version picker cf\" = \"%s\"", "10021")));
        Assert.assertThat((Object)searchNewVersionResultMultiversion.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat(((SearchResult)searchNewVersionResultMultiversion.body).issues.stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"HSP-2", "HSP-3"}));
        ParsedResponse searchMergedVersionResultSingleVersion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("\"single version picker cf\" = \"%s\"", "10020")));
        Assert.assertThat((Object)searchMergedVersionResultSingleVersion.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertThat((Object)searchMergedVersionResultSingleVersion.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{String.format("The value '%s' does not exist for the field 'single version picker cf'.", "10020")}));
        ParsedResponse searchNewVersionResultSingleVersion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("\"single version picker cf\" = \"%s\"", "10021")));
        Assert.assertThat((Object)searchNewVersionResultSingleVersion.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat(((SearchResult)searchNewVersionResultSingleVersion.body).issues.stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"HSP-2", "HSP-3"}));
    }

    @Test
    @Restore(value="TestVersionCustomFieldsMerge.xml")
    public void testShouldReplaceOneSpecifiedCustomFieldButNoOthers() {
        ParsedResponse resp1 = this.versionClient.deleteVersionAndSwap("10020", DeleteVersionWithCustomFieldParameters.create().moveCustomFieldTo(10000L, 10011L).build());
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        ParsedResponse searchNewVersionResultMultiversion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("\"multi version picker cf\" = \"%s\"", "10011")));
        Assert.assertThat((Object)searchNewVersionResultMultiversion.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat(((SearchResult)searchNewVersionResultMultiversion.body).issues.stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"HSP-1", "HSP-2", "HSP-3"}));
        ParsedResponse searchNewVersionResultSingleversion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("\"single version picker cf\" = \"%s\"", "10011")));
        Assert.assertThat((Object)searchNewVersionResultSingleversion.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat(((SearchResult)searchNewVersionResultSingleversion.body).issues.stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"HSP-1"}));
    }

    @Test
    @Restore(value="TestVersionCustomFieldsMerge.xml")
    public void testShouldReplaceAllSpecifiedCustomField() {
        ParsedResponse resp1 = this.versionClient.deleteVersionAndSwap("10020", DeleteVersionWithCustomFieldParameters.create().moveCustomFieldTo(10000L, 10011L).moveCustomFieldTo(10001L, 10010L).build());
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        ParsedResponse searchNewVersionResultMultiversion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("\"multi version picker cf\" = \"%s\"", "10011")));
        Assert.assertThat((Object)searchNewVersionResultMultiversion.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat(((SearchResult)searchNewVersionResultMultiversion.body).issues.stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"HSP-1", "HSP-2", "HSP-3"}));
        ParsedResponse searchNewVersionResultSingleversion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("\"single version picker cf\" = \"%s\"", "10010")));
        Assert.assertThat((Object)searchNewVersionResultSingleversion.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat(((SearchResult)searchNewVersionResultSingleversion.body).issues.stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"HSP-2"}));
    }

    @Test
    @Restore(value="TestVersionCustomFieldsMerge.xml")
    public void testShouldReplaceFixVersionOnly() {
        ParsedResponse resp1 = this.versionClient.deleteVersionAndSwap("10020", DeleteVersionWithCustomFieldParameters.create().moveFixIssuesTo(10011L).build());
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        ParsedResponse searchNewVersionResultFixVersion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("fixVersion = \"%s\"", "10011")));
        Assert.assertThat((Object)searchNewVersionResultFixVersion.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat(((SearchResult)searchNewVersionResultFixVersion.body).issues.stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"HSP-3", "HSP-4"}));
        ParsedResponse searchNewVersionResultMultiversion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("\"multi version picker cf\" = \"%s\"", "10011")));
        Assert.assertThat((Object)searchNewVersionResultMultiversion.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat(((SearchResult)searchNewVersionResultMultiversion.body).issues.stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"HSP-1"}));
        ParsedResponse searchNewVersionResultSingleversion = this.searchClient.postSearchResponse(new SearchRequest().jql(String.format("\"single version picker cf\" = \"%s\"", "10011")));
        Assert.assertThat((Object)searchNewVersionResultSingleversion.statusCode, (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat(((SearchResult)searchNewVersionResultSingleversion.body).issues.stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"HSP-1"}));
    }

    @Test
    @Restore(value="TestVersionCustomFieldsMerge.xml")
    public void testShouldAddHistoryItemForVersionRemovalInAllFields() {
        IssueClient issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        ParsedResponse resp1 = this.versionClient.deleteVersionAndSwap("10020", DeleteVersionWithCustomFieldParameters.create().build());
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        Issue issueChangeInformation = issueClient.get("HSP-3", new Issue.Expand[]{Issue.Expand.changelog});
        List allHistoryItems = issueChangeInformation.changelog.getHistories().stream().flatMap(history -> history.getItems().stream()).collect(Collectors.toList());
        Assert.assertThat(allHistoryItems, (Matcher)Matchers.hasItem((Object)new ChangeLog.HistoryItem().setFieldtype("jira").setField("Fix Version").setFrom("10020").setFromString("VersionWillBeMerged")));
        Assert.assertThat(allHistoryItems, (Matcher)Matchers.hasItem((Object)new ChangeLog.HistoryItem().setFieldtype("custom").setField("multi version picker cf").setFrom("[10020]").setFromString("VersionWillBeMerged").setTo("").setToString("")));
    }

    @Test
    @Restore(value="TestVersionCustomFieldsMerge.xml")
    public void testShouldAddHistoryItemForVersionReplaceInAllFields() {
        IssueClient issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        ParsedResponse resp1 = this.versionClient.deleteVersionAndSwap("10020", DeleteVersionWithCustomFieldParameters.create().moveFixIssuesTo(10011L).moveCustomFieldTo(10000L, 10011L).build());
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        Issue issueChangeInformation = issueClient.get("HSP-3", new Issue.Expand[]{Issue.Expand.changelog});
        List allHistoryItems = issueChangeInformation.changelog.getHistories().stream().flatMap(history -> history.getItems().stream()).collect(Collectors.toList());
        List fixVersionChanges = allHistoryItems.stream().filter(historyItem -> historyItem.getField().equals("Fix Version")).collect(Collectors.toList());
        Assert.assertThat(fixVersionChanges, (Matcher)Matchers.containsInAnyOrder((Object[])new ChangeLog.HistoryItem[]{new ChangeLog.HistoryItem().setFieldtype("jira").setField("Fix Version").setTo("10011").setToString("New Version 2"), new ChangeLog.HistoryItem().setFieldtype("jira").setField("Fix Version").setFrom("10020").setFromString("VersionWillBeMerged")}));
        Assert.assertThat(allHistoryItems, (Matcher)Matchers.hasItem((Object)new ChangeLog.HistoryItem().setFieldtype("custom").setField("multi version picker cf").setFrom("[10020]").setFromString("VersionWillBeMerged").setTo("[10011]").setToString("New Version 2")));
    }

    @Test
    @Restore(value="TestVersionCustomFieldsMerge.xml")
    public void testShouldIncludeVersionRemoveInHistory() {
        IssueClient issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        ParsedResponse resp1 = this.versionClient.deleteVersionAndSwap("10020", DeleteVersionWithCustomFieldParameters.create().build());
        Assert.assertThat((Object)resp1.statusCode, (Matcher)CoreMatchers.equalTo((Object)204));
        Issue issueChangeInformation = issueClient.get("HSP-3", new Issue.Expand[]{Issue.Expand.changelog});
        List allHistoryItems = issueChangeInformation.changelog.getHistories().stream().flatMap(history -> history.getItems().stream()).collect(Collectors.toList());
        List fixVersionChanges = allHistoryItems.stream().filter(historyItem -> historyItem.getField().equals("Fix Version")).collect(Collectors.toList());
        Assert.assertThat(fixVersionChanges, (Matcher)Matchers.contains((Object[])new ChangeLog.HistoryItem[]{new ChangeLog.HistoryItem().setFieldtype("jira").setField("Fix Version").setFrom("10020").setFromString("VersionWillBeMerged")}));
        Assert.assertThat(allHistoryItems, (Matcher)Matchers.hasItem((Object)new ChangeLog.HistoryItem().setFieldtype("custom").setField("multi version picker cf").setFrom("[10020]").setFromString("VersionWillBeMerged").setTo("").setToString("")));
    }
}

