/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.WorklogControl;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogChangeBean;
import com.atlassian.jira.testkit.client.restclient.WorklogChangedSinceBean;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import com.atlassian.jira.util.SlowTest;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.WORKLOGS})
@RestoreBlankInstance
public class TestWorklogResource
extends BaseJiraRestTest {
    public static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final DateTime YEAR_AGO = DateTime.now().minusYears(1);
    private WorklogClient worklogClient;
    private WorklogControl worklogControl;

    @Before
    public void setUpTest() {
        this.worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        this.worklogControl = new WorklogControl((JIRAEnvironmentData)this.environmentData);
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.DELETE_ALL_WORKLOGS);
    }

    @Test
    public void noWorklogsReturnEmptyPage() {
        ParsedResponse updatedWorklogsSince = this.worklogClient.getUpdatedWorklogsSince(Long.valueOf(0L));
        WorklogChangedSinceBean body = (WorklogChangedSinceBean)updatedWorklogsSince.body;
        Assert.assertThat((Object)body.values, (Matcher)IsCollectionWithSize.hasSize((int)0));
        Assert.assertTrue((boolean)body.lastPage);
        Assert.assertNull((Object)body.nextPage);
        Assert.assertEquals((Object)body.since, (Object)body.until);
        Assert.assertEquals((long)0L, (long)body.since);
    }

    @Test
    public void gettingSingleElementsInPage() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "asd");
        Long worklog = this.createWorklog(issue);
        ParsedResponse updatedWorklogsSince = this.worklogClient.getUpdatedWorklogsSince(Long.valueOf(0L));
        WorklogChangedSinceBean body = (WorklogChangedSinceBean)updatedWorklogsSince.body;
        Assert.assertThat((Object)body.values, (Matcher)Matchers.contains(this.changeBeanMatcher(worklog)));
    }

    @Test
    public void userWontSeeWorklogsRestrictedToRoleHeDoesntHave() {
        String groupname = "group-without-members";
        this.backdoor.usersAndGroups().addGroup("group-without-members");
        this.backdoor.usersAndGroups().addUserToGroup("admin", "group-without-members");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "asd");
        Worklog worklog = this.newWorklogBean();
        worklog.visibility = new Visibility("group", "group-without-members");
        this.createWorklog(issue, worklog);
        this.backdoor.usersAndGroups().removeUserFromGroup("admin", "group-without-members");
        ParsedResponse updatedWorklogsSince = this.worklogClient.getUpdatedWorklogsSince(Long.valueOf(0L));
        WorklogChangedSinceBean body = (WorklogChangedSinceBean)updatedWorklogsSince.body;
        Assert.assertThat((Object)body.values, (Matcher)Matchers.empty());
    }

    @Test
    public void anonymousResultsIn401() {
        ParsedResponse updatedWorklogsSince = ((WorklogClient)this.worklogClient.anonymous()).getUpdatedWorklogsSince(Long.valueOf(0L));
        Assert.assertEquals((long)updatedWorklogsSince.statusCode, (long)Response.Status.UNAUTHORIZED.getStatusCode());
    }

    @Test
    @SlowTest
    public void responseIsPaginated() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "asd");
        List createdWorklogIds = IntStream.range(0, 2001).mapToObj(n -> this.createWorklog(issue, n)).collect(Collectors.toList());
        WorklogChangedSinceBean firstPage = (WorklogChangedSinceBean)this.worklogClient.getUpdatedWorklogsSince((Long)Long.valueOf((long)0L)).body;
        Assert.assertEquals((long)0L, (long)firstPage.since);
        Assert.assertThat((Object)firstPage.values, (Matcher)Matchers.contains(createdWorklogIds.stream().limit(1000L).map(this::changeBeanMatcher).collect(Collectors.toList())));
        Assert.assertNotNull((Object)firstPage.until);
        WorklogChangedSinceBean secondPage = (WorklogChangedSinceBean)this.worklogClient.getUpdatedWorklogsSince((Long)firstPage.until).body;
        Assert.assertEquals((Object)firstPage.until, (Object)secondPage.since);
        Assert.assertThat((Object)secondPage.values, (Matcher)Matchers.contains(createdWorklogIds.stream().skip(firstPage.values.size() - 1).limit(1000L).map(this::changeBeanMatcher).collect(Collectors.toList())));
        WorklogChangedSinceBean thirdPage = (WorklogChangedSinceBean)this.worklogClient.getUpdatedWorklogsSince((Long)secondPage.until).body;
        Assert.assertEquals((Object)secondPage.until, (Object)thirdPage.since);
        Assert.assertThat((Object)thirdPage.values, (Matcher)Matchers.contains(createdWorklogIds.stream().skip(1000 + secondPage.values.size() - 2).limit(1000L).map(this::changeBeanMatcher).collect(Collectors.toList())));
        for (WorklogChangeBean bean : firstPage.values) {
            this.removeWorklog(issue, bean);
        }
        WorklogChangedSinceBean deletedWorklgosPage = (WorklogChangedSinceBean)this.worklogClient.getDeletedWorklogsSince((Long)firstPage.since).body;
        Assert.assertThat((Object)deletedWorklgosPage.values, (Matcher)Matchers.containsInAnyOrder((Collection)firstPage.values.stream().map(WorklogChangeBean::getWorklogId).map(i -> Matchers.hasProperty((String)"worklogId", (Matcher)Matchers.equalTo((Object)i))).collect(Collectors.toList())));
    }

    @Test
    public void getDeletedWorklogsReturnsEmptyListWhenNoWorklogsDeleted() {
        WorklogChangedSinceBean body = (WorklogChangedSinceBean)this.worklogClient.getDeletedWorklogsSince((Long)Long.valueOf((long)0L)).body;
        Assert.assertThat((Object)body.values, (Matcher)Matchers.empty());
    }

    @Test
    public void deletedWorklogNotInUpdatedWorklogs() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "asd");
        Long createdWorklogId = this.createWorklog(issue);
        List updatedSince = ((WorklogChangedSinceBean)this.worklogClient.getUpdatedWorklogsSince((Long)Long.valueOf((long)0L)).body).values;
        Assert.assertThat((Object)updatedSince, (Matcher)Matchers.contains(this.changeBeanMatcher(createdWorklogId)));
        this.removeWorklog(issue, (WorklogChangeBean)updatedSince.get(0));
        Assert.assertThat((Object)((WorklogChangedSinceBean)this.worklogClient.getUpdatedWorklogsSince((Long)Long.valueOf((long)0L)).body).values, (Matcher)Matchers.empty());
        Assert.assertThat((Object)((WorklogChangedSinceBean)this.worklogClient.getDeletedWorklogsSince((Long)Long.valueOf((long)0L)).body).values, (Matcher)Matchers.contains(this.changeBeanMatcher(createdWorklogId)));
    }

    @Test
    public void getModifiedWorklogsByIds() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "asd");
        Set createdWorklogIds = IntStream.range(0, 1).mapToObj(n -> this.createWorklog(issue)).collect(Collectors.toSet());
        Collection worklogs = (Collection)this.worklogClient.getWorklogs(createdWorklogIds).body;
        Assert.assertThat((Object)worklogs, (Matcher)Matchers.containsInAnyOrder((Collection)createdWorklogIds.stream().map(this::worklogIdMatcher).collect(Collectors.toSet())));
    }

    @Test
    public void returnedWorklogShouldBeSameAsReturnedByJira() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "asd");
        Long worklogId = this.createWorklog(issue);
        Worklog worklog = this.worklogClient.get(issue.key, Long.toString(worklogId));
        Collection worklogsById = (Collection)this.worklogClient.getWorklogs((Collection)ImmutableSet.of((Object)worklogId)).body;
        Assert.assertThat((Object)worklogsById, (Matcher)Matchers.contains((Object[])new Worklog[]{worklog}));
    }

    @Test
    public void canNotGetMoreWorklogsThanPageLimitIs() {
        Set ids = IntStream.range(0, 1001).mapToObj(value -> value).collect(Collectors.toSet());
        ParsedResponse worklogs = this.worklogClient.getWorklogs(ids);
        Assert.assertThat((Object)worklogs.statusCode, (Matcher)Is.is((Object)400));
    }

    @Test
    public void cantGetWorklogsWithoutPermissions() {
        String groupname = "group-without-members";
        this.backdoor.usersAndGroups().addGroup("group-without-members");
        this.backdoor.usersAndGroups().addUserToGroup("admin", "group-without-members");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "asd");
        Worklog worklog = this.newWorklogBean();
        worklog.visibility = new Visibility("group", "group-without-members");
        Long worklogWithoutPermissionsId = this.createWorklog(issue, worklog);
        this.backdoor.usersAndGroups().removeUserFromGroup("admin", "group-without-members");
        Long worklogWithPermissionsId = this.createWorklog(issue);
        ParsedResponse worklogs = this.worklogClient.getWorklogs((Collection)Lists.newArrayList((Object[])new Long[]{worklogWithoutPermissionsId, worklogWithPermissionsId}));
        Assert.assertThat((Object)worklogs.statusCode, (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)worklogs.body, (Matcher)Matchers.contains(this.worklogIdMatcher(worklogWithPermissionsId)));
    }

    @Test
    public void willNotGetNotExistingWorklogs() {
        ParsedResponse worklogs = this.worklogClient.getWorklogs((Collection)Lists.newArrayList((Object[])new Long[]{100002L}));
        Assert.assertThat((Object)worklogs.statusCode, (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)worklogs.body, (Matcher)Matchers.empty());
    }

    @Test
    public void worklogUpdatedWithinLastMinuteIsNotReturned() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "asd");
        this.worklogClient.post(issue.key, this.newWorklogBean());
        Assert.assertThat((Object)((WorklogChangedSinceBean)this.worklogClient.getUpdatedWorklogsSince((Long)Long.valueOf((long)0L)).body).values, (Matcher)Matchers.empty());
    }

    @Test
    public void worklogRemovedWithinLastMinuteIsNotReturned() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "asd");
        ParsedResponse worklogResponse = this.worklogClient.post(issue.key, this.newWorklogBean());
        this.worklogClient.delete(issue.key, (Worklog)worklogResponse.body);
        Assert.assertThat((Object)((WorklogChangedSinceBean)this.worklogClient.getDeletedWorklogsSince((Long)Long.valueOf((long)0L)).body).values, (Matcher)Matchers.empty());
    }

    private Matcher<Worklog> worklogIdMatcher(final Long id) {
        return new TypeSafeMatcher<Worklog>(){

            protected boolean matchesSafely(Worklog item) {
                return Long.parseLong(item.id) == id;
            }

            public void describeTo(Description description) {
                description.appendText("Expected worklog with id ").appendValue((Object)id);
            }
        };
    }

    private void removeWorklog(IssueCreateResponse issue, WorklogChangeBean changeBean) {
        Worklog worklog = new Worklog();
        worklog.id = changeBean.getWorklogId().toString();
        this.worklogClient.delete(issue.key, worklog);
        this.worklogControl.setWorklogDeletedTimestamp(Long.valueOf(Long.parseLong(worklog.id)), Long.valueOf(this.yearAgo().getMillis()));
    }

    private Long createWorklog(IssueCreateResponse issue) {
        return this.createWorklog(issue, this.newWorklogBean());
    }

    private Long createWorklog(IssueCreateResponse issue, int n) {
        return this.createWorklog(issue, this.newWorklogBean(), n);
    }

    private Long createWorklog(IssueCreateResponse issue, Worklog worklog, int n) {
        return this.createWorklog(issue, worklog, YEAR_AGO.plusSeconds(n));
    }

    private Long createWorklog(IssueCreateResponse issue, Worklog worklog) {
        return this.createWorklog(issue, worklog, this.yearAgo());
    }

    private Long createWorklog(IssueCreateResponse issue, Worklog worklog, DateTime updateDate) {
        ParsedResponse worklogResponse = this.worklogClient.post(issue.key, worklog);
        Worklog createdWorklog = (Worklog)worklogResponse.body;
        this.worklogControl.setWorklogUpdatedTimestamp(Long.valueOf(Long.parseLong(createdWorklog.id)), Long.valueOf(updateDate.getMillis()));
        return Long.parseLong(createdWorklog.id);
    }

    private DateTime yearAgo() {
        return new DateTime(System.currentTimeMillis()).minusYears(1);
    }

    private Worklog newWorklogBean() {
        Date now = new Date();
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        worklog.started = TestWorklogResource.asTimeString(now);
        worklog.comment = "This is my comment";
        return worklog;
    }

    private Matcher<WorklogChangeBean> changeBeanMatcher(Long worklogId) {
        return Matchers.hasProperty((String)"worklogId", (Matcher)Matchers.equalTo((Object)worklogId));
    }

    private static String asTimeString(@Nullable Date date) {
        return date != null ? new SimpleDateFormat(TIME_FORMAT).format(date) : null;
    }
}

