/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.UserBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class WorkflowSchemeClient
extends RestApiClient<WorkflowSchemeClient> {
    private final boolean draft;
    private final JIRAEnvironmentData data;

    public WorkflowSchemeClient(JIRAEnvironmentData environmentData) {
        this(environmentData, false);
    }

    public WorkflowSchemeClient(JIRAEnvironmentData environmentData, boolean draft) {
        super(environmentData);
        this.draft = draft;
        this.data = environmentData;
    }

    public WorkflowSchemeClient asDraft() {
        return new WorkflowSchemeClient(this.data, true);
    }

    public ParsedResponse<WorkflowScheme> getWorkflowSchemeResponse(final long id) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeClient.this.createWorkflowSchemeResource(id).request().get(Response.class);
            }
        }, WorkflowScheme.class);
    }

    public WorkflowScheme getWorkflowScheme(long id) {
        return this.getWorkflowScheme(id, false);
    }

    public WorkflowScheme getWorkflowScheme(long id, boolean draftIfThere) {
        return (WorkflowScheme)this.createWorkflowSchemeResource(id).queryParam("returnDraftIfExists", new Object[]{String.valueOf(draftIfThere)}).request().get(WorkflowScheme.class);
    }

    protected WebTarget createResource() {
        return super.createResource().path("workflowscheme");
    }

    private WebTarget createWorkflowSchemeResource(long id) {
        WebTarget webTarget = this.createResource().path(String.valueOf(id));
        if (this.draft) {
            webTarget = webTarget.path("draft");
        }
        return webTarget;
    }

    private WebTarget createWorkflowSchemeWorkflowResource(long id, String workflowName) {
        return this.createWorkflowSchemeResource(id).path("workflow").queryParam("workflowName", new Object[]{workflowName});
    }

    private WebTarget createWorkflowSchemeIssueTypeResource(long id, String issueType) {
        return this.createWorkflowSchemeResource(id).path("issuetype").path(issueType);
    }

    public WorkflowScheme createScheme(WorkflowScheme workflowScheme) {
        return (WorkflowScheme)this.createResource().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)workflowScheme), WorkflowScheme.class);
    }

    public ParsedResponse<WorkflowScheme> createSchemeResponse(final WorkflowScheme workflowScheme) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeClient.this.createResource().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)workflowScheme), Response.class);
            }
        }, WorkflowScheme.class);
    }

    public void deleteScheme(Long id) {
        this.createWorkflowSchemeResource(id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
    }

    public ParsedResponse<Void> deleteSchemeResponse(final Long id) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeClient.this.createWorkflowSchemeResource(id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class);
            }
        }, Void.class);
    }

    public ParsedResponse<WorkflowScheme> updateWorkflowSchemeResponse(final WorkflowScheme workflowSchemeData) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeClient.this.createWorkflowSchemeResource(workflowSchemeData.getId()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)workflowSchemeData), Response.class);
            }
        }, WorkflowScheme.class);
    }

    public WorkflowScheme updateWorkflowScheme(WorkflowScheme workflowSchemeData) {
        return (WorkflowScheme)this.createWorkflowSchemeResource(workflowSchemeData.getId()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)workflowSchemeData), WorkflowScheme.class);
    }

    public WorkflowScheme createDraft(long id) {
        return (WorkflowScheme)this.createWorkflowSchemeResource(id).path("createdraft").request().post(null, WorkflowScheme.class);
    }

    public ParsedResponse<WorkflowScheme> createDraftResponse(final long id) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeClient.this.createWorkflowSchemeResource(id).path("createdraft").request().post(null, Response.class);
            }
        }, WorkflowScheme.class);
    }

    public List<WorkflowMapping> getWorkflowMappings(long id, boolean maybeDraft) {
        WebTarget workflow = this.createWorkflowSchemeResource(id).path("workflow").queryParam("returnDraftIfExists", new Object[]{String.valueOf(maybeDraft)});
        return (List)workflow.request().get(WorkflowMapping.LIST);
    }

    public ParsedResponse<List<WorkflowMapping>> getWorkflowMappingsResponse(long id, boolean maybeDraft) {
        return this.toResponse(() -> {
            WebTarget workflow = this.createWorkflowSchemeResource(id).path("workflow").queryParam("returnDraftIfExists", new Object[]{String.valueOf(maybeDraft)});
            return (Response)workflow.request().get(Response.class);
        }, WorkflowMapping.LIST);
    }

    public WorkflowMapping getWorkflowMapping(long id, String workflowName, boolean maybeDraft) {
        WebTarget workflow = this.createWorkflowSchemeWorkflowResource(id, workflowName).queryParam("returnDraftIfExists", new Object[]{String.valueOf(maybeDraft)});
        return (WorkflowMapping)workflow.request().get(WorkflowMapping.class);
    }

    public ParsedResponse<WorkflowMapping> getWorkflowMappingResponse(final long id, final String workflowName, final boolean maybeDraft) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                WebTarget workflow = WorkflowSchemeClient.this.createWorkflowSchemeWorkflowResource(id, workflowName).queryParam("returnDraftIfExists", new Object[]{String.valueOf(maybeDraft)});
                return (Response)workflow.request().get(Response.class);
            }
        }, WorkflowMapping.class);
    }

    public WorkflowScheme deleteWorkflowMapping(long id, String workflowName, boolean maybeDraft) {
        WebTarget workflow = this.createWorkflowSchemeWorkflowResource(id, workflowName).queryParam("updateDraftIfNeeded", new Object[]{String.valueOf(maybeDraft)});
        return (WorkflowScheme)workflow.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(WorkflowScheme.class);
    }

    public ParsedResponse<WorkflowScheme> deleteWorkflowMappingResponse(final long id, final String workflowName, final boolean maybeDraft) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                WebTarget workflow = WorkflowSchemeClient.this.createWorkflowSchemeWorkflowResource(id, workflowName).queryParam("updateDraftIfNeeded", new Object[]{String.valueOf(maybeDraft)});
                return (Response)workflow.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class);
            }
        }, WorkflowScheme.class);
    }

    public WorkflowScheme updateWorkflowMapping(long id, WorkflowMapping mapping) {
        return this.updateWorkflowMapping(id, mapping.getWorkflow(), mapping);
    }

    public WorkflowScheme updateWorkflowMapping(long id, String workflowName, WorkflowMapping mapping) {
        WebTarget workflow = this.createWorkflowSchemeWorkflowResource(id, workflowName);
        return (WorkflowScheme)workflow.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)mapping), WorkflowScheme.class);
    }

    public ParsedResponse<WorkflowScheme> updateWorkflowMappingResponse(final long id, final WorkflowMapping mapping) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                WebTarget workflow = WorkflowSchemeClient.this.createWorkflowSchemeWorkflowResource(id, mapping.getWorkflow());
                return (Response)workflow.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)mapping), Response.class);
            }
        }, WorkflowScheme.class);
    }

    public IssueTypeMappingBean getIssueTypeMapping(long id, String issueType, boolean maybeDraft) {
        WebTarget workflow = this.createWorkflowSchemeIssueTypeResource(id, issueType).queryParam("returnDraftIfExists", new Object[]{String.valueOf(maybeDraft)});
        return (IssueTypeMappingBean)workflow.request().get(IssueTypeMappingBean.class);
    }

    public ParsedResponse<IssueTypeMappingBean> getIssueTypeMappingResponse(final long id, final String issueType, final boolean maybeDraft) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                WebTarget workflow = WorkflowSchemeClient.this.createWorkflowSchemeIssueTypeResource(id, issueType).queryParam("returnDraftIfExists", new Object[]{String.valueOf(maybeDraft)});
                return (Response)workflow.request().get(Response.class);
            }
        }, IssueTypeMappingBean.class);
    }

    public WorkflowScheme deleteIssueMapping(long id, String issueType, boolean maybeDraft) {
        WebTarget workflow = this.createWorkflowSchemeIssueTypeResource(id, issueType).queryParam("updateDraftIfNeeded", new Object[]{String.valueOf(maybeDraft)});
        return (WorkflowScheme)workflow.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(WorkflowScheme.class);
    }

    public ParsedResponse<WorkflowScheme> deleteIssueMappingResponse(final long id, final String issueType, final boolean maybeDraft) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                WebTarget workflow = WorkflowSchemeClient.this.createWorkflowSchemeIssueTypeResource(id, issueType).queryParam("updateDraftIfNeeded", new Object[]{String.valueOf(maybeDraft)});
                return (Response)workflow.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class);
            }
        }, WorkflowScheme.class);
    }

    public WorkflowScheme updateIssueTypeMapping(long id, IssueTypeMappingBean mapping) {
        return this.updateIssueTypeMapping(id, mapping.getIssueType(), mapping);
    }

    public WorkflowScheme updateIssueTypeMapping(long id, String issueType, IssueTypeMappingBean mapping) {
        WebTarget workflow = this.createWorkflowSchemeIssueTypeResource(id, issueType);
        return (WorkflowScheme)workflow.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)mapping), WorkflowScheme.class);
    }

    public ParsedResponse<WorkflowScheme> updateIssueTypeMappingResponse(final long id, final IssueTypeMappingBean mapping) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                WebTarget workflow = WorkflowSchemeClient.this.createWorkflowSchemeIssueTypeResource(id, mapping.getIssueType());
                return (Response)workflow.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)mapping), Response.class);
            }
        }, WorkflowScheme.class);
    }

    public DefaultBean getDefault(long id, boolean draft) {
        return (DefaultBean)this.createDefaultResource(id).queryParam("returnDraftIfExists", new Object[]{String.valueOf(draft)}).request().get(DefaultBean.class);
    }

    public ParsedResponse<DefaultBean> getDefaultResponse(final long id, final boolean draft) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeClient.this.createDefaultResource(id).queryParam("returnDraftIfExists", new Object[]{String.valueOf(draft)}).request().get(Response.class);
            }
        }, DefaultBean.class);
    }

    public WorkflowScheme deleteDefault(long id, boolean updateDraftIfNeeded) {
        return (WorkflowScheme)this.createDefaultResource(id).queryParam("updateDraftIfNeeded", new Object[]{String.valueOf(updateDraftIfNeeded)}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(WorkflowScheme.class);
    }

    public ParsedResponse<WorkflowScheme> deleteDefaultResponse(final long id, final boolean updateDraftIfNeeded) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeClient.this.createDefaultResource(id).queryParam("updateDraftIfNeeded", new Object[]{String.valueOf(updateDraftIfNeeded)}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class);
            }
        }, WorkflowScheme.class);
    }

    public WorkflowScheme setDefault(long id, String workflowName, boolean updateDraft) {
        DefaultBean requestEntity = new DefaultBean(workflowName);
        requestEntity.setUpdateDraftIfNeeded(updateDraft);
        return (WorkflowScheme)this.createDefaultResource(id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)requestEntity), WorkflowScheme.class);
    }

    public ParsedResponse<WorkflowScheme> setDefaultResponse(final long id, String workflowName, boolean updateDraft) {
        final DefaultBean requestEntity = new DefaultBean(workflowName);
        requestEntity.setUpdateDraftIfNeeded(updateDraft);
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeClient.this.createDefaultResource(id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)requestEntity), Response.class);
            }
        }, WorkflowScheme.class);
    }

    private WebTarget createDefaultResource(long id) {
        return this.createWorkflowSchemeResource(id).path("default");
    }

    public static class DefaultBean {
        @JsonProperty
        private String workflow;
        @JsonProperty
        private Boolean updateDraftIfNeeded;

        public DefaultBean() {
        }

        public DefaultBean(String workflow) {
            this.workflow = workflow;
        }

        public Boolean getUpdateDraftIfNeeded() {
            return this.updateDraftIfNeeded;
        }

        public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
            this.updateDraftIfNeeded = updateDraftIfNeeded;
        }

        public String getWorkflow() {
            return this.workflow;
        }

        public void setWorkflow(String workflow) {
            this.workflow = workflow;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class IssueType {
        @JsonProperty
        private URI self;
        @JsonProperty
        private URI iconUrl;
        @JsonProperty
        private String id;
        @JsonProperty
        private String description;
        @JsonProperty
        private String name;
        @JsonProperty
        private boolean subtask;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class WorkflowMapping {
        public static final GenericType<List<WorkflowMapping>> LIST = new GenericType<List<WorkflowMapping>>(){};
        @JsonProperty
        private String workflow;
        @JsonProperty
        private Set<String> issueTypes;
        @JsonProperty
        private Boolean defaultMapping;
        @JsonProperty
        private Boolean updateDraftIfNeeded;

        public WorkflowMapping(String workflow) {
            this.workflow = workflow;
        }

        public WorkflowMapping() {
        }

        public Set<String> getIssueTypes() {
            return this.issueTypes;
        }

        public void setIssueTypes(Set<String> issueTypes) {
            this.issueTypes = issueTypes;
        }

        public String getWorkflow() {
            return this.workflow;
        }

        public void setWorkflow(String workflow) {
            this.workflow = workflow;
        }

        void addIssueType(String issueType) {
            this.issueTypes.add(issueType);
        }

        public Boolean isDefaultMapping() {
            return this.defaultMapping;
        }

        public void setDefaultMapping(Boolean defaultMapping) {
            this.defaultMapping = defaultMapping;
        }

        public Boolean getUpdateDraftIfNeeded() {
            return this.updateDraftIfNeeded;
        }

        public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
            this.updateDraftIfNeeded = updateDraftIfNeeded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkflowMapping that = (WorkflowMapping)o;
            if (this.defaultMapping != null ? !this.defaultMapping.equals(that.defaultMapping) : that.defaultMapping != null) {
                return false;
            }
            if (this.issueTypes != null ? !this.issueTypes.equals(that.issueTypes) : that.issueTypes != null) {
                return false;
            }
            return !(this.workflow != null ? !this.workflow.equals(that.workflow) : that.workflow != null);
        }

        public int hashCode() {
            int result = this.workflow != null ? this.workflow.hashCode() : 0;
            result = 31 * result + (this.issueTypes != null ? this.issueTypes.hashCode() : 0);
            result = 31 * result + (this.defaultMapping != null ? this.defaultMapping.hashCode() : 0);
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class IssueTypeMappingBean {
        @JsonProperty
        private String issueType;
        @JsonProperty
        private String workflow;
        @JsonProperty
        private Boolean updateDraftIfNeeded;

        public IssueTypeMappingBean() {
        }

        public IssueTypeMappingBean(String issueType, String workflow) {
            this.issueType = issueType;
            this.workflow = workflow;
        }

        public String getIssueType() {
            return this.issueType;
        }

        public void setIssueType(String issueType) {
            this.issueType = issueType;
        }

        public String getWorkflow() {
            return this.workflow;
        }

        public void setWorkflow(String workflow) {
            this.workflow = workflow;
        }

        public Boolean getUpdateDraftIfNeeded() {
            return this.updateDraftIfNeeded;
        }

        public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
            this.updateDraftIfNeeded = updateDraftIfNeeded;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class WorkflowScheme {
        @JsonProperty
        private Long id;
        @JsonProperty
        private String name;
        @JsonProperty
        private String description;
        @JsonProperty
        private String defaultWorkflow;
        @JsonProperty
        private Map<String, String> issueTypeMappings;
        @JsonProperty
        private Map<String, String> originalIssueTypeMappings;
        @JsonProperty
        private Map<String, IssueType> issueTypes;
        @JsonProperty
        private boolean draft;
        @JsonProperty
        private UserBean lastModifiedUser;
        @JsonProperty
        private String lastModified;
        @JsonProperty
        private URI self;
        @JsonProperty
        private Boolean updateDraftIfNeeded;
        @JsonProperty
        private String originalDefaultWorkflow;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getDefaultWorkflow() {
            return this.defaultWorkflow;
        }

        public void setDefaultWorkflow(String defaultWorkflow) {
            this.defaultWorkflow = defaultWorkflow;
        }

        public String getOriginalDefaultWorkflow() {
            return this.originalDefaultWorkflow;
        }

        public void setOriginalDefaultWorkflow(String originalDefaultWorkflow) {
            this.originalDefaultWorkflow = originalDefaultWorkflow;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public URI getSelf() {
            return this.self;
        }

        public void setSelf(URI self) {
            this.self = self;
        }

        public boolean isDraft() {
            return this.draft;
        }

        public void setDraft(boolean draft) {
            this.draft = draft;
        }

        public void setLastModifiedUser(UserBean lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        public UserBean getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public Boolean getUpdateDraftIfNeeded() {
            return this.updateDraftIfNeeded;
        }

        public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
            this.updateDraftIfNeeded = updateDraftIfNeeded;
        }

        public Map<String, String> getIssueTypeMappings() {
            return this.issueTypeMappings;
        }

        public Map<String, String> getOriginalIssueTypeMappings() {
            return this.originalIssueTypeMappings;
        }

        public void setIssueTypeMappings(Map<String, String> issueTypeMappings) {
            this.issueTypeMappings = issueTypeMappings;
        }

        public void setOriginalIssueTypeMappings(Map<String, String> originalIssueTypeMappings) {
            this.originalIssueTypeMappings = originalIssueTypeMappings;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

