/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client;

import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class IssueSubTaskClient
extends RestApiClient<IssueSubTaskClient> {
    private static final GenericType<List<IssueRefJsonBean>> SUBTASKS_GENERIC_TYPE = new GenericType<List<IssueRefJsonBean>>(){};

    public IssueSubTaskClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ParsedResponse getResponse(String issueKey) throws WebApplicationException {
        return this.toResponse(() -> (Response)this.issueSubTaskResource(issueKey).request().get(Response.class));
    }

    public List<IssueRefJsonBean> get(String issueKey) throws WebApplicationException {
        return (List)this.issueSubTaskResource(issueKey).request().get(SUBTASKS_GENERIC_TYPE);
    }

    public WebTarget issueSubTaskResource(String issueKey) {
        return this.createResourceWithIssueKey(issueKey);
    }

    private WebTarget createResourceWithIssueKey(String issueKey) {
        return this.createResource().path(issueKey).path("subtask");
    }

    protected WebTarget createResource() {
        return super.createResource().path("issue");
    }

    public ParsedResponse reorder(String parentKey, final Long from, final Long to) {
        return this.toResponse(() -> (Response)this.createResourceWithIssueKey(parentKey).path("move").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)new HashMap<String, Object>(){
            {
                this.put("original", from);
                this.put("current", to);
            }
        }), Response.class));
    }
}

